/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedTypeConverterRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed TypeConverterRegistry")
public class ManagedTypeConverterRegistry
extends ManagedService
implements ManagedTypeConverterRegistryMBean {
    private final TypeConverterRegistry registry;

    public ManagedTypeConverterRegistry(CamelContext context, TypeConverterRegistry registry) {
        super(context, registry);
        this.registry = registry;
    }

    public TypeConverterRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public long getAttemptCounter() {
        return this.registry.getStatistics().getAttemptCounter();
    }

    @Override
    public long getHitCounter() {
        return this.registry.getStatistics().getHitCounter();
    }

    @Override
    public long getMissCounter() {
        return this.registry.getStatistics().getMissCounter();
    }

    @Override
    public long getFailedCounter() {
        return this.registry.getStatistics().getFailedCounter();
    }

    @Override
    public void resetTypeConversionCounters() {
        this.registry.getStatistics().reset();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.registry.getStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.registry.getStatistics().setStatisticsEnabled(statisticsEnabled);
    }

    @Override
    public int getNumberOfTypeConverters() {
        return this.registry.size();
    }

    @Override
    public boolean hasTypeConverter(String fromType, String toType) {
        try {
            Class<?> from = this.getContext().getClassResolver().resolveMandatoryClass(fromType);
            Class<?> to = this.getContext().getClassResolver().resolveMandatoryClass(toType);
            return this.registry.lookup(to, from) != null;
        }
        catch (ClassNotFoundException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public TabularData listTypeConverters() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listTypeConvertersTabularType());
            List<Class<?>[]> converters = this.registry.listAllTypeConvertersFromTo();
            for (Class<?>[] entry : converters) {
                CompositeType ct = CamelOpenMBeanTypes.listTypeConvertersCompositeType();
                String from = entry[0].getCanonicalName();
                String to = entry[1].getCanonicalName();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"from", "to"}, new Object[]{from, to});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

