/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class last
extends Primitive {
    private static final Primitive LAST = new last();

    public last() {
        super("last", "list &optional n");
    }

    public LispObject execute(LispObject arg) {
        if (arg == Lisp.NIL) {
            return Lisp.NIL;
        }
        if (arg instanceof Cons) {
            while (true) {
                LispObject cdr;
                if (!((cdr = ((Cons)arg).cdr) instanceof Cons)) {
                    return arg;
                }
                arg = cdr;
            }
        }
        return Lisp.type_error(arg, Symbol.LIST);
    }

    public LispObject execute(LispObject first, LispObject second) {
        LispObject list = Lisp.checkList(first);
        if (second instanceof Fixnum) {
            int n = ((Fixnum)second).value;
            if (n >= 0) {
                if (list == Lisp.NIL) {
                    return Lisp.NIL;
                }
                LispObject result = list;
                while (list instanceof Cons) {
                    list = list.cdr();
                    if (n-- > 0) continue;
                    result = result.cdr();
                }
                return result;
            }
        } else if (second instanceof Bignum) {
            if (list == Lisp.NIL) {
                return Lisp.NIL;
            }
            LispObject n = second;
            LispObject result = list;
            while (list instanceof Cons) {
                list = list.cdr();
                if (!n.plusp()) {
                    result = result.cdr();
                }
                n = n.decr();
            }
            return result;
        }
        return Lisp.type_error(second, Symbol.UNSIGNED_BYTE);
    }
}

