/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class FloatFunctions {
    private static final Primitive SET_FLOATING_POINT_MODES = new Primitive("set-floating-point-modes", Lisp.PACKAGE_EXT, true, "&key traps"){

        public LispObject execute(LispObject[] args) {
            if (args.length % 2 != 0) {
                Lisp.program_error("Odd number of keyword arguments.");
            }
            for (int i = 0; i < args.length; i += 2) {
                Symbol key = Lisp.checkSymbol(args[i]);
                if (key == Keyword.TRAPS) {
                    boolean trap_overflow = false;
                    boolean trap_underflow = false;
                    for (LispObject value = args[i + 1]; value != Lisp.NIL; value = value.cdr()) {
                        LispObject car = value.car();
                        if (car == Keyword.OVERFLOW) {
                            trap_overflow = true;
                            continue;
                        }
                        if (car == Keyword.UNDERFLOW) {
                            trap_underflow = true;
                            continue;
                        }
                        Lisp.error(new LispError("Unsupported floating point trap: " + car.princToString()));
                    }
                    Lisp.TRAP_OVERFLOW = trap_overflow;
                    Lisp.TRAP_UNDERFLOW = trap_underflow;
                    continue;
                }
                Lisp.error(new LispError("Unrecognized keyword: " + key.princToString()));
            }
            return LispThread.currentThread().nothing();
        }
    };
    private static final Primitive GET_FLOATING_POINT_MODES = new Primitive("get-floating-point-modes", Lisp.PACKAGE_EXT, true, ""){

        public LispObject execute() {
            LispObject traps = Lisp.NIL;
            if (Lisp.TRAP_UNDERFLOW) {
                traps = traps.push(Keyword.UNDERFLOW);
            }
            if (Lisp.TRAP_OVERFLOW) {
                traps = traps.push(Keyword.OVERFLOW);
            }
            return Lisp.list(Keyword.TRAPS, traps);
        }
    };
    private static final Primitive INTEGER_DECODE_FLOAT = new Primitive("integer-decode-float", "float"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                int bits = Float.floatToRawIntBits(((SingleFloat)arg).value);
                int s = bits >> 31 == 0 ? 1 : -1;
                int e = (int)((long)(bits >> 23) & 0xFFL);
                int m = e == 0 ? (bits & 0x7FFFFF) << 1 : bits & 0x7FFFFF | 0x800000;
                LispObject significand = Lisp.number(m);
                Fixnum exponent = Fixnum.getInstance(e - 150);
                Fixnum sign = Fixnum.getInstance(s);
                return LispThread.currentThread().setValues(significand, exponent, sign);
            }
            if (arg instanceof DoubleFloat) {
                long bits = Double.doubleToRawLongBits(((DoubleFloat)arg).value);
                int s = bits >> 63 == 0L ? 1 : -1;
                int e = (int)(bits >> 52 & 0x7FFL);
                long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                LispObject significand = Lisp.number(m);
                Fixnum exponent = Fixnum.getInstance(e - 1075);
                Fixnum sign = Fixnum.getInstance(s);
                return LispThread.currentThread().setValues(significand, exponent, sign);
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    private static final Primitive _FLOAT_BITS = new Primitive("%float-bits", Lisp.PACKAGE_SYS, true, "integer"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                int bits = Float.floatToIntBits(((SingleFloat)arg).value);
                BigInteger big = BigInteger.valueOf(bits >> 1);
                return Bignum.getInstance(big.shiftLeft(1).add((bits & 1) == 1 ? BigInteger.ONE : BigInteger.ZERO));
            }
            if (arg instanceof DoubleFloat) {
                long bits = Double.doubleToLongBits(((DoubleFloat)arg).value);
                BigInteger big = BigInteger.valueOf(bits >> 1);
                return Bignum.getInstance(big.shiftLeft(1).add((bits & 1L) == 1L ? BigInteger.ONE : BigInteger.ZERO));
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    private static final Primitive RATIONAL = new Primitive("rational", "number"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                return ((SingleFloat)arg).rational();
            }
            if (arg instanceof DoubleFloat) {
                return ((DoubleFloat)arg).rational();
            }
            if (arg.rationalp()) {
                return arg;
            }
            return Lisp.type_error(arg, Symbol.REAL);
        }
    };
    private static final Primitive FLOAT_RADIX = new Primitive("float-radix", "float"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat || arg instanceof DoubleFloat) {
                return Fixnum.TWO;
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    static final Fixnum FIXNUM_24 = Fixnum.getInstance(24);
    static final Fixnum FIXNUM_53 = Fixnum.getInstance(53);
    private static final Primitive FLOAT_DIGITS = new Primitive("float-digits", "float"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                return FIXNUM_24;
            }
            if (arg instanceof DoubleFloat) {
                return FIXNUM_53;
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    private static final Primitive SCALE_FLOAT = new Primitive("scale-float", "float integer"){

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof SingleFloat) {
                float f = ((SingleFloat)first).value;
                int n = Fixnum.getValue(second);
                return new SingleFloat(f * (float)Math.pow(2.0, n));
            }
            if (first instanceof DoubleFloat) {
                double d = ((DoubleFloat)first).value;
                int n = Fixnum.getValue(second);
                return new DoubleFloat(d * Math.pow(2.0, n));
            }
            return Lisp.type_error(first, Symbol.FLOAT);
        }
    };
    private static final Primitive COERCE_TO_SINGLE_FLOAT = new Primitive("coerce-to-single-float", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            return SingleFloat.coerceToFloat(arg);
        }
    };
    private static final Primitive COERCE_TO_DOUBLE_FLOAT = new Primitive("coerce-to-double-float", Lisp.PACKAGE_SYS, false){

        public LispObject execute(LispObject arg) {
            return DoubleFloat.coerceToFloat(arg);
        }
    };
    private static final Primitive FLOAT = new Primitive("float", "number &optional prototype"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat || arg instanceof DoubleFloat) {
                return arg;
            }
            return SingleFloat.coerceToFloat(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof SingleFloat) {
                return SingleFloat.coerceToFloat(first);
            }
            if (second instanceof DoubleFloat) {
                return DoubleFloat.coerceToFloat(first);
            }
            return Lisp.type_error(second, Symbol.FLOAT);
        }
    };
    private static final Primitive FLOATP = new Primitive("floatp", "object"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                return Lisp.T;
            }
            if (arg instanceof DoubleFloat) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    };
    private static final Primitive SINGLE_FLOAT_BITS = new Primitive("single-float-bits", Lisp.PACKAGE_SYS, true, "float"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                SingleFloat f = (SingleFloat)arg;
                return Fixnum.getInstance(Float.floatToIntBits(f.value));
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    private static final Primitive DOUBLE_FLOAT_HIGH_BITS = new Primitive("double-float-high-bits", Lisp.PACKAGE_SYS, true, "float"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof DoubleFloat) {
                DoubleFloat f = (DoubleFloat)arg;
                return Lisp.number(Double.doubleToLongBits(f.value) >>> 32);
            }
            return Lisp.type_error(arg, Symbol.DOUBLE_FLOAT);
        }
    };
    private static final Primitive DOUBLE_FLOAT_LOW_BITS = new Primitive("double-float-low-bits", Lisp.PACKAGE_SYS, true, "float"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof DoubleFloat) {
                DoubleFloat f = (DoubleFloat)arg;
                return Lisp.number(Double.doubleToLongBits(f.value) & 0xFFFFFFFFL);
            }
            return Lisp.type_error(arg, Symbol.DOUBLE_FLOAT);
        }
    };
    private static final Primitive MAKE_SINGLE_FLOAT = new Primitive("make-single-float", Lisp.PACKAGE_SYS, true, "bits"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Fixnum) {
                int bits = ((Fixnum)arg).value;
                return new SingleFloat(Float.intBitsToFloat(bits));
            }
            if (arg instanceof Bignum) {
                long bits = ((Bignum)arg).value.longValue();
                return new SingleFloat(Float.intBitsToFloat((int)bits));
            }
            return Lisp.type_error(arg, Symbol.INTEGER);
        }
    };
    private static final Primitive MAKE_DOUBLE_FLOAT = new Primitive("make-double-float", Lisp.PACKAGE_SYS, true, "bits"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof Fixnum) {
                long bits = ((Fixnum)arg).value;
                return new DoubleFloat(Double.longBitsToDouble(bits));
            }
            if (arg instanceof Bignum) {
                long bits = ((Bignum)arg).value.longValue();
                return new DoubleFloat(Double.longBitsToDouble(bits));
            }
            return Lisp.type_error(arg, Symbol.INTEGER);
        }
    };
    private static final Primitive FLOAT_INFINITY_P = new Primitive("float-infinity-p", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                return Float.isInfinite(((SingleFloat)arg).value) ? Lisp.T : Lisp.NIL;
            }
            if (arg instanceof DoubleFloat) {
                return Double.isInfinite(((DoubleFloat)arg).value) ? Lisp.T : Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    private static final Primitive FLOAT_NAN_P = new Primitive("float-nan-p", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof SingleFloat) {
                return Float.isNaN(((SingleFloat)arg).value) ? Lisp.T : Lisp.NIL;
            }
            if (arg instanceof DoubleFloat) {
                return Double.isNaN(((DoubleFloat)arg).value) ? Lisp.T : Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.FLOAT);
        }
    };
    private static final Primitive FLOAT_STRING = new Primitive("float-string", Lisp.PACKAGE_SYS, true){

        public LispObject execute(LispObject arg) {
            String s1;
            if (arg instanceof SingleFloat) {
                s1 = String.valueOf(((SingleFloat)arg).value);
            } else if (arg instanceof DoubleFloat) {
                s1 = String.valueOf(((DoubleFloat)arg).value);
            } else {
                return Lisp.type_error(arg, Symbol.FLOAT);
            }
            int i = s1.indexOf(69);
            if (i < 0) {
                return new SimpleString(s1);
            }
            String s2 = s1.substring(0, i);
            int exponent = Integer.parseInt(s1.substring(i + 1));
            if (exponent == 0) {
                return new SimpleString(s2);
            }
            int index = s2.indexOf(46);
            if (index < 0) {
                return new SimpleString(s2);
            }
            StringBuffer sb = new StringBuffer(s2);
            if (index >= 0) {
                sb.deleteCharAt(index);
            }
            if (exponent > 0) {
                int newIndex = index + exponent;
                if (newIndex < sb.length()) {
                    sb.insert(newIndex, '.');
                } else if (newIndex == sb.length()) {
                    sb.append('.');
                } else {
                    while (newIndex > sb.length()) {
                        sb.append('0');
                    }
                    sb.append('.');
                }
            } else {
                Debug.assertTrue(exponent < 0);
                for (int newIndex = index + exponent; newIndex < 0; ++newIndex) {
                    sb.insert(0, '0');
                }
                sb.insert(0, '.');
            }
            return new SimpleString(sb.toString());
        }
    };
}

