#ifndef _DO_POSTGRES_ERROR_H_
#define _DO_POSTGRES_ERROR_H_

#include "do_common.h"

static struct errcodes do_postgres_errors[] = {
#ifdef ERRCODE_CONNECTION_EXCEPTION
  ERRCODE(ERRCODE_CONNECTION_EXCEPTION, "ConnectionError"),
#endif
#ifdef ERRCODE_CONNECTION_DOES_NOT_EXIST
  ERRCODE(ERRCODE_CONNECTION_DOES_NOT_EXIST, "ConnectionError"),
#endif
#ifdef ERRCODE_CONNECTION_FAILURE
  ERRCODE(ERRCODE_CONNECTION_FAILURE, "ConnectionError"),
#endif
#ifdef ERRCODE_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION
  ERRCODE(ERRCODE_SQLCLIENT_UNABLE_TO_ESTABLISH_SQLCONNECTION, "ConnectionError"),
#endif
#ifdef ERRCODE_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION
  ERRCODE(ERRCODE_SQLSERVER_REJECTED_ESTABLISHMENT_OF_SQLCONNECTION, "ConnectionError"),
#endif
#ifdef ERRCODE_TRANSACTION_RESOLUTION_UNKNOWN
  ERRCODE(ERRCODE_TRANSACTION_RESOLUTION_UNKNOWN, "ConnectionError"),
#endif
#ifdef ERRCODE_PROTOCOL_VIOLATION
  ERRCODE(ERRCODE_PROTOCOL_VIOLATION, "ConnectionError"),
#endif

#ifdef ERRCODE_DATA_EXCEPTION
  ERRCODE(ERRCODE_DATA_EXCEPTION, "DataError"),
#endif
#ifdef ERRCODE_ARRAY_ELEMENT_ERROR
  ERRCODE(ERRCODE_ARRAY_ELEMENT_ERROR, "DataError"),
#endif
#ifdef ERRCODE_ARRAY_SUBSCRIPT_ERROR
  ERRCODE(ERRCODE_ARRAY_SUBSCRIPT_ERROR, "DataError"),
#endif
#ifdef ERRCODE_CHARACTER_NOT_IN_REPERTOIRE
  ERRCODE(ERRCODE_CHARACTER_NOT_IN_REPERTOIRE, "DataError"),
#endif
#ifdef ERRCODE_DATETIME_FIELD_OVERFLOW
  ERRCODE(ERRCODE_DATETIME_FIELD_OVERFLOW, "DataError"),
#endif
#ifdef ERRCODE_DATETIME_VALUE_OUT_OF_RANGE
  ERRCODE(ERRCODE_DATETIME_VALUE_OUT_OF_RANGE, "DataError"),
#endif
#ifdef ERRCODE_DIVISION_BY_ZERO
  ERRCODE(ERRCODE_DIVISION_BY_ZERO, "DataError"),
#endif
#ifdef ERRCODE_ERROR_IN_ASSIGNMENT
  ERRCODE(ERRCODE_ERROR_IN_ASSIGNMENT, "DataError"),
#endif
#ifdef ERRCODE_ESCAPE_CHARACTER_CONFLICT
  ERRCODE(ERRCODE_ESCAPE_CHARACTER_CONFLICT, "DataError"),
#endif
#ifdef ERRCODE_INDICATOR_OVERFLOW
  ERRCODE(ERRCODE_INDICATOR_OVERFLOW, "DataError"),
#endif
#ifdef ERRCODE_INTERVAL_FIELD_OVERFLOW
  ERRCODE(ERRCODE_INTERVAL_FIELD_OVERFLOW, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_LOG
  ERRCODE(ERRCODE_INVALID_ARGUMENT_FOR_LOG, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_NTILE
  ERRCODE(ERRCODE_INVALID_ARGUMENT_FOR_NTILE, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_NTH_VALUE
  ERRCODE(ERRCODE_INVALID_ARGUMENT_FOR_NTH_VALUE, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_POWER_FUNCTION
  ERRCODE(ERRCODE_INVALID_ARGUMENT_FOR_POWER_FUNCTION, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION
  ERRCODE(ERRCODE_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION, "DataError"),
#endif
#ifdef ERRCODE_INVALID_CHARACTER_VALUE_FOR_CAST
  ERRCODE(ERRCODE_INVALID_CHARACTER_VALUE_FOR_CAST, "DataError"),
#endif
#ifdef ERRCODE_INVALID_DATETIME_FORMAT
  ERRCODE(ERRCODE_INVALID_DATETIME_FORMAT, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ESCAPE_CHARACTER
  ERRCODE(ERRCODE_INVALID_ESCAPE_CHARACTER, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ESCAPE_OCTET
  ERRCODE(ERRCODE_INVALID_ESCAPE_OCTET, "DataError"),
#endif
#ifdef ERRCODE_INVALID_ESCAPE_SEQUENCE
  ERRCODE(ERRCODE_INVALID_ESCAPE_SEQUENCE, "DataError"),
#endif
#ifdef ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER
  ERRCODE(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER, "DataError"),
#endif
#ifdef ERRCODE_INVALID_INDICATOR_PARAMETER_VALUE
  ERRCODE(ERRCODE_INVALID_INDICATOR_PARAMETER_VALUE, "DataError"),
#endif
#ifdef ERRCODE_INVALID_LIMIT_VALUE
  ERRCODE(ERRCODE_INVALID_LIMIT_VALUE, "DataError"),
#endif
#ifdef ERRCODE_INVALID_PARAMETER_VALUE
  ERRCODE(ERRCODE_INVALID_PARAMETER_VALUE, "DataError"),
#endif
#ifdef ERRCODE_INVALID_REGULAR_EXPRESSION
  ERRCODE(ERRCODE_INVALID_REGULAR_EXPRESSION, "DataError"),
#endif
#ifdef ERRCODE_INVALID_TIME_ZONE_DISPLACEMENT_VALUE
  ERRCODE(ERRCODE_INVALID_TIME_ZONE_DISPLACEMENT_VALUE, "DataError"),
#endif
#ifdef ERRCODE_INVALID_USE_OF_ESCAPE_CHARACTER
  ERRCODE(ERRCODE_INVALID_USE_OF_ESCAPE_CHARACTER, "DataError"),
#endif
#ifdef ERRCODE_MOST_SPECIFIC_TYPE_MISMATCH
  ERRCODE(ERRCODE_MOST_SPECIFIC_TYPE_MISMATCH, "DataError"),
#endif
#ifdef ERRCODE_NULL_VALUE_NOT_ALLOWED
  ERRCODE(ERRCODE_NULL_VALUE_NOT_ALLOWED, "DataError"),
#endif
#ifdef ERRCODE_NULL_VALUE_NO_INDICATOR_PARAMETER
  ERRCODE(ERRCODE_NULL_VALUE_NO_INDICATOR_PARAMETER, "DataError"),
#endif
#ifdef ERRCODE_NUMERIC_VALUE_OUT_OF_RANGE
  ERRCODE(ERRCODE_NUMERIC_VALUE_OUT_OF_RANGE, "DataError"),
#endif
#ifdef ERRCODE_STRING_DATA_LENGTH_MISMATCH
  ERRCODE(ERRCODE_STRING_DATA_LENGTH_MISMATCH, "DataError"),
#endif
#ifdef ERRCODE_STRING_DATA_RIGHT_TRUNCATION
  ERRCODE(ERRCODE_STRING_DATA_RIGHT_TRUNCATION, "DataError"),
#endif
#ifdef ERRCODE_SUBSTRING_ERROR
  ERRCODE(ERRCODE_SUBSTRING_ERROR, "DataError"),
#endif
#ifdef ERRCODE_TRIM_ERROR
  ERRCODE(ERRCODE_TRIM_ERROR, "DataError"),
#endif
#ifdef ERRCODE_UNTERMINATED_C_STRING
  ERRCODE(ERRCODE_UNTERMINATED_C_STRING, "DataError"),
#endif
#ifdef ERRCODE_ZERO_LENGTH_CHARACTER_STRING
  ERRCODE(ERRCODE_ZERO_LENGTH_CHARACTER_STRING, "DataError"),
#endif
#ifdef ERRCODE_FLOATING_POINT_EXCEPTION
  ERRCODE(ERRCODE_FLOATING_POINT_EXCEPTION, "DataError"),
#endif
#ifdef ERRCODE_INVALID_TEXT_REPRESENTATION
  ERRCODE(ERRCODE_INVALID_TEXT_REPRESENTATION, "DataError"),
#endif
#ifdef ERRCODE_INVALID_BINARY_REPRESENTATION
  ERRCODE(ERRCODE_INVALID_BINARY_REPRESENTATION, "DataError"),
#endif
#ifdef ERRCODE_BAD_COPY_FILE_FORMAT
  ERRCODE(ERRCODE_BAD_COPY_FILE_FORMAT, "DataError"),
#endif
#ifdef ERRCODE_UNTRANSLATABLE_CHARACTER
  ERRCODE(ERRCODE_UNTRANSLATABLE_CHARACTER, "DataError"),
#endif
#ifdef ERRCODE_NOT_AN_XML_DOCUMENT
  ERRCODE(ERRCODE_NOT_AN_XML_DOCUMENT, "DataError"),
#endif
#ifdef ERRCODE_INVALID_XML_DOCUMENT
  ERRCODE(ERRCODE_INVALID_XML_DOCUMENT, "DataError"),
#endif
#ifdef ERRCODE_INVALID_XML_CONTENT
  ERRCODE(ERRCODE_INVALID_XML_CONTENT, "DataError"),
#endif
#ifdef ERRCODE_INVALID_XML_COMMENT
  ERRCODE(ERRCODE_INVALID_XML_COMMENT, "DataError"),
#endif
#ifdef ERRCODE_INVALID_XML_PROCESSING_INSTRUCTION
  ERRCODE(ERRCODE_INVALID_XML_PROCESSING_INSTRUCTION, "DataError"),
#endif

#ifdef ERRCODE_INTEGRITY_CONSTRAINT_VIOLATION
  ERRCODE(ERRCODE_INTEGRITY_CONSTRAINT_VIOLATION, "IntegrityError"),
#endif
#ifdef ERRCODE_RESTRICT_VIOLATION
  ERRCODE(ERRCODE_RESTRICT_VIOLATION, "IntegrityError"),
#endif
#ifdef ERRCODE_NOT_NULL_VIOLATION
  ERRCODE(ERRCODE_NOT_NULL_VIOLATION, "IntegrityError"),
#endif
#ifdef ERRCODE_FOREIGN_KEY_VIOLATION
  ERRCODE(ERRCODE_FOREIGN_KEY_VIOLATION, "IntegrityError"),
#endif
#ifdef ERRCODE_UNIQUE_VIOLATION
  ERRCODE(ERRCODE_UNIQUE_VIOLATION, "IntegrityError"),
#endif
#ifdef ERRCODE_CHECK_VIOLATION
  ERRCODE(ERRCODE_CHECK_VIOLATION, "IntegrityError"),
#endif
#ifdef ERRCODE_WITH_CHECK_OPTION_VIOLATION
  ERRCODE(ERRCODE_WITH_CHECK_OPTION_VIOLATION, "IntegrityError"),
#endif

#ifdef ERRCODE_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION
  ERRCODE(ERRCODE_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION, "SyntaxError"),
#endif
#ifdef ERRCODE_SYNTAX_ERROR
  ERRCODE(ERRCODE_SYNTAX_ERROR, "SyntaxError"),
#endif
#ifdef ERRCODE_INSUFFICIENT_PRIVILEGE
  ERRCODE(ERRCODE_INSUFFICIENT_PRIVILEGE, "SyntaxError"),
#endif
#ifdef ERRCODE_CANNOT_COERCE
  ERRCODE(ERRCODE_CANNOT_COERCE, "SyntaxError"),
#endif
#ifdef ERRCODE_GROUPING_ERROR
  ERRCODE(ERRCODE_GROUPING_ERROR, "SyntaxError"),
#endif
#ifdef ERRCODE_WINDOWING_ERROR
  ERRCODE(ERRCODE_WINDOWING_ERROR, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_RECURSION
  ERRCODE(ERRCODE_INVALID_RECURSION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_FOREIGN_KEY
  ERRCODE(ERRCODE_INVALID_FOREIGN_KEY, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_NAME
  ERRCODE(ERRCODE_INVALID_NAME, "SyntaxError"),
#endif
#ifdef ERRCODE_NAME_TOO_LONG
  ERRCODE(ERRCODE_NAME_TOO_LONG, "SyntaxError"),
#endif
#ifdef ERRCODE_RESERVED_NAME
  ERRCODE(ERRCODE_RESERVED_NAME, "SyntaxError"),
#endif
#ifdef ERRCODE_DATATYPE_MISMATCH
  ERRCODE(ERRCODE_DATATYPE_MISMATCH, "SyntaxError"),
#endif
#ifdef ERRCODE_INDETERMINATE_DATATYPE
  ERRCODE(ERRCODE_INDETERMINATE_DATATYPE, "SyntaxError"),
#endif
#ifdef ERRCODE_WRONG_OBJECT_TYPE
  ERRCODE(ERRCODE_WRONG_OBJECT_TYPE, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_COLUMN
  ERRCODE(ERRCODE_UNDEFINED_COLUMN, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_CURSOR
  ERRCODE(ERRCODE_UNDEFINED_CURSOR, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_DATABASE
  ERRCODE(ERRCODE_UNDEFINED_DATABASE, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_FUNCTION
  ERRCODE(ERRCODE_UNDEFINED_FUNCTION, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_PSTATEMENT
  ERRCODE(ERRCODE_UNDEFINED_PSTATEMENT, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_SCHEMA
  ERRCODE(ERRCODE_UNDEFINED_SCHEMA, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_TABLE
  ERRCODE(ERRCODE_UNDEFINED_TABLE, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_PARAMETER
  ERRCODE(ERRCODE_UNDEFINED_PARAMETER, "SyntaxError"),
#endif
#ifdef ERRCODE_UNDEFINED_OBJECT
  ERRCODE(ERRCODE_UNDEFINED_OBJECT, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_COLUMN
  ERRCODE(ERRCODE_DUPLICATE_COLUMN, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_CURSOR
  ERRCODE(ERRCODE_DUPLICATE_CURSOR, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_DATABASE
  ERRCODE(ERRCODE_DUPLICATE_DATABASE, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_FUNCTION
  ERRCODE(ERRCODE_DUPLICATE_FUNCTION, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_PSTATEMENT
  ERRCODE(ERRCODE_DUPLICATE_PSTATEMENT, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_SCHEMA
  ERRCODE(ERRCODE_DUPLICATE_SCHEMA, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_TABLE
  ERRCODE(ERRCODE_DUPLICATE_TABLE, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_ALIAS
  ERRCODE(ERRCODE_DUPLICATE_ALIAS, "SyntaxError"),
#endif
#ifdef ERRCODE_DUPLICATE_OBJECT
  ERRCODE(ERRCODE_DUPLICATE_OBJECT, "SyntaxError"),
#endif
#ifdef ERRCODE_AMBIGUOUS_COLUMN
  ERRCODE(ERRCODE_AMBIGUOUS_COLUMN, "SyntaxError"),
#endif
#ifdef ERRCODE_AMBIGUOUS_FUNCTION
  ERRCODE(ERRCODE_AMBIGUOUS_FUNCTION, "SyntaxError"),
#endif
#ifdef ERRCODE_AMBIGUOUS_PARAMETER
  ERRCODE(ERRCODE_AMBIGUOUS_PARAMETER, "SyntaxError"),
#endif
#ifdef ERRCODE_AMBIGUOUS_ALIAS
  ERRCODE(ERRCODE_AMBIGUOUS_ALIAS, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_COLUMN_REFERENCE
  ERRCODE(ERRCODE_INVALID_COLUMN_REFERENCE, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_COLUMN_DEFINITION
  ERRCODE(ERRCODE_INVALID_COLUMN_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_CURSOR_DEFINITION
  ERRCODE(ERRCODE_INVALID_CURSOR_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_DATABASE_DEFINITION
  ERRCODE(ERRCODE_INVALID_DATABASE_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_FUNCTION_DEFINITION
  ERRCODE(ERRCODE_INVALID_FUNCTION_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_PSTATEMENT_DEFINITION
  ERRCODE(ERRCODE_INVALID_PSTATEMENT_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_SCHEMA_DEFINITION
  ERRCODE(ERRCODE_INVALID_SCHEMA_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_TABLE_DEFINITION
  ERRCODE(ERRCODE_INVALID_TABLE_DEFINITION, "SyntaxError"),
#endif
#ifdef ERRCODE_INVALID_OBJECT_DEFINITION
  ERRCODE(ERRCODE_INVALID_OBJECT_DEFINITION, "SyntaxError"),
#endif

#ifdef ERRCODE_INVALID_TRANSACTION_STATE
  ERRCODE(ERRCODE_INVALID_TRANSACTION_STATE, "TransactionError"),
#endif
#ifdef ERRCODE_ACTIVE_SQL_TRANSACTION
  ERRCODE(ERRCODE_ACTIVE_SQL_TRANSACTION, "TransactionError"),
#endif
#ifdef ERRCODE_BRANCH_TRANSACTION_ALREADY_ACTIVE
  ERRCODE(ERRCODE_BRANCH_TRANSACTION_ALREADY_ACTIVE, "TransactionError"),
#endif
#ifdef ERRCODE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL
  ERRCODE(ERRCODE_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL, "TransactionError"),
#endif
#ifdef ERRCODE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION
  ERRCODE(ERRCODE_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION, "TransactionError"),
#endif
#ifdef ERRCODE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION
  ERRCODE(ERRCODE_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION, "TransactionError"),
#endif
#ifdef ERRCODE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION
  ERRCODE(ERRCODE_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION, "TransactionError"),
#endif
#ifdef ERRCODE_READ_ONLY_SQL_TRANSACTION
  ERRCODE(ERRCODE_READ_ONLY_SQL_TRANSACTION, "TransactionError"),
#endif
#ifdef ERRCODE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED
  ERRCODE(ERRCODE_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED, "TransactionError"),
#endif
#ifdef ERRCODE_NO_ACTIVE_SQL_TRANSACTION
  ERRCODE(ERRCODE_NO_ACTIVE_SQL_TRANSACTION, "TransactionError"),
#endif
#ifdef ERRCODE_IN_FAILED_SQL_TRANSACTION
  ERRCODE(ERRCODE_IN_FAILED_SQL_TRANSACTION, "TransactionError"),
#endif
  {0, NULL, NULL}
};

#endif
