require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/task.ph';
eval 'sub IRQ_NONE () {0;}' unless defined(&IRQ_NONE);
eval 'sub IRQ_HANDLED () {1;}' unless defined(&IRQ_HANDLED);
eval 'sub __force () {1;}' unless defined(&__force);
eval 'sub __always_unused () {1;}' unless defined(&__always_unused);
eval 'sub __read_mostly () {1;}' unless defined(&__read_mostly);
eval 'sub __iomem () {1;}' unless defined(&__iomem);
eval 'sub __must_check () {1;}' unless defined(&__must_check);
eval 'sub __init () {1;}' unless defined(&__init);
unless(defined(&uninitialized_var)) {
    sub uninitialized_var {
	my($x) = @_;
	eval q($x);
    }
}
if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
    eval 'sub __BIG_ENDIAN () {1;}' unless defined(&__BIG_ENDIAN);
} else {
    eval 'sub __LITTLE_ENDIAN () {1;}' unless defined(&__LITTLE_ENDIAN);
}
unless(defined(&le16_to_cpu)) {
    sub le16_to_cpu {
	my($x) = @_;
	eval q( &letoh16($x));
    }
}
unless(defined(&le32_to_cpu)) {
    sub le32_to_cpu {
	my($x) = @_;
	eval q( &letoh32($x));
    }
}
unless(defined(&cpu_to_le16)) {
    sub cpu_to_le16 {
	my($x) = @_;
	eval q( &htole16($x));
    }
}
unless(defined(&cpu_to_le32)) {
    sub cpu_to_le32 {
	my($x) = @_;
	eval q( &htole32($x));
    }
}
unless(defined(&be32_to_cpup)) {
    sub be32_to_cpup {
	my($x) = @_;
	eval q( &betoh32(*$x));
    }
}
unless(defined(&lower_32_bits)) {
    sub lower_32_bits {
	my($n) = @_;
	eval q((( &u32)($n)));
    }
}
unless(defined(&upper_32_bits)) {
    sub upper_32_bits {
	my($_val) = @_;
	eval q((( &u32)((($_val) >> 16) >> 16)));
    }
}
unless(defined(&DMA_BIT_MASK)) {
    sub DMA_BIT_MASK {
	my($n) = @_;
	eval q(((($n) == 64) ? ~0 : (1<<($n)) -1));
    }
}
unless(defined(&EXPORT_SYMBOL)) {
    sub EXPORT_SYMBOL {
	my($x) = @_;
	eval q();
    }
}
unless(defined(&MODULE_FIRMWARE)) {
    sub MODULE_FIRMWARE {
	my($x) = @_;
	eval q();
    }
}
unless(defined(&MODULE_PARM_DESC)) {
    sub MODULE_PARM_DESC {
	my($parm, $desc) = @_;
	eval q();
    }
}
unless(defined(&module_param_named)) {
    sub module_param_named {
	my($name, $value, $type, $perm) = @_;
	eval q();
    }
}
eval 'sub ARRAY_SIZE () { &nitems;}' unless defined(&ARRAY_SIZE);
eval 'sub ERESTARTSYS () { &EINTR;}' unless defined(&ERESTARTSYS);
eval 'sub ETIME () { &ETIMEDOUT;}' unless defined(&ETIME);
eval 'sub EREMOTEIO () { &EIO;}' unless defined(&EREMOTEIO);
eval 'sub EPROTO () { &EIO;}' unless defined(&EPROTO);
eval 'sub ENOTSUPP () { &ENOTSUP;}' unless defined(&ENOTSUPP);
eval 'sub KERN_INFO () {1;}' unless defined(&KERN_INFO);
eval 'sub KERN_WARNING () {1;}' unless defined(&KERN_WARNING);
eval 'sub KERN_NOTICE () {1;}' unless defined(&KERN_NOTICE);
eval 'sub KERN_DEBUG () {1;}' unless defined(&KERN_DEBUG);
eval 'sub KERN_CRIT () {1;}' unless defined(&KERN_CRIT);
eval 'sub KERN_ERR () {1;}' unless defined(&KERN_ERR);
eval 'sub KBUILD_MODNAME () {"drm";}' unless defined(&KBUILD_MODNAME);
unless(defined(&pr_fmt)) {
    eval 'sub pr_fmt {
        my($fmt) = @_;
	    eval q($fmt);
    }' unless defined(&pr_fmt);
}
eval 'sub printk_once () {( &fmt,  &arg...) ({  &static \'int\'  &__warned;  &if (! &__warned) {  &printf( &fmt,   &arg);  &__warned = 1; } });}' unless defined(&printk_once);
eval 'sub printk () {( &fmt,  &arg...)  &printf( &fmt,   &arg);}' unless defined(&printk);
eval 'sub pr_warn () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_warn);
eval 'sub pr_warn_once () {( &fmt,  &arg...)  &printk_once( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_warn_once);
eval 'sub pr_notice () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_notice);
eval 'sub pr_crit () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_crit);
eval 'sub pr_err () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_err);
if(defined(&DRMDEBUG)) {
    eval 'sub pr_info () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_info);
    eval 'sub pr_debug () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_debug);
} else {
    eval 'sub pr_info () {( &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&pr_info);
    eval 'sub pr_debug () {( &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&pr_debug);
}
eval 'sub dev_warn () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *WARNING* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_warn);
eval 'sub dev_notice () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *NOTICE* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_notice);
eval 'sub dev_crit () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_crit);
eval 'sub dev_err () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_err);
if(defined(&DRMDEBUG)) {
    eval 'sub dev_info () {( &dev,  &fmt,  &arg...)  &printf("drm: "  &fmt,   &arg);}' unless defined(&dev_info);
    eval 'sub dev_debug () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *DEBUG* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_debug);
} else {
    eval 'sub dev_info () {( &dev,  &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&dev_info);
    eval 'sub dev_debug () {( &dev,  &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&dev_debug);
}
unless(defined(&unlikely)) {
    sub unlikely {
	my($x) = @_;
	eval q( &__builtin_expect(!!($x), 0));
    }
}
unless(defined(&likely)) {
    sub likely {
	my($x) = @_;
	eval q( &__builtin_expect(!!($x), 1));
    }
}
unless(defined(&BUG)) {
    sub BUG () {
	eval q( &do {  &panic(\"BUG at %s:%d\",  &__FILE__,  &__LINE__); }  &while (0));
    }
}
unless(defined(&BUG_ON)) {
    sub BUG_ON {
	my($x) = @_;
	eval q( &KASSERT(!($x)));
    }
}
unless(defined(&BUILD_BUG_ON)) {
    sub BUILD_BUG_ON {
	my($x) = @_;
	eval q( &CTASSERT(!($x)));
    }
}
eval 'sub WARN () {( &condition,  &fmt...) ({ \'int\'  &__ret = !!( &condition);  &if ( &__ret)  &printf( &fmt);  &unlikely( &__ret); });}' unless defined(&WARN);
eval 'sub WARN_ONCE () {( &condition,  &fmt...) ({  &static \'int\'  &__warned; \'int\'  &__ret = !!( &condition);  &if ( &__ret  && ! &__warned) {  &printf( &fmt);  &__warned = 1; }  &unlikely( &__ret); });}' unless defined(&WARN_ONCE);
unless(defined(&_WARN_STR)) {
    sub _WARN_STR {
	my($x) = @_;
	eval q($x);
    }
}
unless(defined(&WARN_ON)) {
    sub WARN_ON {
	my($condition) = @_;
	eval q(({ 'int'  &__ret = !!($condition);  &if ( &__ret)  &printf(\"WARNING %s failed at %s:%d\\n\",  &_WARN_STR($condition),  &__FILE__,  &__LINE__);  &unlikely( &__ret); }));
    }
}
unless(defined(&WARN_ON_ONCE)) {
    sub WARN_ON_ONCE {
	my($condition) = @_;
	eval q(({  &static 'int'  &__warned; 'int'  &__ret = !!($condition);  &if ( &__ret  && ! &__warned) {  &printf(\"WARNING %s failed at %s:%d\\n\",  &_WARN_STR($condition),  &__FILE__,  &__LINE__);  &__warned = 1; }  &unlikely( &__ret); }));
    }
}
eval 'sub TP_PROTO () {( &x...)  &x;}' unless defined(&TP_PROTO);
unless(defined(&DEFINE_EVENT)) {
    sub DEFINE_EVENT {
	my($template, $name, $proto, $args) = @_;
	eval q( &static  &inline  &void  &trace_$name($proto) {});
    }
}
unless(defined(&TRACE_EVENT)) {
    sub TRACE_EVENT {
	my($name, $proto, $args, $struct, $assign, $print) = @_;
	eval q( &static  &inline  &void  &trace_$name($proto) {});
    }
}
unless(defined(&DECLARE_EVENT_CLASS)) {
    sub DECLARE_EVENT_CLASS {
	my($name, $proto, $args, $tstruct, $assign, $print) = @_;
	eval q( &static  &inline  &void  &trace_$name($proto) {});
    }
}
unless(defined(&IS_ERR_VALUE)) {
    sub IS_ERR_VALUE {
	my($x) = @_;
	eval q( &unlikely(($x) >= - &ELAST));
    }
}
unless(defined(&container_of)) {
    sub container_of {
	my($ptr, $type, $member) = @_;
	eval q(({  &__typeof( (($type *)0)->$member ) * &__mptr = ($ptr); ($type *)(  &__mptr -  &offsetof($type,$member) );}));
    }
}
unless(defined(&__DECONST)) {
    eval 'sub __DECONST {
        my($type, $var) = @_;
	    eval q((($type)( &__uintptr_t)( &const  &void *)($var)));
    }' unless defined(&__DECONST);
}
unless(defined(&DEFINE_SPINLOCK)) {
    sub DEFINE_SPINLOCK {
	my($x) = @_;
	eval q('struct mutex' $x);
    }
}
unless(defined(&spin_lock)) {
    sub spin_lock {
	my($mtxp) = @_;
	eval q( &mtx_enter($mtxp));
    }
}
unless(defined(&spin_unlock)) {
    sub spin_unlock {
	my($mtxp) = @_;
	eval q( &mtx_leave($mtxp));
    }
}
unless(defined(&spin_lock_irq)) {
    sub spin_lock_irq {
	my($mtxp) = @_;
	eval q( &mtx_enter($mtxp));
    }
}
unless(defined(&spin_unlock_irq)) {
    sub spin_unlock_irq {
	my($mtxp) = @_;
	eval q( &mtx_leave($mtxp));
    }
}
unless(defined(&assert_spin_locked)) {
    sub assert_spin_locked {
	my($mtxp) = @_;
	eval q( &MUTEX_ASSERT_LOCKED($mtxp));
    }
}
unless(defined(&mutex_lock_interruptible)) {
    sub mutex_lock_interruptible {
	my($rwl) = @_;
	eval q(- &rw_enter($rwl,  &RW_WRITE |  &RW_INTR));
    }
}
unless(defined(&mutex_lock)) {
    sub mutex_lock {
	my($rwl) = @_;
	eval q( &rw_enter_write($rwl));
    }
}
unless(defined(&mutex_unlock)) {
    sub mutex_unlock {
	my($rwl) = @_;
	eval q( &rw_exit_write($rwl));
    }
}
unless(defined(&mutex_is_locked)) {
    sub mutex_is_locked {
	my($rwl) = @_;
	eval q(( &rw_status($rwl) ==  &RW_WRITE));
    }
}
unless(defined(&down_read)) {
    sub down_read {
	my($rwl) = @_;
	eval q( &rw_enter_read($rwl));
    }
}
unless(defined(&up_read)) {
    sub up_read {
	my($rwl) = @_;
	eval q( &rw_exit_read($rwl));
    }
}
unless(defined(&down_write)) {
    sub down_write {
	my($rwl) = @_;
	eval q( &rw_enter_write($rwl));
    }
}
unless(defined(&up_write)) {
    sub up_write {
	my($rwl) = @_;
	eval q( &rw_exit_write($rwl));
    }
}
unless(defined(&read_lock)) {
    sub read_lock {
	my($rwl) = @_;
	eval q( &rw_enter_read($rwl));
    }
}
unless(defined(&read_unlock)) {
    sub read_unlock {
	my($rwl) = @_;
	eval q( &rw_exit_read($rwl));
    }
}
unless(defined(&write_lock)) {
    sub write_lock {
	my($rwl) = @_;
	eval q( &rw_enter_write($rwl));
    }
}
unless(defined(&write_unlock)) {
    sub write_unlock {
	my($rwl) = @_;
	eval q( &rw_exit_write($rwl));
    }
}
unless(defined(&wait_event)) {
    sub wait_event {
	my($wq, $condition) = @_;
	eval q( &do { 'struct sleep_state'  &sls;  &if ($condition)  &break;  &sleep_setup( &sls, $wq, 0, \"drmwe\");  &sleep_finish( &sls, !($condition)); }  &while (!($condition)));
    }
}
unless(defined(&__wait_event_timeout)) {
    sub __wait_event_timeout {
	my($wq, $condition, $ret) = @_;
	eval q( &do { 'struct sleep_state'  &sls; 'int'  &deadline,  &error;  &sleep_setup( &sls, $wq, 0, \"drmwet\");  &sleep_setup_timeout( &sls, $ret);  &deadline =  &ticks + $ret;  &sleep_finish( &sls, !($condition)); $ret =  &deadline -  &ticks;  &error =  &sleep_finish_timeout( &sls);  &if ($ret < 0||  &error ==  &EWOULDBLOCK) $ret = 0;  &if ($ret == 0 && ($condition)) { $ret = 1;  &break; } }  &while ($ret > 0 && !($condition)));
    }
}
unless(defined(&wait_event_timeout)) {
    sub wait_event_timeout {
	my($wq, $condition, $timo) = @_;
	eval q(({ 'long __ret' = $timo;  &if (!($condition))  &__wait_event_timeout($wq, $condition,  &__ret);  &__ret; }));
    }
}
unless(defined(&__wait_event_interruptible_timeout)) {
    sub __wait_event_interruptible_timeout {
	my($wq, $condition, $ret) = @_;
	eval q( &do { 'struct sleep_state'  &sls; 'int'  &deadline,  &error,  &error1;  &sleep_setup( &sls, $wq,  &PCATCH, \"drmweti\");  &sleep_setup_timeout( &sls, $ret);  &sleep_setup_signal( &sls,  &PCATCH);  &deadline =  &ticks + $ret;  &sleep_finish( &sls, !($condition)); $ret =  &deadline -  &ticks;  &error1 =  &sleep_finish_timeout( &sls);  &error =  &sleep_finish_signal( &sls);  &if ($ret < 0||  &error1 ==  &EWOULDBLOCK) $ret = 0;  &if ( &error ==  &ERESTART) $ret = - &ERESTARTSYS;  &else  &if ( &error) $ret = - &error;  &if ($ret == 0 && ($condition)) { $ret = 1;  &break; } }  &while ($ret > 0 && !($condition)));
    }
}
unless(defined(&wait_event_interruptible_timeout)) {
    sub wait_event_interruptible_timeout {
	my($wq, $condition, $timo) = @_;
	eval q(({ 'long __ret' = $timo;  &if (!($condition))  &__wait_event_interruptible_timeout($wq, $condition,  &__ret);  &__ret; }));
    }
}
unless(defined(&wake_up)) {
    sub wake_up {
	my($x) = @_;
	eval q( &wakeup($x));
    }
}
unless(defined(&wake_up_all)) {
    sub wake_up_all {
	my($x) = @_;
	eval q( &wakeup($x));
    }
}
unless(defined(&wake_up_all_locked)) {
    sub wake_up_all_locked {
	my($x) = @_;
	eval q( &wakeup($x));
    }
}
unless(defined(&INIT_COMPLETION)) {
    sub INIT_COMPLETION {
	my($x) = @_;
	eval q((($x). &done = 0));
    }
}
eval 'sub NSEC_PER_USEC () {1000;}' unless defined(&NSEC_PER_USEC);
eval 'sub NSEC_PER_SEC () {1000000000;}' unless defined(&NSEC_PER_SEC);
unless(defined(&KHZ2PICOS)) {
    sub KHZ2PICOS {
	my($a) = @_;
	eval q((1000000000/($a)));
    }
}
eval 'sub jiffies () { &ticks;}' unless defined(&jiffies);
undef(&HZ) if defined(&HZ);
eval 'sub HZ () { &hz;}' unless defined(&HZ);
unless(defined(&jiffies_to_msecs)) {
    sub jiffies_to_msecs {
	my($x) = @_;
	eval q(((( &int64_t)($x)) * 1000/  &hz));
    }
}
unless(defined(&msecs_to_jiffies)) {
    sub msecs_to_jiffies {
	my($x) = @_;
	eval q(((( &int64_t)($x)) *  &hz / 1000));
    }
}
unless(defined(&time_after)) {
    sub time_after {
	my($a,$b) = @_;
	eval q(( - ($a) < 0));
    }
}
unless(defined(&time_after_eq)) {
    sub time_after_eq {
	my($a,$b) = @_;
	eval q(( - ($a) <= 0));
    }
}
unless(defined(&get_seconds)) {
    sub get_seconds () {
	eval q( &time_second);
    }
}
unless(defined(&getrawmonotonic)) {
    sub getrawmonotonic {
	my($x) = @_;
	eval q( &nanouptime($x));
    }
}
eval 'sub GFP_ATOMIC () { &M_NOWAIT;}' unless defined(&GFP_ATOMIC);
eval 'sub GFP_KERNEL () {( &M_WAITOK |  &M_CANFAIL);}' unless defined(&GFP_KERNEL);
eval 'sub __GFP_NOWARN () {0;}' unless defined(&__GFP_NOWARN);
eval 'sub __GFP_NORETRY () {0;}' unless defined(&__GFP_NORETRY);
unless(defined(&min_t)) {
    sub min_t {
	my($t, $a, $b) = @_;
	eval q(({ $t  &__min_a = ($a); $t  &__min_b = ($b);  &__min_a <  &__min_b ?  &__min_a :  &__min_b; }));
    }
}
unless(defined(&max_t)) {
    sub max_t {
	my($t, $a, $b) = @_;
	eval q(({ $t  &__max_a = ($a); $t  &__max_b = ($b);  &__max_a >  &__max_b ?  &__max_a :  &__max_b; }));
    }
}
unless(defined(&get_user)) {
    sub get_user {
	my($x, $ptr) = @_;
	eval q(- &copyin($ptr, ($x), $sizeof{$x}));
    }
}
unless(defined(&put_user)) {
    sub put_user {
	my($x, $ptr) = @_;
	eval q(- &copyout(($x), $ptr, $sizeof{$x}));
    }
}
unless(defined(&hweight16)) {
    sub hweight16 {
	my($x) = @_;
	eval q({ $x = ($x & 0x5555) + (($x & 0xaaaa) >> 1); $x = ($x & 0x3333) + (($x & 0xcccc) >> 2); $x = ($x + ($x >> 4)) & 0xf0f; $x = ($x + ($x >> 8)) & 0xff; ($x); });
    }
}
unless(defined(&console_lock)) {
    sub console_lock () {
	eval q();
    }
}
unless(defined(&console_unlock)) {
    sub console_unlock () {
	eval q();
    }
}
unless(defined(&PCI_MEM_START)) {
    eval 'sub PCI_MEM_START () {0;}' unless defined(&PCI_MEM_START);
}
unless(defined(&PCI_MEM_END)) {
    eval 'sub PCI_MEM_END () {0xffffffff;}' unless defined(&PCI_MEM_END);
}
eval("sub DMI_NONE () { 0; }") unless defined(&DMI_NONE);
eval("sub DMI_BIOS_VENDOR () { 1; }") unless defined(&DMI_BIOS_VENDOR);
eval("sub DMI_BIOS_VERSION () { 2; }") unless defined(&DMI_BIOS_VERSION);
eval("sub DMI_BIOS_DATE () { 3; }") unless defined(&DMI_BIOS_DATE);
eval("sub DMI_SYS_VENDOR () { 4; }") unless defined(&DMI_SYS_VENDOR);
eval("sub DMI_PRODUCT_NAME () { 5; }") unless defined(&DMI_PRODUCT_NAME);
eval("sub DMI_PRODUCT_VERSION () { 6; }") unless defined(&DMI_PRODUCT_VERSION);
eval("sub DMI_PRODUCT_SERIAL () { 7; }") unless defined(&DMI_PRODUCT_SERIAL);
eval("sub DMI_PRODUCT_UUID () { 8; }") unless defined(&DMI_PRODUCT_UUID);
eval("sub DMI_BOARD_VENDOR () { 9; }") unless defined(&DMI_BOARD_VENDOR);
eval("sub DMI_BOARD_NAME () { 10; }") unless defined(&DMI_BOARD_NAME);
eval("sub DMI_BOARD_VERSION () { 11; }") unless defined(&DMI_BOARD_VERSION);
eval("sub DMI_BOARD_SERIAL () { 12; }") unless defined(&DMI_BOARD_SERIAL);
eval("sub DMI_BOARD_ASSET_TAG () { 13; }") unless defined(&DMI_BOARD_ASSET_TAG);
eval("sub DMI_CHASSIS_VENDOR () { 14; }") unless defined(&DMI_CHASSIS_VENDOR);
eval("sub DMI_CHASSIS_TYPE () { 15; }") unless defined(&DMI_CHASSIS_TYPE);
eval("sub DMI_CHASSIS_VERSION () { 16; }") unless defined(&DMI_CHASSIS_VERSION);
eval("sub DMI_CHASSIS_SERIAL () { 17; }") unless defined(&DMI_CHASSIS_SERIAL);
eval("sub DMI_CHASSIS_ASSET_TAG () { 18; }") unless defined(&DMI_CHASSIS_ASSET_TAG);
eval("sub DMI_STRING_MAX () { 19; }") unless defined(&DMI_STRING_MAX);
unless(defined(&DMI_MATCH)) {
    sub DMI_MATCH {
	my($a, $b) = @_;
	eval q({($a), ($b)});
    }
}
unless(defined(&DMI_EXACT_MATCH)) {
    sub DMI_EXACT_MATCH {
	my($a, $b) = @_;
	eval q({($a), ($b)});
    }
}
eval 'sub PCI_ANY_ID () {( &uint16_t) (~0);}' unless defined(&PCI_ANY_ID);
eval 'sub PCI_VENDOR_ID_ASUSTEK () { &PCI_VENDOR_ASUSTEK;}' unless defined(&PCI_VENDOR_ID_ASUSTEK);
eval 'sub PCI_VENDOR_ID_ATI () { &PCI_VENDOR_ATI;}' unless defined(&PCI_VENDOR_ID_ATI);
eval 'sub PCI_VENDOR_ID_DELL () { &PCI_VENDOR_DELL;}' unless defined(&PCI_VENDOR_ID_DELL);
eval 'sub PCI_VENDOR_ID_HP () { &PCI_VENDOR_HP;}' unless defined(&PCI_VENDOR_ID_HP);
eval 'sub PCI_VENDOR_ID_IBM () { &PCI_VENDOR_IBM;}' unless defined(&PCI_VENDOR_ID_IBM);
eval 'sub PCI_VENDOR_ID_INTEL () { &PCI_VENDOR_INTEL;}' unless defined(&PCI_VENDOR_ID_INTEL);
eval 'sub PCI_VENDOR_ID_SONY () { &PCI_VENDOR_SONY;}' unless defined(&PCI_VENDOR_ID_SONY);
eval 'sub PCI_VENDOR_ID_VIA () { &PCI_VENDOR_VIATECH;}' unless defined(&PCI_VENDOR_ID_VIA);
eval 'sub PCI_DEVICE_ID_ATI_RADEON_QY () { &PCI_PRODUCT_ATI_RADEON_QY;}' unless defined(&PCI_DEVICE_ID_ATI_RADEON_QY);
unless(defined(&memcpy_toio)) {
    sub memcpy_toio {
	my($d, $s, $n) = @_;
	eval q( &memcpy($d, $s, $n));
    }
}
unless(defined(&memcpy_fromio)) {
    sub memcpy_fromio {
	my($d, $s, $n) = @_;
	eval q( &memcpy($d, $s, $n));
    }
}
unless(defined(&memset_io)) {
    sub memset_io {
	my($d, $b, $n) = @_;
	eval q( &memset($d, $b, $n));
    }
}
unless(defined(&page_to_phys)) {
    sub page_to_phys {
	my($page) = @_;
	eval q(( &VM_PAGE_TO_PHYS($page)));
    }
}
unless(defined(&page_to_pfn)) {
    sub page_to_pfn {
	my($pp) = @_;
	eval q(( &VM_PAGE_TO_PHYS($pp) /  &PAGE_SIZE));
    }
}
unless(defined(&offset_in_page)) {
    sub offset_in_page {
	my($off) = @_;
	eval q((($off) &  &PAGE_MASK));
    }
}
unless(defined(&set_page_dirty)) {
    sub set_page_dirty {
	my($page) = @_;
	eval q( &atomic_clearbits_int( ($page->{pg_flags}),  &PG_CLEAN));
    }
}
unless(defined(&pgprot_val)) {
    sub pgprot_val {
	my($v) = @_;
	eval q(($v));
    }
}
eval 'sub PAGE_KERNEL () {0;}' unless defined(&PAGE_KERNEL);
unless(defined(&round_up)) {
    sub round_up {
	my($x, $y) = @_;
	eval q((((($x) + (($y) - 1)) / ($y)) * ($y)));
    }
}
unless(defined(&round_down)) {
    sub round_down {
	my($x, $y) = @_;
	eval q(((($x) / ($y)) * ($y)));
    }
}
unless(defined(&roundup2)) {
    sub roundup2 {
	my($x, $y) = @_;
	eval q(((($x)+(($y)-1))(~(($y)-1))));
    }
}
unless(defined(&DIV_ROUND_UP)) {
    sub DIV_ROUND_UP {
	my($x, $y) = @_;
	eval q(((($x) + (($y) - 1)) / ($y)));
    }
}
unless(defined(&DIV_ROUND_CLOSEST)) {
    sub DIV_ROUND_CLOSEST {
	my($x, $y) = @_;
	eval q(((($x) + (($y) / 2)) / ($y)));
    }
}
unless(defined(&PAGE_ALIGN)) {
    sub PAGE_ALIGN {
	my($addr) = @_;
	eval q(((($addr) +  &PAGE_MASK) & ~ &PAGE_MASK));
    }
}
unless(defined(&IS_ALIGNED)) {
    sub IS_ALIGNED {
	my($x, $y) = @_;
	eval q(((($x) & (($y) - 1)) == 0));
    }
}
unless(defined(&udelay)) {
    sub udelay {
	my($usecs) = @_;
	eval q({  &DELAY($usecs); });
    }
}
unless(defined(&usleep_range)) {
    sub usleep_range {
	my($min,$max) = @_;
	eval q({  &DELAY($min); });
    }
}
unless(defined(&mdelay)) {
    sub mdelay {
	my($msecs) = @_;
	eval q({ 'int'  &loops = $msecs;  &while ( &loops--)  &DELAY(1000); });
    }
}
if(defined(&__macppc__)) {
    eval 'sub of_machine_is_compatible {
        my($model) = @_;
	    eval q({ \'char\' * &hw_prod; ( &strcmp($model,  &hw_prod) == 0); });
    }' unless defined(&of_machine_is_compatible);
}
if(defined(&__i386__) || defined(&__amd64__)) {
}
1;
