require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_ENVELOPE_H)) {
    eval 'sub HEADER_ENVELOPE_H () {1;}' unless defined(&HEADER_ENVELOPE_H);
    require 'openssl/opensslconf.ph';
    require 'openssl/ossl_typ.ph';
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    eval 'sub EVP_MAX_MD_SIZE () {64;}' unless defined(&EVP_MAX_MD_SIZE);
    eval 'sub EVP_MAX_KEY_LENGTH () {64;}' unless defined(&EVP_MAX_KEY_LENGTH);
    eval 'sub EVP_MAX_IV_LENGTH () {16;}' unless defined(&EVP_MAX_IV_LENGTH);
    eval 'sub EVP_MAX_BLOCK_LENGTH () {32;}' unless defined(&EVP_MAX_BLOCK_LENGTH);
    eval 'sub PKCS5_SALT_LEN () {8;}' unless defined(&PKCS5_SALT_LEN);
    eval 'sub PKCS5_DEFAULT_ITER () {2048;}' unless defined(&PKCS5_DEFAULT_ITER);
    require 'openssl/objects.ph';
    eval 'sub EVP_PK_RSA () {0x1;}' unless defined(&EVP_PK_RSA);
    eval 'sub EVP_PK_DSA () {0x2;}' unless defined(&EVP_PK_DSA);
    eval 'sub EVP_PK_DH () {0x4;}' unless defined(&EVP_PK_DH);
    eval 'sub EVP_PK_EC () {0x8;}' unless defined(&EVP_PK_EC);
    eval 'sub EVP_PKT_SIGN () {0x10;}' unless defined(&EVP_PKT_SIGN);
    eval 'sub EVP_PKT_ENC () {0x20;}' unless defined(&EVP_PKT_ENC);
    eval 'sub EVP_PKT_EXCH () {0x40;}' unless defined(&EVP_PKT_EXCH);
    eval 'sub EVP_PKS_RSA () {0x100;}' unless defined(&EVP_PKS_RSA);
    eval 'sub EVP_PKS_DSA () {0x200;}' unless defined(&EVP_PKS_DSA);
    eval 'sub EVP_PKS_EC () {0x400;}' unless defined(&EVP_PKS_EC);
    eval 'sub EVP_PKT_EXP () {0x1000;}' unless defined(&EVP_PKT_EXP);
    eval 'sub EVP_PKEY_NONE () { &NID_undef;}' unless defined(&EVP_PKEY_NONE);
    eval 'sub EVP_PKEY_RSA () { &NID_rsaEncryption;}' unless defined(&EVP_PKEY_RSA);
    eval 'sub EVP_PKEY_RSA2 () { &NID_rsa;}' unless defined(&EVP_PKEY_RSA2);
    eval 'sub EVP_PKEY_DSA () { &NID_dsa;}' unless defined(&EVP_PKEY_DSA);
    eval 'sub EVP_PKEY_DSA1 () { &NID_dsa_2;}' unless defined(&EVP_PKEY_DSA1);
    eval 'sub EVP_PKEY_DSA2 () { &NID_dsaWithSHA;}' unless defined(&EVP_PKEY_DSA2);
    eval 'sub EVP_PKEY_DSA3 () { &NID_dsaWithSHA1;}' unless defined(&EVP_PKEY_DSA3);
    eval 'sub EVP_PKEY_DSA4 () { &NID_dsaWithSHA1_2;}' unless defined(&EVP_PKEY_DSA4);
    eval 'sub EVP_PKEY_DH () { &NID_dhKeyAgreement;}' unless defined(&EVP_PKEY_DH);
    eval 'sub EVP_PKEY_EC () { &NID_X9_62_id_ecPublicKey;}' unless defined(&EVP_PKEY_EC);
    eval 'sub EVP_PKEY_GOSTR01 () { &NID_id_GostR3410_2001;}' unless defined(&EVP_PKEY_GOSTR01);
    eval 'sub EVP_PKEY_GOSTIMIT () { &NID_id_Gost28147_89_MAC;}' unless defined(&EVP_PKEY_GOSTIMIT);
    eval 'sub EVP_PKEY_HMAC () { &NID_hmac;}' unless defined(&EVP_PKEY_HMAC);
    eval 'sub EVP_PKEY_CMAC () { &NID_cmac;}' unless defined(&EVP_PKEY_CMAC);
    eval 'sub EVP_PKEY_GOSTR12_256 () { &NID_id_tc26_gost3410_2012_256;}' unless defined(&EVP_PKEY_GOSTR12_256);
    eval 'sub EVP_PKEY_GOSTR12_512 () { &NID_id_tc26_gost3410_2012_512;}' unless defined(&EVP_PKEY_GOSTR12_512);
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_DH)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    unless(defined(&OPENSSL_NO_GOST)) {
    }
    eval 'sub EVP_PKEY_MO_SIGN () {0x1;}' unless defined(&EVP_PKEY_MO_SIGN);
    eval 'sub EVP_PKEY_MO_VERIFY () {0x2;}' unless defined(&EVP_PKEY_MO_VERIFY);
    eval 'sub EVP_PKEY_MO_ENCRYPT () {0x4;}' unless defined(&EVP_PKEY_MO_ENCRYPT);
    eval 'sub EVP_PKEY_MO_DECRYPT () {0x8;}' unless defined(&EVP_PKEY_MO_DECRYPT);
    unless(defined(&EVP_MD)) {
	eval 'sub EVP_MD_FLAG_ONESHOT () {0x1;}' unless defined(&EVP_MD_FLAG_ONESHOT);
	eval 'sub EVP_MD_FLAG_PKEY_DIGEST () {0x2;}' unless defined(&EVP_MD_FLAG_PKEY_DIGEST);
	eval 'sub EVP_MD_FLAG_PKEY_METHOD_SIGNATURE () {0x4;}' unless defined(&EVP_MD_FLAG_PKEY_METHOD_SIGNATURE);
	eval 'sub EVP_MD_FLAG_DIGALGID_MASK () {0x18;}' unless defined(&EVP_MD_FLAG_DIGALGID_MASK);
	eval 'sub EVP_MD_FLAG_DIGALGID_NULL () {0x;}' unless defined(&EVP_MD_FLAG_DIGALGID_NULL);
	eval 'sub EVP_MD_FLAG_DIGALGID_ABSENT () {0x8;}' unless defined(&EVP_MD_FLAG_DIGALGID_ABSENT);
	eval 'sub EVP_MD_FLAG_DIGALGID_CUSTOM () {0x18;}' unless defined(&EVP_MD_FLAG_DIGALGID_CUSTOM);
	eval 'sub EVP_MD_FLAG_FIPS () {0x400;}' unless defined(&EVP_MD_FLAG_FIPS);
	eval 'sub EVP_MD_CTRL_DIGALGID () {0x1;}' unless defined(&EVP_MD_CTRL_DIGALGID);
	eval 'sub EVP_MD_CTRL_MICALG () {0x2;}' unless defined(&EVP_MD_CTRL_MICALG);
	eval 'sub EVP_MD_CTRL_SET_KEY () {0x3;}' unless defined(&EVP_MD_CTRL_SET_KEY);
	eval 'sub EVP_MD_CTRL_GOST_SET_SBOX () {0x4;}' unless defined(&EVP_MD_CTRL_GOST_SET_SBOX);
	eval 'sub EVP_MD_CTRL_ALG_CTRL () {0x1000;}' unless defined(&EVP_MD_CTRL_ALG_CTRL);
	eval 'sub EVP_PKEY_NULL_method () { &NULL, &NULL,{0,0,0,0};}' unless defined(&EVP_PKEY_NULL_method);
	unless(defined(&OPENSSL_NO_DSA)) {
	    eval 'sub EVP_PKEY_DSA_method () {( &evp_sign_method *) &DSA_sign, ( &evp_verify_method *) &DSA_verify, { &EVP_PKEY_DSA, &EVP_PKEY_DSA2, &EVP_PKEY_DSA3,  &EVP_PKEY_DSA4,0};}' unless defined(&EVP_PKEY_DSA_method);
	} else {
	    eval 'sub EVP_PKEY_DSA_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_DSA_method);
	}
	unless(defined(&OPENSSL_NO_ECDSA)) {
	    eval 'sub EVP_PKEY_ECDSA_method () {( &evp_sign_method *) &ECDSA_sign, ( &evp_verify_method *) &ECDSA_verify, { &EVP_PKEY_EC,0,0,0};}' unless defined(&EVP_PKEY_ECDSA_method);
	} else {
	    eval 'sub EVP_PKEY_ECDSA_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_ECDSA_method);
	}
	unless(defined(&OPENSSL_NO_RSA)) {
	    eval 'sub EVP_PKEY_RSA_method () {( &evp_sign_method *) &RSA_sign, ( &evp_verify_method *) &RSA_verify, { &EVP_PKEY_RSA, &EVP_PKEY_RSA2,0,0};}' unless defined(&EVP_PKEY_RSA_method);
	    eval 'sub EVP_PKEY_RSA_ASN1_OCTET_STRING_method () {( &evp_sign_method *) &RSA_sign_ASN1_OCTET_STRING, ( &evp_verify_method *) &RSA_verify_ASN1_OCTET_STRING, { &EVP_PKEY_RSA, &EVP_PKEY_RSA2,0,0};}' unless defined(&EVP_PKEY_RSA_ASN1_OCTET_STRING_method);
	} else {
	    eval 'sub EVP_PKEY_RSA_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_RSA_method);
	    eval 'sub EVP_PKEY_RSA_ASN1_OCTET_STRING_method () { &EVP_PKEY_NULL_method;}' unless defined(&EVP_PKEY_RSA_ASN1_OCTET_STRING_method);
	}
    }
    eval 'sub EVP_MD_CTX_FLAG_ONESHOT () {0x1;}' unless defined(&EVP_MD_CTX_FLAG_ONESHOT);
    eval 'sub EVP_MD_CTX_FLAG_CLEANED () {0x2;}' unless defined(&EVP_MD_CTX_FLAG_CLEANED);
    eval 'sub EVP_MD_CTX_FLAG_REUSE () {0x4;}' unless defined(&EVP_MD_CTX_FLAG_REUSE);
    eval 'sub EVP_MD_CTX_FLAG_NON_FIPS_ALLOW () {0x8;}' unless defined(&EVP_MD_CTX_FLAG_NON_FIPS_ALLOW);
    eval 'sub EVP_MD_CTX_FLAG_PAD_MASK () {0xf0;}' unless defined(&EVP_MD_CTX_FLAG_PAD_MASK);
    eval 'sub EVP_MD_CTX_FLAG_PAD_PKCS1 () {0x;}' unless defined(&EVP_MD_CTX_FLAG_PAD_PKCS1);
    eval 'sub EVP_MD_CTX_FLAG_PAD_X931 () {0x10;}' unless defined(&EVP_MD_CTX_FLAG_PAD_X931);
    eval 'sub EVP_MD_CTX_FLAG_PAD_PSS () {0x20;}' unless defined(&EVP_MD_CTX_FLAG_PAD_PSS);
    eval 'sub EVP_MD_CTX_FLAG_NO_INIT () {0x100;}' unless defined(&EVP_MD_CTX_FLAG_NO_INIT);
    eval 'sub EVP_CIPH_STREAM_CIPHER () {0x;}' unless defined(&EVP_CIPH_STREAM_CIPHER);
    eval 'sub EVP_CIPH_ECB_MODE () {0x1;}' unless defined(&EVP_CIPH_ECB_MODE);
    eval 'sub EVP_CIPH_CBC_MODE () {0x2;}' unless defined(&EVP_CIPH_CBC_MODE);
    eval 'sub EVP_CIPH_CFB_MODE () {0x3;}' unless defined(&EVP_CIPH_CFB_MODE);
    eval 'sub EVP_CIPH_OFB_MODE () {0x4;}' unless defined(&EVP_CIPH_OFB_MODE);
    eval 'sub EVP_CIPH_CTR_MODE () {0x5;}' unless defined(&EVP_CIPH_CTR_MODE);
    eval 'sub EVP_CIPH_GCM_MODE () {0x6;}' unless defined(&EVP_CIPH_GCM_MODE);
    eval 'sub EVP_CIPH_CCM_MODE () {0x7;}' unless defined(&EVP_CIPH_CCM_MODE);
    eval 'sub EVP_CIPH_XTS_MODE () {0x10001;}' unless defined(&EVP_CIPH_XTS_MODE);
    eval 'sub EVP_CIPH_MODE () {0xf0007;}' unless defined(&EVP_CIPH_MODE);
    eval 'sub EVP_CIPH_VARIABLE_LENGTH () {0x8;}' unless defined(&EVP_CIPH_VARIABLE_LENGTH);
    eval 'sub EVP_CIPH_CUSTOM_IV () {0x10;}' unless defined(&EVP_CIPH_CUSTOM_IV);
    eval 'sub EVP_CIPH_ALWAYS_CALL_INIT () {0x20;}' unless defined(&EVP_CIPH_ALWAYS_CALL_INIT);
    eval 'sub EVP_CIPH_CTRL_INIT () {0x40;}' unless defined(&EVP_CIPH_CTRL_INIT);
    eval 'sub EVP_CIPH_CUSTOM_KEY_LENGTH () {0x80;}' unless defined(&EVP_CIPH_CUSTOM_KEY_LENGTH);
    eval 'sub EVP_CIPH_NO_PADDING () {0x100;}' unless defined(&EVP_CIPH_NO_PADDING);
    eval 'sub EVP_CIPH_RAND_KEY () {0x200;}' unless defined(&EVP_CIPH_RAND_KEY);
    eval 'sub EVP_CIPH_CUSTOM_COPY () {0x400;}' unless defined(&EVP_CIPH_CUSTOM_COPY);
    eval 'sub EVP_CIPH_FLAG_DEFAULT_ASN1 () {0x1000;}' unless defined(&EVP_CIPH_FLAG_DEFAULT_ASN1);
    eval 'sub EVP_CIPH_FLAG_LENGTH_BITS () {0x2000;}' unless defined(&EVP_CIPH_FLAG_LENGTH_BITS);
    eval 'sub EVP_CIPH_FLAG_FIPS () {0x4000;}' unless defined(&EVP_CIPH_FLAG_FIPS);
    eval 'sub EVP_CIPH_FLAG_NON_FIPS_ALLOW () {0x8000;}' unless defined(&EVP_CIPH_FLAG_NON_FIPS_ALLOW);
    eval 'sub EVP_CIPH_FLAG_CUSTOM_CIPHER () {0x100000;}' unless defined(&EVP_CIPH_FLAG_CUSTOM_CIPHER);
    eval 'sub EVP_CIPH_FLAG_AEAD_CIPHER () {0x200000;}' unless defined(&EVP_CIPH_FLAG_AEAD_CIPHER);
    eval 'sub EVP_CTRL_INIT () {0x;}' unless defined(&EVP_CTRL_INIT);
    eval 'sub EVP_CTRL_SET_KEY_LENGTH () {0x1;}' unless defined(&EVP_CTRL_SET_KEY_LENGTH);
    eval 'sub EVP_CTRL_GET_RC2_KEY_BITS () {0x2;}' unless defined(&EVP_CTRL_GET_RC2_KEY_BITS);
    eval 'sub EVP_CTRL_SET_RC2_KEY_BITS () {0x3;}' unless defined(&EVP_CTRL_SET_RC2_KEY_BITS);
    eval 'sub EVP_CTRL_GET_RC5_ROUNDS () {0x4;}' unless defined(&EVP_CTRL_GET_RC5_ROUNDS);
    eval 'sub EVP_CTRL_SET_RC5_ROUNDS () {0x5;}' unless defined(&EVP_CTRL_SET_RC5_ROUNDS);
    eval 'sub EVP_CTRL_RAND_KEY () {0x6;}' unless defined(&EVP_CTRL_RAND_KEY);
    eval 'sub EVP_CTRL_PBE_PRF_NID () {0x7;}' unless defined(&EVP_CTRL_PBE_PRF_NID);
    eval 'sub EVP_CTRL_COPY () {0x8;}' unless defined(&EVP_CTRL_COPY);
    eval 'sub EVP_CTRL_GCM_SET_IVLEN () {0x9;}' unless defined(&EVP_CTRL_GCM_SET_IVLEN);
    eval 'sub EVP_CTRL_GCM_GET_TAG () {0x10;}' unless defined(&EVP_CTRL_GCM_GET_TAG);
    eval 'sub EVP_CTRL_GCM_SET_TAG () {0x11;}' unless defined(&EVP_CTRL_GCM_SET_TAG);
    eval 'sub EVP_CTRL_GCM_SET_IV_FIXED () {0x12;}' unless defined(&EVP_CTRL_GCM_SET_IV_FIXED);
    eval 'sub EVP_CTRL_GCM_IV_GEN () {0x13;}' unless defined(&EVP_CTRL_GCM_IV_GEN);
    eval 'sub EVP_CTRL_CCM_SET_IVLEN () { &EVP_CTRL_GCM_SET_IVLEN;}' unless defined(&EVP_CTRL_CCM_SET_IVLEN);
    eval 'sub EVP_CTRL_CCM_GET_TAG () { &EVP_CTRL_GCM_GET_TAG;}' unless defined(&EVP_CTRL_CCM_GET_TAG);
    eval 'sub EVP_CTRL_CCM_SET_TAG () { &EVP_CTRL_GCM_SET_TAG;}' unless defined(&EVP_CTRL_CCM_SET_TAG);
    eval 'sub EVP_CTRL_CCM_SET_L () {0x14;}' unless defined(&EVP_CTRL_CCM_SET_L);
    eval 'sub EVP_CTRL_CCM_SET_MSGLEN () {0x15;}' unless defined(&EVP_CTRL_CCM_SET_MSGLEN);
    eval 'sub EVP_CTRL_AEAD_TLS1_AAD () {0x16;}' unless defined(&EVP_CTRL_AEAD_TLS1_AAD);
    eval 'sub EVP_CTRL_AEAD_SET_MAC_KEY () {0x17;}' unless defined(&EVP_CTRL_AEAD_SET_MAC_KEY);
    eval 'sub EVP_CTRL_GCM_SET_IV_INV () {0x18;}' unless defined(&EVP_CTRL_GCM_SET_IV_INV);
    eval 'sub EVP_CTRL_GOST_SET_SBOX () {0x19;}' unless defined(&EVP_CTRL_GOST_SET_SBOX);
    eval 'sub EVP_GCM_TLS_FIXED_IV_LEN () {4;}' unless defined(&EVP_GCM_TLS_FIXED_IV_LEN);
    eval 'sub EVP_GCM_TLS_EXPLICIT_IV_LEN () {8;}' unless defined(&EVP_GCM_TLS_EXPLICIT_IV_LEN);
    eval 'sub EVP_GCM_TLS_TAG_LEN () {16;}' unless defined(&EVP_GCM_TLS_TAG_LEN);
    unless(defined(&OPENSSL_NO_RSA)) {
	eval 'sub EVP_PKEY_assign_RSA {
	    my($pkey,$rsa) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_RSA, ($rsa)));
	}' unless defined(&EVP_PKEY_assign_RSA);
    }
    unless(defined(&OPENSSL_NO_DSA)) {
	eval 'sub EVP_PKEY_assign_DSA {
	    my($pkey,$dsa) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_DSA, ($dsa)));
	}' unless defined(&EVP_PKEY_assign_DSA);
    }
    unless(defined(&OPENSSL_NO_DH)) {
	eval 'sub EVP_PKEY_assign_DH {
	    my($pkey,$dh) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_DH, ($dh)));
	}' unless defined(&EVP_PKEY_assign_DH);
    }
    unless(defined(&OPENSSL_NO_EC)) {
	eval 'sub EVP_PKEY_assign_EC_KEY {
	    my($pkey,$eckey) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_EC, ($eckey)));
	}' unless defined(&EVP_PKEY_assign_EC_KEY);
    }
    unless(defined(&OPENSSL_NO_GOST)) {
	eval 'sub EVP_PKEY_assign_GOST {
	    my($pkey,$gostkey) = @_;
    	    eval q( &EVP_PKEY_assign(, &EVP_PKEY_GOSTR01, ($gostkey)));
	}' unless defined(&EVP_PKEY_assign_GOST);
    }
    eval 'sub EVP_get_digestbynid {
        my($a) = @_;
	    eval q( &EVP_get_digestbyname( &OBJ_nid2sn($a)));
    }' unless defined(&EVP_get_digestbynid);
    eval 'sub EVP_get_digestbyobj {
        my($a) = @_;
	    eval q( &EVP_get_digestbynid( &OBJ_obj2nid($a)));
    }' unless defined(&EVP_get_digestbyobj);
    eval 'sub EVP_get_cipherbynid {
        my($a) = @_;
	    eval q( &EVP_get_cipherbyname( &OBJ_nid2sn($a)));
    }' unless defined(&EVP_get_cipherbynid);
    eval 'sub EVP_get_cipherbyobj {
        my($a) = @_;
	    eval q( &EVP_get_cipherbynid( &OBJ_obj2nid($a)));
    }' unless defined(&EVP_get_cipherbyobj);
    eval 'sub EVP_MD_nid {
        my($e) = @_;
	    eval q( &EVP_MD_type($e));
    }' unless defined(&EVP_MD_nid);
    eval 'sub EVP_MD_name {
        my($e) = @_;
	    eval q( &OBJ_nid2sn( &EVP_MD_nid($e)));
    }' unless defined(&EVP_MD_name);
    eval 'sub EVP_MD_CTX_size {
        my($e) = @_;
	    eval q( &EVP_MD_size( &EVP_MD_CTX_md($e)));
    }' unless defined(&EVP_MD_CTX_size);
    eval 'sub EVP_MD_CTX_block_size {
        my($e) = @_;
	    eval q( &EVP_MD_block_size( &EVP_MD_CTX_md($e)));
    }' unless defined(&EVP_MD_CTX_block_size);
    eval 'sub EVP_MD_CTX_type {
        my($e) = @_;
	    eval q( &EVP_MD_type( &EVP_MD_CTX_md($e)));
    }' unless defined(&EVP_MD_CTX_type);
    eval 'sub EVP_CIPHER_name {
        my($e) = @_;
	    eval q( &OBJ_nid2sn( &EVP_CIPHER_nid($e)));
    }' unless defined(&EVP_CIPHER_name);
    eval 'sub EVP_CIPHER_mode {
        my($e) = @_;
	    eval q(( &EVP_CIPHER_flags($e) &  &EVP_CIPH_MODE));
    }' unless defined(&EVP_CIPHER_mode);
    eval 'sub EVP_CIPHER_CTX_type {
        my($c) = @_;
	    eval q( &EVP_CIPHER_type( &EVP_CIPHER_CTX_cipher($c)));
    }' unless defined(&EVP_CIPHER_CTX_type);
    eval 'sub EVP_CIPHER_CTX_mode {
        my($e) = @_;
	    eval q(( &EVP_CIPHER_CTX_flags($e) &  &EVP_CIPH_MODE));
    }' unless defined(&EVP_CIPHER_CTX_mode);
    eval 'sub EVP_ENCODE_LENGTH {
        my($l) = @_;
	    eval q(((($l+2)/3*4)+($l/48+1)*2+80));
    }' unless defined(&EVP_ENCODE_LENGTH);
    eval 'sub EVP_DECODE_LENGTH {
        my($l) = @_;
	    eval q((($l+3)/4*3+80));
    }' unless defined(&EVP_DECODE_LENGTH);
    eval 'sub EVP_SignInit_ex {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestInit_ex($a,$b,$c));
    }' unless defined(&EVP_SignInit_ex);
    eval 'sub EVP_SignInit {
        my($a,$b) = @_;
	    eval q( &EVP_DigestInit($a,$b));
    }' unless defined(&EVP_SignInit);
    eval 'sub EVP_SignUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_SignUpdate);
    eval 'sub EVP_VerifyInit_ex {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestInit_ex($a,$b,$c));
    }' unless defined(&EVP_VerifyInit_ex);
    eval 'sub EVP_VerifyInit {
        my($a,$b) = @_;
	    eval q( &EVP_DigestInit($a,$b));
    }' unless defined(&EVP_VerifyInit);
    eval 'sub EVP_VerifyUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_VerifyUpdate);
    eval 'sub EVP_OpenUpdate {
        my($a,$b,$c,$d,$e) = @_;
	    eval q( &EVP_DecryptUpdate($a,$b,$c,$d,$e));
    }' unless defined(&EVP_OpenUpdate);
    eval 'sub EVP_SealUpdate {
        my($a,$b,$c,$d,$e) = @_;
	    eval q( &EVP_EncryptUpdate($a,$b,$c,$d,$e));
    }' unless defined(&EVP_SealUpdate);
    eval 'sub EVP_DigestSignUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_DigestSignUpdate);
    eval 'sub EVP_DigestVerifyUpdate {
        my($a,$b,$c) = @_;
	    eval q( &EVP_DigestUpdate($a,$b,$c));
    }' unless defined(&EVP_DigestVerifyUpdate);
    eval 'sub BIO_set_md {
        my($b,$md) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_MD,0,$md));
    }' unless defined(&BIO_set_md);
    eval 'sub BIO_get_md {
        my($b,$mdp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_MD,0,$mdp));
    }' unless defined(&BIO_get_md);
    eval 'sub BIO_get_md_ctx {
        my($b,$mdcp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_MD_CTX,0,$mdcp));
    }' unless defined(&BIO_get_md_ctx);
    eval 'sub BIO_set_md_ctx {
        my($b,$mdcp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_MD_CTX,0,$mdcp));
    }' unless defined(&BIO_set_md_ctx);
    eval 'sub BIO_get_cipher_status {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_CIPHER_STATUS,0, &NULL));
    }' unless defined(&BIO_get_cipher_status);
    eval 'sub BIO_get_cipher_ctx {
        my($b,$c_pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_CIPHER_CTX,0,$c_pp));
    }' unless defined(&BIO_get_cipher_ctx);
    eval 'sub EVP_add_cipher_alias {
        my($n,$alias) = @_;
	    eval q( &OBJ_NAME_add(($alias), &OBJ_NAME_TYPE_CIPHER_METH| &OBJ_NAME_ALIAS,($n)));
    }' unless defined(&EVP_add_cipher_alias);
    eval 'sub EVP_add_digest_alias {
        my($n,$alias) = @_;
	    eval q( &OBJ_NAME_add(($alias), &OBJ_NAME_TYPE_MD_METH| &OBJ_NAME_ALIAS,($n)));
    }' unless defined(&EVP_add_digest_alias);
    eval 'sub EVP_delete_cipher_alias {
        my($alias) = @_;
	    eval q( &OBJ_NAME_remove($alias, &OBJ_NAME_TYPE_CIPHER_METH| &OBJ_NAME_ALIAS););
    }' unless defined(&EVP_delete_cipher_alias);
    eval 'sub EVP_delete_digest_alias {
        my($alias) = @_;
	    eval q( &OBJ_NAME_remove($alias, &OBJ_NAME_TYPE_MD_METH| &OBJ_NAME_ALIAS););
    }' unless defined(&EVP_delete_digest_alias);
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    unless(defined(&OPENSSL_NO_MD4)) {
    }
    unless(defined(&OPENSSL_NO_MD5)) {
    }
    unless(defined(&OPENSSL_NO_SHA)) {
    }
    unless(defined(&OPENSSL_NO_SHA256)) {
    }
    unless(defined(&OPENSSL_NO_SHA512)) {
    }
    unless(defined(&OPENSSL_NO_RIPEMD)) {
    }
    unless(defined(&OPENSSL_NO_WHIRLPOOL)) {
    }
    unless(defined(&OPENSSL_NO_GOST)) {
    }
    unless(defined(&OPENSSL_NO_DES)) {
	eval 'sub EVP_des_cfb () { &EVP_des_cfb64;}' unless defined(&EVP_des_cfb);
	eval 'sub EVP_des_ede_cfb () { &EVP_des_ede_cfb64;}' unless defined(&EVP_des_ede_cfb);
	eval 'sub EVP_des_ede3_cfb () { &EVP_des_ede3_cfb64;}' unless defined(&EVP_des_ede3_cfb);
    }
    unless(defined(&OPENSSL_NO_RC4)) {
	unless(defined(&OPENSSL_NO_MD5)) {
	}
    }
    unless(defined(&OPENSSL_NO_IDEA)) {
	eval 'sub EVP_idea_cfb () { &EVP_idea_cfb64;}' unless defined(&EVP_idea_cfb);
    }
    unless(defined(&OPENSSL_NO_RC2)) {
	eval 'sub EVP_rc2_cfb () { &EVP_rc2_cfb64;}' unless defined(&EVP_rc2_cfb);
    }
    unless(defined(&OPENSSL_NO_BF)) {
	eval 'sub EVP_bf_cfb () { &EVP_bf_cfb64;}' unless defined(&EVP_bf_cfb);
    }
    unless(defined(&OPENSSL_NO_CAST)) {
	eval 'sub EVP_cast5_cfb () { &EVP_cast5_cfb64;}' unless defined(&EVP_cast5_cfb);
    }
    unless(defined(&OPENSSL_NO_AES)) {
	eval 'sub EVP_aes_128_cfb () { &EVP_aes_128_cfb128;}' unless defined(&EVP_aes_128_cfb);
	eval 'sub EVP_aes_192_cfb () { &EVP_aes_192_cfb128;}' unless defined(&EVP_aes_192_cfb);
	eval 'sub EVP_aes_256_cfb () { &EVP_aes_256_cfb128;}' unless defined(&EVP_aes_256_cfb);
	if(!defined(&OPENSSL_NO_SHA)  && !defined(&OPENSSL_NO_SHA1)) {
	}
    }
    unless(defined(&OPENSSL_NO_CAMELLIA)) {
	eval 'sub EVP_camellia_128_cfb () { &EVP_camellia_128_cfb128;}' unless defined(&EVP_camellia_128_cfb);
	eval 'sub EVP_camellia_192_cfb () { &EVP_camellia_192_cfb128;}' unless defined(&EVP_camellia_192_cfb);
	eval 'sub EVP_camellia_256_cfb () { &EVP_camellia_256_cfb128;}' unless defined(&EVP_camellia_256_cfb);
    }
    unless(defined(&OPENSSL_NO_CHACHA)) {
    }
    unless(defined(&OPENSSL_NO_GOST)) {
    }
    if(defined(&OPENSSL_LOAD_CONF)) {
	eval 'sub OpenSSL_add_all_algorithms () {
	    eval q( &OPENSSL_add_all_algorithms_conf());
	}' unless defined(&OpenSSL_add_all_algorithms);
    } else {
	eval 'sub OpenSSL_add_all_algorithms () {
	    eval q( &OPENSSL_add_all_algorithms_noconf());
	}' unless defined(&OpenSSL_add_all_algorithms);
    }
    eval 'sub SSLeay_add_all_algorithms () {
        eval q( &OpenSSL_add_all_algorithms());
    }' unless defined(&SSLeay_add_all_algorithms);
    eval 'sub SSLeay_add_all_ciphers () {
        eval q( &OpenSSL_add_all_ciphers());
    }' unless defined(&SSLeay_add_all_ciphers);
    eval 'sub SSLeay_add_all_digests () {
        eval q( &OpenSSL_add_all_digests());
    }' unless defined(&SSLeay_add_all_digests);
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_DH)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    unless(defined(&OPENSSL_NO_GOST)) {
    }
    eval 'sub EVP_PBE_TYPE_OUTER () {0x;}' unless defined(&EVP_PBE_TYPE_OUTER);
    eval 'sub EVP_PBE_TYPE_PRF () {0x1;}' unless defined(&EVP_PBE_TYPE_PRF);
    eval 'sub ASN1_PKEY_ALIAS () {0x1;}' unless defined(&ASN1_PKEY_ALIAS);
    eval 'sub ASN1_PKEY_DYNAMIC () {0x2;}' unless defined(&ASN1_PKEY_DYNAMIC);
    eval 'sub ASN1_PKEY_SIGPARAM_NULL () {0x4;}' unless defined(&ASN1_PKEY_SIGPARAM_NULL);
    eval 'sub ASN1_PKEY_CTRL_PKCS7_SIGN () {0x1;}' unless defined(&ASN1_PKEY_CTRL_PKCS7_SIGN);
    eval 'sub ASN1_PKEY_CTRL_PKCS7_ENCRYPT () {0x2;}' unless defined(&ASN1_PKEY_CTRL_PKCS7_ENCRYPT);
    eval 'sub ASN1_PKEY_CTRL_DEFAULT_MD_NID () {0x3;}' unless defined(&ASN1_PKEY_CTRL_DEFAULT_MD_NID);
    eval 'sub ASN1_PKEY_CTRL_CMS_SIGN () {0x5;}' unless defined(&ASN1_PKEY_CTRL_CMS_SIGN);
    eval 'sub ASN1_PKEY_CTRL_CMS_ENVELOPE () {0x7;}' unless defined(&ASN1_PKEY_CTRL_CMS_ENVELOPE);
    eval 'sub EVP_PKEY_OP_UNDEFINED () {0;}' unless defined(&EVP_PKEY_OP_UNDEFINED);
    eval 'sub EVP_PKEY_OP_PARAMGEN () {(1<<1);}' unless defined(&EVP_PKEY_OP_PARAMGEN);
    eval 'sub EVP_PKEY_OP_KEYGEN () {(1<<2);}' unless defined(&EVP_PKEY_OP_KEYGEN);
    eval 'sub EVP_PKEY_OP_SIGN () {(1<<3);}' unless defined(&EVP_PKEY_OP_SIGN);
    eval 'sub EVP_PKEY_OP_VERIFY () {(1<<4);}' unless defined(&EVP_PKEY_OP_VERIFY);
    eval 'sub EVP_PKEY_OP_VERIFYRECOVER () {(1<<5);}' unless defined(&EVP_PKEY_OP_VERIFYRECOVER);
    eval 'sub EVP_PKEY_OP_SIGNCTX () {(1<<6);}' unless defined(&EVP_PKEY_OP_SIGNCTX);
    eval 'sub EVP_PKEY_OP_VERIFYCTX () {(1<<7);}' unless defined(&EVP_PKEY_OP_VERIFYCTX);
    eval 'sub EVP_PKEY_OP_ENCRYPT () {(1<<8);}' unless defined(&EVP_PKEY_OP_ENCRYPT);
    eval 'sub EVP_PKEY_OP_DECRYPT () {(1<<9);}' unless defined(&EVP_PKEY_OP_DECRYPT);
    eval 'sub EVP_PKEY_OP_DERIVE () {(1<<10);}' unless defined(&EVP_PKEY_OP_DERIVE);
    eval 'sub EVP_PKEY_OP_TYPE_SIG () {( &EVP_PKEY_OP_SIGN |  &EVP_PKEY_OP_VERIFY |  &EVP_PKEY_OP_VERIFYRECOVER |  &EVP_PKEY_OP_SIGNCTX |  &EVP_PKEY_OP_VERIFYCTX);}' unless defined(&EVP_PKEY_OP_TYPE_SIG);
    eval 'sub EVP_PKEY_OP_TYPE_CRYPT () {( &EVP_PKEY_OP_ENCRYPT |  &EVP_PKEY_OP_DECRYPT);}' unless defined(&EVP_PKEY_OP_TYPE_CRYPT);
    eval 'sub EVP_PKEY_OP_TYPE_NOGEN () {( &EVP_PKEY_OP_SIG |  &EVP_PKEY_OP_CRYPT |  &EVP_PKEY_OP_DERIVE);}' unless defined(&EVP_PKEY_OP_TYPE_NOGEN);
    eval 'sub EVP_PKEY_OP_TYPE_GEN () {( &EVP_PKEY_OP_PARAMGEN |  &EVP_PKEY_OP_KEYGEN);}' unless defined(&EVP_PKEY_OP_TYPE_GEN);
    eval 'sub EVP_PKEY_CTX_set_signature_md {
        my($ctx, $md) = @_;
	    eval q( &EVP_PKEY_CTX_ctrl($ctx, -1,  &EVP_PKEY_OP_TYPE_SIG,  &EVP_PKEY_CTRL_MD, 0, ( &void *)$md));
    }' unless defined(&EVP_PKEY_CTX_set_signature_md);
    eval 'sub EVP_PKEY_CTRL_MD () {1;}' unless defined(&EVP_PKEY_CTRL_MD);
    eval 'sub EVP_PKEY_CTRL_PEER_KEY () {2;}' unless defined(&EVP_PKEY_CTRL_PEER_KEY);
    eval 'sub EVP_PKEY_CTRL_PKCS7_ENCRYPT () {3;}' unless defined(&EVP_PKEY_CTRL_PKCS7_ENCRYPT);
    eval 'sub EVP_PKEY_CTRL_PKCS7_DECRYPT () {4;}' unless defined(&EVP_PKEY_CTRL_PKCS7_DECRYPT);
    eval 'sub EVP_PKEY_CTRL_PKCS7_SIGN () {5;}' unless defined(&EVP_PKEY_CTRL_PKCS7_SIGN);
    eval 'sub EVP_PKEY_CTRL_SET_MAC_KEY () {6;}' unless defined(&EVP_PKEY_CTRL_SET_MAC_KEY);
    eval 'sub EVP_PKEY_CTRL_DIGESTINIT () {7;}' unless defined(&EVP_PKEY_CTRL_DIGESTINIT);
    eval 'sub EVP_PKEY_CTRL_SET_IV () {8;}' unless defined(&EVP_PKEY_CTRL_SET_IV);
    eval 'sub EVP_PKEY_CTRL_CMS_ENCRYPT () {9;}' unless defined(&EVP_PKEY_CTRL_CMS_ENCRYPT);
    eval 'sub EVP_PKEY_CTRL_CMS_DECRYPT () {10;}' unless defined(&EVP_PKEY_CTRL_CMS_DECRYPT);
    eval 'sub EVP_PKEY_CTRL_CMS_SIGN () {11;}' unless defined(&EVP_PKEY_CTRL_CMS_SIGN);
    eval 'sub EVP_PKEY_CTRL_CIPHER () {12;}' unless defined(&EVP_PKEY_CTRL_CIPHER);
    eval 'sub EVP_PKEY_ALG_CTRL () {0x1000;}' unless defined(&EVP_PKEY_ALG_CTRL);
    eval 'sub EVP_PKEY_FLAG_AUTOARGLEN () {2;}' unless defined(&EVP_PKEY_FLAG_AUTOARGLEN);
    eval 'sub EVP_PKEY_FLAG_SIGCTX_CUSTOM () {4;}' unless defined(&EVP_PKEY_FLAG_SIGCTX_CUSTOM);
    unless(defined(&OPENSSL_NO_AES)) {
    }
    if(!defined(&OPENSSL_NO_CHACHA)  && !defined(&OPENSSL_NO_POLY1305)) {
    }
    eval 'sub EVP_AEAD_MAX_TAG_LENGTH () {16;}' unless defined(&EVP_AEAD_MAX_TAG_LENGTH);
    eval 'sub EVP_AEAD_DEFAULT_TAG_LENGTH () {0;}' unless defined(&EVP_AEAD_DEFAULT_TAG_LENGTH);
    eval 'sub EVP_F_AEAD_AES_GCM_INIT () {187;}' unless defined(&EVP_F_AEAD_AES_GCM_INIT);
    eval 'sub EVP_F_AEAD_AES_GCM_OPEN () {188;}' unless defined(&EVP_F_AEAD_AES_GCM_OPEN);
    eval 'sub EVP_F_AEAD_AES_GCM_SEAL () {189;}' unless defined(&EVP_F_AEAD_AES_GCM_SEAL);
    eval 'sub EVP_F_AEAD_CHACHA20_POLY1305_INIT () {192;}' unless defined(&EVP_F_AEAD_CHACHA20_POLY1305_INIT);
    eval 'sub EVP_F_AEAD_CHACHA20_POLY1305_OPEN () {193;}' unless defined(&EVP_F_AEAD_CHACHA20_POLY1305_OPEN);
    eval 'sub EVP_F_AEAD_CHACHA20_POLY1305_SEAL () {194;}' unless defined(&EVP_F_AEAD_CHACHA20_POLY1305_SEAL);
    eval 'sub EVP_F_AEAD_CTX_OPEN () {185;}' unless defined(&EVP_F_AEAD_CTX_OPEN);
    eval 'sub EVP_F_AEAD_CTX_SEAL () {186;}' unless defined(&EVP_F_AEAD_CTX_SEAL);
    eval 'sub EVP_F_AESNI_INIT_KEY () {165;}' unless defined(&EVP_F_AESNI_INIT_KEY);
    eval 'sub EVP_F_AESNI_XTS_CIPHER () {176;}' unless defined(&EVP_F_AESNI_XTS_CIPHER);
    eval 'sub EVP_F_AES_INIT_KEY () {133;}' unless defined(&EVP_F_AES_INIT_KEY);
    eval 'sub EVP_F_AES_XTS () {172;}' unless defined(&EVP_F_AES_XTS);
    eval 'sub EVP_F_AES_XTS_CIPHER () {175;}' unless defined(&EVP_F_AES_XTS_CIPHER);
    eval 'sub EVP_F_ALG_MODULE_INIT () {177;}' unless defined(&EVP_F_ALG_MODULE_INIT);
    eval 'sub EVP_F_CAMELLIA_INIT_KEY () {159;}' unless defined(&EVP_F_CAMELLIA_INIT_KEY);
    eval 'sub EVP_F_CMAC_INIT () {173;}' unless defined(&EVP_F_CMAC_INIT);
    eval 'sub EVP_F_D2I_PKEY () {100;}' unless defined(&EVP_F_D2I_PKEY);
    eval 'sub EVP_F_DO_SIGVER_INIT () {161;}' unless defined(&EVP_F_DO_SIGVER_INIT);
    eval 'sub EVP_F_DSAPKEY2PKCS8 () {134;}' unless defined(&EVP_F_DSAPKEY2PKCS8);
    eval 'sub EVP_F_DSA_PKEY2PKCS8 () {135;}' unless defined(&EVP_F_DSA_PKEY2PKCS8);
    eval 'sub EVP_F_ECDSA_PKEY2PKCS8 () {129;}' unless defined(&EVP_F_ECDSA_PKEY2PKCS8);
    eval 'sub EVP_F_ECKEY_PKEY2PKCS8 () {132;}' unless defined(&EVP_F_ECKEY_PKEY2PKCS8);
    eval 'sub EVP_F_EVP_AEAD_CTX_INIT () {180;}' unless defined(&EVP_F_EVP_AEAD_CTX_INIT);
    eval 'sub EVP_F_EVP_AEAD_CTX_OPEN () {190;}' unless defined(&EVP_F_EVP_AEAD_CTX_OPEN);
    eval 'sub EVP_F_EVP_AEAD_CTX_SEAL () {191;}' unless defined(&EVP_F_EVP_AEAD_CTX_SEAL);
    eval 'sub EVP_F_EVP_BYTESTOKEY () {200;}' unless defined(&EVP_F_EVP_BYTESTOKEY);
    eval 'sub EVP_F_EVP_CIPHERINIT_EX () {123;}' unless defined(&EVP_F_EVP_CIPHERINIT_EX);
    eval 'sub EVP_F_EVP_CIPHER_CTX_COPY () {163;}' unless defined(&EVP_F_EVP_CIPHER_CTX_COPY);
    eval 'sub EVP_F_EVP_CIPHER_CTX_CTRL () {124;}' unless defined(&EVP_F_EVP_CIPHER_CTX_CTRL);
    eval 'sub EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH () {122;}' unless defined(&EVP_F_EVP_CIPHER_CTX_SET_KEY_LENGTH);
    eval 'sub EVP_F_EVP_CIPHER_GET_ASN1_IV () {201;}' unless defined(&EVP_F_EVP_CIPHER_GET_ASN1_IV);
    eval 'sub EVP_F_EVP_CIPHER_SET_ASN1_IV () {202;}' unless defined(&EVP_F_EVP_CIPHER_SET_ASN1_IV);
    eval 'sub EVP_F_EVP_DECRYPTFINAL_EX () {101;}' unless defined(&EVP_F_EVP_DECRYPTFINAL_EX);
    eval 'sub EVP_F_EVP_DECRYPTUPDATE () {199;}' unless defined(&EVP_F_EVP_DECRYPTUPDATE);
    eval 'sub EVP_F_EVP_DIGESTFINAL_EX () {196;}' unless defined(&EVP_F_EVP_DIGESTFINAL_EX);
    eval 'sub EVP_F_EVP_DIGESTINIT_EX () {128;}' unless defined(&EVP_F_EVP_DIGESTINIT_EX);
    eval 'sub EVP_F_EVP_ENCRYPTFINAL_EX () {127;}' unless defined(&EVP_F_EVP_ENCRYPTFINAL_EX);
    eval 'sub EVP_F_EVP_ENCRYPTUPDATE () {198;}' unless defined(&EVP_F_EVP_ENCRYPTUPDATE);
    eval 'sub EVP_F_EVP_MD_CTX_COPY_EX () {110;}' unless defined(&EVP_F_EVP_MD_CTX_COPY_EX);
    eval 'sub EVP_F_EVP_MD_CTX_CTRL () {195;}' unless defined(&EVP_F_EVP_MD_CTX_CTRL);
    eval 'sub EVP_F_EVP_MD_SIZE () {162;}' unless defined(&EVP_F_EVP_MD_SIZE);
    eval 'sub EVP_F_EVP_OPENINIT () {102;}' unless defined(&EVP_F_EVP_OPENINIT);
    eval 'sub EVP_F_EVP_PBE_ALG_ADD () {115;}' unless defined(&EVP_F_EVP_PBE_ALG_ADD);
    eval 'sub EVP_F_EVP_PBE_ALG_ADD_TYPE () {160;}' unless defined(&EVP_F_EVP_PBE_ALG_ADD_TYPE);
    eval 'sub EVP_F_EVP_PBE_CIPHERINIT () {116;}' unless defined(&EVP_F_EVP_PBE_CIPHERINIT);
    eval 'sub EVP_F_EVP_PKCS82PKEY () {111;}' unless defined(&EVP_F_EVP_PKCS82PKEY);
    eval 'sub EVP_F_EVP_PKCS82PKEY_BROKEN () {136;}' unless defined(&EVP_F_EVP_PKCS82PKEY_BROKEN);
    eval 'sub EVP_F_EVP_PKEY2PKCS8_BROKEN () {113;}' unless defined(&EVP_F_EVP_PKEY2PKCS8_BROKEN);
    eval 'sub EVP_F_EVP_PKEY_COPY_PARAMETERS () {103;}' unless defined(&EVP_F_EVP_PKEY_COPY_PARAMETERS);
    eval 'sub EVP_F_EVP_PKEY_CTX_CTRL () {137;}' unless defined(&EVP_F_EVP_PKEY_CTX_CTRL);
    eval 'sub EVP_F_EVP_PKEY_CTX_CTRL_STR () {150;}' unless defined(&EVP_F_EVP_PKEY_CTX_CTRL_STR);
    eval 'sub EVP_F_EVP_PKEY_CTX_DUP () {156;}' unless defined(&EVP_F_EVP_PKEY_CTX_DUP);
    eval 'sub EVP_F_EVP_PKEY_DECRYPT () {104;}' unless defined(&EVP_F_EVP_PKEY_DECRYPT);
    eval 'sub EVP_F_EVP_PKEY_DECRYPT_INIT () {138;}' unless defined(&EVP_F_EVP_PKEY_DECRYPT_INIT);
    eval 'sub EVP_F_EVP_PKEY_DECRYPT_OLD () {151;}' unless defined(&EVP_F_EVP_PKEY_DECRYPT_OLD);
    eval 'sub EVP_F_EVP_PKEY_DERIVE () {153;}' unless defined(&EVP_F_EVP_PKEY_DERIVE);
    eval 'sub EVP_F_EVP_PKEY_DERIVE_INIT () {154;}' unless defined(&EVP_F_EVP_PKEY_DERIVE_INIT);
    eval 'sub EVP_F_EVP_PKEY_DERIVE_SET_PEER () {155;}' unless defined(&EVP_F_EVP_PKEY_DERIVE_SET_PEER);
    eval 'sub EVP_F_EVP_PKEY_ENCRYPT () {105;}' unless defined(&EVP_F_EVP_PKEY_ENCRYPT);
    eval 'sub EVP_F_EVP_PKEY_ENCRYPT_INIT () {139;}' unless defined(&EVP_F_EVP_PKEY_ENCRYPT_INIT);
    eval 'sub EVP_F_EVP_PKEY_ENCRYPT_OLD () {152;}' unless defined(&EVP_F_EVP_PKEY_ENCRYPT_OLD);
    eval 'sub EVP_F_EVP_PKEY_GET1_DH () {119;}' unless defined(&EVP_F_EVP_PKEY_GET1_DH);
    eval 'sub EVP_F_EVP_PKEY_GET1_DSA () {120;}' unless defined(&EVP_F_EVP_PKEY_GET1_DSA);
    eval 'sub EVP_F_EVP_PKEY_GET1_ECDSA () {130;}' unless defined(&EVP_F_EVP_PKEY_GET1_ECDSA);
    eval 'sub EVP_F_EVP_PKEY_GET1_EC_KEY () {131;}' unless defined(&EVP_F_EVP_PKEY_GET1_EC_KEY);
    eval 'sub EVP_F_EVP_PKEY_GET1_RSA () {121;}' unless defined(&EVP_F_EVP_PKEY_GET1_RSA);
    eval 'sub EVP_F_EVP_PKEY_KEYGEN () {146;}' unless defined(&EVP_F_EVP_PKEY_KEYGEN);
    eval 'sub EVP_F_EVP_PKEY_KEYGEN_INIT () {147;}' unless defined(&EVP_F_EVP_PKEY_KEYGEN_INIT);
    eval 'sub EVP_F_EVP_PKEY_NEW () {106;}' unless defined(&EVP_F_EVP_PKEY_NEW);
    eval 'sub EVP_F_EVP_PKEY_PARAMGEN () {148;}' unless defined(&EVP_F_EVP_PKEY_PARAMGEN);
    eval 'sub EVP_F_EVP_PKEY_PARAMGEN_INIT () {149;}' unless defined(&EVP_F_EVP_PKEY_PARAMGEN_INIT);
    eval 'sub EVP_F_EVP_PKEY_SIGN () {140;}' unless defined(&EVP_F_EVP_PKEY_SIGN);
    eval 'sub EVP_F_EVP_PKEY_SIGN_INIT () {141;}' unless defined(&EVP_F_EVP_PKEY_SIGN_INIT);
    eval 'sub EVP_F_EVP_PKEY_VERIFY () {142;}' unless defined(&EVP_F_EVP_PKEY_VERIFY);
    eval 'sub EVP_F_EVP_PKEY_VERIFY_INIT () {143;}' unless defined(&EVP_F_EVP_PKEY_VERIFY_INIT);
    eval 'sub EVP_F_EVP_PKEY_VERIFY_RECOVER () {144;}' unless defined(&EVP_F_EVP_PKEY_VERIFY_RECOVER);
    eval 'sub EVP_F_EVP_PKEY_VERIFY_RECOVER_INIT () {145;}' unless defined(&EVP_F_EVP_PKEY_VERIFY_RECOVER_INIT);
    eval 'sub EVP_F_EVP_RIJNDAEL () {126;}' unless defined(&EVP_F_EVP_RIJNDAEL);
    eval 'sub EVP_F_EVP_SIGNFINAL () {107;}' unless defined(&EVP_F_EVP_SIGNFINAL);
    eval 'sub EVP_F_EVP_VERIFYFINAL () {108;}' unless defined(&EVP_F_EVP_VERIFYFINAL);
    eval 'sub EVP_F_FIPS_CIPHERINIT () {166;}' unless defined(&EVP_F_FIPS_CIPHERINIT);
    eval 'sub EVP_F_FIPS_CIPHER_CTX_COPY () {170;}' unless defined(&EVP_F_FIPS_CIPHER_CTX_COPY);
    eval 'sub EVP_F_FIPS_CIPHER_CTX_CTRL () {167;}' unless defined(&EVP_F_FIPS_CIPHER_CTX_CTRL);
    eval 'sub EVP_F_FIPS_CIPHER_CTX_SET_KEY_LENGTH () {171;}' unless defined(&EVP_F_FIPS_CIPHER_CTX_SET_KEY_LENGTH);
    eval 'sub EVP_F_FIPS_DIGESTINIT () {168;}' unless defined(&EVP_F_FIPS_DIGESTINIT);
    eval 'sub EVP_F_FIPS_MD_CTX_COPY () {169;}' unless defined(&EVP_F_FIPS_MD_CTX_COPY);
    eval 'sub EVP_F_HMAC_INIT_EX () {174;}' unless defined(&EVP_F_HMAC_INIT_EX);
    eval 'sub EVP_F_INT_CTX_NEW () {157;}' unless defined(&EVP_F_INT_CTX_NEW);
    eval 'sub EVP_F_PKCS5_PBE_KEYIVGEN () {117;}' unless defined(&EVP_F_PKCS5_PBE_KEYIVGEN);
    eval 'sub EVP_F_PKCS5_V2_PBE_KEYIVGEN () {118;}' unless defined(&EVP_F_PKCS5_V2_PBE_KEYIVGEN);
    eval 'sub EVP_F_PKCS5_V2_PBKDF2_KEYIVGEN () {164;}' unless defined(&EVP_F_PKCS5_V2_PBKDF2_KEYIVGEN);
    eval 'sub EVP_F_PKCS8_SET_BROKEN () {112;}' unless defined(&EVP_F_PKCS8_SET_BROKEN);
    eval 'sub EVP_F_PKEY_SET_TYPE () {158;}' unless defined(&EVP_F_PKEY_SET_TYPE);
    eval 'sub EVP_F_RC2_GET_ASN1_TYPE_AND_IV () {197;}' unless defined(&EVP_F_RC2_GET_ASN1_TYPE_AND_IV);
    eval 'sub EVP_F_RC2_MAGIC_TO_METH () {109;}' unless defined(&EVP_F_RC2_MAGIC_TO_METH);
    eval 'sub EVP_F_RC5_CTRL () {125;}' unless defined(&EVP_F_RC5_CTRL);
    eval 'sub EVP_R_AES_IV_SETUP_FAILED () {162;}' unless defined(&EVP_R_AES_IV_SETUP_FAILED);
    eval 'sub EVP_R_AES_KEY_SETUP_FAILED () {143;}' unless defined(&EVP_R_AES_KEY_SETUP_FAILED);
    eval 'sub EVP_R_ASN1_LIB () {140;}' unless defined(&EVP_R_ASN1_LIB);
    eval 'sub EVP_R_BAD_BLOCK_LENGTH () {136;}' unless defined(&EVP_R_BAD_BLOCK_LENGTH);
    eval 'sub EVP_R_BAD_DECRYPT () {100;}' unless defined(&EVP_R_BAD_DECRYPT);
    eval 'sub EVP_R_BAD_KEY_LENGTH () {137;}' unless defined(&EVP_R_BAD_KEY_LENGTH);
    eval 'sub EVP_R_BN_DECODE_ERROR () {112;}' unless defined(&EVP_R_BN_DECODE_ERROR);
    eval 'sub EVP_R_BN_PUBKEY_ERROR () {113;}' unless defined(&EVP_R_BN_PUBKEY_ERROR);
    eval 'sub EVP_R_BUFFER_TOO_SMALL () {155;}' unless defined(&EVP_R_BUFFER_TOO_SMALL);
    eval 'sub EVP_R_CAMELLIA_KEY_SETUP_FAILED () {157;}' unless defined(&EVP_R_CAMELLIA_KEY_SETUP_FAILED);
    eval 'sub EVP_R_CIPHER_PARAMETER_ERROR () {122;}' unless defined(&EVP_R_CIPHER_PARAMETER_ERROR);
    eval 'sub EVP_R_COMMAND_NOT_SUPPORTED () {147;}' unless defined(&EVP_R_COMMAND_NOT_SUPPORTED);
    eval 'sub EVP_R_CTRL_NOT_IMPLEMENTED () {132;}' unless defined(&EVP_R_CTRL_NOT_IMPLEMENTED);
    eval 'sub EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED () {133;}' unless defined(&EVP_R_CTRL_OPERATION_NOT_IMPLEMENTED);
    eval 'sub EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH () {138;}' unless defined(&EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH);
    eval 'sub EVP_R_DECODE_ERROR () {114;}' unless defined(&EVP_R_DECODE_ERROR);
    eval 'sub EVP_R_DIFFERENT_KEY_TYPES () {101;}' unless defined(&EVP_R_DIFFERENT_KEY_TYPES);
    eval 'sub EVP_R_DIFFERENT_PARAMETERS () {153;}' unless defined(&EVP_R_DIFFERENT_PARAMETERS);
    eval 'sub EVP_R_DISABLED_FOR_FIPS () {163;}' unless defined(&EVP_R_DISABLED_FOR_FIPS);
    eval 'sub EVP_R_ENCODE_ERROR () {115;}' unless defined(&EVP_R_ENCODE_ERROR);
    eval 'sub EVP_R_ERROR_LOADING_SECTION () {165;}' unless defined(&EVP_R_ERROR_LOADING_SECTION);
    eval 'sub EVP_R_ERROR_SETTING_FIPS_MODE () {166;}' unless defined(&EVP_R_ERROR_SETTING_FIPS_MODE);
    eval 'sub EVP_R_EVP_PBE_CIPHERINIT_ERROR () {119;}' unless defined(&EVP_R_EVP_PBE_CIPHERINIT_ERROR);
    eval 'sub EVP_R_EXPECTING_AN_RSA_KEY () {127;}' unless defined(&EVP_R_EXPECTING_AN_RSA_KEY);
    eval 'sub EVP_R_EXPECTING_A_DH_KEY () {128;}' unless defined(&EVP_R_EXPECTING_A_DH_KEY);
    eval 'sub EVP_R_EXPECTING_A_DSA_KEY () {129;}' unless defined(&EVP_R_EXPECTING_A_DSA_KEY);
    eval 'sub EVP_R_EXPECTING_A_ECDSA_KEY () {141;}' unless defined(&EVP_R_EXPECTING_A_ECDSA_KEY);
    eval 'sub EVP_R_EXPECTING_A_EC_KEY () {142;}' unless defined(&EVP_R_EXPECTING_A_EC_KEY);
    eval 'sub EVP_R_FIPS_MODE_NOT_SUPPORTED () {167;}' unless defined(&EVP_R_FIPS_MODE_NOT_SUPPORTED);
    eval 'sub EVP_R_INITIALIZATION_ERROR () {134;}' unless defined(&EVP_R_INITIALIZATION_ERROR);
    eval 'sub EVP_R_INPUT_NOT_INITIALIZED () {111;}' unless defined(&EVP_R_INPUT_NOT_INITIALIZED);
    eval 'sub EVP_R_INVALID_DIGEST () {152;}' unless defined(&EVP_R_INVALID_DIGEST);
    eval 'sub EVP_R_INVALID_FIPS_MODE () {168;}' unless defined(&EVP_R_INVALID_FIPS_MODE);
    eval 'sub EVP_R_INVALID_KEY_LENGTH () {130;}' unless defined(&EVP_R_INVALID_KEY_LENGTH);
    eval 'sub EVP_R_INVALID_OPERATION () {148;}' unless defined(&EVP_R_INVALID_OPERATION);
    eval 'sub EVP_R_IV_TOO_LARGE () {102;}' unless defined(&EVP_R_IV_TOO_LARGE);
    eval 'sub EVP_R_KEYGEN_FAILURE () {120;}' unless defined(&EVP_R_KEYGEN_FAILURE);
    eval 'sub EVP_R_MESSAGE_DIGEST_IS_NULL () {159;}' unless defined(&EVP_R_MESSAGE_DIGEST_IS_NULL);
    eval 'sub EVP_R_METHOD_NOT_SUPPORTED () {144;}' unless defined(&EVP_R_METHOD_NOT_SUPPORTED);
    eval 'sub EVP_R_MISSING_PARAMETERS () {103;}' unless defined(&EVP_R_MISSING_PARAMETERS);
    eval 'sub EVP_R_NO_CIPHER_SET () {131;}' unless defined(&EVP_R_NO_CIPHER_SET);
    eval 'sub EVP_R_NO_DEFAULT_DIGEST () {158;}' unless defined(&EVP_R_NO_DEFAULT_DIGEST);
    eval 'sub EVP_R_NO_DIGEST_SET () {139;}' unless defined(&EVP_R_NO_DIGEST_SET);
    eval 'sub EVP_R_NO_DSA_PARAMETERS () {116;}' unless defined(&EVP_R_NO_DSA_PARAMETERS);
    eval 'sub EVP_R_NO_KEY_SET () {154;}' unless defined(&EVP_R_NO_KEY_SET);
    eval 'sub EVP_R_NO_OPERATION_SET () {149;}' unless defined(&EVP_R_NO_OPERATION_SET);
    eval 'sub EVP_R_NO_SIGN_FUNCTION_CONFIGURED () {104;}' unless defined(&EVP_R_NO_SIGN_FUNCTION_CONFIGURED);
    eval 'sub EVP_R_NO_VERIFY_FUNCTION_CONFIGURED () {105;}' unless defined(&EVP_R_NO_VERIFY_FUNCTION_CONFIGURED);
    eval 'sub EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE () {150;}' unless defined(&EVP_R_OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE);
    eval 'sub EVP_R_OPERATON_NOT_INITIALIZED () {151;}' unless defined(&EVP_R_OPERATON_NOT_INITIALIZED);
    eval 'sub EVP_R_OUTPUT_ALIASES_INPUT () {172;}' unless defined(&EVP_R_OUTPUT_ALIASES_INPUT);
    eval 'sub EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE () {117;}' unless defined(&EVP_R_PKCS8_UNKNOWN_BROKEN_TYPE);
    eval 'sub EVP_R_PRIVATE_KEY_DECODE_ERROR () {145;}' unless defined(&EVP_R_PRIVATE_KEY_DECODE_ERROR);
    eval 'sub EVP_R_PRIVATE_KEY_ENCODE_ERROR () {146;}' unless defined(&EVP_R_PRIVATE_KEY_ENCODE_ERROR);
    eval 'sub EVP_R_PUBLIC_KEY_NOT_RSA () {106;}' unless defined(&EVP_R_PUBLIC_KEY_NOT_RSA);
    eval 'sub EVP_R_TAG_TOO_LARGE () {171;}' unless defined(&EVP_R_TAG_TOO_LARGE);
    eval 'sub EVP_R_TOO_LARGE () {164;}' unless defined(&EVP_R_TOO_LARGE);
    eval 'sub EVP_R_UNKNOWN_CIPHER () {160;}' unless defined(&EVP_R_UNKNOWN_CIPHER);
    eval 'sub EVP_R_UNKNOWN_DIGEST () {161;}' unless defined(&EVP_R_UNKNOWN_DIGEST);
    eval 'sub EVP_R_UNKNOWN_OPTION () {169;}' unless defined(&EVP_R_UNKNOWN_OPTION);
    eval 'sub EVP_R_UNKNOWN_PBE_ALGORITHM () {121;}' unless defined(&EVP_R_UNKNOWN_PBE_ALGORITHM);
    eval 'sub EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS () {135;}' unless defined(&EVP_R_UNSUPORTED_NUMBER_OF_ROUNDS);
    eval 'sub EVP_R_UNSUPPORTED_ALGORITHM () {156;}' unless defined(&EVP_R_UNSUPPORTED_ALGORITHM);
    eval 'sub EVP_R_UNSUPPORTED_CIPHER () {107;}' unless defined(&EVP_R_UNSUPPORTED_CIPHER);
    eval 'sub EVP_R_UNSUPPORTED_KEYLENGTH () {123;}' unless defined(&EVP_R_UNSUPPORTED_KEYLENGTH);
    eval 'sub EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION () {124;}' unless defined(&EVP_R_UNSUPPORTED_KEY_DERIVATION_FUNCTION);
    eval 'sub EVP_R_UNSUPPORTED_KEY_SIZE () {108;}' unless defined(&EVP_R_UNSUPPORTED_KEY_SIZE);
    eval 'sub EVP_R_UNSUPPORTED_PRF () {125;}' unless defined(&EVP_R_UNSUPPORTED_PRF);
    eval 'sub EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM () {118;}' unless defined(&EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM);
    eval 'sub EVP_R_UNSUPPORTED_SALT_TYPE () {126;}' unless defined(&EVP_R_UNSUPPORTED_SALT_TYPE);
    eval 'sub EVP_R_WRONG_FINAL_BLOCK_LENGTH () {109;}' unless defined(&EVP_R_WRONG_FINAL_BLOCK_LENGTH);
    eval 'sub EVP_R_WRONG_PUBLIC_KEY_TYPE () {110;}' unless defined(&EVP_R_WRONG_PUBLIC_KEY_TYPE);
    if(defined(&__cplusplus)) {
    }
}
1;
