require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__HIFN7751VAR_H__)) {
    eval 'sub __HIFN7751VAR_H__ () {1;}' unless defined(&__HIFN7751VAR_H__);
    if(defined(&_KERNEL)) {
	eval 'sub HIFN_D_CMD_RSIZE () {24;}' unless defined(&HIFN_D_CMD_RSIZE);
	eval 'sub HIFN_D_SRC_RSIZE () {80;}' unless defined(&HIFN_D_SRC_RSIZE);
	eval 'sub HIFN_D_DST_RSIZE () {80;}' unless defined(&HIFN_D_DST_RSIZE);
	eval 'sub HIFN_D_RES_RSIZE () {24;}' unless defined(&HIFN_D_RES_RSIZE);
	eval 'sub HIFN_DES_KEY_LENGTH () {8;}' unless defined(&HIFN_DES_KEY_LENGTH);
	eval 'sub HIFN_3DES_KEY_LENGTH () {24;}' unless defined(&HIFN_3DES_KEY_LENGTH);
	eval 'sub HIFN_MAX_CRYPT_KEY_LENGTH () { &HIFN_3DES_KEY_LENGTH;}' unless defined(&HIFN_MAX_CRYPT_KEY_LENGTH);
	eval 'sub HIFN_IV_LENGTH () {8;}' unless defined(&HIFN_IV_LENGTH);
	eval 'sub HIFN_AES_IV_LENGTH () {16;}' unless defined(&HIFN_AES_IV_LENGTH);
	eval 'sub HIFN_MAX_IV_LENGTH () { &HIFN_AES_IV_LENGTH;}' unless defined(&HIFN_MAX_IV_LENGTH);
	eval 'sub HIFN_MAC_KEY_LENGTH () {64;}' unless defined(&HIFN_MAC_KEY_LENGTH);
	eval 'sub HIFN_MD5_LENGTH () {16;}' unless defined(&HIFN_MD5_LENGTH);
	eval 'sub HIFN_SHA1_LENGTH () {20;}' unless defined(&HIFN_SHA1_LENGTH);
	eval 'sub HIFN_MAC_TRUNC_LENGTH () {12;}' unless defined(&HIFN_MAC_TRUNC_LENGTH);
	eval 'sub MAX_SCATTER () {64;}' unless defined(&MAX_SCATTER);
	eval 'sub HIFN_RING_SYNC {
	    my($sc, $r, $i, $f) = @_;
    	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_dmamap,  &offsetof(\'struct hifn_dma\', $r->[$i]), $sizeof{\'struct hifn_desc\'}, ($f)));
	}' unless defined(&HIFN_RING_SYNC);
	eval 'sub HIFN_CMDR_SYNC {
	    my($sc, $i, $f) = @_;
    	    eval q( &HIFN_RING_SYNC(($sc),  &cmdr, ($i), ($f)));
	}' unless defined(&HIFN_CMDR_SYNC);
	eval 'sub HIFN_RESR_SYNC {
	    my($sc, $i, $f) = @_;
    	    eval q( &HIFN_RING_SYNC(($sc),  &resr, ($i), ($f)));
	}' unless defined(&HIFN_RESR_SYNC);
	eval 'sub HIFN_SRCR_SYNC {
	    my($sc, $i, $f) = @_;
    	    eval q( &HIFN_RING_SYNC(($sc),  &srcr, ($i), ($f)));
	}' unless defined(&HIFN_SRCR_SYNC);
	eval 'sub HIFN_DSTR_SYNC {
	    my($sc, $i, $f) = @_;
    	    eval q( &HIFN_RING_SYNC(($sc),  &dstr, ($i), ($f)));
	}' unless defined(&HIFN_DSTR_SYNC);
	eval 'sub HIFN_CMD_SYNC {
	    my($sc, $i, $f) = @_;
    	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_dmamap,  &offsetof(\'struct hifn_dma\',  $command_bufs[($i)][0]),  &HIFN_MAX_COMMAND, ($f)));
	}' unless defined(&HIFN_CMD_SYNC);
	eval 'sub HIFN_RES_SYNC {
	    my($sc, $i, $f) = @_;
    	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_dmamap,  &offsetof(\'struct hifn_dma\',  $result_bufs[($i)][0]),  &HIFN_MAX_RESULT, ($f)));
	}' unless defined(&HIFN_RES_SYNC);
	eval 'sub HIFN_HAS_RNG () {0x1;}' unless defined(&HIFN_HAS_RNG);
	eval 'sub HIFN_HAS_PUBLIC () {0x2;}' unless defined(&HIFN_HAS_PUBLIC);
	eval 'sub HIFN_IS_7811 () {0x4;}' unless defined(&HIFN_IS_7811);
	eval 'sub HIFN_NO_BURSTWRITE () {0x8;}' unless defined(&HIFN_NO_BURSTWRITE);
	eval 'sub HIFN_HAS_LEDS () {0x10;}' unless defined(&HIFN_HAS_LEDS);
	eval 'sub HIFN_HAS_AES () {0x20;}' unless defined(&HIFN_HAS_AES);
	eval 'sub HIFN_IS_7956 () {0x40;}' unless defined(&HIFN_IS_7956);
	eval 'sub WRITE_REG_0 {
	    my($sc,$reg,$val) = @_;
    	    eval q( &hifn_write_4(($sc), 0, ($reg), ($val)));
	}' unless defined(&WRITE_REG_0);
	eval 'sub WRITE_REG_1 {
	    my($sc,$reg,$val) = @_;
    	    eval q( &hifn_write_4(($sc), 1, ($reg), ($val)));
	}' unless defined(&WRITE_REG_1);
	eval 'sub READ_REG_0 {
	    my($sc,$reg) = @_;
    	    eval q( &hifn_read_4(($sc), 0, ($reg)));
	}' unless defined(&READ_REG_0);
	eval 'sub READ_REG_1 {
	    my($sc,$reg) = @_;
    	    eval q( &hifn_read_4(($sc), 1, ($reg)));
	}' unless defined(&READ_REG_1);
	eval 'sub SET_LED {
	    my($sc,$v) = @_;
    	    eval q( &if ( ($sc->{sc_flags}) &  &HIFN_HAS_LEDS)  &WRITE_REG_1($sc,  &HIFN_1_7811_MIPSRST,  &READ_REG_1($sc,  &HIFN_1_7811_MIPSRST) | ($v)));
	}' unless defined(&SET_LED);
	eval 'sub CLR_LED {
	    my($sc,$v) = @_;
    	    eval q( &if ( ($sc->{sc_flags}) &  &HIFN_HAS_LEDS)  &WRITE_REG_1($sc,  &HIFN_1_7811_MIPSRST,  &READ_REG_1($sc,  &HIFN_1_7811_MIPSRST) & ~($v)));
	}' unless defined(&CLR_LED);
	eval 'sub HIFN_CRYPTO_SUCCESS () {0;}' unless defined(&HIFN_CRYPTO_SUCCESS);
	eval 'sub HIFN_CRYPTO_BAD_INPUT () {(-1);}' unless defined(&HIFN_CRYPTO_BAD_INPUT);
	eval 'sub HIFN_CRYPTO_RINGS_FULL () {(-2);}' unless defined(&HIFN_CRYPTO_RINGS_FULL);
	eval 'sub HIFN_CARD {
	    my($sid) = @_;
    	    eval q(((($sid) & 0xf0000000) >> 28));
	}' unless defined(&HIFN_CARD);
	eval 'sub HIFN_SESSION {
	    my($sid) = @_;
    	    eval q((($sid) & 0x7ff));
	}' unless defined(&HIFN_SESSION);
	eval 'sub HIFN_SID {
	    my($crd,$ses) = @_;
    	    eval q(((($crd) << 28) | (($ses) & 0x7ff)));
	}' unless defined(&HIFN_SID);
    }
}
1;
