require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub RT2860_PCI_CFG () {0x;}' unless defined(&RT2860_PCI_CFG);
eval 'sub RT2860_PCI_EECTRL () {0x4;}' unless defined(&RT2860_PCI_EECTRL);
eval 'sub RT2860_PCI_MCUCTRL () {0x8;}' unless defined(&RT2860_PCI_MCUCTRL);
eval 'sub RT2860_PCI_SYSCTRL () {0xc;}' unless defined(&RT2860_PCI_SYSCTRL);
eval 'sub RT2860_PCIE_JTAG () {0x10;}' unless defined(&RT2860_PCIE_JTAG);
eval 'sub RT3090_AUX_CTRL () {0x10c;}' unless defined(&RT3090_AUX_CTRL);
eval 'sub RT3070_OPT_14 () {0x114;}' unless defined(&RT3070_OPT_14);
eval 'sub RT2860_INT_STATUS () {0x200;}' unless defined(&RT2860_INT_STATUS);
eval 'sub RT2860_INT_MASK () {0x204;}' unless defined(&RT2860_INT_MASK);
eval 'sub RT2860_WPDMA_GLO_CFG () {0x208;}' unless defined(&RT2860_WPDMA_GLO_CFG);
eval 'sub RT2860_WPDMA_RST_IDX () {0x20c;}' unless defined(&RT2860_WPDMA_RST_IDX);
eval 'sub RT2860_DELAY_INT_CFG () {0x210;}' unless defined(&RT2860_DELAY_INT_CFG);
eval 'sub RT2860_WMM_AIFSN_CFG () {0x214;}' unless defined(&RT2860_WMM_AIFSN_CFG);
eval 'sub RT2860_WMM_CWMIN_CFG () {0x218;}' unless defined(&RT2860_WMM_CWMIN_CFG);
eval 'sub RT2860_WMM_CWMAX_CFG () {0x21c;}' unless defined(&RT2860_WMM_CWMAX_CFG);
eval 'sub RT2860_WMM_TXOP0_CFG () {0x220;}' unless defined(&RT2860_WMM_TXOP0_CFG);
eval 'sub RT2860_WMM_TXOP1_CFG () {0x224;}' unless defined(&RT2860_WMM_TXOP1_CFG);
eval 'sub RT2860_GPIO_CTRL () {0x228;}' unless defined(&RT2860_GPIO_CTRL);
eval 'sub RT2860_MCU_CMD_REG () {0x22c;}' unless defined(&RT2860_MCU_CMD_REG);
unless(defined(&RT2860_TX_BASE_PTR)) {
    sub RT2860_TX_BASE_PTR {
	my($qid) = @_;
	eval q((0x230 + ($qid) * 16));
    }
}
unless(defined(&RT2860_TX_MAX_CNT)) {
    sub RT2860_TX_MAX_CNT {
	my($qid) = @_;
	eval q((0x234 + ($qid) * 16));
    }
}
unless(defined(&RT2860_TX_CTX_IDX)) {
    sub RT2860_TX_CTX_IDX {
	my($qid) = @_;
	eval q((0x238 + ($qid) * 16));
    }
}
unless(defined(&RT2860_TX_DTX_IDX)) {
    sub RT2860_TX_DTX_IDX {
	my($qid) = @_;
	eval q((0x23c + ($qid) * 16));
    }
}
eval 'sub RT2860_RX_BASE_PTR () {0x290;}' unless defined(&RT2860_RX_BASE_PTR);
eval 'sub RT2860_RX_MAX_CNT () {0x294;}' unless defined(&RT2860_RX_MAX_CNT);
eval 'sub RT2860_RX_CALC_IDX () {0x298;}' unless defined(&RT2860_RX_CALC_IDX);
eval 'sub RT2860_FS_DRX_IDX () {0x29c;}' unless defined(&RT2860_FS_DRX_IDX);
eval 'sub RT2860_USB_DMA_CFG () {0x2a0;}' unless defined(&RT2860_USB_DMA_CFG);
eval 'sub RT2860_US_CYC_CNT () {0x2a4;}' unless defined(&RT2860_US_CYC_CNT);
eval 'sub RT2860_SYS_CTRL () {0x400;}' unless defined(&RT2860_SYS_CTRL);
eval 'sub RT2860_HOST_CMD () {0x404;}' unless defined(&RT2860_HOST_CMD);
eval 'sub RT2860_PBF_CFG () {0x408;}' unless defined(&RT2860_PBF_CFG);
eval 'sub RT2860_MAX_PCNT () {0x40c;}' unless defined(&RT2860_MAX_PCNT);
eval 'sub RT2860_BUF_CTRL () {0x410;}' unless defined(&RT2860_BUF_CTRL);
eval 'sub RT2860_MCU_INT_STA () {0x414;}' unless defined(&RT2860_MCU_INT_STA);
eval 'sub RT2860_MCU_INT_ENA () {0x418;}' unless defined(&RT2860_MCU_INT_ENA);
unless(defined(&RT2860_TXQ_IO)) {
    sub RT2860_TXQ_IO {
	my($qid) = @_;
	eval q((0x41c + ($qid) * 4));
    }
}
eval 'sub RT2860_RX0Q_IO () {0x424;}' unless defined(&RT2860_RX0Q_IO);
eval 'sub RT2860_BCN_OFFSET0 () {0x42c;}' unless defined(&RT2860_BCN_OFFSET0);
eval 'sub RT2860_BCN_OFFSET1 () {0x430;}' unless defined(&RT2860_BCN_OFFSET1);
eval 'sub RT2860_TXRXQ_STA () {0x434;}' unless defined(&RT2860_TXRXQ_STA);
eval 'sub RT2860_TXRXQ_PCNT () {0x438;}' unless defined(&RT2860_TXRXQ_PCNT);
eval 'sub RT2860_PBF_DBG () {0x43c;}' unless defined(&RT2860_PBF_DBG);
eval 'sub RT2860_CAP_CTRL () {0x440;}' unless defined(&RT2860_CAP_CTRL);
eval 'sub RT3070_RF_CSR_CFG () {0x500;}' unless defined(&RT3070_RF_CSR_CFG);
eval 'sub RT3070_EFUSE_CTRL () {0x580;}' unless defined(&RT3070_EFUSE_CTRL);
eval 'sub RT3070_EFUSE_DATA0 () {0x590;}' unless defined(&RT3070_EFUSE_DATA0);
eval 'sub RT3070_EFUSE_DATA1 () {0x594;}' unless defined(&RT3070_EFUSE_DATA1);
eval 'sub RT3070_EFUSE_DATA2 () {0x598;}' unless defined(&RT3070_EFUSE_DATA2);
eval 'sub RT3070_EFUSE_DATA3 () {0x59c;}' unless defined(&RT3070_EFUSE_DATA3);
eval 'sub RT3090_OSC_CTRL () {0x5a4;}' unless defined(&RT3090_OSC_CTRL);
eval 'sub RT3070_LDO_CFG0 () {0x5d4;}' unless defined(&RT3070_LDO_CFG0);
eval 'sub RT3070_GPIO_SWITCH () {0x5dc;}' unless defined(&RT3070_GPIO_SWITCH);
eval 'sub RT5592_DEBUG_INDEX () {0x5e8;}' unless defined(&RT5592_DEBUG_INDEX);
eval 'sub RT2860_ASIC_VER_ID () {0x1000;}' unless defined(&RT2860_ASIC_VER_ID);
eval 'sub RT2860_MAC_SYS_CTRL () {0x1004;}' unless defined(&RT2860_MAC_SYS_CTRL);
eval 'sub RT2860_MAC_ADDR_DW0 () {0x1008;}' unless defined(&RT2860_MAC_ADDR_DW0);
eval 'sub RT2860_MAC_ADDR_DW1 () {0x100c;}' unless defined(&RT2860_MAC_ADDR_DW1);
eval 'sub RT2860_MAC_BSSID_DW0 () {0x1010;}' unless defined(&RT2860_MAC_BSSID_DW0);
eval 'sub RT2860_MAC_BSSID_DW1 () {0x1014;}' unless defined(&RT2860_MAC_BSSID_DW1);
eval 'sub RT2860_MAX_LEN_CFG () {0x1018;}' unless defined(&RT2860_MAX_LEN_CFG);
eval 'sub RT2860_BBP_CSR_CFG () {0x101c;}' unless defined(&RT2860_BBP_CSR_CFG);
eval 'sub RT2860_RF_CSR_CFG0 () {0x1020;}' unless defined(&RT2860_RF_CSR_CFG0);
eval 'sub RT2860_RF_CSR_CFG1 () {0x1024;}' unless defined(&RT2860_RF_CSR_CFG1);
eval 'sub RT2860_RF_CSR_CFG2 () {0x1028;}' unless defined(&RT2860_RF_CSR_CFG2);
eval 'sub RT2860_LED_CFG () {0x102c;}' unless defined(&RT2860_LED_CFG);
eval 'sub RT2860_DEBUG () {0x10f4;}' unless defined(&RT2860_DEBUG);
eval 'sub RT2860_XIFS_TIME_CFG () {0x1100;}' unless defined(&RT2860_XIFS_TIME_CFG);
eval 'sub RT2860_BKOFF_SLOT_CFG () {0x1104;}' unless defined(&RT2860_BKOFF_SLOT_CFG);
eval 'sub RT2860_NAV_TIME_CFG () {0x1108;}' unless defined(&RT2860_NAV_TIME_CFG);
eval 'sub RT2860_CH_TIME_CFG () {0x110c;}' unless defined(&RT2860_CH_TIME_CFG);
eval 'sub RT2860_PBF_LIFE_TIMER () {0x1110;}' unless defined(&RT2860_PBF_LIFE_TIMER);
eval 'sub RT2860_BCN_TIME_CFG () {0x1114;}' unless defined(&RT2860_BCN_TIME_CFG);
eval 'sub RT2860_TBTT_SYNC_CFG () {0x1118;}' unless defined(&RT2860_TBTT_SYNC_CFG);
eval 'sub RT2860_TSF_TIMER_DW0 () {0x111c;}' unless defined(&RT2860_TSF_TIMER_DW0);
eval 'sub RT2860_TSF_TIMER_DW1 () {0x1120;}' unless defined(&RT2860_TSF_TIMER_DW1);
eval 'sub RT2860_TBTT_TIMER () {0x1124;}' unless defined(&RT2860_TBTT_TIMER);
eval 'sub RT2860_INT_TIMER_CFG () {0x1128;}' unless defined(&RT2860_INT_TIMER_CFG);
eval 'sub RT2860_INT_TIMER_EN () {0x112c;}' unless defined(&RT2860_INT_TIMER_EN);
eval 'sub RT2860_CH_IDLE_TIME () {0x1130;}' unless defined(&RT2860_CH_IDLE_TIME);
eval 'sub RT2860_MAC_STATUS_REG () {0x1200;}' unless defined(&RT2860_MAC_STATUS_REG);
eval 'sub RT2860_PWR_PIN_CFG () {0x1204;}' unless defined(&RT2860_PWR_PIN_CFG);
eval 'sub RT2860_AUTO_WAKEUP_CFG () {0x1208;}' unless defined(&RT2860_AUTO_WAKEUP_CFG);
unless(defined(&RT2860_EDCA_AC_CFG)) {
    sub RT2860_EDCA_AC_CFG {
	my($aci) = @_;
	eval q((0x1300 + ($aci) * 4));
    }
}
eval 'sub RT2860_EDCA_TID_AC_MAP () {0x1310;}' unless defined(&RT2860_EDCA_TID_AC_MAP);
unless(defined(&RT2860_TX_PWR_CFG)) {
    sub RT2860_TX_PWR_CFG {
	my($ridx) = @_;
	eval q((0x1314 + ($ridx) * 4));
    }
}
eval 'sub RT2860_TX_PIN_CFG () {0x1328;}' unless defined(&RT2860_TX_PIN_CFG);
eval 'sub RT2860_TX_BAND_CFG () {0x132c;}' unless defined(&RT2860_TX_BAND_CFG);
eval 'sub RT2860_TX_SW_CFG0 () {0x1330;}' unless defined(&RT2860_TX_SW_CFG0);
eval 'sub RT2860_TX_SW_CFG1 () {0x1334;}' unless defined(&RT2860_TX_SW_CFG1);
eval 'sub RT2860_TX_SW_CFG2 () {0x1338;}' unless defined(&RT2860_TX_SW_CFG2);
eval 'sub RT2860_TXOP_THRES_CFG () {0x133c;}' unless defined(&RT2860_TXOP_THRES_CFG);
eval 'sub RT2860_TXOP_CTRL_CFG () {0x1340;}' unless defined(&RT2860_TXOP_CTRL_CFG);
eval 'sub RT2860_TX_RTS_CFG () {0x1344;}' unless defined(&RT2860_TX_RTS_CFG);
eval 'sub RT2860_TX_TIMEOUT_CFG () {0x1348;}' unless defined(&RT2860_TX_TIMEOUT_CFG);
eval 'sub RT2860_TX_RTY_CFG () {0x134c;}' unless defined(&RT2860_TX_RTY_CFG);
eval 'sub RT2860_TX_LINK_CFG () {0x1350;}' unless defined(&RT2860_TX_LINK_CFG);
eval 'sub RT2860_HT_FBK_CFG0 () {0x1354;}' unless defined(&RT2860_HT_FBK_CFG0);
eval 'sub RT2860_HT_FBK_CFG1 () {0x1358;}' unless defined(&RT2860_HT_FBK_CFG1);
eval 'sub RT2860_LG_FBK_CFG0 () {0x135c;}' unless defined(&RT2860_LG_FBK_CFG0);
eval 'sub RT2860_LG_FBK_CFG1 () {0x1360;}' unless defined(&RT2860_LG_FBK_CFG1);
eval 'sub RT2860_CCK_PROT_CFG () {0x1364;}' unless defined(&RT2860_CCK_PROT_CFG);
eval 'sub RT2860_OFDM_PROT_CFG () {0x1368;}' unless defined(&RT2860_OFDM_PROT_CFG);
eval 'sub RT2860_MM20_PROT_CFG () {0x136c;}' unless defined(&RT2860_MM20_PROT_CFG);
eval 'sub RT2860_MM40_PROT_CFG () {0x1370;}' unless defined(&RT2860_MM40_PROT_CFG);
eval 'sub RT2860_GF20_PROT_CFG () {0x1374;}' unless defined(&RT2860_GF20_PROT_CFG);
eval 'sub RT2860_GF40_PROT_CFG () {0x1378;}' unless defined(&RT2860_GF40_PROT_CFG);
eval 'sub RT2860_EXP_CTS_TIME () {0x137c;}' unless defined(&RT2860_EXP_CTS_TIME);
eval 'sub RT2860_EXP_ACK_TIME () {0x1380;}' unless defined(&RT2860_EXP_ACK_TIME);
eval 'sub RT2860_RX_FILTR_CFG () {0x1400;}' unless defined(&RT2860_RX_FILTR_CFG);
eval 'sub RT2860_AUTO_RSP_CFG () {0x1404;}' unless defined(&RT2860_AUTO_RSP_CFG);
eval 'sub RT2860_LEGACY_BASIC_RATE () {0x1408;}' unless defined(&RT2860_LEGACY_BASIC_RATE);
eval 'sub RT2860_HT_BASIC_RATE () {0x140c;}' unless defined(&RT2860_HT_BASIC_RATE);
eval 'sub RT2860_HT_CTRL_CFG () {0x1410;}' unless defined(&RT2860_HT_CTRL_CFG);
eval 'sub RT2860_SIFS_COST_CFG () {0x1414;}' unless defined(&RT2860_SIFS_COST_CFG);
eval 'sub RT2860_RX_PARSER_CFG () {0x1418;}' unless defined(&RT2860_RX_PARSER_CFG);
eval 'sub RT2860_TX_SEC_CNT0 () {0x1500;}' unless defined(&RT2860_TX_SEC_CNT0);
eval 'sub RT2860_RX_SEC_CNT0 () {0x1504;}' unless defined(&RT2860_RX_SEC_CNT0);
eval 'sub RT2860_CCMP_FC_MUTE () {0x1508;}' unless defined(&RT2860_CCMP_FC_MUTE);
eval 'sub RT2860_TXOP_HLDR_ADDR0 () {0x1600;}' unless defined(&RT2860_TXOP_HLDR_ADDR0);
eval 'sub RT2860_TXOP_HLDR_ADDR1 () {0x1604;}' unless defined(&RT2860_TXOP_HLDR_ADDR1);
eval 'sub RT2860_TXOP_HLDR_ET () {0x1608;}' unless defined(&RT2860_TXOP_HLDR_ET);
eval 'sub RT2860_QOS_CFPOLL_RA_DW0 () {0x160c;}' unless defined(&RT2860_QOS_CFPOLL_RA_DW0);
eval 'sub RT2860_QOS_CFPOLL_A1_DW1 () {0x1610;}' unless defined(&RT2860_QOS_CFPOLL_A1_DW1);
eval 'sub RT2860_QOS_CFPOLL_QC () {0x1614;}' unless defined(&RT2860_QOS_CFPOLL_QC);
eval 'sub RT2860_RX_STA_CNT0 () {0x1700;}' unless defined(&RT2860_RX_STA_CNT0);
eval 'sub RT2860_RX_STA_CNT1 () {0x1704;}' unless defined(&RT2860_RX_STA_CNT1);
eval 'sub RT2860_RX_STA_CNT2 () {0x1708;}' unless defined(&RT2860_RX_STA_CNT2);
eval 'sub RT2860_TX_STA_CNT0 () {0x170c;}' unless defined(&RT2860_TX_STA_CNT0);
eval 'sub RT2860_TX_STA_CNT1 () {0x1710;}' unless defined(&RT2860_TX_STA_CNT1);
eval 'sub RT2860_TX_STA_CNT2 () {0x1714;}' unless defined(&RT2860_TX_STA_CNT2);
eval 'sub RT2860_TX_STAT_FIFO () {0x1718;}' unless defined(&RT2860_TX_STAT_FIFO);
unless(defined(&RT2860_WCID_ENTRY)) {
    sub RT2860_WCID_ENTRY {
	my($wcid) = @_;
	eval q((0x1800 + ($wcid) * 8));
    }
}
eval 'sub RT2860_FW_BASE () {0x2000;}' unless defined(&RT2860_FW_BASE);
eval 'sub RT2870_FW_BASE () {0x3000;}' unless defined(&RT2870_FW_BASE);
unless(defined(&RT2860_PKEY)) {
    sub RT2860_PKEY {
	my($wcid) = @_;
	eval q((0x4000 + ($wcid) * 32));
    }
}
unless(defined(&RT2860_IVEIV)) {
    sub RT2860_IVEIV {
	my($wcid) = @_;
	eval q((0x6000 + ($wcid) * 8));
    }
}
unless(defined(&RT2860_WCID_ATTR)) {
    sub RT2860_WCID_ATTR {
	my($wcid) = @_;
	eval q((0x6800 + ($wcid) * 4));
    }
}
unless(defined(&RT2860_SKEY)) {
    sub RT2860_SKEY {
	my($vap, $kidx) = @_;
	eval q((0x6c00 + ($vap) * 128+ ($kidx) * 32));
    }
}
eval 'sub RT2860_SKEY_MODE_0_7 () {0x7000;}' unless defined(&RT2860_SKEY_MODE_0_7);
eval 'sub RT2860_SKEY_MODE_8_15 () {0x7004;}' unless defined(&RT2860_SKEY_MODE_8_15);
eval 'sub RT2860_SKEY_MODE_16_23 () {0x7008;}' unless defined(&RT2860_SKEY_MODE_16_23);
eval 'sub RT2860_SKEY_MODE_24_31 () {0x700c;}' unless defined(&RT2860_SKEY_MODE_24_31);
eval 'sub RT2860_H2M_MAILBOX () {0x7010;}' unless defined(&RT2860_H2M_MAILBOX);
eval 'sub RT2860_H2M_MAILBOX_CID () {0x7014;}' unless defined(&RT2860_H2M_MAILBOX_CID);
eval 'sub RT2860_H2M_MAILBOX_STATUS () {0x701c;}' unless defined(&RT2860_H2M_MAILBOX_STATUS);
eval 'sub RT2860_H2M_INTSRC () {0x7024;}' unless defined(&RT2860_H2M_INTSRC);
eval 'sub RT2860_H2M_BBPAGENT () {0x7028;}' unless defined(&RT2860_H2M_BBPAGENT);
unless(defined(&RT2860_BCN_BASE)) {
    sub RT2860_BCN_BASE {
	my($vap) = @_;
	eval q((0x7800 + ($vap) * 512));
    }
}
eval 'sub RT2860_PCI_CFG_USB () {(1<< 17);}' unless defined(&RT2860_PCI_CFG_USB);
eval 'sub RT2860_PCI_CFG_PCI () {(1<< 16);}' unless defined(&RT2860_PCI_CFG_PCI);
eval 'sub RT2860_C () {(1<< 0);}' unless defined(&RT2860_C);
eval 'sub RT2860_S () {(1<< 1);}' unless defined(&RT2860_S);
eval 'sub RT2860_D () {(1<< 2);}' unless defined(&RT2860_D);
eval 'sub RT2860_SHIFT_D () {2;}' unless defined(&RT2860_SHIFT_D);
eval 'sub RT2860_Q () {(1<< 3);}' unless defined(&RT2860_Q);
eval 'sub RT2860_SHIFT_Q () {3;}' unless defined(&RT2860_SHIFT_Q);
eval 'sub RT2860_TX_COHERENT () {(1<< 17);}' unless defined(&RT2860_TX_COHERENT);
eval 'sub RT2860_RX_COHERENT () {(1<< 16);}' unless defined(&RT2860_RX_COHERENT);
eval 'sub RT2860_MAC_INT_4 () {(1<< 15);}' unless defined(&RT2860_MAC_INT_4);
eval 'sub RT2860_MAC_INT_3 () {(1<< 14);}' unless defined(&RT2860_MAC_INT_3);
eval 'sub RT2860_MAC_INT_2 () {(1<< 13);}' unless defined(&RT2860_MAC_INT_2);
eval 'sub RT2860_MAC_INT_1 () {(1<< 12);}' unless defined(&RT2860_MAC_INT_1);
eval 'sub RT2860_MAC_INT_0 () {(1<< 11);}' unless defined(&RT2860_MAC_INT_0);
eval 'sub RT2860_TX_RX_COHERENT () {(1<< 10);}' unless defined(&RT2860_TX_RX_COHERENT);
eval 'sub RT2860_MCU_CMD_INT () {(1<< 9);}' unless defined(&RT2860_MCU_CMD_INT);
eval 'sub RT2860_TX_DONE_INT5 () {(1<< 8);}' unless defined(&RT2860_TX_DONE_INT5);
eval 'sub RT2860_TX_DONE_INT4 () {(1<< 7);}' unless defined(&RT2860_TX_DONE_INT4);
eval 'sub RT2860_TX_DONE_INT3 () {(1<< 6);}' unless defined(&RT2860_TX_DONE_INT3);
eval 'sub RT2860_TX_DONE_INT2 () {(1<< 5);}' unless defined(&RT2860_TX_DONE_INT2);
eval 'sub RT2860_TX_DONE_INT1 () {(1<< 4);}' unless defined(&RT2860_TX_DONE_INT1);
eval 'sub RT2860_TX_DONE_INT0 () {(1<< 3);}' unless defined(&RT2860_TX_DONE_INT0);
eval 'sub RT2860_RX_DONE_INT () {(1<< 2);}' unless defined(&RT2860_RX_DONE_INT);
eval 'sub RT2860_TX_DLY_INT () {(1<< 1);}' unless defined(&RT2860_TX_DLY_INT);
eval 'sub RT2860_RX_DLY_INT () {(1<< 0);}' unless defined(&RT2860_RX_DLY_INT);
eval 'sub RT2860_HDR_SEG_LEN_SHIFT () {8;}' unless defined(&RT2860_HDR_SEG_LEN_SHIFT);
eval 'sub RT2860_BIG_ENDIAN () {(1<< 7);}' unless defined(&RT2860_BIG_ENDIAN);
eval 'sub RT2860_TX_WB_DDONE () {(1<< 6);}' unless defined(&RT2860_TX_WB_DDONE);
eval 'sub RT2860_WPDMA_BT_SIZE_SHIFT () {4;}' unless defined(&RT2860_WPDMA_BT_SIZE_SHIFT);
eval 'sub RT2860_WPDMA_BT_SIZE16 () {0;}' unless defined(&RT2860_WPDMA_BT_SIZE16);
eval 'sub RT2860_WPDMA_BT_SIZE32 () {1;}' unless defined(&RT2860_WPDMA_BT_SIZE32);
eval 'sub RT2860_WPDMA_BT_SIZE64 () {2;}' unless defined(&RT2860_WPDMA_BT_SIZE64);
eval 'sub RT2860_WPDMA_BT_SIZE128 () {3;}' unless defined(&RT2860_WPDMA_BT_SIZE128);
eval 'sub RT2860_RX_DMA_BUSY () {(1<< 3);}' unless defined(&RT2860_RX_DMA_BUSY);
eval 'sub RT2860_RX_DMA_EN () {(1<< 2);}' unless defined(&RT2860_RX_DMA_EN);
eval 'sub RT2860_TX_DMA_BUSY () {(1<< 1);}' unless defined(&RT2860_TX_DMA_BUSY);
eval 'sub RT2860_TX_DMA_EN () {(1<< 0);}' unless defined(&RT2860_TX_DMA_EN);
eval 'sub RT2860_TXDLY_INT_EN () {(1 << 31);}' unless defined(&RT2860_TXDLY_INT_EN);
eval 'sub RT2860_TXMAX_PINT_SHIFT () {24;}' unless defined(&RT2860_TXMAX_PINT_SHIFT);
eval 'sub RT2860_TXMAX_PTIME_SHIFT () {16;}' unless defined(&RT2860_TXMAX_PTIME_SHIFT);
eval 'sub RT2860_RXDLY_INT_EN () {(1 << 15);}' unless defined(&RT2860_RXDLY_INT_EN);
eval 'sub RT2860_RXMAX_PINT_SHIFT () {8;}' unless defined(&RT2860_RXMAX_PINT_SHIFT);
eval 'sub RT2860_RXMAX_PTIME_SHIFT () {0;}' unless defined(&RT2860_RXMAX_PTIME_SHIFT);
eval 'sub RT2860_GPIO_D_SHIFT () {8;}' unless defined(&RT2860_GPIO_D_SHIFT);
eval 'sub RT2860_GPIO_O_SHIFT () {0;}' unless defined(&RT2860_GPIO_O_SHIFT);
eval 'sub RT2860_USB_TX_BUSY () {(1 << 31);}' unless defined(&RT2860_USB_TX_BUSY);
eval 'sub RT2860_USB_RX_BUSY () {(1 << 30);}' unless defined(&RT2860_USB_RX_BUSY);
eval 'sub RT2860_USB_EPOUT_VLD_SHIFT () {24;}' unless defined(&RT2860_USB_EPOUT_VLD_SHIFT);
eval 'sub RT2860_USB_TX_EN () {(1 << 23);}' unless defined(&RT2860_USB_TX_EN);
eval 'sub RT2860_USB_RX_EN () {(1 << 22);}' unless defined(&RT2860_USB_RX_EN);
eval 'sub RT2860_USB_RX_AGG_EN () {(1 << 21);}' unless defined(&RT2860_USB_RX_AGG_EN);
eval 'sub RT2860_USB_TXOP_HALT () {(1 << 20);}' unless defined(&RT2860_USB_TXOP_HALT);
eval 'sub RT2860_USB_TX_CLEAR () {(1 << 19);}' unless defined(&RT2860_USB_TX_CLEAR);
eval 'sub RT2860_USB_PHY_WD_EN () {(1 << 16);}' unless defined(&RT2860_USB_PHY_WD_EN);
eval 'sub RT2860_USB_PHY_MAN_RST () {(1 << 15);}' unless defined(&RT2860_USB_PHY_MAN_RST);
unless(defined(&RT2860_USB_RX_AGG_LMT)) {
    sub RT2860_USB_RX_AGG_LMT {
	my($x) = @_;
	eval q((($x) << 8));
    }
}
unless(defined(&RT2860_USB_RX_AGG_TO)) {
    sub RT2860_USB_RX_AGG_TO {
	my($x) = @_;
	eval q((($x) & 0xff));
    }
}
eval 'sub RT2860_TEST_EN () {(1<< 24);}' unless defined(&RT2860_TEST_EN);
eval 'sub RT2860_TEST_SEL_SHIFT () {16;}' unless defined(&RT2860_TEST_SEL_SHIFT);
eval 'sub RT2860_BT_MODE_EN () {(1<< 8);}' unless defined(&RT2860_BT_MODE_EN);
eval 'sub RT2860_US_CYC_CNT_SHIFT () {0;}' unless defined(&RT2860_US_CYC_CNT_SHIFT);
eval 'sub RT2860_HST_PM_SEL () {(1<< 16);}' unless defined(&RT2860_HST_PM_SEL);
eval 'sub RT2860_CAP_MODE () {(1<< 14);}' unless defined(&RT2860_CAP_MODE);
eval 'sub RT2860_PME_OEN () {(1<< 13);}' unless defined(&RT2860_PME_OEN);
eval 'sub RT2860_CLKSELECT () {(1<< 12);}' unless defined(&RT2860_CLKSELECT);
eval 'sub RT2860_PBF_CLK_EN () {(1<< 11);}' unless defined(&RT2860_PBF_CLK_EN);
eval 'sub RT2860_MAC_CLK_EN () {(1<< 10);}' unless defined(&RT2860_MAC_CLK_EN);
eval 'sub RT2860_DMA_CLK_EN () {(1<< 9);}' unless defined(&RT2860_DMA_CLK_EN);
eval 'sub RT2860_MCU_READY () {(1<< 7);}' unless defined(&RT2860_MCU_READY);
eval 'sub RT2860_ASY_RESET () {(1<< 4);}' unless defined(&RT2860_ASY_RESET);
eval 'sub RT2860_PBF_RESET () {(1<< 3);}' unless defined(&RT2860_PBF_RESET);
eval 'sub RT2860_MAC_RESET () {(1<< 2);}' unless defined(&RT2860_MAC_RESET);
eval 'sub RT2860_DMA_RESET () {(1<< 1);}' unless defined(&RT2860_DMA_RESET);
eval 'sub RT2860_MCU_RESET () {(1<< 0);}' unless defined(&RT2860_MCU_RESET);
eval 'sub RT2860_MCU_CMD_SLEEP () {0x30;}' unless defined(&RT2860_MCU_CMD_SLEEP);
eval 'sub RT2860_MCU_CMD_WAKEUP () {0x31;}' unless defined(&RT2860_MCU_CMD_WAKEUP);
eval 'sub RT2860_MCU_CMD_LEDS () {0x50;}' unless defined(&RT2860_MCU_CMD_LEDS);
eval 'sub RT2860_MCU_CMD_LED_RSSI () {0x51;}' unless defined(&RT2860_MCU_CMD_LED_RSSI);
eval 'sub RT2860_MCU_CMD_LED1 () {0x52;}' unless defined(&RT2860_MCU_CMD_LED1);
eval 'sub RT2860_MCU_CMD_LED2 () {0x53;}' unless defined(&RT2860_MCU_CMD_LED2);
eval 'sub RT2860_MCU_CMD_LED3 () {0x54;}' unless defined(&RT2860_MCU_CMD_LED3);
eval 'sub RT2860_MCU_CMD_RFRESET () {0x72;}' unless defined(&RT2860_MCU_CMD_RFRESET);
eval 'sub RT2860_MCU_CMD_ANTSEL () {0x73;}' unless defined(&RT2860_MCU_CMD_ANTSEL);
eval 'sub RT2860_MCU_CMD_BBP () {0x80;}' unless defined(&RT2860_MCU_CMD_BBP);
eval 'sub RT2860_MCU_CMD_PSLEVEL () {0x83;}' unless defined(&RT2860_MCU_CMD_PSLEVEL);
eval 'sub RT2860_TX1Q_NUM_SHIFT () {21;}' unless defined(&RT2860_TX1Q_NUM_SHIFT);
eval 'sub RT2860_TX2Q_NUM_SHIFT () {16;}' unless defined(&RT2860_TX2Q_NUM_SHIFT);
eval 'sub RT2860_NULL0_MODE () {(1<< 15);}' unless defined(&RT2860_NULL0_MODE);
eval 'sub RT2860_NULL1_MODE () {(1<< 14);}' unless defined(&RT2860_NULL1_MODE);
eval 'sub RT2860_RX_DROP_MODE () {(1<< 13);}' unless defined(&RT2860_RX_DROP_MODE);
eval 'sub RT2860_TX0Q_MANUAL () {(1<< 12);}' unless defined(&RT2860_TX0Q_MANUAL);
eval 'sub RT2860_TX1Q_MANUAL () {(1<< 11);}' unless defined(&RT2860_TX1Q_MANUAL);
eval 'sub RT2860_TX2Q_MANUAL () {(1<< 10);}' unless defined(&RT2860_TX2Q_MANUAL);
eval 'sub RT2860_RX0Q_MANUAL () {(1<< 9);}' unless defined(&RT2860_RX0Q_MANUAL);
eval 'sub RT2860_HCCA_EN () {(1<< 8);}' unless defined(&RT2860_HCCA_EN);
eval 'sub RT2860_TX0Q_EN () {(1<< 4);}' unless defined(&RT2860_TX0Q_EN);
eval 'sub RT2860_TX1Q_EN () {(1<< 3);}' unless defined(&RT2860_TX1Q_EN);
eval 'sub RT2860_TX2Q_EN () {(1<< 2);}' unless defined(&RT2860_TX2Q_EN);
eval 'sub RT2860_RX0Q_EN () {(1<< 1);}' unless defined(&RT2860_RX0Q_EN);
unless(defined(&RT2860_WRITE_TXQ)) {
    sub RT2860_WRITE_TXQ {
	my($qid) = @_;
	eval q((1<< (11- ($qid))));
    }
}
eval 'sub RT2860_NULL0_KICK () {(1<< 7);}' unless defined(&RT2860_NULL0_KICK);
eval 'sub RT2860_NULL1_KICK () {(1<< 6);}' unless defined(&RT2860_NULL1_KICK);
eval 'sub RT2860_BUF_RESET () {(1<< 5);}' unless defined(&RT2860_BUF_RESET);
unless(defined(&RT2860_READ_TXQ)) {
    sub RT2860_READ_TXQ {
	my($qid) = @_;
	eval q((1<< (3- ($qid)));
    }
}
eval 'sub RT2860_READ_RX0Q () {(1<< 0);}' unless defined(&RT2860_READ_RX0Q);
eval 'sub RT2860_MCU_MAC_INT_8 () {(1<< 24);}' unless defined(&RT2860_MCU_MAC_INT_8);
eval 'sub RT2860_MCU_MAC_INT_7 () {(1<< 23);}' unless defined(&RT2860_MCU_MAC_INT_7);
eval 'sub RT2860_MCU_MAC_INT_6 () {(1<< 22);}' unless defined(&RT2860_MCU_MAC_INT_6);
eval 'sub RT2860_MCU_MAC_INT_4 () {(1<< 20);}' unless defined(&RT2860_MCU_MAC_INT_4);
eval 'sub RT2860_MCU_MAC_INT_3 () {(1<< 19);}' unless defined(&RT2860_MCU_MAC_INT_3);
eval 'sub RT2860_MCU_MAC_INT_2 () {(1<< 18);}' unless defined(&RT2860_MCU_MAC_INT_2);
eval 'sub RT2860_MCU_MAC_INT_1 () {(1<< 17);}' unless defined(&RT2860_MCU_MAC_INT_1);
eval 'sub RT2860_MCU_MAC_INT_0 () {(1<< 16);}' unless defined(&RT2860_MCU_MAC_INT_0);
eval 'sub RT2860_DTX0_INT () {(1<< 11);}' unless defined(&RT2860_DTX0_INT);
eval 'sub RT2860_DTX1_INT () {(1<< 10);}' unless defined(&RT2860_DTX1_INT);
eval 'sub RT2860_DTX2_INT () {(1<< 9);}' unless defined(&RT2860_DTX2_INT);
eval 'sub RT2860_DRX0_INT () {(1<< 8);}' unless defined(&RT2860_DRX0_INT);
eval 'sub RT2860_HCMD_INT () {(1<< 7);}' unless defined(&RT2860_HCMD_INT);
eval 'sub RT2860_N0TX_INT () {(1<< 6);}' unless defined(&RT2860_N0TX_INT);
eval 'sub RT2860_N1TX_INT () {(1<< 5);}' unless defined(&RT2860_N1TX_INT);
eval 'sub RT2860_BCNTX_INT () {(1<< 4);}' unless defined(&RT2860_BCNTX_INT);
eval 'sub RT2860_MTX0_INT () {(1<< 3);}' unless defined(&RT2860_MTX0_INT);
eval 'sub RT2860_MTX1_INT () {(1<< 2);}' unless defined(&RT2860_MTX1_INT);
eval 'sub RT2860_MTX2_INT () {(1<< 1);}' unless defined(&RT2860_MTX2_INT);
eval 'sub RT2860_MRX0_INT () {(1<< 0);}' unless defined(&RT2860_MRX0_INT);
eval 'sub RT2860_RX0Q_PCNT_MASK () {0xff000000;}' unless defined(&RT2860_RX0Q_PCNT_MASK);
eval 'sub RT2860_TX2Q_PCNT_MASK () {0xff0000;}' unless defined(&RT2860_TX2Q_PCNT_MASK);
eval 'sub RT2860_TX1Q_PCNT_MASK () {0xff00;}' unless defined(&RT2860_TX1Q_PCNT_MASK);
eval 'sub RT2860_TX0Q_PCNT_MASK () {0xff;}' unless defined(&RT2860_TX0Q_PCNT_MASK);
eval 'sub RT2860_CAP_ADC_FEQ () {(1 << 31);}' unless defined(&RT2860_CAP_ADC_FEQ);
eval 'sub RT2860_CAP_START () {(1 << 30);}' unless defined(&RT2860_CAP_START);
eval 'sub RT2860_MAN_TRIG () {(1 << 29);}' unless defined(&RT2860_MAN_TRIG);
eval 'sub RT2860_TRIG_OFFSET_SHIFT () {16;}' unless defined(&RT2860_TRIG_OFFSET_SHIFT);
eval 'sub RT2860_START_ADDR_SHIFT () {0;}' unless defined(&RT2860_START_ADDR_SHIFT);
eval 'sub RT3070_RF_KICK () {(1<< 17);}' unless defined(&RT3070_RF_KICK);
eval 'sub RT3070_RF_WRITE () {(1<< 16);}' unless defined(&RT3070_RF_WRITE);
eval 'sub RT3070_SEL_EFUSE () {(1 << 31);}' unless defined(&RT3070_SEL_EFUSE);
eval 'sub RT3070_EFSROM_KICK () {(1 << 30);}' unless defined(&RT3070_EFSROM_KICK);
eval 'sub RT3070_EFSROM_AIN_MASK () {0x3ff0000;}' unless defined(&RT3070_EFSROM_AIN_MASK);
eval 'sub RT3070_EFSROM_AIN_SHIFT () {16;}' unless defined(&RT3070_EFSROM_AIN_SHIFT);
eval 'sub RT3070_EFSROM_MODE_MASK () {0xc0;}' unless defined(&RT3070_EFSROM_MODE_MASK);
eval 'sub RT3070_EFUSE_AOUT_MASK () {0x3f;}' unless defined(&RT3070_EFUSE_AOUT_MASK);
eval 'sub RT5592_SEL_XTAL () {(1 << 31);}' unless defined(&RT5592_SEL_XTAL);
eval 'sub RT2860_RX_TS_EN () {(1<< 7);}' unless defined(&RT2860_RX_TS_EN);
eval 'sub RT2860_WLAN_HALT_EN () {(1<< 6);}' unless defined(&RT2860_WLAN_HALT_EN);
eval 'sub RT2860_PBF_LOOP_EN () {(1<< 5);}' unless defined(&RT2860_PBF_LOOP_EN);
eval 'sub RT2860_CONT_TX_TEST () {(1<< 4);}' unless defined(&RT2860_CONT_TX_TEST);
eval 'sub RT2860_MAC_RX_EN () {(1<< 3);}' unless defined(&RT2860_MAC_RX_EN);
eval 'sub RT2860_MAC_TX_EN () {(1<< 2);}' unless defined(&RT2860_MAC_TX_EN);
eval 'sub RT2860_BBP_HRST () {(1<< 1);}' unless defined(&RT2860_BBP_HRST);
eval 'sub RT2860_MAC_SRST () {(1<< 0);}' unless defined(&RT2860_MAC_SRST);
eval 'sub RT2860_MULTI_BCN_NUM_SHIFT () {18;}' unless defined(&RT2860_MULTI_BCN_NUM_SHIFT);
eval 'sub RT2860_MULTI_BSSID_MODE_SHIFT () {16;}' unless defined(&RT2860_MULTI_BSSID_MODE_SHIFT);
eval 'sub RT2860_MIN_MPDU_LEN_SHIFT () {16;}' unless defined(&RT2860_MIN_MPDU_LEN_SHIFT);
eval 'sub RT2860_MAX_PSDU_LEN_SHIFT () {12;}' unless defined(&RT2860_MAX_PSDU_LEN_SHIFT);
eval 'sub RT2860_MAX_PSDU_LEN8K () {0;}' unless defined(&RT2860_MAX_PSDU_LEN8K);
eval 'sub RT2860_MAX_PSDU_LEN16K () {1;}' unless defined(&RT2860_MAX_PSDU_LEN16K);
eval 'sub RT2860_MAX_PSDU_LEN32K () {2;}' unless defined(&RT2860_MAX_PSDU_LEN32K);
eval 'sub RT2860_MAX_PSDU_LEN64K () {3;}' unless defined(&RT2860_MAX_PSDU_LEN64K);
eval 'sub RT2860_MAX_MPDU_LEN_SHIFT () {0;}' unless defined(&RT2860_MAX_MPDU_LEN_SHIFT);
eval 'sub RT2860_BBP_RW_PARALLEL () {(1<< 19);}' unless defined(&RT2860_BBP_RW_PARALLEL);
eval 'sub RT2860_BBP_PAR_DUR_112_5 () {(1<< 18);}' unless defined(&RT2860_BBP_PAR_DUR_112_5);
eval 'sub RT2860_BBP_CSR_KICK () {(1<< 17);}' unless defined(&RT2860_BBP_CSR_KICK);
eval 'sub RT2860_BBP_CSR_READ () {(1<< 16);}' unless defined(&RT2860_BBP_CSR_READ);
eval 'sub RT2860_BBP_ADDR_SHIFT () {8;}' unless defined(&RT2860_BBP_ADDR_SHIFT);
eval 'sub RT2860_BBP_DATA_SHIFT () {0;}' unless defined(&RT2860_BBP_DATA_SHIFT);
eval 'sub RT2860_RF_REG_CTRL () {(1 << 31);}' unless defined(&RT2860_RF_REG_CTRL);
eval 'sub RT2860_RF_LE_SEL1 () {(1 << 30);}' unless defined(&RT2860_RF_LE_SEL1);
eval 'sub RT2860_RF_LE_STBY () {(1 << 29);}' unless defined(&RT2860_RF_LE_STBY);
eval 'sub RT2860_RF_REG_WIDTH_SHIFT () {24;}' unless defined(&RT2860_RF_REG_WIDTH_SHIFT);
eval 'sub RT2860_RF_REG_0_SHIFT () {0;}' unless defined(&RT2860_RF_REG_0_SHIFT);
eval 'sub RT2860_RF_DUR_5 () {(1<< 24);}' unless defined(&RT2860_RF_DUR_5);
eval 'sub RT2860_RF_REG_1_SHIFT () {0;}' unless defined(&RT2860_RF_REG_1_SHIFT);
eval 'sub RT2860_LED_POL () {(1<< 30);}' unless defined(&RT2860_LED_POL);
eval 'sub RT2860_Y_LED_MODE_SHIFT () {28;}' unless defined(&RT2860_Y_LED_MODE_SHIFT);
eval 'sub RT2860_G_LED_MODE_SHIFT () {26;}' unless defined(&RT2860_G_LED_MODE_SHIFT);
eval 'sub RT2860_R_LED_MODE_SHIFT () {24;}' unless defined(&RT2860_R_LED_MODE_SHIFT);
eval 'sub RT2860_LED_MODE_OFF () {0;}' unless defined(&RT2860_LED_MODE_OFF);
eval 'sub RT2860_LED_MODE_BLINK_TX () {1;}' unless defined(&RT2860_LED_MODE_BLINK_TX);
eval 'sub RT2860_LED_MODE_SLOW_BLINK () {2;}' unless defined(&RT2860_LED_MODE_SLOW_BLINK);
eval 'sub RT2860_LED_MODE_ON () {3;}' unless defined(&RT2860_LED_MODE_ON);
eval 'sub RT2860_SLOW_BLK_TIME_SHIFT () {16;}' unless defined(&RT2860_SLOW_BLK_TIME_SHIFT);
eval 'sub RT2860_LED_OFF_TIME_SHIFT () {8;}' unless defined(&RT2860_LED_OFF_TIME_SHIFT);
eval 'sub RT2860_LED_ON_TIME_SHIFT () {0;}' unless defined(&RT2860_LED_ON_TIME_SHIFT);
eval 'sub RT2860_BB_RXEND_EN () {(1<< 29);}' unless defined(&RT2860_BB_RXEND_EN);
eval 'sub RT2860_EIFS_TIME_SHIFT () {20;}' unless defined(&RT2860_EIFS_TIME_SHIFT);
eval 'sub RT2860_OFDM_XIFS_TIME_SHIFT () {16;}' unless defined(&RT2860_OFDM_XIFS_TIME_SHIFT);
eval 'sub RT2860_OFDM_SIFS_TIME_SHIFT () {8;}' unless defined(&RT2860_OFDM_SIFS_TIME_SHIFT);
eval 'sub RT2860_CCK_SIFS_TIME_SHIFT () {0;}' unless defined(&RT2860_CCK_SIFS_TIME_SHIFT);
eval 'sub RT2860_CC_DELAY_TIME_SHIFT () {8;}' unless defined(&RT2860_CC_DELAY_TIME_SHIFT);
eval 'sub RT2860_SLOT_TIME () {0;}' unless defined(&RT2860_SLOT_TIME);
eval 'sub RT2860_NAV_UPD () {(1 << 31);}' unless defined(&RT2860_NAV_UPD);
eval 'sub RT2860_NAV_UPD_VAL_SHIFT () {16;}' unless defined(&RT2860_NAV_UPD_VAL_SHIFT);
eval 'sub RT2860_NAV_CLR_EN () {(1 << 15);}' unless defined(&RT2860_NAV_CLR_EN);
eval 'sub RT2860_NAV_TIMER_SHIFT () {0;}' unless defined(&RT2860_NAV_TIMER_SHIFT);
eval 'sub RT2860_EIFS_AS_CH_BUSY () {(1<< 4);}' unless defined(&RT2860_EIFS_AS_CH_BUSY);
eval 'sub RT2860_NAV_AS_CH_BUSY () {(1<< 3);}' unless defined(&RT2860_NAV_AS_CH_BUSY);
eval 'sub RT2860_RX_AS_CH_BUSY () {(1<< 2);}' unless defined(&RT2860_RX_AS_CH_BUSY);
eval 'sub RT2860_TX_AS_CH_BUSY () {(1<< 1);}' unless defined(&RT2860_TX_AS_CH_BUSY);
eval 'sub RT2860_CH_STA_TIMER_EN () {(1<< 0);}' unless defined(&RT2860_CH_STA_TIMER_EN);
eval 'sub RT2860_TSF_INS_COMP_SHIFT () {24;}' unless defined(&RT2860_TSF_INS_COMP_SHIFT);
eval 'sub RT2860_BCN_TX_EN () {(1<< 20);}' unless defined(&RT2860_BCN_TX_EN);
eval 'sub RT2860_TBTT_TIMER_EN () {(1<< 19);}' unless defined(&RT2860_TBTT_TIMER_EN);
eval 'sub RT2860_TSF_SYNC_MODE_SHIFT () {17;}' unless defined(&RT2860_TSF_SYNC_MODE_SHIFT);
eval 'sub RT2860_TSF_SYNC_MODE_DIS () {0;}' unless defined(&RT2860_TSF_SYNC_MODE_DIS);
eval 'sub RT2860_TSF_SYNC_MODE_STA () {1;}' unless defined(&RT2860_TSF_SYNC_MODE_STA);
eval 'sub RT2860_TSF_SYNC_MODE_IBSS () {2;}' unless defined(&RT2860_TSF_SYNC_MODE_IBSS);
eval 'sub RT2860_TSF_SYNC_MODE_HOSTAP () {3;}' unless defined(&RT2860_TSF_SYNC_MODE_HOSTAP);
eval 'sub RT2860_TSF_TIMER_EN () {(1<< 16);}' unless defined(&RT2860_TSF_TIMER_EN);
eval 'sub RT2860_BCN_INTVAL_SHIFT () {0;}' unless defined(&RT2860_BCN_INTVAL_SHIFT);
eval 'sub RT2860_BCN_CWMIN_SHIFT () {20;}' unless defined(&RT2860_BCN_CWMIN_SHIFT);
eval 'sub RT2860_BCN_AIFSN_SHIFT () {16;}' unless defined(&RT2860_BCN_AIFSN_SHIFT);
eval 'sub RT2860_BCN_EXP_WIN_SHIFT () {8;}' unless defined(&RT2860_BCN_EXP_WIN_SHIFT);
eval 'sub RT2860_TBTT_ADJUST_SHIFT () {0;}' unless defined(&RT2860_TBTT_ADJUST_SHIFT);
eval 'sub RT2860_GP_TIMER_SHIFT () {16;}' unless defined(&RT2860_GP_TIMER_SHIFT);
eval 'sub RT2860_PRE_TBTT_TIMER_SHIFT () {0;}' unless defined(&RT2860_PRE_TBTT_TIMER_SHIFT);
eval 'sub RT2860_GP_TIMER_EN () {(1<< 1);}' unless defined(&RT2860_GP_TIMER_EN);
eval 'sub RT2860_PRE_TBTT_INT_EN () {(1<< 0);}' unless defined(&RT2860_PRE_TBTT_INT_EN);
eval 'sub RT2860_RX_STATUS_BUSY () {(1<< 1);}' unless defined(&RT2860_RX_STATUS_BUSY);
eval 'sub RT2860_TX_STATUS_BUSY () {(1<< 0);}' unless defined(&RT2860_TX_STATUS_BUSY);
eval 'sub RT2860_IO_ADDA_PD () {(1<< 3);}' unless defined(&RT2860_IO_ADDA_PD);
eval 'sub RT2860_IO_PLL_PD () {(1<< 2);}' unless defined(&RT2860_IO_PLL_PD);
eval 'sub RT2860_IO_RA_PE () {(1<< 1);}' unless defined(&RT2860_IO_RA_PE);
eval 'sub RT2860_IO_RF_PE () {(1<< 0);}' unless defined(&RT2860_IO_RF_PE);
eval 'sub RT2860_AUTO_WAKEUP_EN () {(1<< 15);}' unless defined(&RT2860_AUTO_WAKEUP_EN);
eval 'sub RT2860_SLEEP_TBTT_NUM_SHIFT () {8;}' unless defined(&RT2860_SLEEP_TBTT_NUM_SHIFT);
eval 'sub RT2860_WAKEUP_LEAD_TIME_SHIFT () {0;}' unless defined(&RT2860_WAKEUP_LEAD_TIME_SHIFT);
eval 'sub RT3593_LNA_PE_G2_POL () {(1 << 31);}' unless defined(&RT3593_LNA_PE_G2_POL);
eval 'sub RT3593_LNA_PE_A2_POL () {(1 << 30);}' unless defined(&RT3593_LNA_PE_A2_POL);
eval 'sub RT3593_LNA_PE_G2_EN () {(1 << 29);}' unless defined(&RT3593_LNA_PE_G2_EN);
eval 'sub RT3593_LNA_PE_A2_EN () {(1 << 28);}' unless defined(&RT3593_LNA_PE_A2_EN);
eval 'sub RT3593_LNA_PE2_EN () {( &RT3593_LNA_PE_A2_EN |  &RT3593_LNA_PE_G2_EN);}' unless defined(&RT3593_LNA_PE2_EN);
eval 'sub RT3593_PA_PE_G2_POL () {(1 << 27);}' unless defined(&RT3593_PA_PE_G2_POL);
eval 'sub RT3593_PA_PE_A2_POL () {(1 << 26);}' unless defined(&RT3593_PA_PE_A2_POL);
eval 'sub RT3593_PA_PE_G2_EN () {(1 << 25);}' unless defined(&RT3593_PA_PE_G2_EN);
eval 'sub RT3593_PA_PE_A2_EN () {(1 << 24);}' unless defined(&RT3593_PA_PE_A2_EN);
eval 'sub RT2860_TRSW_POL () {(1 << 19);}' unless defined(&RT2860_TRSW_POL);
eval 'sub RT2860_TRSW_EN () {(1 << 18);}' unless defined(&RT2860_TRSW_EN);
eval 'sub RT2860_RFTR_POL () {(1 << 17);}' unless defined(&RT2860_RFTR_POL);
eval 'sub RT2860_RFTR_EN () {(1 << 16);}' unless defined(&RT2860_RFTR_EN);
eval 'sub RT2860_LNA_PE_G1_POL () {(1 << 15);}' unless defined(&RT2860_LNA_PE_G1_POL);
eval 'sub RT2860_LNA_PE_A1_POL () {(1 << 14);}' unless defined(&RT2860_LNA_PE_A1_POL);
eval 'sub RT2860_LNA_PE_G0_POL () {(1 << 13);}' unless defined(&RT2860_LNA_PE_G0_POL);
eval 'sub RT2860_LNA_PE_A0_POL () {(1 << 12);}' unless defined(&RT2860_LNA_PE_A0_POL);
eval 'sub RT2860_LNA_PE_G1_EN () {(1 << 11);}' unless defined(&RT2860_LNA_PE_G1_EN);
eval 'sub RT2860_LNA_PE_A1_EN () {(1 << 10);}' unless defined(&RT2860_LNA_PE_A1_EN);
eval 'sub RT2860_LNA_PE1_EN () {( &RT2860_LNA_PE_A1_EN |  &RT2860_LNA_PE_G1_EN);}' unless defined(&RT2860_LNA_PE1_EN);
eval 'sub RT2860_LNA_PE_G0_EN () {(1 << 9);}' unless defined(&RT2860_LNA_PE_G0_EN);
eval 'sub RT2860_LNA_PE_A0_EN () {(1 << 8);}' unless defined(&RT2860_LNA_PE_A0_EN);
eval 'sub RT2860_LNA_PE0_EN () {( &RT2860_LNA_PE_A0_EN |  &RT2860_LNA_PE_G0_EN);}' unless defined(&RT2860_LNA_PE0_EN);
eval 'sub RT2860_PA_PE_G1_POL () {(1 << 7);}' unless defined(&RT2860_PA_PE_G1_POL);
eval 'sub RT2860_PA_PE_A1_POL () {(1 << 6);}' unless defined(&RT2860_PA_PE_A1_POL);
eval 'sub RT2860_PA_PE_G0_POL () {(1 << 5);}' unless defined(&RT2860_PA_PE_G0_POL);
eval 'sub RT2860_PA_PE_A0_POL () {(1 << 4);}' unless defined(&RT2860_PA_PE_A0_POL);
eval 'sub RT2860_PA_PE_G1_EN () {(1 << 3);}' unless defined(&RT2860_PA_PE_G1_EN);
eval 'sub RT2860_PA_PE_A1_EN () {(1 << 2);}' unless defined(&RT2860_PA_PE_A1_EN);
eval 'sub RT2860_PA_PE_G0_EN () {(1 << 1);}' unless defined(&RT2860_PA_PE_G0_EN);
eval 'sub RT2860_PA_PE_A0_EN () {(1 << 0);}' unless defined(&RT2860_PA_PE_A0_EN);
eval 'sub RT2860_5G_BAND_SEL_N () {(1<< 2);}' unless defined(&RT2860_5G_BAND_SEL_N);
eval 'sub RT2860_5G_BAND_SEL_P () {(1<< 1);}' unless defined(&RT2860_5G_BAND_SEL_P);
eval 'sub RT2860_TX_BAND_SEL () {(1<< 0);}' unless defined(&RT2860_TX_BAND_SEL);
eval 'sub RT2860_DLY_RFTR_EN_SHIFT () {24;}' unless defined(&RT2860_DLY_RFTR_EN_SHIFT);
eval 'sub RT2860_DLY_TRSW_EN_SHIFT () {16;}' unless defined(&RT2860_DLY_TRSW_EN_SHIFT);
eval 'sub RT2860_DLY_PAPE_EN_SHIFT () {8;}' unless defined(&RT2860_DLY_PAPE_EN_SHIFT);
eval 'sub RT2860_DLY_TXPE_EN_SHIFT () {0;}' unless defined(&RT2860_DLY_TXPE_EN_SHIFT);
eval 'sub RT2860_DLY_RFTR_DIS_SHIFT () {16;}' unless defined(&RT2860_DLY_RFTR_DIS_SHIFT);
eval 'sub RT2860_DLY_TRSW_DIS_SHIFT () {8;}' unless defined(&RT2860_DLY_TRSW_DIS_SHIFT);
eval 'sub RT2860_DLY_PAPE_DIS () { &SHIFT 0;}' unless defined(&RT2860_DLY_PAPE_DIS);
eval 'sub RT2860_DLY_LNA_EN_SHIFT () {24;}' unless defined(&RT2860_DLY_LNA_EN_SHIFT);
eval 'sub RT2860_DLY_LNA_DIS_SHIFT () {16;}' unless defined(&RT2860_DLY_LNA_DIS_SHIFT);
eval 'sub RT2860_DLY_DAC_EN_SHIFT () {8;}' unless defined(&RT2860_DLY_DAC_EN_SHIFT);
eval 'sub RT2860_DLY_DAC_DIS_SHIFT () {0;}' unless defined(&RT2860_DLY_DAC_DIS_SHIFT);
eval 'sub RT2860_TXOP_REM_THRES_SHIFT () {24;}' unless defined(&RT2860_TXOP_REM_THRES_SHIFT);
eval 'sub RT2860_CF_END_THRES_SHIFT () {16;}' unless defined(&RT2860_CF_END_THRES_SHIFT);
eval 'sub RT2860_RDG_IN_THRES () {8;}' unless defined(&RT2860_RDG_IN_THRES);
eval 'sub RT2860_RDG_OUT_THRES () {0;}' unless defined(&RT2860_RDG_OUT_THRES);
eval 'sub RT2860_EXT_CW_MIN_SHIFT () {16;}' unless defined(&RT2860_EXT_CW_MIN_SHIFT);
eval 'sub RT2860_EXT_CCA_DLY_SHIFT () {8;}' unless defined(&RT2860_EXT_CCA_DLY_SHIFT);
eval 'sub RT2860_EXT_CCA_EN () {(1<< 7);}' unless defined(&RT2860_EXT_CCA_EN);
eval 'sub RT2860_LSIG_TXOP_EN () {(1<< 6);}' unless defined(&RT2860_LSIG_TXOP_EN);
eval 'sub RT2860_TXOP_TRUN_EN_MIMOPS () {(1<< 4);}' unless defined(&RT2860_TXOP_TRUN_EN_MIMOPS);
eval 'sub RT2860_TXOP_TRUN_EN_TXOP () {(1<< 3);}' unless defined(&RT2860_TXOP_TRUN_EN_TXOP);
eval 'sub RT2860_TXOP_TRUN_EN_RATE () {(1<< 2);}' unless defined(&RT2860_TXOP_TRUN_EN_RATE);
eval 'sub RT2860_TXOP_TRUN_EN_AC () {(1<< 1);}' unless defined(&RT2860_TXOP_TRUN_EN_AC);
eval 'sub RT2860_TXOP_TRUN_EN_TIMEOUT () {(1<< 0);}' unless defined(&RT2860_TXOP_TRUN_EN_TIMEOUT);
eval 'sub RT2860_RTS_FBK_EN () {(1<< 24);}' unless defined(&RT2860_RTS_FBK_EN);
eval 'sub RT2860_RTS_THRES_SHIFT () {8;}' unless defined(&RT2860_RTS_THRES_SHIFT);
eval 'sub RT2860_RTS_RTY_LIMIT_SHIFT () {0;}' unless defined(&RT2860_RTS_RTY_LIMIT_SHIFT);
eval 'sub RT2860_TXOP_TIMEOUT_SHIFT () {16;}' unless defined(&RT2860_TXOP_TIMEOUT_SHIFT);
eval 'sub RT2860_RX_ACK_TIMEOUT_SHIFT () {8;}' unless defined(&RT2860_RX_ACK_TIMEOUT_SHIFT);
eval 'sub RT2860_MPDU_LIFE_TIME_SHIFT () {4;}' unless defined(&RT2860_MPDU_LIFE_TIME_SHIFT);
eval 'sub RT2860_TX_AUTOFB_EN () {(1<< 30);}' unless defined(&RT2860_TX_AUTOFB_EN);
eval 'sub RT2860_AGG_RTY_MODE_TIMER () {(1<< 29);}' unless defined(&RT2860_AGG_RTY_MODE_TIMER);
eval 'sub RT2860_NAG_RTY_MODE_TIMER () {(1<< 28);}' unless defined(&RT2860_NAG_RTY_MODE_TIMER);
eval 'sub RT2860_LONG_RTY_THRES_SHIFT () {16;}' unless defined(&RT2860_LONG_RTY_THRES_SHIFT);
eval 'sub RT2860_LONG_RTY_LIMIT_SHIFT () {8;}' unless defined(&RT2860_LONG_RTY_LIMIT_SHIFT);
eval 'sub RT2860_SHORT_RTY_LIMIT_SHIFT () {0;}' unless defined(&RT2860_SHORT_RTY_LIMIT_SHIFT);
eval 'sub RT2860_REMOTE_MFS_SHIFT () {24;}' unless defined(&RT2860_REMOTE_MFS_SHIFT);
eval 'sub RT2860_REMOTE_MFB_SHIFT () {16;}' unless defined(&RT2860_REMOTE_MFB_SHIFT);
eval 'sub RT2860_TX_CFACK_EN () {(1<< 12);}' unless defined(&RT2860_TX_CFACK_EN);
eval 'sub RT2860_TX_RDG_EN () {(1<< 11);}' unless defined(&RT2860_TX_RDG_EN);
eval 'sub RT2860_TX_MRQ_EN () {(1<< 10);}' unless defined(&RT2860_TX_MRQ_EN);
eval 'sub RT2860_REMOTE_UMFS_EN () {(1<< 9);}' unless defined(&RT2860_REMOTE_UMFS_EN);
eval 'sub RT2860_TX_MFB_EN () {(1<< 8);}' unless defined(&RT2860_TX_MFB_EN);
eval 'sub RT2860_REMOTE_MFB_LT_SHIFT () {0;}' unless defined(&RT2860_REMOTE_MFB_LT_SHIFT);
eval 'sub RT2860_RTSTH_EN () {(1<< 26);}' unless defined(&RT2860_RTSTH_EN);
eval 'sub RT2860_TXOP_ALLOW_GF40 () {(1<< 25);}' unless defined(&RT2860_TXOP_ALLOW_GF40);
eval 'sub RT2860_TXOP_ALLOW_GF20 () {(1<< 24);}' unless defined(&RT2860_TXOP_ALLOW_GF20);
eval 'sub RT2860_TXOP_ALLOW_MM40 () {(1<< 23);}' unless defined(&RT2860_TXOP_ALLOW_MM40);
eval 'sub RT2860_TXOP_ALLOW_MM20 () {(1<< 22);}' unless defined(&RT2860_TXOP_ALLOW_MM20);
eval 'sub RT2860_TXOP_ALLOW_OFDM () {(1<< 21);}' unless defined(&RT2860_TXOP_ALLOW_OFDM);
eval 'sub RT2860_TXOP_ALLOW_CCK () {(1<< 20);}' unless defined(&RT2860_TXOP_ALLOW_CCK);
eval 'sub RT2860_TXOP_ALLOW_ALL () {(0x3f << 20);}' unless defined(&RT2860_TXOP_ALLOW_ALL);
eval 'sub RT2860_PROT_NAV_SHORT () {(1<< 18);}' unless defined(&RT2860_PROT_NAV_SHORT);
eval 'sub RT2860_PROT_NAV_LONG () {(2<< 18);}' unless defined(&RT2860_PROT_NAV_LONG);
eval 'sub RT2860_PROT_CTRL_RTS_CTS () {(1<< 16);}' unless defined(&RT2860_PROT_CTRL_RTS_CTS);
eval 'sub RT2860_PROT_CTRL_CTS () {(2<< 16);}' unless defined(&RT2860_PROT_CTRL_CTS);
eval 'sub RT2860_EXP_OFDM_TIME_SHIFT () {16;}' unless defined(&RT2860_EXP_OFDM_TIME_SHIFT);
eval 'sub RT2860_EXP_CCK_TIME_SHIFT () {0;}' unless defined(&RT2860_EXP_CCK_TIME_SHIFT);
eval 'sub RT2860_DROP_CTRL_RSV () {(1<< 16);}' unless defined(&RT2860_DROP_CTRL_RSV);
eval 'sub RT2860_DROP_BAR () {(1<< 15);}' unless defined(&RT2860_DROP_BAR);
eval 'sub RT2860_DROP_BA () {(1<< 14);}' unless defined(&RT2860_DROP_BA);
eval 'sub RT2860_DROP_PSPOLL () {(1<< 13);}' unless defined(&RT2860_DROP_PSPOLL);
eval 'sub RT2860_DROP_RTS () {(1<< 12);}' unless defined(&RT2860_DROP_RTS);
eval 'sub RT2860_DROP_CTS () {(1<< 11);}' unless defined(&RT2860_DROP_CTS);
eval 'sub RT2860_DROP_ACK () {(1<< 10);}' unless defined(&RT2860_DROP_ACK);
eval 'sub RT2860_DROP_CFEND () {(1<< 9);}' unless defined(&RT2860_DROP_CFEND);
eval 'sub RT2860_DROP_CFACK () {(1<< 8);}' unless defined(&RT2860_DROP_CFACK);
eval 'sub RT2860_DROP_DUPL () {(1<< 7);}' unless defined(&RT2860_DROP_DUPL);
eval 'sub RT2860_DROP_BC () {(1<< 6);}' unless defined(&RT2860_DROP_BC);
eval 'sub RT2860_DROP_MC () {(1<< 5);}' unless defined(&RT2860_DROP_MC);
eval 'sub RT2860_DROP_VER_ERR () {(1<< 4);}' unless defined(&RT2860_DROP_VER_ERR);
eval 'sub RT2860_DROP_NOT_MYBSS () {(1<< 3);}' unless defined(&RT2860_DROP_NOT_MYBSS);
eval 'sub RT2860_DROP_UC_NOME () {(1<< 2);}' unless defined(&RT2860_DROP_UC_NOME);
eval 'sub RT2860_DROP_PHY_ERR () {(1<< 1);}' unless defined(&RT2860_DROP_PHY_ERR);
eval 'sub RT2860_DROP_CRC_ERR () {(1<< 0);}' unless defined(&RT2860_DROP_CRC_ERR);
eval 'sub RT2860_CTRL_PWR_BIT () {(1<< 7);}' unless defined(&RT2860_CTRL_PWR_BIT);
eval 'sub RT2860_BAC_ACK_POLICY () {(1<< 6);}' unless defined(&RT2860_BAC_ACK_POLICY);
eval 'sub RT2860_CCK_SHORT_EN () {(1<< 4);}' unless defined(&RT2860_CCK_SHORT_EN);
eval 'sub RT2860_CTS_40M_REF_EN () {(1<< 3);}' unless defined(&RT2860_CTS_40M_REF_EN);
eval 'sub RT2860_CTS_40M_MODE_EN () {(1<< 2);}' unless defined(&RT2860_CTS_40M_MODE_EN);
eval 'sub RT2860_BAC_ACKPOLICY_EN () {(1<< 1);}' unless defined(&RT2860_BAC_ACKPOLICY_EN);
eval 'sub RT2860_AUTO_RSP_EN () {(1<< 0);}' unless defined(&RT2860_AUTO_RSP_EN);
eval 'sub RT2860_OFDM_SIFS_COST_SHIFT () {8;}' unless defined(&RT2860_OFDM_SIFS_COST_SHIFT);
eval 'sub RT2860_CCK_SIFS_COST_SHIFT () {0;}' unless defined(&RT2860_CCK_SIFS_COST_SHIFT);
eval 'sub RT2860_TXOP_ETM1_EN () {(1<< 25);}' unless defined(&RT2860_TXOP_ETM1_EN);
eval 'sub RT2860_TXOP_ETM0_EN () {(1<< 24);}' unless defined(&RT2860_TXOP_ETM0_EN);
eval 'sub RT2860_TXOP_ETM_THRES_SHIFT () {16;}' unless defined(&RT2860_TXOP_ETM_THRES_SHIFT);
eval 'sub RT2860_TXOP_ETO_EN () {(1<< 8);}' unless defined(&RT2860_TXOP_ETO_EN);
eval 'sub RT2860_TXOP_ETO_THRES_SHIFT () {1;}' unless defined(&RT2860_TXOP_ETO_THRES_SHIFT);
eval 'sub RT2860_PER_RX_RST_EN () {(1<< 0);}' unless defined(&RT2860_PER_RX_RST_EN);
eval 'sub RT2860_TXQ_MCS_SHIFT () {16;}' unless defined(&RT2860_TXQ_MCS_SHIFT);
eval 'sub RT2860_TXQ_WCID_SHIFT () {8;}' unless defined(&RT2860_TXQ_WCID_SHIFT);
eval 'sub RT2860_TXQ_ACKREQ () {(1<< 7);}' unless defined(&RT2860_TXQ_ACKREQ);
eval 'sub RT2860_TXQ_AGG () {(1<< 6);}' unless defined(&RT2860_TXQ_AGG);
eval 'sub RT2860_TXQ_OK () {(1<< 5);}' unless defined(&RT2860_TXQ_OK);
eval 'sub RT2860_TXQ_PID_SHIFT () {1;}' unless defined(&RT2860_TXQ_PID_SHIFT);
eval 'sub RT2860_TXQ_VLD () {(1<< 0);}' unless defined(&RT2860_TXQ_VLD);
eval 'sub RT2860_MODE_NOSEC () {0;}' unless defined(&RT2860_MODE_NOSEC);
eval 'sub RT2860_MODE_WEP40 () {1;}' unless defined(&RT2860_MODE_WEP40);
eval 'sub RT2860_MODE_WEP104 () {2;}' unless defined(&RT2860_MODE_WEP104);
eval 'sub RT2860_MODE_TKIP () {3;}' unless defined(&RT2860_MODE_TKIP);
eval 'sub RT2860_MODE_AES_CCMP () {4;}' unless defined(&RT2860_MODE_AES_CCMP);
eval 'sub RT2860_MODE_CKIP40 () {5;}' unless defined(&RT2860_MODE_CKIP40);
eval 'sub RT2860_MODE_CKIP104 () {6;}' unless defined(&RT2860_MODE_CKIP104);
eval 'sub RT2860_MODE_CKIP128 () {7;}' unless defined(&RT2860_MODE_CKIP128);
eval 'sub RT2860_RX_PKEY_EN () {(1<< 0);}' unless defined(&RT2860_RX_PKEY_EN);
eval 'sub RT2860_H2M_BUSY () {(1<< 24);}' unless defined(&RT2860_H2M_BUSY);
eval 'sub RT2860_TOKEN_NO_INTR () {0xff;}' unless defined(&RT2860_TOKEN_NO_INTR);
eval 'sub RT2860_LED_RADIO () {(1<< 13);}' unless defined(&RT2860_LED_RADIO);
eval 'sub RT2860_LED_LINK_2GHZ () {(1<< 14);}' unless defined(&RT2860_LED_LINK_2GHZ);
eval 'sub RT2860_LED_LINK_5GHZ () {(1<< 15);}' unless defined(&RT2860_LED_LINK_5GHZ);
eval 'sub RT3070_RF_BLOCK () {(1<< 0);}' unless defined(&RT3070_RF_BLOCK);
eval 'sub RT3070_PLL_PD () {(1<< 1);}' unless defined(&RT3070_PLL_PD);
eval 'sub RT3070_RX0_PD () {(1<< 2);}' unless defined(&RT3070_RX0_PD);
eval 'sub RT3070_TX0_PD () {(1<< 3);}' unless defined(&RT3070_TX0_PD);
eval 'sub RT3070_RX1_PD () {(1<< 4);}' unless defined(&RT3070_RX1_PD);
eval 'sub RT3070_TX1_PD () {(1<< 5);}' unless defined(&RT3070_TX1_PD);
eval 'sub RT3070_RX2_PD () {(1<< 6);}' unless defined(&RT3070_RX2_PD);
eval 'sub RT3070_TX2_PD () {(1<< 7);}' unless defined(&RT3070_TX2_PD);
eval 'sub RT3070_TUNE () {(1<< 0);}' unless defined(&RT3070_TUNE);
eval 'sub RT3070_TX_LO2 () {(1<< 3);}' unless defined(&RT3070_TX_LO2);
eval 'sub RT3070_TX_LO1 () {(1<< 3);}' unless defined(&RT3070_TX_LO1);
eval 'sub RT3070_RX_LO1 () {(1<< 3);}' unless defined(&RT3070_RX_LO1);
eval 'sub RT3070_RX_LO2 () {(1<< 3);}' unless defined(&RT3070_RX_LO2);
eval 'sub RT3070_RX_CTB () {(1<< 7);}' unless defined(&RT3070_RX_CTB);
eval 'sub RT3070_BB_LOOPBACK () {(1<< 0);}' unless defined(&RT3070_BB_LOOPBACK);
eval 'sub RT3593_VCO () {(1<< 0);}' unless defined(&RT3593_VCO);
eval 'sub RT3593_RESCAL () {(1<< 7);}' unless defined(&RT3593_RESCAL);
eval 'sub RT3593_VCOCAL () {(1<< 7);}' unless defined(&RT3593_VCOCAL);
eval 'sub RT3593_VCO_IC () {(1<< 6);}' unless defined(&RT3593_VCO_IC);
eval 'sub RT3593_AUTOTUNE_BYPASS () {(1<< 6);}' unless defined(&RT3593_AUTOTUNE_BYPASS);
eval 'sub RT3593_LDO_PLL_VC_MASK () {0xe;}' unless defined(&RT3593_LDO_PLL_VC_MASK);
eval 'sub RT3593_LDO_RF_VC_MASK () {0xe0;}' unless defined(&RT3593_LDO_RF_VC_MASK);
eval 'sub RT3593_CP_IC_MASK () {0xe0;}' unless defined(&RT3593_CP_IC_MASK);
eval 'sub RT3593_CP_IC_SHIFT () {5;}' unless defined(&RT3593_CP_IC_SHIFT);
eval 'sub RT5390_RX_LO1 () {(1<< 5);}' unless defined(&RT5390_RX_LO1);
eval 'sub RT5390_RX_LO2 () {(1<< 7);}' unless defined(&RT5390_RX_LO2);
eval 'sub RT3593_RX_CTB () {(1<< 5);}' unless defined(&RT3593_RX_CTB);
eval 'sub RT3593_TX_LO2 () {(1<< 4);}' unless defined(&RT3593_TX_LO2);
eval 'sub RT3593_TX_LO1 () {(1<< 4);}' unless defined(&RT3593_TX_LO1);
eval 'sub RT5390_MAC_IF_CTRL () {(1<< 6);}' unless defined(&RT5390_MAC_IF_CTRL);
eval 'sub RT5390_MLD () {(1<< 2);}' unless defined(&RT5390_MLD);
eval 'sub RT5390_EN_SIG_MODULATION () {(1<< 3);}' unless defined(&RT5390_EN_SIG_MODULATION);
eval 'sub RT3090_DEF_LNA () {10;}' unless defined(&RT3090_DEF_LNA);
eval 'sub RT2860_TX_BURST () {(1<< 15);}' unless defined(&RT2860_TX_BURST);
eval 'sub RT2860_TX_LS1 () {(1<< 14);}' unless defined(&RT2860_TX_LS1);
eval 'sub RT2860_TX_DDONE () {(1<< 15);}' unless defined(&RT2860_TX_DDONE);
eval 'sub RT2860_TX_LS0 () {(1<< 14);}' unless defined(&RT2860_TX_LS0);
eval 'sub RT2860_TX_QSEL_SHIFT () {1;}' unless defined(&RT2860_TX_QSEL_SHIFT);
eval 'sub RT2860_TX_QSEL_MGMT () {(0<< 1);}' unless defined(&RT2860_TX_QSEL_MGMT);
eval 'sub RT2860_TX_QSEL_HCCA () {(1<< 1);}' unless defined(&RT2860_TX_QSEL_HCCA);
eval 'sub RT2860_TX_QSEL_EDCA () {(2<< 1);}' unless defined(&RT2860_TX_QSEL_EDCA);
eval 'sub RT2860_TX_WIV () {(1<< 0);}' unless defined(&RT2860_TX_WIV);
eval 'sub RT2860_TX_MPDU_DSITY_SHIFT () {5;}' unless defined(&RT2860_TX_MPDU_DSITY_SHIFT);
eval 'sub RT2860_TX_AMPDU () {(1<< 4);}' unless defined(&RT2860_TX_AMPDU);
eval 'sub RT2860_TX_TS () {(1<< 3);}' unless defined(&RT2860_TX_TS);
eval 'sub RT2860_TX_CFACK () {(1<< 2);}' unless defined(&RT2860_TX_CFACK);
eval 'sub RT2860_TX_MMPS () {(1<< 1);}' unless defined(&RT2860_TX_MMPS);
eval 'sub RT2860_TX_FRAG () {(1<< 0);}' unless defined(&RT2860_TX_FRAG);
eval 'sub RT2860_TX_TXOP_HT () {0;}' unless defined(&RT2860_TX_TXOP_HT);
eval 'sub RT2860_TX_TXOP_PIFS () {1;}' unless defined(&RT2860_TX_TXOP_PIFS);
eval 'sub RT2860_TX_TXOP_SIFS () {2;}' unless defined(&RT2860_TX_TXOP_SIFS);
eval 'sub RT2860_TX_TXOP_BACKOFF () {3;}' unless defined(&RT2860_TX_TXOP_BACKOFF);
eval 'sub RT2860_PHY_MODE () {0xc000;}' unless defined(&RT2860_PHY_MODE);
eval 'sub RT2860_PHY_CCK () {(0<< 14);}' unless defined(&RT2860_PHY_CCK);
eval 'sub RT2860_PHY_OFDM () {(1<< 14);}' unless defined(&RT2860_PHY_OFDM);
eval 'sub RT2860_PHY_HT () {(2<< 14);}' unless defined(&RT2860_PHY_HT);
eval 'sub RT2860_PHY_HT_GF () {(3<< 14);}' unless defined(&RT2860_PHY_HT_GF);
eval 'sub RT2860_PHY_SGI () {(1<< 8);}' unless defined(&RT2860_PHY_SGI);
eval 'sub RT2860_PHY_BW40 () {(1<< 7);}' unless defined(&RT2860_PHY_BW40);
eval 'sub RT2860_PHY_MCS () {0x7f;}' unless defined(&RT2860_PHY_MCS);
eval 'sub RT2860_PHY_SHPRE () {(1<< 3);}' unless defined(&RT2860_PHY_SHPRE);
eval 'sub RT2860_TX_BAWINSIZE_SHIFT () {2;}' unless defined(&RT2860_TX_BAWINSIZE_SHIFT);
eval 'sub RT2860_TX_NSEQ () {(1<< 1);}' unless defined(&RT2860_TX_NSEQ);
eval 'sub RT2860_TX_ACK () {(1<< 0);}' unless defined(&RT2860_TX_ACK);
eval 'sub RT2860_TX_PID_SHIFT () {12;}' unless defined(&RT2860_TX_PID_SHIFT);
eval 'sub RT2860_RX_DDONE () {(1<< 15);}' unless defined(&RT2860_RX_DDONE);
eval 'sub RT2860_RX_LS0 () {(1<< 14);}' unless defined(&RT2860_RX_LS0);
eval 'sub RT2860_RX_DEC () {(1<< 16);}' unless defined(&RT2860_RX_DEC);
eval 'sub RT2860_RX_AMPDU () {(1<< 15);}' unless defined(&RT2860_RX_AMPDU);
eval 'sub RT2860_RX_L2PAD () {(1<< 14);}' unless defined(&RT2860_RX_L2PAD);
eval 'sub RT2860_RX_RSSI () {(1<< 13);}' unless defined(&RT2860_RX_RSSI);
eval 'sub RT2860_RX_HTC () {(1<< 12);}' unless defined(&RT2860_RX_HTC);
eval 'sub RT2860_RX_AMSDU () {(1<< 11);}' unless defined(&RT2860_RX_AMSDU);
eval 'sub RT2860_RX_MICERR () {(1<< 10);}' unless defined(&RT2860_RX_MICERR);
eval 'sub RT2860_RX_ICVERR () {(1<< 9);}' unless defined(&RT2860_RX_ICVERR);
eval 'sub RT2860_RX_CRCERR () {(1<< 8);}' unless defined(&RT2860_RX_CRCERR);
eval 'sub RT2860_RX_MYBSS () {(1<< 7);}' unless defined(&RT2860_RX_MYBSS);
eval 'sub RT2860_RX_BC () {(1<< 6);}' unless defined(&RT2860_RX_BC);
eval 'sub RT2860_RX_MC () {(1<< 5);}' unless defined(&RT2860_RX_MC);
eval 'sub RT2860_RX_UC2ME () {(1<< 4);}' unless defined(&RT2860_RX_UC2ME);
eval 'sub RT2860_RX_FRAG () {(1<< 3);}' unless defined(&RT2860_RX_FRAG);
eval 'sub RT2860_RX_NULL () {(1<< 2);}' unless defined(&RT2860_RX_NULL);
eval 'sub RT2860_RX_DATA () {(1<< 1);}' unless defined(&RT2860_RX_DATA);
eval 'sub RT2860_RX_BA () {(1<< 0);}' unless defined(&RT2860_RX_BA);
eval 'sub RT2860_RX_UDF_SHIFT () {5;}' unless defined(&RT2860_RX_UDF_SHIFT);
eval 'sub RT2860_RX_BSS_IDX_SHIFT () {2;}' unless defined(&RT2860_RX_BSS_IDX_SHIFT);
eval 'sub RT2860_RX_TID_SHIFT () {12;}' unless defined(&RT2860_RX_TID_SHIFT);
eval 'sub RT2860_TXWI_DMASZ () {($sizeof{\'struct rt2860_txwi\'} + $sizeof{\'struct ieee80211_htframe\'} + $sizeof{ &uint16_t});}' unless defined(&RT2860_TXWI_DMASZ);
eval 'sub RT2860_RF1 () {0;}' unless defined(&RT2860_RF1);
eval 'sub RT2860_RF2 () {2;}' unless defined(&RT2860_RF2);
eval 'sub RT2860_RF3 () {1;}' unless defined(&RT2860_RF3);
eval 'sub RT2860_RF4 () {3;}' unless defined(&RT2860_RF4);
eval 'sub RT2860_RF_2820 () {1;}' unless defined(&RT2860_RF_2820);
eval 'sub RT2860_RF_2850 () {2;}' unless defined(&RT2860_RF_2850);
eval 'sub RT2860_RF_2720 () {3;}' unless defined(&RT2860_RF_2720);
eval 'sub RT2860_RF_2750 () {4;}' unless defined(&RT2860_RF_2750);
eval 'sub RT3070_RF_3020 () {5;}' unless defined(&RT3070_RF_3020);
eval 'sub RT3070_RF_2020 () {6;}' unless defined(&RT3070_RF_2020);
eval 'sub RT3070_RF_3021 () {7;}' unless defined(&RT3070_RF_3021);
eval 'sub RT3070_RF_3022 () {8;}' unless defined(&RT3070_RF_3022);
eval 'sub RT3070_RF_3052 () {9;}' unless defined(&RT3070_RF_3052);
eval 'sub RT3070_RF_3320 () {11;}' unless defined(&RT3070_RF_3320);
eval 'sub RT3070_RF_3053 () {13;}' unless defined(&RT3070_RF_3053);
eval 'sub RT5592_RF_5592 () {0xf;}' unless defined(&RT5592_RF_5592);
eval 'sub RT5390_RF_5370 () {0x5370;}' unless defined(&RT5390_RF_5370);
eval 'sub RT5390_RF_5372 () {0x5372;}' unless defined(&RT5390_RF_5372);
eval 'sub RT2870_RESET () {1;}' unless defined(&RT2870_RESET);
eval 'sub RT2870_WRITE_2 () {2;}' unless defined(&RT2870_WRITE_2);
eval 'sub RT2870_WRITE_REGION_1 () {6;}' unless defined(&RT2870_WRITE_REGION_1);
eval 'sub RT2870_READ_REGION_1 () {7;}' unless defined(&RT2870_READ_REGION_1);
eval 'sub RT2870_EEPROM_READ () {9;}' unless defined(&RT2870_EEPROM_READ);
eval 'sub RT2860_EEPROM_DELAY () {1;}' unless defined(&RT2860_EEPROM_DELAY);
eval 'sub RT2860_EEPROM_VERSION () {0x1;}' unless defined(&RT2860_EEPROM_VERSION);
eval 'sub RT2860_EEPROM_MAC01 () {0x2;}' unless defined(&RT2860_EEPROM_MAC01);
eval 'sub RT2860_EEPROM_MAC23 () {0x3;}' unless defined(&RT2860_EEPROM_MAC23);
eval 'sub RT2860_EEPROM_MAC45 () {0x4;}' unless defined(&RT2860_EEPROM_MAC45);
eval 'sub RT2860_EEPROM_PCIE_PSLEVEL () {0x11;}' unless defined(&RT2860_EEPROM_PCIE_PSLEVEL);
eval 'sub RT2860_EEPROM_REV () {0x12;}' unless defined(&RT2860_EEPROM_REV);
eval 'sub RT2860_EEPROM_ANTENNA () {0x1a;}' unless defined(&RT2860_EEPROM_ANTENNA);
eval 'sub RT2860_EEPROM_CONFIG () {0x1b;}' unless defined(&RT2860_EEPROM_CONFIG);
eval 'sub RT2860_EEPROM_COUNTRY () {0x1c;}' unless defined(&RT2860_EEPROM_COUNTRY);
eval 'sub RT2860_EEPROM_FREQ_LEDS () {0x1d;}' unless defined(&RT2860_EEPROM_FREQ_LEDS);
eval 'sub RT2860_EEPROM_LED1 () {0x1e;}' unless defined(&RT2860_EEPROM_LED1);
eval 'sub RT2860_EEPROM_LED2 () {0x1f;}' unless defined(&RT2860_EEPROM_LED2);
eval 'sub RT2860_EEPROM_LED3 () {0x20;}' unless defined(&RT2860_EEPROM_LED3);
eval 'sub RT2860_EEPROM_LNA () {0x22;}' unless defined(&RT2860_EEPROM_LNA);
eval 'sub RT2860_EEPROM_RSSI1_2GHZ () {0x23;}' unless defined(&RT2860_EEPROM_RSSI1_2GHZ);
eval 'sub RT2860_EEPROM_RSSI2_2GHZ () {0x24;}' unless defined(&RT2860_EEPROM_RSSI2_2GHZ);
eval 'sub RT2860_EEPROM_RSSI1_5GHZ () {0x25;}' unless defined(&RT2860_EEPROM_RSSI1_5GHZ);
eval 'sub RT2860_EEPROM_RSSI2_5GHZ () {0x26;}' unless defined(&RT2860_EEPROM_RSSI2_5GHZ);
eval 'sub RT2860_EEPROM_DELTAPWR () {0x28;}' unless defined(&RT2860_EEPROM_DELTAPWR);
eval 'sub RT2860_EEPROM_PWR2GHZ_BASE1 () {0x29;}' unless defined(&RT2860_EEPROM_PWR2GHZ_BASE1);
eval 'sub RT2860_EEPROM_PWR2GHZ_BASE2 () {0x30;}' unless defined(&RT2860_EEPROM_PWR2GHZ_BASE2);
eval 'sub RT2860_EEPROM_TSSI1_2GHZ () {0x37;}' unless defined(&RT2860_EEPROM_TSSI1_2GHZ);
eval 'sub RT2860_EEPROM_TSSI2_2GHZ () {0x38;}' unless defined(&RT2860_EEPROM_TSSI2_2GHZ);
eval 'sub RT2860_EEPROM_TSSI3_2GHZ () {0x39;}' unless defined(&RT2860_EEPROM_TSSI3_2GHZ);
eval 'sub RT2860_EEPROM_TSSI4_2GHZ () {0x3a;}' unless defined(&RT2860_EEPROM_TSSI4_2GHZ);
eval 'sub RT2860_EEPROM_TSSI5_2GHZ () {0x3b;}' unless defined(&RT2860_EEPROM_TSSI5_2GHZ);
eval 'sub RT2860_EEPROM_PWR5GHZ_BASE1 () {0x3c;}' unless defined(&RT2860_EEPROM_PWR5GHZ_BASE1);
eval 'sub RT2860_EEPROM_PWR5GHZ_BASE2 () {0x53;}' unless defined(&RT2860_EEPROM_PWR5GHZ_BASE2);
eval 'sub RT2860_EEPROM_TSSI1_5GHZ () {0x6a;}' unless defined(&RT2860_EEPROM_TSSI1_5GHZ);
eval 'sub RT2860_EEPROM_TSSI2_5GHZ () {0x6b;}' unless defined(&RT2860_EEPROM_TSSI2_5GHZ);
eval 'sub RT2860_EEPROM_TSSI3_5GHZ () {0x6c;}' unless defined(&RT2860_EEPROM_TSSI3_5GHZ);
eval 'sub RT2860_EEPROM_TSSI4_5GHZ () {0x6d;}' unless defined(&RT2860_EEPROM_TSSI4_5GHZ);
eval 'sub RT2860_EEPROM_TSSI5_5GHZ () {0x6e;}' unless defined(&RT2860_EEPROM_TSSI5_5GHZ);
eval 'sub RT2860_EEPROM_RPWR () {0x6f;}' unless defined(&RT2860_EEPROM_RPWR);
eval 'sub RT2860_EEPROM_BBP_BASE () {0x78;}' unless defined(&RT2860_EEPROM_BBP_BASE);
eval 'sub RT3071_EEPROM_RF_BASE () {0x82;}' unless defined(&RT3071_EEPROM_RF_BASE);
eval 'sub RT3593_EEPROM_FREQ_LEDS () {0x21;}' unless defined(&RT3593_EEPROM_FREQ_LEDS);
eval 'sub RT3593_EEPROM_FREQ () {0x22;}' unless defined(&RT3593_EEPROM_FREQ);
eval 'sub RT3593_EEPROM_LED1 () {0x22;}' unless defined(&RT3593_EEPROM_LED1);
eval 'sub RT3593_EEPROM_LED2 () {0x23;}' unless defined(&RT3593_EEPROM_LED2);
eval 'sub RT3593_EEPROM_LED3 () {0x24;}' unless defined(&RT3593_EEPROM_LED3);
eval 'sub RT3593_EEPROM_LNA () {0x26;}' unless defined(&RT3593_EEPROM_LNA);
eval 'sub RT3593_EEPROM_LNA_5GHZ () {0x27;}' unless defined(&RT3593_EEPROM_LNA_5GHZ);
eval 'sub RT3593_EEPROM_RSSI1_2GHZ () {0x28;}' unless defined(&RT3593_EEPROM_RSSI1_2GHZ);
eval 'sub RT3593_EEPROM_RSSI2_2GHZ () {0x29;}' unless defined(&RT3593_EEPROM_RSSI2_2GHZ);
eval 'sub RT3593_EEPROM_RSSI1_5GHZ () {0x2a;}' unless defined(&RT3593_EEPROM_RSSI1_5GHZ);
eval 'sub RT3593_EEPROM_RSSI2_5GHZ () {0x2b;}' unless defined(&RT3593_EEPROM_RSSI2_5GHZ);
eval 'sub RT3593_EEPROM_PWR2GHZ_BASE1 () {0x30;}' unless defined(&RT3593_EEPROM_PWR2GHZ_BASE1);
eval 'sub RT3593_EEPROM_PWR2GHZ_BASE2 () {0x37;}' unless defined(&RT3593_EEPROM_PWR2GHZ_BASE2);
eval 'sub RT3593_EEPROM_PWR2GHZ_BASE3 () {0x3e;}' unless defined(&RT3593_EEPROM_PWR2GHZ_BASE3);
eval 'sub RT3593_EEPROM_PWR5GHZ_BASE1 () {0x4b;}' unless defined(&RT3593_EEPROM_PWR5GHZ_BASE1);
eval 'sub RT3593_EEPROM_PWR5GHZ_BASE2 () {0x65;}' unless defined(&RT3593_EEPROM_PWR5GHZ_BASE2);
eval 'sub RT3593_EEPROM_PWR5GHZ_BASE3 () {0x7f;}' unless defined(&RT3593_EEPROM_PWR5GHZ_BASE3);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX0_2GHZ () {0x130;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX0_2GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX0_2GHZ () {0x131;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX0_2GHZ);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX1_2GHZ () {0x133;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX1_2GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX1_2GHZ () {0x134;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX1_2GHZ);
eval 'sub RT5390_EEPROM_RF_IQ_COMPENSATION_CTL () {0x13c;}' unless defined(&RT5390_EEPROM_RF_IQ_COMPENSATION_CTL);
eval 'sub RT5390_EEPROM_RF_IQ_IMBALANCE_COMPENSATION_CTL () {0x13d;}' unless defined(&RT5390_EEPROM_RF_IQ_IMBALANCE_COMPENSATION_CTL);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX0_CH36_TO_CH64_5GHZ () {0x144;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX0_CH36_TO_CH64_5GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX0_CH36_TO_CH64_5GHZ () {0x145;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX0_CH36_TO_CH64_5GHZ);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX0_CH100_TO_CH138_5GHZ () {0x146;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX0_CH100_TO_CH138_5GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX0_CH100_TO_CH138_5GHZ () {0x147;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX0_CH100_TO_CH138_5GHZ);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX0_CH140_TO_CH165_5GHZ () {0x148;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX0_CH140_TO_CH165_5GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX0_CH140_TO_CH165_5GHZ () {0x149;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX0_CH140_TO_CH165_5GHZ);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX1_CH36_TO_CH64_5GHZ () {0x14a;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX1_CH36_TO_CH64_5GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX1_CH36_TO_CH64_5GHZ () {0x14b;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX1_CH36_TO_CH64_5GHZ);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX1_CH100_TO_CH138_5GHZ () {0x14c;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX1_CH100_TO_CH138_5GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX1_CH100_TO_CH138_5GHZ () {0x14d;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX1_CH100_TO_CH138_5GHZ);
eval 'sub RT5390_EEPROM_IQ_GAIN_CAL_TX1_CH140_TO_CH165_5GHZ () {0x14e;}' unless defined(&RT5390_EEPROM_IQ_GAIN_CAL_TX1_CH140_TO_CH165_5GHZ);
eval 'sub RT5390_EEPROM_IQ_PHASE_CAL_TX1_CH140_TO_CH165_5GHZ () {0x14f;}' unless defined(&RT5390_EEPROM_IQ_PHASE_CAL_TX1_CH140_TO_CH165_5GHZ);
eval 'sub RT2860_RIDX_CCK1 () {0;}' unless defined(&RT2860_RIDX_CCK1);
eval 'sub RT2860_RIDX_CCK11 () {3;}' unless defined(&RT2860_RIDX_CCK11);
eval 'sub RT2860_RIDX_OFDM6 () {4;}' unless defined(&RT2860_RIDX_OFDM6);
eval 'sub RT2860_RIDX_MAX () {11;}' unless defined(&RT2860_RIDX_MAX);
unless(defined(&RAL_READ)) {
    sub RAL_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&RAL_WRITE)) {
    sub RAL_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RAL_BARRIER_WRITE)) {
    sub RAL_BARRIER_WRITE {
	my($sc) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, 0, 0x1800,  &BUS_SPACE_BARRIER_WRITE));
    }
}
unless(defined(&RAL_BARRIER_READ_WRITE)) {
    sub RAL_BARRIER_READ_WRITE {
	my($sc) = @_;
	eval q( &bus_space_barrier(($sc)-> &sc_st, ($sc)-> &sc_sh, 0, 0x1800,  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE));
    }
}
unless(defined(&RAL_WRITE_REGION_1)) {
    sub RAL_WRITE_REGION_1 {
	my($sc, $offset, $datap, $count) = @_;
	eval q( &bus_space_write_region_1(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($datap), ($count)));
    }
}
unless(defined(&RAL_SET_REGION_4)) {
    sub RAL_SET_REGION_4 {
	my($sc, $offset, $val, $count) = @_;
	eval q( &bus_space_set_region_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($offset), ($val), ($count)));
    }
}
unless(defined(&RT2860_EEPROM_CTL)) {
    sub RT2860_EEPROM_CTL {
	my($sc, $val) = @_;
	eval q( &do {  &RAL_WRITE(($sc),  &RT2860_PCI_EECTRL, ($val));  &RAL_BARRIER_READ_WRITE(($sc));  &DELAY( &RT2860_EEPROM_DELAY); }  &while ( 0));
    }
}
eval 'sub RT2860_DEF_MAC () {{  &RT2860_BCN_OFFSET0, 0xf8f0e8e0 }, {  &RT2860_LEGACY_BASIC_RATE, 0x13f }, {  &RT2860_HT_BASIC_RATE, 0x8003 }, {  &RT2860_MAC_SYS_CTRL, 0x }, {  &RT2860_BKOFF_SLOT_CFG, 0x209 }, {  &RT2860_TX_SW_CFG0, 0x }, {  &RT2860_TX_SW_CFG1, 0x80606 }, {  &RT2860_TX_LINK_CFG, 0x1020 }, {  &RT2860_TX_TIMEOUT_CFG, 0xa2090 }, {  &RT2860_LED_CFG, 0x7f031e46 }, {  &RT2860_WMM_AIFSN_CFG, 0x2273 }, {  &RT2860_WMM_CWMIN_CFG, 0x2344 }, {  &RT2860_WMM_CWMAX_CFG, 0x34aa }, {  &RT2860_MAX_PCNT, 0x1f3fbf9f }, {  &RT2860_TX_RTY_CFG, 0x47d01f0f }, {  &RT2860_AUTO_RSP_CFG, 0x13 }, {  &RT2860_CCK_PROT_CFG, 0x5740003 }, {  &RT2860_OFDM_PROT_CFG, 0x5740003 }, {  &RT2860_GF20_PROT_CFG, 0x1744004 }, {  &RT2860_GF40_PROT_CFG, 0x3f44084 }, {  &RT2860_MM20_PROT_CFG, 0x1744004 }, {  &RT2860_MM40_PROT_CFG, 0x3f54084 }, {  &RT2860_TXOP_CTRL_CFG, 0x583f }, {  &RT2860_TXOP_HLDR_ET, 0x2 }, {  &RT2860_TX_RTS_CFG, 0x92b20 }, {  &RT2860_EXP_ACK_TIME, 0x2400ca }, {  &RT2860_XIFS_TIME_CFG, 0x33a41010 }, {  &RT2860_PWR_PIN_CFG, 0x3 };}' unless defined(&RT2860_DEF_MAC);
eval 'sub RT2870_DEF_MAC () {{  &RT2860_BCN_OFFSET0, 0xf8f0e8e0 }, {  &RT2860_LEGACY_BASIC_RATE, 0x13f }, {  &RT2860_HT_BASIC_RATE, 0x8003 }, {  &RT2860_MAC_SYS_CTRL, 0x }, {  &RT2860_BKOFF_SLOT_CFG, 0x209 }, {  &RT2860_TX_SW_CFG0, 0x }, {  &RT2860_TX_SW_CFG1, 0x80606 }, {  &RT2860_TX_LINK_CFG, 0x1020 }, {  &RT2860_TX_TIMEOUT_CFG, 0xa2090 }, {  &RT2860_LED_CFG, 0x7f031e46 }, {  &RT2860_WMM_AIFSN_CFG, 0x2273 }, {  &RT2860_WMM_CWMIN_CFG, 0x2344 }, {  &RT2860_WMM_CWMAX_CFG, 0x34aa }, {  &RT2860_MAX_PCNT, 0x1f3fbf9f }, {  &RT2860_TX_RTY_CFG, 0x47d01f0f }, {  &RT2860_AUTO_RSP_CFG, 0x13 }, {  &RT2860_CCK_PROT_CFG, 0x5740003 }, {  &RT2860_OFDM_PROT_CFG, 0x5740003 }, {  &RT2860_PBF_CFG, 0xf40006 }, {  &RT2860_WPDMA_GLO_CFG, 0x30 }, {  &RT2860_GF20_PROT_CFG, 0x1744004 }, {  &RT2860_GF40_PROT_CFG, 0x3f44084 }, {  &RT2860_MM20_PROT_CFG, 0x1744004 }, {  &RT2860_MM40_PROT_CFG, 0x3f44084 }, {  &RT2860_TXOP_CTRL_CFG, 0x583f }, {  &RT2860_TXOP_HLDR_ET, 0x2 }, {  &RT2860_TX_RTS_CFG, 0x92b20 }, {  &RT2860_EXP_ACK_TIME, 0x2400ca }, {  &RT2860_XIFS_TIME_CFG, 0x33a41010 }, {  &RT2860_PWR_PIN_CFG, 0x3 };}' unless defined(&RT2870_DEF_MAC);
eval 'sub RT2860_DEF_BBP () {{ 65, 0x2c }, { 66, 0x38 }, { 69, 0x12 }, { 70, 0xa }, { 73, 0x10 }, { 81, 0x37 }, { 82, 0x62 }, { 83, 0x6a }, { 84, 0x99 }, { 86, 0x }, { 91, 0x4 }, { 92, 0x }, { 103, 0x }, { 105, 0x5 }, { 106, 0x35 };}' unless defined(&RT2860_DEF_BBP);
eval 'sub RT5390_DEF_BBP () {{ 31, 0x8 }, { 65, 0x2c }, { 66, 0x38 }, { 68, 0xb }, { 69, 0xd }, { 70, 0x6 }, { 73, 0x13 }, { 75, 0x46 }, { 76, 0x28 }, { 77, 0x59 }, { 81, 0x37 }, { 82, 0x62 }, { 83, 0x7a }, { 84, 0x9a }, { 86, 0x38 }, { 91, 0x4 }, { 92, 0x2 }, { 103, 0xc0 }, { 104, 0x92 }, { 105, 0x3c }, { 106, 0x3 }, { 128, 0x12 };}' unless defined(&RT5390_DEF_BBP);
eval 'sub RT5592_DEF_BBP () {{ 20, 0x6 }, { 31, 0x8 }, { 65, 0x2c }, { 66, 0x38 }, { 68, 0xdd }, { 69, 0x1a }, { 70, 0x5 }, { 73, 0x13 }, { 74, 0xf }, { 75, 0x4f }, { 76, 0x28 }, { 77, 0x59 }, { 81, 0x37 }, { 82, 0x62 }, { 83, 0x6a }, { 84, 0x9a }, { 86, 0x38 }, { 88, 0x90 }, { 91, 0x4 }, { 92, 0x2 }, { 95, 0x9a }, { 98, 0x12 }, { 103, 0xc0 }, { 104, 0x92 }, { 105, 0x3c }, { 106, 0x35 }, { 128, 0x12 }, { 134, 0xd0 }, { 135, 0xf6 }, { 137, 0xf };}' unless defined(&RT5592_DEF_BBP);
eval 'sub RT2860_RF2850 () {{ 1, 0x100bb3, 0x1301e1, 0x5a014, 0x1402 }, { 2, 0x100bb3, 0x1301e1, 0x5a014, 0x1407 }, { 3, 0x100bb3, 0x1301e2, 0x5a014, 0x1402 }, { 4, 0x100bb3, 0x1301e2, 0x5a014, 0x1407 }, { 5, 0x100bb3, 0x1301e3, 0x5a014, 0x1402 }, { 6, 0x100bb3, 0x1301e3, 0x5a014, 0x1407 }, { 7, 0x100bb3, 0x1301e4, 0x5a014, 0x1402 }, { 8, 0x100bb3, 0x1301e4, 0x5a014, 0x1407 }, { 9, 0x100bb3, 0x1301e5, 0x5a014, 0x1402 }, { 10, 0x100bb3, 0x1301e5, 0x5a014, 0x1407 }, { 11, 0x100bb3, 0x1301e6, 0x5a014, 0x1402 }, { 12, 0x100bb3, 0x1301e6, 0x5a014, 0x1407 }, { 13, 0x100bb3, 0x1301e7, 0x5a014, 0x1402 }, { 14, 0x100bb3, 0x1301e8, 0x5a014, 0x1404 }, { 36, 0x100bb3, 0x130266, 0x56014, 0x1408 }, { 38, 0x100bb3, 0x130267, 0x56014, 0x1404 }, { 40, 0x100bb2, 0x1301a0, 0x56014, 0x1400 }, { 44, 0x100bb2, 0x1301a0, 0x56014, 0x1408 }, { 46, 0x100bb2, 0x1301a1, 0x56014, 0x1402 }, { 48, 0x100bb2, 0x1301a1, 0x56014, 0x1406 }, { 52, 0x100bb2, 0x1301a2, 0x56014, 0x1404 }, { 54, 0x100bb2, 0x1301a2, 0x56014, 0x1408 }, { 56, 0x100bb2, 0x1301a3, 0x56014, 0x1402 }, { 60, 0x100bb2, 0x1301a4, 0x56014, 0x1400 }, { 62, 0x100bb2, 0x1301a4, 0x56014, 0x1404 }, { 64, 0x100bb2, 0x1301a4, 0x56014, 0x1408 }, { 100, 0x100bb2, 0x1301ac, 0x5e014, 0x1400 }, { 102, 0x100bb2, 0x1701ac, 0x15e014, 0x1404 }, { 104, 0x100bb2, 0x1701ac, 0x15e014, 0x1408 }, { 108, 0x100bb3, 0x17028c, 0x15e014, 0x1404 }, { 110, 0x100bb3, 0x13028d, 0x5e014, 0x1400 }, { 112, 0x100bb3, 0x13028d, 0x5e014, 0x1406 }, { 116, 0x100bb3, 0x13028e, 0x5e014, 0x1408 }, { 118, 0x100bb3, 0x13028f, 0x5e014, 0x1404 }, { 120, 0x100bb1, 0x1300e0, 0x5e014, 0x1400 }, { 124, 0x100bb1, 0x1300e0, 0x5e014, 0x1404 }, { 126, 0x100bb1, 0x1300e0, 0x5e014, 0x1406 }, { 128, 0x100bb1, 0x1300e0, 0x5e014, 0x1408 }, { 132, 0x100bb1, 0x1300e1, 0x5e014, 0x1402 }, { 134, 0x100bb1, 0x1300e1, 0x5e014, 0x1404 }, { 136, 0x100bb1, 0x1300e1, 0x5e014, 0x1406 }, { 140, 0x100bb1, 0x1300e2, 0x5e014, 0x1400 }, { 149, 0x100bb1, 0x1300e2, 0x5e014, 0x1409 }, { 151, 0x100bb1, 0x1300e3, 0x5e014, 0x1401 }, { 153, 0x100bb1, 0x1300e3, 0x5e014, 0x1403 }, { 157, 0x100bb1, 0x1300e3, 0x5e014, 0x1407 }, { 159, 0x100bb1, 0x1300e3, 0x5e014, 0x1409 }, { 161, 0x100bb1, 0x1300e4, 0x5e014, 0x1401 }, { 165, 0x100bb1, 0x1300e4, 0x5e014, 0x1405 }, { 167, 0x100bb1, 0x1300f4, 0x5e014, 0x1407 }, { 169, 0x100bb1, 0x1300f4, 0x5e014, 0x1409 }, { 171, 0x100bb1, 0x1300f5, 0x5e014, 0x1401 }, { 173, 0x100bb1, 0x1300f5, 0x5e014, 0x1403 };}' unless defined(&RT2860_RF2850);
eval 'sub RT3070_RF3052 () {{ 0xf1, 2, 2}, { 0xf1, 2, 7}, { 0xf2, 2, 2}, { 0xf2, 2, 7}, { 0xf3, 2, 2}, { 0xf3, 2, 7}, { 0xf4, 2, 2}, { 0xf4, 2, 7}, { 0xf5, 2, 2}, { 0xf5, 2, 7}, { 0xf6, 2, 2}, { 0xf6, 2, 7}, { 0xf7, 2, 2}, { 0xf8, 2, 4}, { 0x56, 0, 4}, { 0x56, 0, 6}, { 0x56, 0, 8}, { 0x57, 0, 0}, { 0x57, 0, 2}, { 0x57, 0, 4}, { 0x57, 0, 8}, { 0x57, 0, 10}, { 0x58, 0, 0}, { 0x58, 0, 4}, { 0x58, 0, 6}, { 0x58, 0, 8}, { 0x5b, 0, 8}, { 0x5b, 0, 10}, { 0x5c, 0, 0}, { 0x5c, 0, 4}, { 0x5c, 0, 6}, { 0x5c, 0, 8}, { 0x5d, 0, 0}, { 0x5d, 0, 2}, { 0x5d, 0, 4}, { 0x5d, 0, 8}, { 0x5d, 0, 10}, { 0x5e, 0, 0}, { 0x5e, 0, 4}, { 0x5e, 0, 6}, { 0x5e, 0, 8}, { 0x5f, 0, 0}, { 0x5f, 0, 9}, { 0x5f, 0, 11}, { 0x60, 0, 1}, { 0x60, 0, 5}, { 0x60, 0, 7}, { 0x60, 0, 9}, { 0x61, 0, 1}, { 0x61, 0, 3}, { 0x61, 0, 5}, { 0x61, 0, 7}, { 0x61, 0, 9};}' unless defined(&RT3070_RF3052);
eval 'sub RT5592_RF5592_20MHZ () {{ 0x1e2, 4, 10, 3}, { 0x1e3, 4, 10, 3}, { 0x1e4, 4, 10, 3}, { 0x1e5, 4, 10, 3}, { 0x1e6, 4, 10, 3}, { 0x1e7, 4, 10, 3}, { 0x1e8, 4, 10, 3}, { 0x1e9, 4, 10, 3}, { 0x1ea, 4, 10, 3}, { 0x1eb, 4, 10, 3}, { 0x1ec, 4, 10, 3}, { 0x1ed, 4, 10, 3}, { 0x1ee, 4, 10, 3}, { 0x1f0, 8, 10, 3}, { 0xac, 8, 12, 1}, { 0xad, 0, 12, 1}, { 0xad, 4, 12, 1}, { 0xae, 0, 12, 1}, { 0xae, 4, 12, 1}, { 0xae, 8, 12, 1}, { 0xaf, 4, 12, 1}, { 0xaf, 8, 12, 1}, { 0xb0, 0, 12, 1}, { 0xb0, 8, 12, 1}, { 0xb1, 0, 12, 1}, { 0xb1, 4, 12, 1}, { 0xb7, 4, 12, 1}, { 0xb7, 8, 12, 1}, { 0xb8, 0, 12, 1}, { 0xb8, 8, 12, 1}, { 0xb9, 0, 12, 1}, { 0xb9, 4, 12, 1}, { 0xba, 0, 12, 1}, { 0xba, 4, 12, 1}, { 0xba, 8, 12, 1}, { 0xbb, 4, 12, 1}, { 0xbb, 8, 12, 1}, { 0xbc, 0, 12, 1}, { 0xbc, 8, 12, 1}, { 0xbd, 0, 12, 1}, { 0xbd, 4, 12, 1}, { 0xbe, 0, 12, 1}, { 0xbf, 6, 12, 1}, { 0xbf, 10, 12, 1}, { 0xc0, 2, 12, 1}, { 0xc0, 10, 12, 1}, { 0xc1, 2, 12, 1}, { 0xc1, 6, 12, 1}, { 0xc2, 2, 12, 1}, { 0xa4, 0, 12, 1}, { 0xa4, 4, 12, 1}, { 0xa5, 8, 12, 1}, { 0xa6, 0, 12, 1};}' unless defined(&RT5592_RF5592_20MHZ);
eval 'sub RT5592_RF5592_40MHZ () {{ 0xf1, 2, 10, 3}, { 0xf1, 7, 10, 3}, { 0xf2, 2, 10, 3}, { 0xf2, 7, 10, 3}, { 0xf3, 2, 10, 3}, { 0xf3, 7, 10, 3}, { 0xf4, 2, 10, 3}, { 0xf4, 7, 10, 3}, { 0xf5, 2, 10, 3}, { 0xf5, 7, 10, 3}, { 0xf6, 2, 10, 3}, { 0xf6, 7, 10, 3}, { 0xf7, 2, 10, 3}, { 0xf8, 4, 10, 3}, { 0x56, 4, 12, 1}, { 0x56, 6, 12, 1}, { 0x56, 8, 12, 1}, { 0x57, 0, 12, 1}, { 0x57, 2, 12, 1}, { 0x57, 4, 12, 1}, { 0x57, 8, 12, 1}, { 0x57, 10, 12, 1}, { 0x58, 0, 12, 1}, { 0x58, 4, 12, 1}, { 0x58, 6, 12, 1}, { 0x58, 8, 12, 1}, { 0x5b, 8, 12, 1}, { 0x5b, 10, 12, 1}, { 0x5c, 0, 12, 1}, { 0x5c, 4, 12, 1}, { 0x5c, 6, 12, 1}, { 0x5c, 8, 12, 1}, { 0x5d, 0, 12, 1}, { 0x5d, 2, 12, 1}, { 0x5d, 4, 12, 1}, { 0x5d, 8, 12, 1}, { 0x5d, 10, 12, 1}, { 0x5e, 0, 12, 1}, { 0x5e, 4, 12, 1}, { 0x5e, 6, 12, 1}, { 0x5e, 8, 12, 1}, { 0x5f, 0, 12, 1}, { 0x5f, 9, 12, 1}, { 0x5f, 11, 12, 1}, { 0x60, 1, 12, 1}, { 0x60, 5, 12, 1}, { 0x60, 7, 12, 1}, { 0x60, 9, 12, 1}, { 0x61, 1, 12, 1}, { 0x52, 0, 12, 1}, { 0x52, 4, 12, 1}, { 0x52, 8, 12, 1}, { 0x53, 0, 12, 1};}' unless defined(&RT5592_RF5592_40MHZ);
eval 'sub RT3070_DEF_RF () {{ 4, 0x40 }, { 5, 0x3 }, { 6, 0x2 }, { 7, 0x70 }, { 9, 0xf }, { 10, 0x41 }, { 11, 0x21 }, { 12, 0x7b }, { 14, 0x90 }, { 15, 0x58 }, { 16, 0xb3 }, { 17, 0x92 }, { 18, 0x2c }, { 19, 0x2 }, { 20, 0xba }, { 21, 0xdb }, { 24, 0x16 }, { 25, 0x1 }, { 29, 0x1f };}' unless defined(&RT3070_DEF_RF);
eval 'sub RT3572_DEF_RF () {{ 0, 0x70 }, { 1, 0x81 }, { 2, 0xf1 }, { 3, 0x2 }, { 4, 0x4c }, { 5, 0x5 }, { 6, 0x4a }, { 7, 0xd8 }, { 9, 0xc3 }, { 10, 0xf1 }, { 11, 0xb9 }, { 12, 0x70 }, { 13, 0x65 }, { 14, 0xa0 }, { 15, 0x53 }, { 16, 0x4c }, { 17, 0x23 }, { 18, 0xac }, { 19, 0x93 }, { 20, 0xb3 }, { 21, 0xd0 }, { 22, 0x }, { 23, 0x3c }, { 24, 0x16 }, { 25, 0x15 }, { 26, 0x85 }, { 27, 0x }, { 28, 0x }, { 29, 0x9b }, { 30, 0x9 }, { 31, 0x10 };}' unless defined(&RT3572_DEF_RF);
eval 'sub RT3593_DEF_RF () {{ 1, 0x3 }, { 3, 0x80 }, { 5, 0x }, { 6, 0x40 }, { 8, 0xf1 }, { 9, 0x2 }, { 10, 0xd3 }, { 11, 0x40 }, { 12, 0x4e }, { 13, 0x12 }, { 18, 0x40 }, { 22, 0x20 }, { 30, 0x10 }, { 31, 0x80 }, { 32, 0x78 }, { 33, 0x3b }, { 34, 0x3c }, { 35, 0xe0 }, { 38, 0x86 }, { 39, 0x23 }, { 44, 0xd3 }, { 45, 0xbb }, { 46, 0x60 }, { 49, 0x81 }, { 50, 0x86 }, { 51, 0x75 }, { 52, 0x45 }, { 53, 0x18 }, { 54, 0x18 }, { 55, 0x18 }, { 56, 0xdb }, { 57, 0x6e };}' unless defined(&RT3593_DEF_RF);
eval 'sub RT5390_DEF_RF () {{ 1, 0xf }, { 2, 0x80 }, { 3, 0x88 }, { 5, 0x10 }, { 6, 0xa0 }, { 7, 0x }, { 10, 0x53 }, { 11, 0x4a }, { 12, 0x46 }, { 13, 0x9f }, { 14, 0x }, { 15, 0x }, { 16, 0x }, { 18, 0x3 }, { 19, 0x }, { 20, 0x }, { 21, 0x }, { 22, 0x20 }, { 23, 0x }, { 24, 0x }, { 25, 0xc0 }, { 26, 0x }, { 27, 0x9 }, { 28, 0x }, { 29, 0x10 }, { 30, 0x10 }, { 31, 0x80 }, { 32, 0x80 }, { 33, 0x }, { 34, 0x7 }, { 35, 0x12 }, { 36, 0x }, { 37, 0x8 }, { 38, 0x85 }, { 39, 0x1b }, { 40, 0xb }, { 41, 0xbb }, { 42, 0xd2 }, { 43, 0x9a }, { 44, 0xe }, { 45, 0xa2 }, { 46, 0x7b }, { 47, 0x }, { 48, 0x10 }, { 49, 0x94 }, { 52, 0x38 }, { 53, 0x84 }, { 54, 0x78 }, { 55, 0x44 }, { 56, 0x22 }, { 57, 0x80 }, { 58, 0x7f }, { 59, 0x8f }, { 60, 0x45 }, { 61, 0xdd }, { 62, 0x }, { 63, 0x };}' unless defined(&RT5390_DEF_RF);
eval 'sub RT5392_DEF_RF () {{ 1, 0x17 }, { 3, 0x88 }, { 5, 0x10 }, { 6, 0xe0 }, { 7, 0x }, { 10, 0x53 }, { 11, 0x4a }, { 12, 0x46 }, { 13, 0x9f }, { 14, 0x }, { 15, 0x }, { 16, 0x }, { 18, 0x3 }, { 19, 0x4d }, { 20, 0x }, { 21, 0x8d }, { 22, 0x20 }, { 23, 0xb }, { 24, 0x44 }, { 25, 0x80 }, { 26, 0x82 }, { 27, 0x9 }, { 28, 0x }, { 29, 0x10 }, { 30, 0x10 }, { 31, 0x80 }, { 32, 0x20 }, { 33, 0xc0 }, { 34, 0x7 }, { 35, 0x12 }, { 36, 0x }, { 37, 0x8 }, { 38, 0x89 }, { 39, 0x1b }, { 40, 0xf }, { 41, 0xbb }, { 42, 0xd5 }, { 43, 0x9b }, { 44, 0xe }, { 45, 0xa2 }, { 46, 0x73 }, { 47, 0xc }, { 48, 0x10 }, { 49, 0x94 }, { 50, 0x94 }, { 51, 0x3a }, { 52, 0x48 }, { 53, 0x44 }, { 54, 0x38 }, { 55, 0x43 }, { 56, 0xa1 }, { 57, 0x }, { 58, 0x39 }, { 59, 0x7 }, { 60, 0x45 }, { 61, 0x91 }, { 62, 0x39 }, { 63, 0x7 };}' unless defined(&RT5392_DEF_RF);
eval 'sub RT5592_DEF_RF () {{ 1, 0x3f }, { 3, 0x8 }, { 5, 0x10 }, { 6, 0xe4 }, { 7, 0x }, { 14, 0x }, { 15, 0x }, { 16, 0x }, { 18, 0x3 }, { 19, 0x4d }, { 20, 0x10 }, { 21, 0x8d }, { 26, 0x82 }, { 28, 0x }, { 29, 0x10 }, { 33, 0xc0 }, { 34, 0x7 }, { 35, 0x12 }, { 47, 0xc }, { 53, 0x22 }, { 63, 0x7 };}' unless defined(&RT5592_DEF_RF);
eval 'sub RT5592_2GHZ_DEF_RF () {{ 10, 0x90 }, { 11, 0x4a }, { 12, 0x52 }, { 13, 0x42 }, { 22, 0x40 }, { 24, 0x4a }, { 25, 0x80 }, { 27, 0x42 }, { 36, 0x80 }, { 37, 0x8 }, { 38, 0x89 }, { 39, 0x1b }, { 40, 0xd }, { 41, 0x9b }, { 42, 0xd5 }, { 43, 0x72 }, { 44, 0xe }, { 45, 0xa2 }, { 46, 0x6b }, { 48, 0x10 }, { 51, 0x3e }, { 52, 0x48 }, { 54, 0x38 }, { 56, 0xa1 }, { 57, 0x }, { 58, 0x39 }, { 60, 0x45 }, { 61, 0x91 }, { 62, 0x39 };}' unless defined(&RT5592_2GHZ_DEF_RF);
eval 'sub RT5592_5GHZ_DEF_RF () {{ 10, 0x97 }, { 11, 0x40 }, { 25, 0xbf }, { 27, 0x42 }, { 36, 0x }, { 37, 0x4 }, { 38, 0x85 }, { 40, 0x42 }, { 41, 0xbb }, { 42, 0xd7 }, { 45, 0x41 }, { 48, 0x }, { 57, 0x77 }, { 60, 0x5 }, { 61, 0x1 };}' unless defined(&RT5592_5GHZ_DEF_RF);
eval 'sub RT5592_CHAN_5GHZ () {{ 36, 64, 12, 0x2e }, { 100, 165, 12, 0xe }, { 36, 64, 13, 0x22 }, { 100, 165, 13, 0x42 }, { 36, 64, 22, 0x60 }, { 100, 165, 22, 0x40 }, { 36, 64, 23, 0x7f }, { 100, 153, 23, 0x3c }, { 155, 165, 23, 0x38 }, { 36, 50, 24, 0x9 }, { 52, 64, 24, 0x7 }, { 100, 153, 24, 0x6 }, { 155, 165, 24, 0x5 }, { 36, 64, 39, 0x1c }, { 100, 138, 39, 0x1a }, { 140, 165, 39, 0x18 }, { 36, 64, 43, 0x5b }, { 100, 138, 43, 0x3b }, { 140, 165, 43, 0x1b }, { 36, 64, 44, 0x40 }, { 100, 138, 44, 0x20 }, { 140, 165, 44, 0x10 }, { 36, 64, 46, 0x }, { 100, 138, 46, 0x18 }, { 140, 165, 46, 0x8 }, { 36, 64, 51, 0xfe }, { 100, 124, 51, 0xfc }, { 126, 165, 51, 0xec }, { 36, 64, 52, 0xc }, { 100, 138, 52, 0x6 }, { 140, 165, 52, 0x6 }, { 36, 64, 54, 0xf8 }, { 100, 165, 54, 0xeb }, { 36, 50, 55, 0x6 }, { 52, 64, 55, 0x4 }, { 100, 138, 55, 0x1 }, { 140, 165, 55, 0x }, { 36, 50, 56, 0xd3 }, { 52, 128, 56, 0xbb }, { 130, 165, 56, 0xab }, { 36, 64, 58, 0x15 }, { 100, 116, 58, 0x1d }, { 118, 165, 58, 0x15 }, { 36, 64, 59, 0x7f }, { 100, 138, 59, 0x3f }, { 140, 165, 59, 0x7c }, { 36, 64, 62, 0x15 }, { 100, 116, 62, 0x1d }, { 118, 165, 62, 0x15 };}' unless defined(&RT5592_CHAN_5GHZ);
1;
