require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_CPU_H_)) {
    eval 'sub _MACHINE_CPU_H_ () {1;}' unless defined(&_MACHINE_CPU_H_);
    if(defined(&_KERNEL)) {
	require 'machine/frame.ph';
	require 'machine/psl.ph';
	require 'machine/segments.ph';
	require 'machine/intrdefs.ph';
	if(defined(&MULTIPROCESSOR)) {
	    require 'machine/i82489reg.ph';
	    require 'machine/i82489var.ph';
	}
    }
    eval 'sub clockframe () { &intrframe;}' unless defined(&clockframe);
    require 'sys/device.ph';
    require 'sys/sched.ph';
    require 'sys/sensors.ph';
    if(defined(&_KERNEL)) {
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&DIAGNOSTIC)) {
	}
	eval 'sub MWAIT_IN_IDLE () {0x1;}' unless defined(&MWAIT_IN_IDLE);
	eval 'sub MWAIT_KEEP_IDLING () {0x2;}' unless defined(&MWAIT_KEEP_IDLING);
	eval 'sub MWAIT_ONLY () {0x4;}' unless defined(&MWAIT_ONLY);
	eval 'sub MWAIT_IDLING () {( &MWAIT_IN_IDLE |  &MWAIT_KEEP_IDLING);}' unless defined(&MWAIT_IDLING);
	eval 'sub CI_DDB_RUNNING () {0;}' unless defined(&CI_DDB_RUNNING);
	eval 'sub CI_DDB_SHOULDSTOP () {1;}' unless defined(&CI_DDB_SHOULDSTOP);
	eval 'sub CI_DDB_STOPPED () {2;}' unless defined(&CI_DDB_STOPPED);
	eval 'sub CI_DDB_ENTERDDB () {3;}' unless defined(&CI_DDB_ENTERDDB);
	eval 'sub CI_DDB_INDDB () {4;}' unless defined(&CI_DDB_INDDB);
	if(defined(&GPROF)) {
	}
	eval 'sub CPUF_BSP () {0x1;}' unless defined(&CPUF_BSP);
	eval 'sub CPUF_AP () {0x2;}' unless defined(&CPUF_AP);
	eval 'sub CPUF_SP () {0x4;}' unless defined(&CPUF_SP);
	eval 'sub CPUF_PRIMARY () {0x8;}' unless defined(&CPUF_PRIMARY);
	eval 'sub CPUF_APIC_CD () {0x10;}' unless defined(&CPUF_APIC_CD);
	eval 'sub CPUF_CONST_TSC () {0x20;}' unless defined(&CPUF_CONST_TSC);
	eval 'sub CPUF_PRESENT () {0x1000;}' unless defined(&CPUF_PRESENT);
	eval 'sub CPUF_RUNNING () {0x2000;}' unless defined(&CPUF_RUNNING);
	eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q( &for ($cii = 0, $ci =  &cpu_info_list; $ci !=  &NULL; $ci =  ($ci->{ci_next})));
	}' unless defined(&CPU_INFO_FOREACH);
	eval 'sub CPU_INFO_UNIT {
	    my($ci) = @_;
    	    eval q((($ci)-> ($ci_dev->{dv_unit})));
	}' unless defined(&CPU_INFO_UNIT);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub MAXCPUS () {32;}' unless defined(&MAXCPUS);
	    eval 'sub CPU_STARTUP {
	        my($_ci) = @_;
    		eval q((($_ci)-> ($ci_func->{start})($_ci)));
	    }' unless defined(&CPU_STARTUP);
	    eval 'sub CPU_STOP {
	        my($_ci) = @_;
    		eval q((($_ci)-> ($ci_func->{stop})($_ci)));
	    }' unless defined(&CPU_STOP);
	    eval 'sub CPU_START_CLEANUP {
	        my($_ci) = @_;
    		eval q((($_ci)-> ($ci_func->{cleanup})($_ci)));
	    }' unless defined(&CPU_START_CLEANUP);
	    eval 'sub cpu_number () {
	        eval q(( &curcpu()-> &ci_cpuid));
	    }' unless defined(&cpu_number);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_BUSY_CYCLE () {
	        eval q( &__asm  &volatile(\\"pause\\": : : \\"memory\\"));
	    }' unless defined(&CPU_BUSY_CYCLE);
	} else {
	    eval 'sub MAXCPUS () {1;}' unless defined(&MAXCPUS);
	    eval 'sub cpu_number () {
	        eval q(0);
	    }' unless defined(&cpu_number);
	    eval 'sub curcpu () {
	        eval q(( &cpu_info_primary));
	    }' unless defined(&curcpu);
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q(1);
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub cpu_kick {
	        my($ci) = @_;
    		eval q();
	    }' unless defined(&cpu_kick);
	    eval 'sub cpu_unidle {
	        my($ci) = @_;
    		eval q();
	    }' unless defined(&cpu_unidle);
	    eval 'sub CPU_BUSY_CYCLE () {
	        eval q( &do {}  &while (0));
	    }' unless defined(&CPU_BUSY_CYCLE);
	}
	eval 'sub aston {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
	}' unless defined(&aston);
	eval 'sub curpcb () { &curcpu()-> &ci_curpcb;}' unless defined(&curpcb);
	eval 'sub want_resched () {( &curcpu()-> &ci_want_resched);}' unless defined(&want_resched);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q(($ci)-> &ci_want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub CLKF_USERMODE {
	    my($frame) = @_;
    	    eval q( &USERMODE(($frame)-> &if_cs, ($frame)-> &if_eflags));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($frame) = @_;
    	    eval q((($frame)-> &if_eip));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($frame) = @_;
    	    eval q(( &IDXSEL(($frame)-> &if_cs) ==  &GICODE_SEL));
	}' unless defined(&CLKF_INTR);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_regs}->{tf_eip})));
	}' unless defined(&PROC_PC);
	eval 'sub PROC_STACK {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_regs}->{tf_esp})));
	}' unless defined(&PROC_STACK);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&need_proftick);
	eval 'sub DELAY {
	    my($x) = @_;
    	    eval q((* &delay_func)($x));
	}' unless defined(&DELAY);
	eval 'sub delay {
	    my($x) = @_;
    	    eval q((* &delay_func)($x));
	}' unless defined(&delay);
	require 'machine/cputypes.ph';
	if(!defined(&SMALL_KERNEL)) {
	    eval 'sub BUS66 () {6667;}' unless defined(&BUS66);
	    eval 'sub BUS100 () {10000;}' unless defined(&BUS100);
	    eval 'sub BUS133 () {13333;}' unless defined(&BUS133);
	    eval 'sub BUS166 () {16667;}' unless defined(&BUS166);
	    eval 'sub BUS200 () {20000;}' unless defined(&BUS200);
	    eval 'sub BUS266 () {26667;}' unless defined(&BUS266);
	    eval 'sub BUS333 () {33333;}' unless defined(&BUS333);
	}
	if(!defined(&SMALL_KERNEL)) {
	}
	if(defined(&USER_LDT)) {
	}
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&VM86)) {
	}
    }
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_BIOS () {2;}' unless defined(&CPU_BIOS);
    eval 'sub CPU_BLK2CHR () {3;}' unless defined(&CPU_BLK2CHR);
    eval 'sub CPU_CHR2BLK () {4;}' unless defined(&CPU_CHR2BLK);
    eval 'sub CPU_ALLOWAPERTURE () {5;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_CPUVENDOR () {6;}' unless defined(&CPU_CPUVENDOR);
    eval 'sub CPU_CPUID () {7;}' unless defined(&CPU_CPUID);
    eval 'sub CPU_CPUFEATURE () {8;}' unless defined(&CPU_CPUFEATURE);
    eval 'sub CPU_APMWARN () {9;}' unless defined(&CPU_APMWARN);
    eval 'sub CPU_KBDRESET () {10;}' unless defined(&CPU_KBDRESET);
    eval 'sub CPU_APMHALT () {11;}' unless defined(&CPU_APMHALT);
    eval 'sub CPU_USERLDT () {12;}' unless defined(&CPU_USERLDT);
    eval 'sub CPU_OSFXSR () {13;}' unless defined(&CPU_OSFXSR);
    eval 'sub CPU_SSE () {14;}' unless defined(&CPU_SSE);
    eval 'sub CPU_SSE2 () {15;}' unless defined(&CPU_SSE2);
    eval 'sub CPU_XCRYPT () {16;}' unless defined(&CPU_XCRYPT);
    eval 'sub CPU_LIDSUSPEND () {17;}' unless defined(&CPU_LIDSUSPEND);
    eval 'sub CPU_MAXID () {18;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "bios",  &CTLTYPE_INT }, { "blk2chr",  &CTLTYPE_STRUCT }, { "chr2blk",  &CTLTYPE_STRUCT }, { "allowaperture",  &CTLTYPE_INT }, { "cpuvendor",  &CTLTYPE_STRING }, { "cpuid",  &CTLTYPE_INT }, { "cpufeature",  &CTLTYPE_INT }, { "apmwarn",  &CTLTYPE_INT }, { "kbdreset",  &CTLTYPE_INT }, { "apmhalt",  &CTLTYPE_INT }, { "userldt",  &CTLTYPE_INT }, { "osfxsr",  &CTLTYPE_INT }, { "sse",  &CTLTYPE_INT }, { "sse2",  &CTLTYPE_INT }, { "xcrypt",  &CTLTYPE_INT }, { "lidsuspend",  &CTLTYPE_INT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&MULTIPROCESSOR)  && defined(&_KERNEL)) {
	require 'sys/mplock.ph';
    }
}
1;
