require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/selinfo.ph';
require 'sys/queue.ph';
require 'sys/timeout.ph';
unless(defined(&_SOCKLEN_T_DEFINED_)) {
    eval 'sub _SOCKLEN_T_DEFINED_ () {1;}' unless defined(&_SOCKLEN_T_DEFINED_);
}
eval 'sub SB_MAX () {(256*1024);}' unless defined(&SB_MAX);
eval 'sub SB_LOCK () {0x1;}' unless defined(&SB_LOCK);
eval 'sub SB_WANT () {0x2;}' unless defined(&SB_WANT);
eval 'sub SB_WAIT () {0x4;}' unless defined(&SB_WAIT);
eval 'sub SB_SEL () {0x8;}' unless defined(&SB_SEL);
eval 'sub SB_ASYNC () {0x10;}' unless defined(&SB_ASYNC);
eval 'sub SB_SPLICE () {0x20;}' unless defined(&SB_SPLICE);
eval 'sub SB_NOINTR () {0x40;}' unless defined(&SB_NOINTR);
eval 'sub SB_KNOTE () {0x80;}' unless defined(&SB_KNOTE);
eval 'sub SS_NOFDREF () {0x1;}' unless defined(&SS_NOFDREF);
eval 'sub SS_ISCONNECTED () {0x2;}' unless defined(&SS_ISCONNECTED);
eval 'sub SS_ISCONNECTING () {0x4;}' unless defined(&SS_ISCONNECTING);
eval 'sub SS_ISDISCONNECTING () {0x8;}' unless defined(&SS_ISDISCONNECTING);
eval 'sub SS_CANTSENDMORE () {0x10;}' unless defined(&SS_CANTSENDMORE);
eval 'sub SS_CANTRCVMORE () {0x20;}' unless defined(&SS_CANTRCVMORE);
eval 'sub SS_RCVATMARK () {0x40;}' unless defined(&SS_RCVATMARK);
eval 'sub SS_ISDISCONNECTED () {0x800;}' unless defined(&SS_ISDISCONNECTED);
eval 'sub SS_PRIV () {0x80;}' unless defined(&SS_PRIV);
eval 'sub SS_NBIO () {0x100;}' unless defined(&SS_NBIO);
eval 'sub SS_ASYNC () {0x200;}' unless defined(&SS_ASYNC);
eval 'sub SS_CONNECTOUT () {0x1000;}' unless defined(&SS_CONNECTOUT);
eval 'sub SS_ISSENDING () {0x2000;}' unless defined(&SS_ISSENDING);
if(defined(&_KERNEL)) {
    eval 'sub isspliced {
        my($so) = @_;
	    eval q((($so)-> &so_sp  && ($so)-> ($so_sp->{ssp_socket})));
    }' unless defined(&isspliced);
    eval 'sub issplicedback {
        my($so) = @_;
	    eval q((($so)-> &so_sp  && ($so)-> ($so_sp->{ssp_soback})));
    }' unless defined(&issplicedback);
    eval 'sub sb_notify {
        my($sb) = @_;
	    eval q((((($sb)-> &sb_flags | ($sb)-> &sb_flagsintr) & ( &SB_WAIT| &SB_SEL| &SB_ASYNC| &SB_SPLICE| &SB_KNOTE)) != 0));
    }' unless defined(&sb_notify);
    eval 'sub sbspace {
        my($sb) = @_;
	    eval q( &lmin(($sb)-> &sb_hiwat - ($sb)-> &sb_cc, ($sb)-> &sb_mbmax - ($sb)-> &sb_mbcnt));
    }' unless defined(&sbspace);
    eval 'sub sosendallatonce {
        my($so) = @_;
	    eval q((($so)-> ($so_proto->{pr_flags}) &  &PR_ATOMIC));
    }' unless defined(&sosendallatonce);
    eval 'sub soissending {
        my($so) = @_;
	    eval q((($so)-> &so_state &  &SS_ISSENDING));
    }' unless defined(&soissending);
    eval 'sub soreadable {
        my($so) = @_;
	    eval q((! &isspliced($so)  && (($so)-> ($so_rcv->{sb_cc}) >= ($so)-> ($so_rcv->{sb_lowat}) || (($so)-> &so_state &  &SS_CANTRCVMORE) || ($so)-> &so_qlen || ($so)-> &so_error)));
    }' unless defined(&soreadable);
    eval 'sub sowriteable {
        my($so) = @_;
	    eval q((( &sbspace(($so)-> &so_snd) >= ($so)-> ($so_snd->{sb_lowat})  && ((($so)-> &so_state &  &SS_ISCONNECTED) || (($so)-> ($so_proto->{pr_flags}) &  &PR_CONNREQUIRED)==0)) || (($so)-> &so_state &  &SS_CANTSENDMORE) || ($so)-> &so_error));
    }' unless defined(&sowriteable);
    eval 'sub sballoc {
        my($sb, $m) = @_;
	    eval q( &do { ($sb)-> &sb_cc += ($m)-> &m_len;  &if (($m)-> &m_type !=  &MT_CONTROL  && ($m)-> &m_type !=  &MT_SONAME) ($sb)-> &sb_datacc += ($m)-> &m_len; ($sb)-> &sb_mbcnt +=  &MSIZE;  &if (($m)-> &m_flags &  &M_EXT) ($sb)-> &sb_mbcnt += ($m)-> ($m_ext->{ext_size}); }  &while ( 0));
    }' unless defined(&sballoc);
    eval 'sub sbfree {
        my($sb, $m) = @_;
	    eval q( &do { ($sb)-> &sb_cc -= ($m)-> &m_len;  &if (($m)-> &m_type !=  &MT_CONTROL  && ($m)-> &m_type !=  &MT_SONAME) ($sb)-> &sb_datacc -= ($m)-> &m_len; ($sb)-> &sb_mbcnt -=  &MSIZE;  &if (($m)-> &m_flags &  &M_EXT) ($sb)-> &sb_mbcnt -= ($m)-> ($m_ext->{ext_size}); }  &while ( 0));
    }' unless defined(&sbfree);
    eval 'sub sblock {
        my($sb, $wf) = @_;
	    eval q((($sb)-> &sb_flags &  &SB_LOCK ? ((($wf) ==  &M_WAITOK) ?  &sb_lock($sb) :  &EWOULDBLOCK) : (($sb)-> &sb_flags |=  &SB_LOCK, 0)));
    }' unless defined(&sblock);
    eval 'sub sbunlock {
        my($sb) = @_;
	    eval q( &do { ($sb)-> &sb_flags &= ~ &SB_LOCK;  &if (($sb)-> &sb_flags &  &SB_WANT) { ($sb)-> &sb_flags &= ~ &SB_WANT;  &wakeup(($sb)-> &sb_flags); } }  &while ( 0));
    }' unless defined(&sbunlock);
    eval 'sub SB_EMPTY_FIXUP {
        my($sb) = @_;
	    eval q( &do {  &if (($sb)-> &sb_mb ==  &NULL) { ($sb)-> &sb_mbtail =  &NULL; ($sb)-> &sb_lastrecord =  &NULL; } }  &while ( 0));
    }' unless defined(&SB_EMPTY_FIXUP);
    if(defined(&SOCKBUF_DEBUG)) {
	eval 'sub SBLASTRECORDCHK {
	    my($sb, $where) = @_;
    	    eval q( &sblastrecordchk(($sb), ($where)));
	}' unless defined(&SBLASTRECORDCHK);
	eval 'sub SBLASTMBUFCHK {
	    my($sb, $where) = @_;
    	    eval q( &sblastmbufchk(($sb), ($where)));
	}' unless defined(&SBLASTMBUFCHK);
	eval 'sub SBCHECK {
	    my($sb) = @_;
    	    eval q( &sbcheck($sb));
	}' unless defined(&SBCHECK);
    } else {
	eval 'sub SBLASTRECORDCHK {
	    my($sb, $where) = @_;
    	    eval q();
	}' unless defined(&SBLASTRECORDCHK);
	eval 'sub SBLASTMBUFCHK {
	    my($sb, $where) = @_;
    	    eval q();
	}' unless defined(&SBLASTMBUFCHK);
	eval 'sub SBCHECK {
	    my($sb) = @_;
    	    eval q();
	}' unless defined(&SBCHECK);
    }
}
1;
