# Edit Shared Folder Settings of a Guest
use strict;
use warnings;
our (%gui, %vmc);

sub setup_edit_dialog_shared() {
    &addrow_log("Fetching shared folder settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    &fill_list_editshared($vmc{IMachine});
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log('Shared folder settings complete.');
}

# Show the dialog for adding a shared folder
sub show_dialog_shared {
    my ($widget) = @_;

    if ($widget eq $gui{buttonEditSharedEdit}) {
        my $sref = &getsel_list_editshared();
        $gui{entrySharedFolderPath}->set_text($$sref{Folder});
        $gui{entrySharedFolderName}->set_text($$sref{Name});

        if ($$sref{Access} eq 'Read-Only') { $gui{checkbuttonSharedFolderRO}->set_active(1); }
        else { $gui{checkbuttonSharedFolderRO}->set_active(0); }

        if ($$sref{Mount} eq 'Yes') { $gui{checkbuttonSharedFolderMount}->set_active(1); }
        else { $gui{checkbuttonSharedFolderMount}->set_active(0); }
    }

    do {
        my $response = $gui{dialogShared}->run;
        
        if ($response eq 'ok') {
            # No validation needed for other entries
            if (!$gui{entrySharedFolderPath}->get_text()) { &show_err_msg('invalidpath', '(Folder Path)'); }
            elsif (!$gui{entrySharedFolderName}->get_text()) { &show_err_msg('invalidname', '(Folder Name)'); }
            else {
                $gui{dialogShared}->hide; 
                &shared_remove($widget, $gui{treeviewEditShared}) if ($widget eq $gui{buttonEditSharedEdit});
                IMachine_createSharedFolder($vmc{IMachine}, $gui{entrySharedFolderName}->get_text(),
                                                            $gui{entrySharedFolderPath}->get_text(),
                                                            !$gui{checkbuttonSharedFolderRO}->get_active(),
                                                            $gui{checkbuttonSharedFolderMount}->get_active());
                &fill_list_editshared($vmc{IMachine});
            }
        }
        else { $gui{dialogShared}->hide; }

    } until (!$gui{dialogShared}->visible());
}

sub shared_remove() {
    my $sref = &getsel_list_editshared();
    IMachine_removeSharedFolder($vmc{IMachine}, $$sref{Name});
    &fill_list_editshared($vmc{IMachine});
}

# Set sensitivity when a shared folder is selected
sub sens_shared() {
    $gui{buttonEditSharedRemove}->set_sensitive(1);
    $gui{buttonEditSharedEdit}->set_sensitive(1);
}

1;