/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import com.rc.retroweaver.runtime.Autobox;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.actions.container.PyContainerAction;

public class PyDeletePycAndClassFiles
extends PyContainerAction
implements IObjectActionDelegate {
    protected int doActionOnContainer(IContainer container, IProgressMonitor monitor) {
        int deleted = 0;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource c = iResourceArray[n2];
                if (!monitor.isCanceled()) {
                    String name;
                    monitor.worked(1);
                    if (c instanceof IContainer) {
                        deleted += this.doActionOnContainer((IContainer)c, monitor);
                    } else if (c instanceof IFile && (name = c.getName()) != null && (name.endsWith(".pyc") || name.endsWith(".pyo") || name.endsWith("$py.class"))) {
                        c.delete(true, monitor);
                        ++deleted;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        return deleted;
    }

    protected void afterRun(int deleted) {
        MessageDialog.openInformation(null, (String)"Files deleted", (String)StringUtils.format((String)"Deleted %s files.", (Object[])new Object[]{Autobox.valueOf((int)deleted)}));
    }

    protected boolean confirmRun() {
        return MessageDialog.openConfirm(null, (String)"Confirm deletion", (String)"Are you sure that you want to recursively delete the *.pyc and *$py.class files from the selected folder(s)?\n\nThis action cannot be undone.");
    }
}

