/*
 * Decompiled with CFR 0.152.
 */
package org.linkgrammar;

import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.linkgrammar.JSONUtils;
import org.linkgrammar.LGConfig;
import org.linkgrammar.Link;
import org.linkgrammar.LinkGrammar;
import org.linkgrammar.Linkage;
import org.linkgrammar.ParseResult;

public class LGService {
    private static boolean verbose = false;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static ThreadLocal<Boolean> initialized = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static boolean isInitialized() {
        return initialized.get();
    }

    public static void init() {
        if (!initialized.get().booleanValue()) {
            LinkGrammar.init();
            initialized.set(Boolean.TRUE);
        }
    }

    public static void close() {
        LinkGrammar.close();
        initialized.set(Boolean.FALSE);
    }

    private static void trace(String s) {
        if (verbose) {
            System.out.println("LG " + dateFormatter.format(new Date()) + " " + s);
        }
    }

    public static void configure(LGConfig config) {
        LGService.init();
        if (config.getMaxCost() > -1.0) {
            LinkGrammar.setMaxCost(config.getMaxCost());
        }
        if (config.getMaxParseSeconds() > -1) {
            LinkGrammar.setMaxParseSeconds(config.getMaxParseSeconds());
        }
    }

    public static ParseResult getAsParseResult(LGConfig config) {
        LinkGrammar.makeLinkage(0);
        ParseResult parseResult = new ParseResult();
        parseResult.setParserVersion(LinkGrammar.getVersion());
        parseResult.setDictVersion(LinkGrammar.getDictVersion());
        parseResult.numSkippedWords = LinkGrammar.getNumSkippedWords();
        int maxLinkages = Math.min(config.getMaxLinkages(), LinkGrammar.getNumLinkages());
        for (int li = 0; li < maxLinkages; ++li) {
            LinkGrammar.makeLinkage(li);
            Linkage linkage = new Linkage();
            linkage.setDisjunctCost(LinkGrammar.getLinkageDisjunctCost());
            linkage.setLinkCost(LinkGrammar.getLinkageLinkCost());
            linkage.setLinkedWordCount(LinkGrammar.getNumWords());
            linkage.setNumViolations(LinkGrammar.getLinkageNumViolations());
            String[] disjuncts = new String[LinkGrammar.getNumWords()];
            String[] words = new String[LinkGrammar.getNumWords()];
            for (int i = 0; i < words.length; ++i) {
                disjuncts[i] = LinkGrammar.getLinkageDisjunct(i);
                words[i] = LinkGrammar.getLinkageWord(i);
            }
            linkage.setWords(words);
            linkage.setDisjuncts(disjuncts);
            int numLinks = LinkGrammar.getNumLinks();
            for (int i = 0; i < numLinks; ++i) {
                Link link = new Link();
                link.setLabel(LinkGrammar.getLinkLabel(i));
                link.setLeft(LinkGrammar.getLinkLWord(i));
                link.setRight(LinkGrammar.getLinkRWord(i));
                link.setLeftLabel(LinkGrammar.getLinkLLabel(i));
                link.setRightLabel(LinkGrammar.getLinkRLabel(i));
                linkage.getLinks().add(link);
            }
            if (config.isStoreConstituentString()) {
                linkage.setConstituentString(LinkGrammar.getConstituentString());
            }
            if (config.isStoreDiagramString()) {
                linkage.setDiagramString(LinkGrammar.getLinkString());
            }
            parseResult.linkages.add(linkage);
        }
        return parseResult;
    }

    public static String getEmptyJSONResult(LGConfig config) {
        StringBuffer buf = new StringBuffer();
        buf.append("\"numSkippedWords\":0,");
        buf.append("\"linkages\":[],");
        buf.append("\"version\":\"" + LinkGrammar.getVersion() + "\",");
        buf.append("\"dictVersion\":\"" + LinkGrammar.getDictVersion() + "\"}");
        return buf.toString();
    }

    public static String getAsJSONFormat(LGConfig config) {
        LinkGrammar.makeLinkage(0);
        int numWords = LinkGrammar.getNumWords();
        int maxLinkages = Math.min(config.getMaxLinkages(), LinkGrammar.getNumLinkages());
        StringBuffer buf = new StringBuffer();
        buf.append("{\"numSkippedWords\":" + LinkGrammar.getNumSkippedWords());
        buf.append(",\"linkages\":[");
        for (int li = 0; li < maxLinkages; ++li) {
            int i;
            LinkGrammar.makeLinkage(li);
            buf.append("{\"words\":[");
            for (i = 0; i < numWords; ++i) {
                buf.append(JSONUtils.jsonString(LinkGrammar.getLinkageWord(i)));
                if (i + 1 >= numWords) continue;
                buf.append(",");
            }
            buf.append("], \"disjuncts\":[");
            for (i = 0; i < numWords; ++i) {
                buf.append(JSONUtils.jsonString(LinkGrammar.getLinkageDisjunct(i)));
                if (i + 1 >= numWords) continue;
                buf.append(",");
            }
            buf.append("], \"disjunctCost\":");
            buf.append(Double.toString(LinkGrammar.getLinkageDisjunctCost()));
            buf.append(", \"linkageCost\":");
            buf.append(Double.toString(LinkGrammar.getLinkageLinkCost()));
            buf.append(", \"numViolations\":");
            buf.append(Integer.toString(LinkGrammar.getLinkageNumViolations()));
            if (config.isStoreConstituentString()) {
                buf.append(", \"constituentString\":");
                buf.append(JSONUtils.jsonString(LinkGrammar.getConstituentString()));
            }
            if (config.isStoreDiagramString()) {
                buf.append(", \"diagramString\":");
                buf.append(JSONUtils.jsonString(LinkGrammar.getLinkString()));
            }
            buf.append(", \"links\":[");
            int numLinks = LinkGrammar.getNumLinks();
            for (int i2 = 0; i2 < numLinks; ++i2) {
                buf.append("{\"label\":" + JSONUtils.jsonString(LinkGrammar.getLinkLabel(i2)) + ",");
                buf.append("\"left\":" + LinkGrammar.getLinkLWord(i2) + ",");
                buf.append("\"right\":" + LinkGrammar.getLinkRWord(i2) + ",");
                buf.append("\"leftLabel\":" + JSONUtils.jsonString(LinkGrammar.getLinkLLabel(i2)) + ",");
                buf.append("\"rightLabel\":" + JSONUtils.jsonString(LinkGrammar.getLinkRLabel(i2)) + "}");
                if (i2 + 1 >= numLinks) continue;
                buf.append(",");
            }
            buf.append("]");
            buf.append("}");
            if (li >= maxLinkages - 1) continue;
            buf.append(",");
        }
        buf.append("],\"version\":\"" + LinkGrammar.getVersion() + "\"");
        buf.append(",\"dictVersion\":\"" + LinkGrammar.getDictVersion() + "\"");
        buf.append("}");
        return buf.toString();
    }

    public static byte[] getAsBinary(LGConfig config) {
        int size = 0;
        byte[] buf = new byte[1024];
        byte[] result = new byte[size];
        System.arraycopy(buf, 0, result, 0, size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleClient(Socket clientSocket) {
        LGService.init();
        Reader in = null;
        PrintWriter out = null;
        JSONUtils msgreader = new JSONUtils();
        try {
            LGService.trace("Connection accepted from : " + clientSocket.getInetAddress());
            in = new InputStreamReader(clientSocket.getInputStream());
            Map<String, String> msg = msgreader.readMsg(in);
            if (verbose) {
                LGService.trace("Received msg '" + msg + "' from " + clientSocket.getInetAddress());
            }
            String json = "{}";
            if ("version".equals(msg.get("get"))) {
                json = "{\"version\":\"" + LinkGrammar.getVersion() + "\"}";
            } else {
                LGConfig config = new LGConfig();
                config.setMaxCost(JSONUtils.getDouble("maxCost", msg, config.getMaxCost()));
                config.setMaxLinkages(JSONUtils.getInt("maxLinkages", msg, config.getMaxLinkages()));
                config.setMaxParseSeconds(JSONUtils.getInt("maxParseSeconds", msg, config.getMaxParseSeconds()));
                config.setStoreConstituentString(JSONUtils.getBool("storeConstituentString", msg, config.isStoreConstituentString()));
                config.setStoreDiagramString(JSONUtils.getBool("storeDiagramString", msg, config.isStoreDiagramString()));
                LGService.configure(config);
                String text = msg.get("text");
                if (text != null && text.trim().length() > 0) {
                    LinkGrammar.parse(text);
                    json = LinkGrammar.getNumLinkages() > 0 ? LGService.getAsJSONFormat(config) : LGService.getEmptyJSONResult(config);
                } else {
                    json = LGService.getEmptyJSONResult(config);
                }
            }
            out = new PrintWriter(clientSocket.getOutputStream(), true);
            out.print(json.length() + 1);
            out.print('\n');
            out.print(json);
            out.print('\n');
            out.flush();
            LGService.trace("Response written to " + clientSocket.getInetAddress() + ", closing client connection...");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable t) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            if (clientSocket != null) {
                try {
                    clientSocket.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static ParseResult parse(LGConfig config, String text) {
        LGService.init();
        LGService.configure(config);
        LinkGrammar.parse(text);
        return LGService.getAsParseResult(config);
    }

    public static void main(String[] argv) {
        int threads = 1;
        int port = 0;
        String dictionaryPath = null;
        String language = null;
        try {
            int argIdx = 0;
            if (argv[argIdx].equals("-verbose")) {
                verbose = true;
                ++argIdx;
            }
            if (argv[argIdx].equals("-threads")) {
                threads = Integer.parseInt(argv[++argIdx]);
            }
            int n = ++argIdx;
            port = Integer.parseInt(argv[n]);
            if (argv.length > ++argIdx) {
                language = argv[argIdx++];
            }
            if (argv.length > argIdx) {
                dictionaryPath = argv[argIdx++];
            }
        }
        catch (Throwable ex) {
            if (argv.length > 0) {
                ex.printStackTrace(System.err);
            }
            System.out.println("Usage: java org.linkgrammar.LGService [-verbose] [-threads n] port [language] [dictPath]");
            System.out.println("Start a link-grammar parse server on tcp/ip port.  The server returns");
            System.out.println("JSON-formated parse results.  Socket input should be a single sentence");
            System.out.println("to parse, preceeded by the identifier \"text:\".\n");
            System.out.println("  'port'      The TCP port the service should listen to.");
            System.out.println("  -verbose    Generate verbose output.");
            System.out.println("  -threads    Number of concurrent threads/clients allowed (default 1).");
            System.out.println("  'language'  Language abbreviation (en, ru, de, lt or fr).");
            System.out.println("  'dictPath'  Full path to the Link-Grammar dictionaries.");
            System.exit(-1);
        }
        if (dictionaryPath != null) {
            File f = new File(dictionaryPath);
            if (!f.exists()) {
                System.err.println("Dictionary path " + dictionaryPath + " not found.");
                System.exit(-1);
            } else if (!f.isDirectory()) {
                System.err.println("Dictionary path " + dictionaryPath + " not a directory.");
                System.exit(-1);
            }
        }
        System.out.println("Starting Link Grammar Server at port " + port + ", with " + threads + " available processing threads and " + (dictionaryPath == null ? " with default dictionary location." : "with dictionary location '" + dictionaryPath + "'."));
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threads, threads, Long.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            if (language != null) {
                LinkGrammar.setLanguage(language);
            }
            if (dictionaryPath != null) {
                LinkGrammar.setDictionariesPath(dictionaryPath);
            }
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                LGService.trace("Waiting for client connections...");
                final Socket clientSocket = serverSocket.accept();
                threadPool.submit(new Runnable(){

                    public void run() {
                        try {
                            LGService.handleClient(clientSocket);
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            System.exit(-1);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(-1);
            return;
        }
    }
}

