/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.Purpose;
import org.jruby.ext.openssl.x509store.X509Aux;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;

public class Trust {
    public int trust;
    public int flags;
    private Checker<Trust> checkTrust;
    private String name;
    private String arg1;
    private Object arg2;
    private static final List<Trust> trustable = new ArrayList<Trust>();
    static final Checker<Trust> trustCompatibe = new Checker<Trust>(){

        @Override
        public int call(Trust trust, X509AuxCertificate x, Integer flags) throws CertificateException {
            Purpose.checkPurpose(x, -1, 0);
            if (x.getIssuerX500Principal().equals(x.getSubjectX500Principal())) {
                return 1;
            }
            return 3;
        }
    };
    static final Checker<Trust> trust1OIDAny = new Checker<Trust>(){

        @Override
        public int call(Trust trust, X509AuxCertificate x, Integer flags) throws Exception {
            X509Aux aux = x.getAux();
            if (aux != null && (aux.trust.size() > 0 || aux.reject.size() > 0)) {
                return objTrust.call(trust.arg1, x, flags);
            }
            return trustCompatibe.call(trust, x, flags);
        }
    };
    static final Checker<Trust> trust1OID = new Checker<Trust>(){

        @Override
        public int call(Trust trust, X509AuxCertificate x, Integer flags) throws Exception {
            if (x.getAux() != null) {
                return objTrust.call(trust.arg1, x, flags);
            }
            return 3;
        }
    };
    static final Checker<String> objTrust = new Checker<String>(){

        @Override
        public int call(String id, X509AuxCertificate x, Integer flags) {
            X509Aux aux = x.getAux();
            if (aux == null) {
                return 3;
            }
            for (String rejectId : aux.reject) {
                if (!rejectId.equals(id)) continue;
                return 2;
            }
            for (String trustId : aux.trust) {
                if (!trustId.equals(id)) continue;
                return 1;
            }
            return 3;
        }
    };
    static Checker<String> defaultTrust = objTrust;
    private static final Trust[] trstandard = new Trust[]{new Trust(1, 0, trustCompatibe, "compatible", null, null), new Trust(2, 0, trust1OIDAny, "SSL Client", "1.3.6.1.5.5.7.3.2", null), new Trust(3, 0, trust1OIDAny, "SSL Server", "1.3.6.1.5.5.7.3.1", null), new Trust(4, 0, trust1OIDAny, "S/MIME email", "1.3.6.1.5.5.7.3.4", null), new Trust(5, 0, trust1OIDAny, "Object Signer", "1.3.6.1.5.5.7.3.3", null), new Trust(6, 0, trust1OID, "OCSP responder", "1.3.6.1.5.5.7.3.9", null), new Trust(7, 0, trust1OID, "OCSP request", "1.3.6.1.5.5.7.48.1", null)};

    private Trust() {
    }

    Trust(int trust, int flags, Checker<Trust> checkTrust, String n, String a1, Object a2) {
        this.trust = trust;
        this.flags = flags;
        this.checkTrust = checkTrust;
        this.name = n;
        this.arg1 = a1;
        this.arg2 = a2;
    }

    public static int checkTrust(X509AuxCertificate x, int id, int flags) throws Exception {
        if (id == -1) {
            return 1;
        }
        int idx = Trust.getByID(id);
        if (idx == -1) {
            return defaultTrust.call(Integer.toString(id), x, flags);
        }
        Trust pt = Trust.getFirst(idx);
        return pt.checkTrust.call(pt, x, flags);
    }

    public static int getCount() {
        return trustable.size() + trstandard.length;
    }

    public static Trust getFirst(int idx) {
        if (idx < 0) {
            return null;
        }
        if (idx < trstandard.length) {
            return trstandard[idx];
        }
        return trustable.get(idx - trstandard.length);
    }

    public static int getByID(int id) {
        if (id >= 1 && id <= 7) {
            return id - 1;
        }
        int i = 0;
        for (Trust t : trustable) {
            if (t.trust != id) continue;
            return i + trstandard.length;
        }
        return -1;
    }

    public static int set(int[] t, int trust) {
        if (Trust.getByID(trust) == -1) {
            X509Error.addError(123);
            return 0;
        }
        t[0] = trust;
        return 1;
    }

    static int add(int id, int flags, Checker<Trust> ck, String name, String arg1, Object arg2) {
        Trust trtmp;
        flags &= 0xFFFFFFFE;
        flags |= 2;
        int idx = Trust.getByID(id);
        if (idx == -1) {
            trtmp = new Trust();
            trtmp.flags = 1;
        } else {
            trtmp = Trust.getFirst(idx);
        }
        trtmp.name = name;
        trtmp.flags &= 1;
        trtmp.flags |= flags;
        trtmp.trust = id;
        trtmp.checkTrust = ck;
        trtmp.arg1 = arg1;
        trtmp.arg2 = arg2;
        if (idx == -1) {
            trustable.add(trtmp);
        }
        return 1;
    }

    public static void cleanup() {
        trustable.clear();
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public int getTrust() {
        return this.trust;
    }

    static interface Checker<T>
    extends Function3<T, X509AuxCertificate, Integer> {
    }
}

