/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.impl.ASN1Registry;

public class EVP {
    public static Cipher getCipher(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String algorithm = EVP.getAlgorithmName(oid);
        String[] cipher = Cipher.Algorithm.osslToJsse(algorithm);
        String realName = cipher[3];
        return SecurityHelper.getCipher(realName);
    }

    public static MessageDigest getDigest(ASN1ObjectIdentifier oid) throws NoSuchAlgorithmException {
        String algorithm = EVP.getAlgorithmName(oid);
        return SecurityHelper.getMessageDigest(algorithm);
    }

    public static MessageDigest sha1() {
        try {
            return SecurityHelper.getMessageDigest("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static int type(MessageDigest digest) {
        String name = digest.getAlgorithm();
        ASN1ObjectIdentifier oid = ASN1Registry.sym2oid(name);
        if (oid == null) {
            name = name.toLowerCase().replace("sha-", "sha");
            oid = ASN1Registry.sym2oid(name);
        }
        return ASN1Registry.obj2nid(oid);
    }

    public static String signatureAlgorithm(MessageDigest digest, Key key) {
        String sig = digest.getAlgorithm().toLowerCase().replace("sha-", "sha");
        String type = key.getAlgorithm().toLowerCase();
        if (sig == null) {
            sig = "none";
        }
        return sig + "with" + type;
    }

    public static byte[] decrypt(byte[] input, int offset, int len, Key key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = SecurityHelper.getCipher(key.getAlgorithm());
        cipher.init(2, key);
        return cipher.doFinal(input, offset, len);
    }

    public static byte[] decrypt(byte[] input, Key key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return EVP.decrypt(input, 0, input.length, key);
    }

    private static String getAlgorithmName(ASN1ObjectIdentifier oid) {
        String algorithm = ASN1Registry.o2a(oid);
        if (algorithm != null) {
            return algorithm.toUpperCase();
        }
        return oid.getId();
    }
}

