/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class X509Extensions {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void createX509Ext(Ruby runtime, RubyModule _X509) {
        RubyClass _ExtensionFactory = _X509.defineClassUnder("ExtensionFactory", runtime.getObject(), ExtensionFactory.ALLOCATOR);
        _ExtensionFactory.defineAnnotatedMethods(ExtensionFactory.class);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("ExtensionError", _OpenSSLError, _OpenSSLError.getAllocator());
        RubyClass _Extension = _X509.defineClassUnder("Extension", runtime.getObject(), Extension.ALLOCATOR);
        _Extension.defineAnnotatedMethods(Extension.class);
    }

    private static byte[] getSHA1Digest(Ruby runtime, byte[] bytes) {
        try {
            return SecurityHelper.getMessageDigest("SHA-1").digest(bytes);
        }
        catch (GeneralSecurityException e) {
            throw X509Extensions.newExtensionError(runtime, e.getMessage());
        }
    }

    private static RaiseException newExtensionError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("ExtensionError"), message);
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    private static boolean isHex(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (X509Extensions.isHex(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int upHex(char c) {
        switch (c) {
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case 'A': 
            case 'a': {
                return 65;
            }
            case 'B': 
            case 'b': {
                return 66;
            }
            case 'C': 
            case 'c': {
                return 67;
            }
            case 'D': 
            case 'd': {
                return 68;
            }
            case 'E': 
            case 'e': {
                return 69;
            }
            case 'F': 
            case 'f': {
                return 70;
            }
        }
        return -1;
    }

    private static ByteList hexBytes(byte[] data, int off) {
        int len = data.length - off;
        return X509Extensions.hexBytes(data, off, len, new ByteList(len * 3));
    }

    private static ByteList hexBytes(byte[] data, ByteList out) {
        return X509Extensions.hexBytes(data, 0, data.length, out);
    }

    private static ByteList hexBytes(byte[] data, int off, int len, ByteList out) {
        boolean notFist = false;
        out.ensure(len * 3 - 1);
        for (int i = off; i < off + len; ++i) {
            if (notFist) {
                out.append(58);
            }
            byte b = data[i];
            out.append((int)HEX[b >> 4 & 0xF]);
            out.append((int)HEX[b & 0xF]);
            notFist = true;
        }
        return out;
    }

    public static class Extension
    extends RubyObject {
        private static final long serialVersionUID = -1160318458085651926L;
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Extension(runtime, klass);
            }
        };
        private ASN1ObjectIdentifier oid;
        private Object value;
        private Boolean critical;
        private static final byte[] CA_ = new byte[]{67, 65, 58};
        private static final byte[] TRUE = new byte[]{84, 82, 85, 69};
        private static final byte[] FALSE = new byte[]{70, 65, 76, 83, 69};
        private static final byte[] _ = new byte[0];
        private static final byte[] SEP = new byte[]{44, 32};
        private static final byte[] Decipher_Only = new byte[]{68, 101, 99, 105, 112, 104, 101, 114, 32, 79, 110, 108, 121};
        private static final byte[] Digital_Signature = new byte[]{68, 105, 103, 105, 116, 97, 108, 32, 83, 105, 103, 110, 97, 116, 117, 114, 101};
        private static final byte[] Non_Repudiation = new byte[]{78, 111, 110, 32, 82, 101, 112, 117, 100, 105, 97, 116, 105, 111, 110};
        private static final byte[] Key_Encipherment = new byte[]{75, 101, 121, 32, 69, 110, 99, 105, 112, 104, 101, 114, 109, 101, 110, 116};
        private static final byte[] Data_Encipherment = new byte[]{68, 97, 116, 97, 32, 69, 110, 99, 105, 112, 104, 101, 114, 109, 101, 110, 116};
        private static final byte[] Key_Agreement = new byte[]{75, 101, 121, 32, 65, 103, 114, 101, 101, 109, 101, 110, 116};
        private static final byte[] Certificate_Sign = new byte[]{67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 83, 105, 103, 110};
        private static final byte[] CRL_Sign = new byte[]{67, 82, 76, 32, 83, 105, 103, 110};
        private static final byte[] Encipher_Only = new byte[]{69, 110, 99, 105, 112, 104, 101, 114, 32, 79, 110, 108, 121};
        private static final byte[] SSL_Client = new byte[]{83, 83, 76, 32, 67, 108, 105, 101, 110, 116};
        private static final byte[] SSL_Server = new byte[]{83, 83, 76, 32, 83, 101, 114, 118, 101, 114};
        private static final byte[] SSL_CA = new byte[]{83, 83, 76, 32, 67, 65};
        private static final byte[] SMIME = new byte[]{83, 47, 77, 73, 77, 69};
        private static final byte[] SMIME_CA = new byte[]{83, 47, 77, 73, 77, 69, 32, 67, 65};
        private static final byte[] Object_Signing = new byte[]{79, 98, 106, 101, 99, 116, 32, 83, 105, 103, 110, 105, 110, 103};
        private static final byte[] Object_Signing_CA = new byte[]{79, 98, 106, 101, 99, 116, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65};
        private static final byte[] Unused = new byte[]{85, 110, 117, 115, 101, 100};
        private static final byte[] Unspecified = new byte[]{85, 110, 115, 112, 101, 99, 105, 102, 105, 101, 100};
        private static final byte[] keyid_ = new byte[]{107, 101, 121, 105, 100, 58};

        public Extension(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        ASN1ObjectIdentifier getRealOid() {
            return this.oid;
        }

        void setRealOid(ASN1ObjectIdentifier oid) {
            this.oid = oid;
        }

        Object getRealValue() {
            return this.value;
        }

        void setRealValue(Object value) {
            this.value = value;
        }

        byte[] getRealValueBytes() throws IOException {
            if (this.value instanceof RubyString) {
                return ((RubyString)this.value).getBytes();
            }
            if (this.value instanceof String) {
                return ByteList.plain((CharSequence)((String)this.value));
            }
            if (this.value instanceof DEROctetString) {
                return ((DEROctetString)this.value).getOctets();
            }
            if (this.value instanceof ASN1Encodable) {
                return ((ASN1Encodable)this.value).toASN1Primitive().getEncoded("DER");
            }
            ASN1Encodable asn1Value = ((ASN1.ASN1Data)((Object)this.value)).toASN1(this.getRuntime().getCurrentContext());
            return asn1Value.toASN1Primitive().getEncoded("DER");
        }

        boolean isRealCritical() {
            return this.critical == null ? Boolean.FALSE.booleanValue() : this.critical.booleanValue();
        }

        void setRealCritical(boolean critical) {
            this.critical = critical;
        }

        private void setRealCritical(Boolean critical) {
            this.critical = critical;
        }

        @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(ThreadContext context, IRubyObject[] args) {
            byte[] octets = null;
            if (args.length == 1) {
                try {
                    ASN1InputStream asn1Stream = new ASN1InputStream(OpenSSLImpl.to_der_if_possible(context, args[0]).asString().getBytes());
                    ASN1Sequence seq = (ASN1Sequence)asn1Stream.readObject();
                    this.setRealOid((ASN1ObjectIdentifier)seq.getObjectAt(0));
                    this.setRealCritical(((DERBoolean)seq.getObjectAt(1)).isTrue());
                    octets = ((DEROctetString)seq.getObjectAt(2)).getOctets();
                }
                catch (IOException ioe) {
                    throw X509Extensions.newExtensionError(context.runtime, ioe.getMessage());
                }
            } else if (args.length > 1) {
                this.setRealOid(ASN1.getObjectIdentifier(context.runtime, args[0].toString()));
                this.setRealValue(args[1]);
            }
            if (args.length > 2) {
                this.setRealCritical(args[2].isTrue());
            }
            if (args.length > 0 && octets != null) {
                this.setRealValue(new String(ByteList.plain(octets)));
            }
            return this;
        }

        @JRubyMethod
        public IRubyObject oid(ThreadContext context) {
            String name = ASN1.oid2Sym(context.runtime, this.oid);
            if (name == null) {
                name = this.oid.toString();
            }
            return context.runtime.newString(name);
        }

        @JRubyMethod(name={"oid="})
        public IRubyObject set_oid(ThreadContext context, IRubyObject arg) {
            if (arg instanceof RubyString) {
                this.setRealOid(ASN1.getObjectIdentifier(context.runtime, arg.toString()));
                return arg;
            }
            throw context.runtime.newTypeError(arg, context.runtime.getString());
        }

        @JRubyMethod
        public IRubyObject value(ThreadContext context) {
            Ruby runtime = context.runtime;
            try {
                String realOid = this.getRealOid().getId();
                if (realOid.equals("2.5.29.19")) {
                    ASN1Sequence seq2 = (ASN1Sequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                    ByteList val = new ByteList(32);
                    if (seq2.size() > 0) {
                        val.append(CA_);
                        val.append(((DERBoolean)seq2.getObjectAt(0)).isTrue() ? TRUE : FALSE);
                    }
                    if (seq2.size() > 1) {
                        val.append(", pathlen:".getBytes());
                        val.append(seq2.getObjectAt(1).toString().getBytes());
                    }
                    return runtime.newString(val);
                }
                if (realOid.equals("2.5.29.15")) {
                    byte[] bytes = this.getRealValueBytes();
                    byte b1 = 0;
                    byte b2 = bytes[2];
                    if (bytes.length > 3) {
                        b1 = bytes[3];
                    }
                    ByteList val = new ByteList(64);
                    byte[] sep = _;
                    if ((b2 & 0xFFFFFF80) != 0) {
                        val.append(sep);
                        val.append(Decipher_Only);
                        sep = SEP;
                    }
                    if ((b1 & 0xFFFFFF80) != 0) {
                        val.append(sep);
                        val.append(Digital_Signature);
                        sep = SEP;
                    }
                    if ((b1 & 0x40) != 0) {
                        val.append(sep);
                        val.append(Non_Repudiation);
                        sep = SEP;
                    }
                    if ((b1 & 0x20) != 0) {
                        val.append(sep);
                        val.append(Key_Encipherment);
                        sep = SEP;
                    }
                    if ((b1 & 0x10) != 0) {
                        val.append(sep);
                        val.append(Data_Encipherment);
                        sep = SEP;
                    }
                    if ((b1 & 8) != 0) {
                        val.append(sep);
                        val.append(Key_Agreement);
                        sep = SEP;
                    }
                    if ((b1 & 4) != 0) {
                        val.append(sep);
                        val.append(Certificate_Sign);
                        sep = SEP;
                    }
                    if ((b1 & 2) != 0) {
                        val.append(sep);
                        val.append(CRL_Sign);
                        sep = SEP;
                    }
                    if ((b1 & 1) != 0) {
                        val.append(sep);
                        val.append(Encipher_Only);
                    }
                    return runtime.newString(val);
                }
                if (realOid.equals("2.16.840.1.113730.1.1")) {
                    byte b = this.getRealValueBytes()[0];
                    ByteList val = new ByteList(64);
                    byte[] sep = _;
                    if ((b & 0xFFFFFF80) != 0) {
                        val.append(sep);
                        val.append(SSL_Client);
                        sep = SEP;
                    }
                    if ((b & 0x40) != 0) {
                        val.append(sep);
                        val.append(SSL_Server);
                        sep = SEP;
                    }
                    if ((b & 0x20) != 0) {
                        val.append(sep);
                        val.append(SMIME);
                        sep = SEP;
                    }
                    if ((b & 0x10) != 0) {
                        val.append(sep);
                        val.append(Object_Signing);
                        sep = SEP;
                    }
                    if ((b & 8) != 0) {
                        val.append(sep);
                        val.append(Unused);
                        sep = SEP;
                    }
                    if ((b & 4) != 0) {
                        val.append(sep);
                        val.append(SSL_CA);
                        sep = SEP;
                    }
                    if ((b & 2) != 0) {
                        val.append(sep);
                        val.append(SMIME_CA);
                        sep = SEP;
                    }
                    if ((b & 1) != 0) {
                        val.append(sep);
                        val.append(Object_Signing_CA);
                    }
                    return runtime.newString(val);
                }
                if (realOid.equals("2.5.29.14")) {
                    byte[] bytes = this.getRealValueBytes();
                    return runtime.newString(X509Extensions.hexBytes(bytes, 2));
                }
                if (realOid.equals("2.5.29.35")) {
                    ASN1Sequence seq = (ASN1Sequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                    if (seq.size() == 0) {
                        return runtime.newString();
                    }
                    ByteList val = new ByteList(32);
                    val.append(keyid_);
                    ASN1Primitive keyid = seq.getObjectAt(0).toASN1Primitive();
                    byte[] bytes = keyid instanceof DEROctetString ? ((DEROctetString)keyid).getOctets() : keyid.getEncoded("DER");
                    return runtime.newString(X509Extensions.hexBytes(bytes, val));
                }
                if (realOid.equals("2.5.29.21")) {
                    IRubyObject val = ((IRubyObject)this.value).callMethod(context, "value");
                    switch (RubyNumeric.fix2int((IRubyObject)val)) {
                        case 0: {
                            return runtime.newString(new ByteList(Unspecified));
                        }
                        case 1: {
                            return runtime.newString("Key Compromise");
                        }
                        case 2: {
                            return runtime.newString("CA Compromise");
                        }
                        case 3: {
                            return runtime.newString("Affiliation Changed");
                        }
                        case 4: {
                            return runtime.newString("Superseded");
                        }
                        case 5: {
                            return runtime.newString("Cessation Of Operation");
                        }
                        case 6: {
                            return runtime.newString("Certificate Hold");
                        }
                        case 8: {
                            return runtime.newString("Remove From CRL");
                        }
                        case 9: {
                            return runtime.newString("Privilege Withdrawn");
                        }
                    }
                    return runtime.newString(new ByteList(Unspecified));
                }
                if (realOid.equals("2.5.29.17")) {
                    try {
                        ASN1Primitive seq = new ASN1InputStream(this.getRealValueBytes()).readObject();
                        GeneralName[] names = seq instanceof ASN1TaggedObject ? new GeneralName[]{GeneralName.getInstance((Object)seq)} : GeneralNames.getInstance((Object)seq).getNames();
                        StringBuilder val = new StringBuilder(48);
                        String sep = "";
                        for (int i = 0; i < names.length; ++i) {
                            GeneralName name = names[i];
                            val.append(sep);
                            if (name.getTagNo() == 2) {
                                val.append("DNS:");
                                val.append(((ASN1String)name.getName()).getString());
                            } else if (name.getTagNo() == 7) {
                                val.append("IP Address:");
                                byte[] bs = ((DEROctetString)name.getName()).getOctets();
                                String sep2 = "";
                                for (int j = 0; j < bs.length; ++j) {
                                    val.append(sep2).append(bs[j] & 0xFF);
                                    sep2 = ".";
                                }
                            } else {
                                val.append(name.toString());
                            }
                            sep = ", ";
                        }
                        return runtime.newString(val.toString());
                    }
                    catch (RuntimeException e) {
                        OpenSSLReal.debugStackTrace(runtime, e);
                        return runtime.newString(this.getRealValue().toString());
                    }
                }
                RubyString decoded = RubyString.newString((Ruby)runtime, (byte[])this.getRealValueBytes());
                try {
                    decoded = ASN1.decodeImpl(context, (IRubyObject)decoded);
                    return decoded.callMethod(context, "value").asString();
                }
                catch (IOException e) {
                    if (OpenSSLReal.isDebug(runtime)) {
                        e.printStackTrace(runtime.getOut());
                    }
                    return runtime.newString(this.getRealValue().toString());
                }
                catch (IllegalArgumentException e) {
                    return runtime.newString(this.getRealValue().toString());
                }
            }
            catch (IOException e) {
                throw X509Extensions.newExtensionError(runtime, e.getMessage());
            }
        }

        @JRubyMethod(name={"value="})
        public IRubyObject set_value(ThreadContext context, IRubyObject arg) {
            if (arg instanceof RubyString) {
                this.setRealValue(arg);
                return arg;
            }
            throw context.runtime.newTypeError(arg, context.runtime.getString());
        }

        @JRubyMethod(name={"critical?"})
        public IRubyObject critical_p() {
            return this.getRuntime().newBoolean(this.isRealCritical());
        }

        @JRubyMethod(name={"critical="})
        public IRubyObject set_critical(ThreadContext context, IRubyObject arg) {
            this.setRealCritical(arg.isTrue());
            return arg;
        }

        @JRubyMethod
        public IRubyObject to_der() {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            try {
                vec.add((ASN1Encodable)this.getRealOid());
                if (this.critical != null && this.critical.booleanValue()) {
                    vec.add((ASN1Encodable)DERBoolean.TRUE);
                }
                vec.add((ASN1Encodable)new DEROctetString(this.getRealValueBytes()));
                return RubyString.newString((Ruby)this.getRuntime(), (byte[])new DLSequence(vec).getEncoded("DER"));
            }
            catch (IOException e) {
                throw X509Extensions.newExtensionError(this.getRuntime(), e.getMessage());
            }
        }
    }

    public static class ExtensionFactory
    extends RubyObject {
        private static final long serialVersionUID = 3180447029639456500L;
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ExtensionFactory(runtime, klass);
            }
        };

        public ExtensionFactory(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
            Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)4);
            if (args.length > 0 && !args[0].isNil()) {
                this.set_issuer_cert(args[0]);
            }
            if (args.length > 1 && !args[1].isNil()) {
                this.set_subject_cert(args[1]);
            }
            if (args.length > 2 && !args[2].isNil()) {
                this.set_subject_req(args[2]);
            }
            if (args.length > 3 && !args[3].isNil()) {
                this.set_crl(args[3]);
            }
            return this;
        }

        @JRubyMethod(name={"issuer_certificate"})
        public IRubyObject issuer_cert() {
            return this.getInstanceVariable("@issuer_certificate");
        }

        @JRubyMethod(name={"issuer_certificate="})
        public IRubyObject set_issuer_cert(IRubyObject arg) {
            this.setInstanceVariable("@issuer_certificate", arg);
            return arg;
        }

        @JRubyMethod(name={"subject_certificate"})
        public IRubyObject subject_cert() {
            return this.getInstanceVariable("@subject_certificate");
        }

        @JRubyMethod(name={"subject_certificate="})
        public IRubyObject set_subject_cert(IRubyObject arg) {
            this.setInstanceVariable("@subject_certificate", arg);
            return arg;
        }

        @JRubyMethod(name={"subject_request"})
        public IRubyObject subject_req() {
            return this.getInstanceVariable("@subject_request");
        }

        @JRubyMethod(name={"subject_request="})
        public IRubyObject set_subject_req(IRubyObject arg) {
            this.setInstanceVariable("@subject_request", arg);
            return arg;
        }

        @JRubyMethod(name={"crl"})
        public IRubyObject crl() {
            return this.getInstanceVariable("@crl");
        }

        @JRubyMethod(name={"crl="})
        public IRubyObject set_crl(IRubyObject arg) {
            this.setInstanceVariable("@crl", arg);
            return arg;
        }

        @JRubyMethod(name={"config"})
        public IRubyObject config() {
            return this.getInstanceVariable("@config");
        }

        @JRubyMethod(name={"config="})
        public IRubyObject set_config(IRubyObject arg) {
            this.setInstanceVariable("@config", arg);
            return arg;
        }

        @JRubyMethod(rest=true)
        public IRubyObject create_ext(ThreadContext context, IRubyObject[] args) {
            ASN1ObjectIdentifier objectId;
            Ruby runtime = context.runtime;
            Object critical = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)3) == 3 && !args[2].isNil() ? args[2] : runtime.getFalse();
            String oid = args[0].toString();
            String valuex = args[1].toString();
            Object value = valuex;
            try {
                objectId = ASN1.getObjectIdentifier(runtime, oid);
            }
            catch (IllegalArgumentException e) {
                OpenSSLReal.debug(runtime, "ASN1.getObjectIdentifier() at ExtensionFactory.create_ext", e);
                throw X509Extensions.newExtensionError(runtime, "unknown OID `" + oid + "'");
            }
            if (valuex.startsWith("critical,")) {
                critical = runtime.getTrue();
                valuex = valuex.substring(9).trim();
            }
            try {
                String id = objectId.getId();
                if (id.equals("2.5.29.14")) {
                    DEROctetString inp = this.parseSubjectKeyIdentifier(context, oid, valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else if (id.equals("2.5.29.35")) {
                    DLSequence inp = this.parseAuthorityKeyIdentifier(context, valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else if (id.equals("2.5.29.18")) {
                    value = this.parseIssuerAltName(context, valuex);
                } else if (id.equals("2.5.29.19")) {
                    DLSequence inp = ExtensionFactory.parseBasicConstrains(valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else if (id.equals("2.5.29.15")) {
                    DERBitString inp = this.parseKeyUsage(oid, valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else {
                    value = id.equals("2.16.840.1.113730.1.1") ? this.parseNsCertType(oid, valuex) : (id.equals("2.5.29.17") ? this.parseSubjectAltName(valuex) : (id.equals("2.5.29.37") ? ExtensionFactory.parseExtendedKeyUsage(valuex) : new DEROctetString(new DEROctetString(ByteList.plain((CharSequence)valuex)).getEncoded("DER"))));
                }
            }
            catch (IOException e) {
                throw X509Extensions.newExtensionError(runtime, "Unable to create extension: " + e.getMessage());
            }
            Extension ext = (Extension)X509._X509(runtime).getClass("Extension").callMethod(context, "new");
            ext.setRealOid(objectId);
            ext.setRealValue(value);
            ext.setRealCritical(critical.isNil() ? null : Boolean.valueOf(critical.isTrue()));
            return ext;
        }

        private DERBitString parseKeyUsage(String oid, String valuex) {
            int i;
            byte[] inp;
            try {
                String[] val = valuex.split(":");
                inp = new byte[val.length];
                for (i = 0; i < val.length; ++i) {
                    inp[i] = (byte)Integer.parseInt(val[i], 16);
                }
            }
            catch (NumberFormatException e) {
                inp = null;
            }
            if (inp == null && valuex.length() < 3) {
                inp = ByteList.plain((CharSequence)valuex);
            }
            if (inp == null) {
                byte[] byArray;
                byte v1 = 0;
                int v2 = 0;
                String[] val = valuex.split(",");
                for (int i2 = 0; i2 < val.length; ++i2) {
                    String value = val[i2].trim();
                    if ("decipherOnly".equals(value) || "Decipher Only".equals(value)) {
                        v2 = (byte)(v2 | 0xFFFFFF80);
                        continue;
                    }
                    if ("digitalSignature".equals(value) || "Digital Signature".equals(value)) {
                        v1 = (byte)(v1 | 0xFFFFFF80);
                        continue;
                    }
                    if ("nonRepudiation".equals(value) || "Non Repudiation".equals(value)) {
                        v1 = (byte)(v1 | 0x40);
                        continue;
                    }
                    if ("keyEncipherment".equals(value) || "Key Encipherment".equals(value)) {
                        v1 = (byte)(v1 | 0x20);
                        continue;
                    }
                    if ("dataEncipherment".equals(value) || "Data Encipherment".equals(value)) {
                        v1 = (byte)(v1 | 0x10);
                        continue;
                    }
                    if ("keyAgreement".equals(value) || "Key Agreement".equals(value)) {
                        v1 = (byte)(v1 | 8);
                        continue;
                    }
                    if ("keyCertSign".equals(value) || "Key Cert Sign".equals(value)) {
                        v1 = (byte)(v1 | 4);
                        continue;
                    }
                    if ("cRLSign".equals(value)) {
                        v1 = (byte)(v1 | 2);
                        continue;
                    }
                    if ("encipherOnly".equals(value) || "Encipher Only".equals(value)) {
                        v1 = (byte)(v1 | 1);
                        continue;
                    }
                    throw X509Extensions.newExtensionError(this.getRuntime(), oid + " = " + valuex + ": unknown bit string argument");
                }
                if (v2 == 0) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = v1;
                } else {
                    byte[] byArray3 = new byte[2];
                    byArray3[0] = v1;
                    byArray = byArray3;
                    byArray3[1] = v2;
                }
                inp = byArray;
            }
            int unused = 0;
            for (i = inp.length - 1; i > -1; --i) {
                if (inp[i] == 0) {
                    unused += 8;
                    continue;
                }
                byte a2 = inp[i];
                int x = 8;
                while (a2 != 0) {
                    a2 = (byte)(a2 << 1);
                    --x;
                }
                unused += x;
                break;
            }
            return new DERBitString(inp, unused);
        }

        private DERBitString parseNsCertType(String oid, String valuex) {
            byte v = 0;
            if (valuex.length() < 3) {
                byte[] inp = ByteList.plain((CharSequence)valuex);
                v = inp[0];
            } else {
                String[] val = valuex.split(",");
                for (int i = 0; i < val.length; ++i) {
                    String value = val[i].trim();
                    if ("SSL Client".equals(value) || "client".equals(value)) {
                        v = (byte)(v | 0xFFFFFF80);
                        continue;
                    }
                    if ("SSL Server".equals(value) || "server".equals(value)) {
                        v = (byte)(v | 0x40);
                        continue;
                    }
                    if ("S/MIME".equals(value) || "email".equals(value)) {
                        v = (byte)(v | 0x20);
                        continue;
                    }
                    if ("Object Signing".equals(value) || "objsign".equals(value)) {
                        v = (byte)(v | 0x10);
                        continue;
                    }
                    if ("Unused".equals(value) || "reserved".equals(value)) {
                        v = (byte)(v | 8);
                        continue;
                    }
                    if ("SSL CA".equals(value) || "sslCA".equals(value)) {
                        v = (byte)(v | 4);
                        continue;
                    }
                    if ("S/MIME CA".equals(value) || "emailCA".equals(value)) {
                        v = (byte)(v | 2);
                        continue;
                    }
                    if ("Object Signing CA".equals(value) || "objCA".equals(value)) {
                        v = (byte)(v | 1);
                        continue;
                    }
                    throw X509Extensions.newExtensionError(this.getRuntime(), oid + " = " + valuex + ": unknown bit string argument");
                }
            }
            int unused = 0;
            if (v == 0) {
                unused += 8;
            } else {
                byte a2 = v;
                int x = 8;
                while (a2 != 0) {
                    a2 = (byte)(a2 << 1);
                    --x;
                }
                unused += x;
            }
            return new DERBitString(new byte[]{v}, unused);
        }

        private static DLSequence parseBasicConstrains(String valuex) {
            String value;
            int i;
            String[] val = valuex.split(",");
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (i = 0; i < val.length; ++i) {
                val[i] = val[i].trim();
                value = val[i];
                if (value.length() <= 3 || !value.substring(0, 3).equalsIgnoreCase("CA:")) continue;
                boolean isTrue = "true".equalsIgnoreCase(value.substring(3).trim());
                vec.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)isTrue));
            }
            for (i = 0; i < val.length; ++i) {
                value = val[i];
                if (value.length() <= 8 || !value.substring(0, 8).equalsIgnoreCase("pathlen:")) continue;
                int pathlen = Integer.parseInt(value.substring(8).trim());
                vec.add((ASN1Encodable)new ASN1Integer(BigInteger.valueOf(pathlen)));
            }
            return new DLSequence(vec);
        }

        private DLSequence parseAuthorityKeyIdentifier(ThreadContext context, String valuex) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            if (valuex.startsWith("keyid:always")) {
                vec.add((ASN1Encodable)new DEROctetString(this.derDigest(context)));
            } else if (valuex.startsWith("keyid")) {
                vec.add((ASN1Encodable)new DEROctetString(this.derDigest(context)));
            }
            return new DLSequence(vec);
        }

        private byte[] derDigest(ThreadContext context) {
            IRubyObject der;
            Ruby runtime = context.runtime;
            IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(context, "public_key");
            if (pkey instanceof PKeyRSA) {
                der = pkey.callMethod(context, "to_der");
            } else {
                der = ASN1.decode(context, (IRubyObject)ASN1._ASN1(runtime), pkey.callMethod(context, "to_der"));
                der = der.callMethod(context, "value").callMethod(context, "[]", (IRubyObject)runtime.newFixnum(1)).callMethod(context, "value");
            }
            return X509Extensions.getSHA1Digest(runtime, der.asString().getBytes());
        }

        private Object parseIssuerAltName(ThreadContext context, String valuex) throws IOException {
            if (valuex.startsWith("issuer:copy")) {
                RubyArray exts = (RubyArray)this.getInstanceVariable("@issuer_certificate").callMethod(context, "extensions");
                for (int i = 0; i < exts.size(); ++i) {
                    Extension ext = (Extension)exts.entry(i);
                    if (!ext.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.17"))) continue;
                    return ext.getRealValue();
                }
            }
            throw new IOException("Malformed IssuerAltName: " + valuex);
        }

        private String parseSubjectAltName(String valuex) throws IOException {
            if (valuex.startsWith("DNS:")) {
                String dns = valuex.substring(4);
                return ExtensionFactory.derEncoded(new GeneralName(2, (ASN1Encodable)new DERIA5String(dns)));
            }
            if (valuex.startsWith("IP:") || valuex.startsWith("IP Address:")) {
                int idx = valuex.charAt(2) == ':' ? 3 : 11;
                String[] numbers = valuex.substring(idx).split("\\.");
                byte[] ip = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                return ExtensionFactory.derEncoded(new GeneralName(7, (ASN1Encodable)new DEROctetString(ip)));
            }
            return valuex;
        }

        private static String derEncoded(GeneralName name) throws IOException {
            GeneralNames names = new GeneralNames(name);
            return new String(ByteList.plain((byte[])names.getEncoded("DER")));
        }

        private DEROctetString parseSubjectKeyIdentifier(ThreadContext context, String oid, String valuex) {
            if ("hash".equalsIgnoreCase(valuex)) {
                return new DEROctetString(this.derDigest(context));
            }
            if (valuex.length() == 20 || !X509Extensions.isHex(valuex)) {
                return new DEROctetString(ByteList.plain((CharSequence)valuex));
            }
            int len = valuex.length();
            ByteList hex = new ByteList(len / 2 + 1);
            for (int i = 0; i < len; i += 2) {
                if (i + 1 >= len) {
                    throw X509Extensions.newExtensionError(context.runtime, oid + " = " + valuex + ": odd number of digits");
                }
                int c1 = X509Extensions.upHex(valuex.charAt(i));
                int c2 = X509Extensions.upHex(valuex.charAt(i + 1));
                if (c1 != -1 && c2 != -1) {
                    hex.append(c1 << 4 & 0xF0 | c2 & 0xF);
                } else {
                    throw X509Extensions.newExtensionError(context.runtime, oid + " = " + valuex + ": illegal hex digit");
                }
                while (i + 2 < len && valuex.charAt(i + 2) == ':') {
                    ++i;
                }
            }
            byte[] hexBytes = new byte[hex.length()];
            System.arraycopy(hex.getUnsafeBytes(), hex.getBegin(), hexBytes, 0, hexBytes.length);
            return new DEROctetString(hexBytes);
        }

        private static DLSequence parseExtendedKeyUsage(String valuex) {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            for (String name : valuex.split(", ?")) {
                vector.add((ASN1Encodable)ASN1Registry.sym2oid(name));
            }
            return new DLSequence(vector);
        }
    }
}

