/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class X509Cert
extends RubyObject {
    private static final long serialVersionUID = 5626619026058595493L;
    private static ObjectAllocator X509CERT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Cert(runtime, klass);
        }
    };
    private IRubyObject serial;
    private RubyTime not_before;
    private RubyTime not_after;
    private IRubyObject issuer;
    private IRubyObject subject;
    private IRubyObject public_key;
    private IRubyObject sig_alg;
    private IRubyObject version;
    private final List<X509Extensions.Extension> extensions = new ArrayList<X509Extensions.Extension>();
    private boolean changed = true;
    private X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
    private X509Certificate cert;
    private String public_key_algorithm;
    private byte[] public_key_encoded;

    public static void createX509Cert(Ruby runtime, RubyModule _X509) {
        RubyClass _Certificate = _X509.defineClassUnder("Certificate", runtime.getObject(), X509CERT_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("CertificateError", _OpenSSLError, _OpenSSLError.getAllocator());
        _Certificate.defineAnnotatedMethods(X509Cert.class);
    }

    public X509Cert(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    X509AuxCertificate getAuxCert() {
        if (this.cert == null) {
            return null;
        }
        if (this.cert instanceof X509AuxCertificate) {
            return (X509AuxCertificate)this.cert;
        }
        return new X509AuxCertificate(this.cert);
    }

    public static IRubyObject wrap(Ruby runtime, Certificate cert) throws java.security.cert.CertificateEncodingException {
        RubyClass _Certificate = X509._X509(runtime).getClass("Certificate");
        RubyString encoded = RubyString.newString((Ruby)runtime, (byte[])cert.getEncoded());
        return _Certificate.callMethod(runtime.getCurrentContext(), "new", (IRubyObject)encoded);
    }

    public static IRubyObject wrap(Ruby runtime, javax.security.cert.Certificate cert) throws CertificateEncodingException {
        RubyClass _Certificate = X509._X509(runtime).getClass("Certificate");
        RubyString encoded = RubyString.newString((Ruby)runtime, (byte[])cert.getEncoded());
        return _Certificate.callMethod(runtime.getCurrentContext(), "new", (IRubyObject)encoded);
    }

    @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args, Block unusedBlock) {
        Set<String> nonCriticalExtOIDs;
        Ruby runtime = context.runtime;
        if (args.length == 0) {
            return this;
        }
        byte[] bytes = OpenSSLImpl.readX509PEM(context, args[0]);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        RubyModule _OpenSSL = runtime.getModule("OpenSSL");
        RubyModule _X509 = (RubyModule)_OpenSSL.getConstant("X509");
        RubyClass _Name = _X509.getClass("Name");
        try {
            this.cert = (X509Certificate)SecurityHelper.getCertificateFactory("X.509").generateCertificate(bis);
        }
        catch (CertificateException e) {
            throw X509Cert.newCertificateError(runtime, e);
        }
        if (this.cert == null) {
            throw X509Cert.newCertificateError(runtime, (String)null);
        }
        this.set_serial((IRubyObject)RubyNumeric.str2inum((Ruby)runtime, (RubyString)runtime.newString(this.cert.getSerialNumber().toString()), (int)10));
        this.set_not_before(context, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)this.cert.getNotBefore().getTime()));
        this.set_not_after(context, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)this.cert.getNotAfter().getTime()));
        bytes = this.cert.getSubjectX500Principal().getEncoded();
        this.set_subject(_Name.callMethod(context, "new", (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])bytes)));
        bytes = this.cert.getIssuerX500Principal().getEncoded();
        this.set_issuer(_Name.callMethod(context, "new", (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])bytes)));
        String algorithm = this.cert.getPublicKey().getAlgorithm();
        this.set_public_key(algorithm, this.cert.getPublicKey().getEncoded());
        IRubyObject extFact = ((RubyClass)_X509.getConstant("ExtensionFactory")).callMethod(context, "new");
        extFact.callMethod(context, "subject_certificate=", (IRubyObject)this);
        RubyModule _ASN1 = (RubyModule)_OpenSSL.getConstant("ASN1");
        RubyClass _Extension = _X509.getClass("Extension");
        Set<String> criticalExtOIDs = this.cert.getCriticalExtensionOIDs();
        if (criticalExtOIDs != null) {
            for (String extOID : criticalExtOIDs) {
                this.addExtension(context, _ASN1, _Extension, extOID, runtime.getTrue());
            }
        }
        if ((nonCriticalExtOIDs = this.cert.getNonCriticalExtensionOIDs()) != null) {
            for (String extOID : nonCriticalExtOIDs) {
                this.addExtension(context, _ASN1, _Extension, extOID, runtime.getFalse());
            }
        }
        this.changed = false;
        return this;
    }

    private void addExtension(ThreadContext context, RubyModule _ASN1, RubyClass _Extension, String extOID, RubyBoolean critical) {
        byte[] extValue = this.cert.getExtensionValue(extOID);
        if (extValue == null) {
            return;
        }
        RubyString extValueStr = context.runtime.newString(new ByteList(extValue, false));
        IRubyObject rValue = ASN1.decode(context, (IRubyObject)_ASN1, (IRubyObject)extValueStr).callMethod(context, "value");
        IRubyObject extension = _Extension.callMethod(context, "new", new IRubyObject[]{context.runtime.newString(extOID), rValue, critical});
        this.add_extension(extension);
    }

    private void set_public_key(String algorithm, byte[] encoded) {
        this.public_key_algorithm = algorithm;
        this.public_key_encoded = encoded;
    }

    private static RubyClass _CertificateError(Ruby runtime) {
        return X509._X509(runtime).getClass("CertificateError");
    }

    public static RaiseException newCertificateError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, X509Cert._CertificateError(runtime), e);
    }

    static RaiseException newCertificateError(Ruby runtime, String msg) {
        return Utils.newError(runtime, X509Cert._CertificateError(runtime), msg);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])this.cert.getEncoded());
        }
        catch (java.security.cert.CertificateEncodingException ex) {
            throw X509Cert.newCertificateError(this.getRuntime(), ex);
        }
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        StringWriter str = new StringWriter();
        try {
            PEMInputOutput.writeX509Certificate(str, this.getAuxCert());
            return this.getRuntime().newString(str.toString());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_text() {
        return this.getRuntime().newString(this.getAuxCert().toString());
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject version) {
        if (!version.equals(this.version)) {
            this.changed = true;
        }
        this.version = version;
        return this.version;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    @JRubyMethod
    public IRubyObject serial() {
        return this.serial;
    }

    @JRubyMethod(name={"serial="})
    public IRubyObject set_serial(IRubyObject serial) {
        String serialStr;
        if (!serial.equals(this.serial)) {
            this.changed = true;
        }
        BigInteger serialInt = (serialStr = serial.toString()).equals("0") ? BigInteger.ONE : new BigInteger(serialStr);
        this.generator.setSerialNumber(new BigInteger(1, serialInt.toByteArray()));
        this.serial = serial;
        return this.serial;
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject;
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject subject) {
        if (!subject.equals(this.subject)) {
            this.changed = true;
        }
        this.generator.setSubjectDN(((X509Name)subject).getRealName());
        this.subject = subject;
        return this.subject;
    }

    @JRubyMethod
    public IRubyObject issuer() {
        return this.issuer;
    }

    @JRubyMethod(name={"issuer="})
    public IRubyObject set_issuer(IRubyObject issuer) {
        if (!issuer.equals(this.issuer)) {
            this.changed = true;
        }
        this.generator.setIssuerDN(((X509Name)issuer).getRealName());
        this.issuer = issuer;
        return this.issuer;
    }

    @JRubyMethod
    public IRubyObject not_before() {
        return this.not_before;
    }

    @JRubyMethod(name={"not_before="})
    public IRubyObject set_not_before(ThreadContext context, IRubyObject time) {
        this.changed = true;
        this.not_before = (RubyTime)time.callMethod(context, "getutc");
        this.not_before.setMicroseconds(0L);
        this.generator.setNotBefore(this.not_before.getJavaDate());
        return time;
    }

    @JRubyMethod
    public IRubyObject not_after() {
        return this.not_after;
    }

    @JRubyMethod(name={"not_after="})
    public IRubyObject set_not_after(ThreadContext context, IRubyObject time) {
        this.changed = true;
        this.not_after = (RubyTime)time.callMethod(context, "getutc");
        this.not_after.setMicroseconds(0L);
        this.generator.setNotAfter(this.not_after.getJavaDate());
        return time;
    }

    @JRubyMethod
    public IRubyObject public_key(ThreadContext context) {
        if (this.public_key == null) {
            this.lazyInitializePublicKey(context);
        }
        return this.public_key.callMethod(context, "public_key");
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject public_key) {
        if (!(public_key instanceof PKey)) {
            throw this.getRuntime().newTypeError("OpenSSL::PKey::PKey expected but got " + public_key.getMetaClass().getName());
        }
        if (!public_key.equals(this.public_key)) {
            this.changed = true;
        }
        this.generator.setPublicKey(((PKey)public_key).getPublicKey());
        this.public_key = public_key;
        return this.public_key;
    }

    private void lazyInitializePublicKey(ThreadContext context) {
        if (this.public_key_encoded == null || this.public_key_algorithm == null) {
            throw new IllegalStateException("lazy public key initialization failed");
        }
        RubyModule _OpenSSL = context.runtime.getModule("OpenSSL");
        RubyModule _PKey = (RubyModule)_OpenSSL.getConstant("PKey");
        boolean _changed = this.changed;
        if ("RSA".equalsIgnoreCase(this.public_key_algorithm)) {
            RubyString encoded = RubyString.newString((Ruby)context.runtime, (byte[])this.public_key_encoded);
            this.set_public_key(_PKey.getConstant("RSA").callMethod(context, "new", (IRubyObject)encoded));
        } else if ("DSA".equalsIgnoreCase(this.public_key_algorithm)) {
            RubyString encoded = RubyString.newString((Ruby)context.runtime, (byte[])this.public_key_encoded);
            this.set_public_key(_PKey.getConstant("DSA").callMethod(context, "new", (IRubyObject)encoded));
        } else {
            throw X509Cert.newCertificateError(context.runtime, "The algorithm " + this.public_key_algorithm + " is unsupported for public keys");
        }
        this.changed = _changed;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context, IRubyObject key, IRubyObject digest) {
        Ruby runtime = context.runtime;
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getShortAlgorithm();
        String digName = ((Digest)digest).name().toString();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(digName)) {
            throw X509Cert.newCertificateError(runtime, "signature_algorithm not supported");
        }
        for (X509Extensions.Extension ext : this.extensions) {
            try {
                byte[] bytes = ext.getRealValueBytes();
                this.generator.addExtension((DERObjectIdentifier)ext.getRealOid(), ext.isRealCritical(), bytes);
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
        }
        this.generator.setSignatureAlgorithm(digAlg + "WITH" + keyAlg);
        if (this.public_key == null) {
            this.lazyInitializePublicKey(context);
        }
        try {
            this.cert = this.generator.generate(((PKey)key).getPrivateKey());
        }
        catch (GeneralSecurityException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        if (this.cert == null) {
            throw X509Cert.newCertificateError(runtime, (String)null);
        }
        String name = ASN1Registry.o2a(this.cert.getSigAlgOID());
        if (name == null) {
            name = this.cert.getSigAlgOID();
        }
        this.sig_alg = runtime.newString(name);
        this.changed = false;
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject key) {
        if (this.changed) {
            return this.getRuntime().getFalse();
        }
        try {
            this.cert.verify(((PKey)key).getPublicKey());
            return this.getRuntime().getTrue();
        }
        catch (CertificateException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (NoSuchProviderException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (SignatureException e) {
            return this.getRuntime().getFalse();
        }
        catch (InvalidKeyException e) {
            return this.getRuntime().getFalse();
        }
    }

    @JRubyMethod
    public IRubyObject check_private_key(IRubyObject arg) {
        PKey key = (PKey)arg;
        PublicKey pubKey = key.getPublicKey();
        PublicKey certPubKey = this.getAuxCert().getPublicKey();
        if (certPubKey.equals(pubKey)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject extensions() {
        List<X509Extensions.Extension> extensions = this.extensions;
        return this.getRuntime().newArray(extensions);
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject array) {
        this.extensions.clear();
        this.extensions.addAll((List)array);
        return array;
    }

    @JRubyMethod
    public IRubyObject add_extension(IRubyObject ext) {
        this.changed = true;
        X509Extensions.Extension newExtension = (X509Extensions.Extension)ext;
        ASN1ObjectIdentifier oid = newExtension.getRealOid();
        if (oid.getId().equals("2.5.29.17")) {
            boolean one = true;
            for (X509Extensions.Extension curExtension : this.extensions) {
                if (!curExtension.getRealOid().equals((Object)oid)) continue;
                ASN1EncodableVector v1 = new ASN1EncodableVector();
                try {
                    int i;
                    GeneralName[] n1 = GeneralNames.getInstance((Object)new ASN1InputStream(curExtension.getRealValueBytes()).readObject()).getNames();
                    GeneralName[] n2 = GeneralNames.getInstance((Object)new ASN1InputStream(newExtension.getRealValueBytes()).readObject()).getNames();
                    for (i = 0; i < n1.length; ++i) {
                        v1.add((ASN1Encodable)n1[i]);
                    }
                    for (i = 0; i < n2.length; ++i) {
                        v1.add((ASN1Encodable)n2[i]);
                    }
                    GeneralNames v1Names = GeneralNames.getInstance((Object)new DLSequence(v1));
                    curExtension.setRealValue(new String(ByteList.plain((byte[])v1Names.getEncoded("DER"))));
                }
                catch (IOException ex) {
                    throw this.getRuntime().newIOErrorFromException(ex);
                }
                one = false;
                break;
            }
            if (one) {
                this.extensions.add(newExtension);
            }
        } else {
            this.extensions.add(newExtension);
        }
        return ext;
    }
}

