/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Revoked;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509CRL
extends RubyObject {
    private static final long serialVersionUID = -2463300006179688577L;
    private static ObjectAllocator X509CRL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509CRL(runtime, klass);
        }
    };
    private IRubyObject version;
    private IRubyObject issuer;
    private IRubyObject last_update;
    private IRubyObject next_update;
    private IRubyObject revoked;
    private RubyArray extensions;
    private IRubyObject sig_alg;
    private boolean changed = true;
    private final X509V2CRLGenerator generator = new X509V2CRLGenerator();
    private java.security.cert.X509CRL crl;
    private ASN1Primitive crl_v;
    private static final String IND8 = "        ";
    private static final String IND12 = "            ";
    private static final String IND16 = "                ";
    private static final DateFormat ASN_DATE = new SimpleDateFormat("MMM dd HH:mm:ss yyyy zzz");

    public static void createX509CRL(Ruby runtime, RubyModule _X509) {
        RubyClass _CRL = _X509.defineClassUnder("CRL", runtime.getObject(), X509CRL_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("CRLError", _OpenSSLError, _OpenSSLError.getAllocator());
        _CRL.defineAnnotatedMethods(X509CRL.class);
    }

    java.security.cert.X509CRL getCRL() {
        return this.crl;
    }

    public X509CRL(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args, Block block) {
        Ruby runtime = context.runtime;
        this.extensions = runtime.newArray();
        this.revoked = runtime.newArray();
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            this.issuer = this.version = runtime.getNil();
            this.next_update = this.last_update = runtime.getNil();
            return this;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(args[0].convertToString().getBytes());
        try {
            CertificateFactory x509 = OpenSSLReal.getX509CertificateFactoryBC();
            this.crl = (java.security.cert.X509CRL)x509.generateCRL(bis);
        }
        catch (GeneralSecurityException e) {
            throw X509CRL.newCRLError(runtime, e.getMessage());
        }
        byte[] crl_bytes = OpenSSLImpl.readX509PEM(context, args[0]);
        try {
            this.crl_v = new ASN1InputStream((InputStream)new ByteArrayInputStream(crl_bytes)).readObject();
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
        ASN1Sequence seqa = (ASN1Sequence)((ASN1Sequence)this.crl_v).getObjectAt(0);
        ASN1Encodable v0 = seqa.getObjectAt(0);
        if (v0 instanceof ASN1Integer) {
            this.set_version((IRubyObject)runtime.newFixnum(((ASN1Integer)v0).getValue().intValue()));
        } else {
            this.set_version((IRubyObject)runtime.newFixnum(2));
        }
        this.set_last_update(context, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)this.crl.getThisUpdate().getTime()));
        this.set_next_update(context, (IRubyObject)RubyTime.newTime((Ruby)runtime, (long)this.crl.getNextUpdate().getTime()));
        RubyString name = RubyString.newString((Ruby)runtime, (byte[])this.crl.getIssuerX500Principal().getEncoded());
        RubyModule _OpenSSL = runtime.getModule("OpenSSL");
        RubyModule _X509 = (RubyModule)_OpenSSL.getConstant("X509");
        this.set_issuer(_X509.getClass("Name").callMethod(context, "new", (IRubyObject)name));
        ASN1Primitive maybe_ext = (ASN1Primitive)seqa.getObjectAt(seqa.size() - 1);
        if (maybe_ext instanceof ASN1TaggedObject && ((ASN1TaggedObject)maybe_ext).getTagNo() == 0) {
            RubyModule _ASN1 = (RubyModule)_OpenSSL.getConstant("ASN1");
            RubyClass _Extension = _X509.getClass("Extension");
            ASN1Sequence exts = (ASN1Sequence)((ASN1TaggedObject)maybe_ext).getObject();
            for (int i = 0; i < exts.size(); ++i) {
                RubyString realValue;
                ASN1Sequence extSeq = (ASN1Sequence)exts.getObjectAt(i);
                boolean critical = false;
                if (extSeq.getObjectAt(1) == DERBoolean.TRUE) {
                    critical = true;
                }
                String oid = ((ASN1ObjectIdentifier)extSeq.getObjectAt(0)).getId();
                byte[] valueBytes = this.crl.getExtensionValue(oid);
                try {
                    RubyString value = RubyString.newString((Ruby)runtime, (byte[])valueBytes);
                    value = ASN1.decodeImpl(context, _ASN1, (IRubyObject)value).callMethod(context, "value");
                    realValue = ASN1.decodeImpl(context, _ASN1, (IRubyObject)value);
                }
                catch (Exception e) {
                    if (OpenSSLReal.isDebug(runtime)) {
                        e.printStackTrace(runtime.getOut());
                    }
                    realValue = RubyString.newString((Ruby)runtime, (byte[])valueBytes);
                }
                X509Extensions.Extension ext = (X509Extensions.Extension)_Extension.callMethod(context, "new");
                ext.setRealOid(ASN1.getObjectIdentifier(context.runtime, oid));
                ext.setRealValue(realValue);
                ext.setRealCritical(critical);
                this.extensions.append((IRubyObject)ext);
            }
        }
        this.changed = false;
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: CRL#init_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem(ThreadContext context) {
        StringWriter writer = new StringWriter();
        try {
            PEMInputOutput.writeX509CRL(writer, this.crl);
            return context.runtime.newString(writer.toString());
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(context.runtime, e);
        }
    }

    @JRubyMethod
    public IRubyObject to_der(ThreadContext context) {
        try {
            return RubyString.newString((Ruby)context.runtime, (byte[])this.crl_v.getEncoded());
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(context.runtime, e);
        }
    }

    @JRubyMethod
    public IRubyObject to_text(ThreadContext context) {
        Ruby runtime = context.runtime;
        StringBuilder text = new StringBuilder(128);
        text.append("Certificate Revocation List (CRL):\n");
        text.append(IND8).append("Version ").append(RubyNumeric.fix2int((IRubyObject)this.version) + 1).append(" (0x");
        text.append(Integer.toString(RubyNumeric.fix2int((IRubyObject)this.version), 16)).append(")\n");
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)((ASN1Sequence)((ASN1Sequence)this.crl_v).getObjectAt(1)).getObjectAt(0);
        text.append(IND8).append("Signature Algorithm: ").append(ASN1.nid2ln(runtime, ASN1.obj2nid(runtime, oid))).append("\n");
        text.append(IND8).append("Issuer: ").append(this.issuer()).append("\n");
        text.append(IND8).append("Last Update: ").append(ASN_DATE.format(((RubyTime)this.last_update()).getJavaDate())).append("\n");
        if (!this.next_update().isNil()) {
            text.append(IND8).append("Next Update: ").append(ASN_DATE.format(((RubyTime)this.next_update()).getJavaDate())).append("\n");
        } else {
            text.append(IND8).append("Next Update: NONE\n");
        }
        if (this.extensions.size() > 0) {
            text.append(IND8).append("CRL extensions\n");
            for (int i = 0; i < this.extensions.size(); ++i) {
                X509Extensions.Extension ext = (X509Extensions.Extension)this.extensions.entry(i);
                ASN1ObjectIdentifier oiden = ext.getRealOid();
                text.append(IND12).append(ASN1.o2a(runtime, oiden)).append(": ");
                if (ext.isRealCritical()) {
                    text.append("critical");
                }
                text.append("\n");
                text.append(IND16).append(ext.value(context)).append("\n");
            }
        }
        return runtime.newString(text.toString());
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject val) {
        if (!val.equals(this.version)) {
            this.changed = true;
        }
        this.version = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    @JRubyMethod
    public IRubyObject issuer() {
        return this.issuer;
    }

    @JRubyMethod(name={"issuer="})
    public IRubyObject set_issuer(IRubyObject issuer) {
        if (!issuer.equals(this.issuer)) {
            this.changed = true;
        }
        this.generator.setIssuerDN(((X509Name)issuer).getRealName());
        this.issuer = issuer;
        return this.issuer;
    }

    @JRubyMethod
    public IRubyObject last_update() {
        return this.last_update;
    }

    @JRubyMethod(name={"last_update="})
    public IRubyObject set_last_update(ThreadContext context, IRubyObject val) {
        this.changed = true;
        RubyTime value = (RubyTime)val.callMethod(context, "getutc");
        value.setMicroseconds(0L);
        this.generator.setThisUpdate(value.getJavaDate());
        this.last_update = val;
        return this.last_update;
    }

    @JRubyMethod
    public IRubyObject next_update() {
        return this.next_update;
    }

    @JRubyMethod(name={"next_update="})
    public IRubyObject set_next_update(ThreadContext context, IRubyObject val) {
        this.changed = true;
        RubyTime value = (RubyTime)val.callMethod(context, "getutc");
        value.setMicroseconds(0L);
        this.generator.setNextUpdate(value.getJavaDate());
        this.next_update = val;
        return this.next_update;
    }

    @JRubyMethod
    public IRubyObject revoked() {
        return this.revoked;
    }

    @JRubyMethod(name={"revoked="})
    public IRubyObject set_revoked(IRubyObject revoked) {
        this.changed = true;
        this.revoked = revoked;
        return this.revoked;
    }

    @JRubyMethod
    public IRubyObject add_revoked(ThreadContext context, IRubyObject val) {
        this.changed = true;
        this.revoked.callMethod(context, "<<", val);
        return val;
    }

    @JRubyMethod
    public IRubyObject extensions() {
        return this.extensions;
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject extensions) {
        this.extensions = (RubyArray)extensions;
        return extensions;
    }

    @JRubyMethod
    public IRubyObject add_extension(IRubyObject extension) {
        this.extensions.append(extension);
        return extension;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context, IRubyObject key, IRubyObject digest) {
        int i;
        Ruby runtime = context.runtime;
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getShortAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(((Digest)digest).name().toString()) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(((Digest)digest).name().toString())) {
            throw X509CRL.newCRLError(runtime, "unsupported key / digest algorithm (" + key + " / " + digAlg + ")");
        }
        this.sig_alg = runtime.newString(digAlg);
        this.generator.setSignatureAlgorithm(digAlg + "WITH" + keyAlg);
        RubyArray revoked = (RubyArray)this.revoked;
        for (i = 0; i < revoked.size(); ++i) {
            X509Revoked rev = (X509Revoked)revoked.entry(i);
            BigInteger serial = new BigInteger(rev.callMethod(context, "serial").toString());
            RubyTime t1 = (RubyTime)rev.callMethod(context, "time").callMethod(context, "getutc");
            t1.setMicroseconds(0L);
            this.generator.addCRLEntry(serial, t1.getJavaDate(), new X509Extensions(new Hashtable()));
        }
        try {
            for (i = 0; i < this.extensions.size(); ++i) {
                X509Extensions.Extension ext = (X509Extensions.Extension)this.extensions.entry(i);
                this.generator.addExtension((DERObjectIdentifier)ext.getRealOid(), ext.isRealCritical(), ext.getRealValueBytes());
            }
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
        PrivateKey privateKey = ((PKey)key).getPrivateKey();
        try {
            this.crl = this.generator.generate(privateKey);
        }
        catch (IllegalStateException e) {
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw X509CRL.newCRLError(runtime, e);
        }
        catch (GeneralSecurityException e) {
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw X509CRL.newCRLError(runtime, e.getMessage());
        }
        try {
            this.crl_v = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.crl.getEncoded())).readObject();
        }
        catch (CRLException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
        catch (IOException e) {
            throw X509CRL.newCRLError(runtime, e);
        }
        ASN1Sequence v1 = (ASN1Sequence)((ASN1Sequence)this.crl_v).getObjectAt(0);
        ASN1EncodableVector build1 = new ASN1EncodableVector();
        int copyIndex = 0;
        if (v1.getObjectAt(0) instanceof ASN1Integer) {
            ++copyIndex;
        }
        build1.add((ASN1Encodable)new ASN1Integer(new BigInteger(this.version.toString())));
        while (copyIndex < v1.size()) {
            build1.add(v1.getObjectAt(copyIndex++));
        }
        ASN1EncodableVector build2 = new ASN1EncodableVector();
        build2.add((ASN1Encodable)new DLSequence(build1));
        build2.add(((ASN1Sequence)this.crl_v).getObjectAt(1));
        build2.add(((ASN1Sequence)this.crl_v).getObjectAt(2));
        this.crl_v = new DLSequence(build2);
        this.changed = false;
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(ThreadContext context, IRubyObject key) {
        if (this.changed) {
            return context.runtime.getFalse();
        }
        PublicKey publicKey = ((PKey)key).getPublicKey();
        try {
            boolean valid = SecurityHelper.verify(this.crl, publicKey, true);
            return context.runtime.newBoolean(valid);
        }
        catch (CRLException e) {
            return context.runtime.getFalse();
        }
        catch (InvalidKeyException e) {
            return context.runtime.getFalse();
        }
        catch (SignatureException e) {
            return context.runtime.getFalse();
        }
        catch (NoSuchAlgorithmException e) {
            return context.runtime.getFalse();
        }
    }

    private static RubyBoolean printExceptionAndGetFalse(Ruby runtime, Exception e) {
        if (OpenSSLReal.isDebug(runtime)) {
            e.printStackTrace(runtime.getOut());
        }
        return runtime.getFalse();
    }

    private static RubyClass _CRLError(Ruby runtime) {
        return X509._X509(runtime).getClass("CertificateError");
    }

    static RaiseException newCRLError(Ruby runtime, Exception e) {
        return Utils.newError(runtime, X509CRL._CRLError(runtime), e);
    }

    private static RaiseException newCRLError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509CRL._CRLError(runtime), message);
    }
}

