/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.SecureRandom;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Random {
    public static void createRandom(Ruby runtime, RubyModule ossl) {
        RubyModule random = ossl.defineModuleUnder("Random");
        RubyClass osslError = (RubyClass)ossl.getConstant("OpenSSLError");
        random.defineClassUnder("RandomError", osslError, osslError.getAllocator());
        random.defineAnnotatedMethods(Random.class);
        random.dataWrapStruct((Object)new RandomHolder(new java.util.Random(), SecurityHelper.getSecureRandom()));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject seed(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return context.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_random_file(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return context.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject write_random_file(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return context.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject random_bytes(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return Random.generate(context.runtime, self, arg, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject pseudo_bytes(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return Random.generate(context.runtime, self, arg, false);
    }

    private static RubyString generate(Ruby runtime, IRubyObject self, IRubyObject arg, boolean secure) {
        int len = RubyNumeric.fix2int((IRubyObject)arg);
        if (len < 0 || len > Integer.MAX_VALUE) {
            throw runtime.newArgumentError("negative string size (or size too big) " + len);
        }
        RandomHolder holder = (RandomHolder)self.dataGetStruct();
        byte[] bytes = new byte[len];
        (secure ? holder.secureRandom : holder.plainRandom).nextBytes(bytes);
        return RubyString.newString((Ruby)runtime, (ByteList)new ByteList(bytes, false));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return context.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd_bytes(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        return context.runtime.getNil();
    }

    static class RandomHolder {
        final java.util.Random plainRandom;
        final SecureRandom secureRandom;

        RandomHolder(java.util.Random plainRandom, SecureRandom secureRandom) {
            this.plainRandom = plainRandom;
            this.secureRandom = secureRandom;
        }
    }
}

