/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.logging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.cli.logging.BaseSlf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.codehaus.plexus.util.PropertyUtils;
import org.slf4j.ILoggerFactory;

public class Slf4jConfigurationFactory {
    public static final String RESOURCE = "META-INF/maven/slf4j-configuration.properties";

    public static Slf4jConfiguration getConfiguration(ILoggerFactory loggerFactory) {
        try {
            Enumeration<URL> resources = Slf4jConfigurationFactory.class.getClassLoader().getResources(RESOURCE);
            String key = loggerFactory.getClass().getCanonicalName();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Properties conf = PropertyUtils.loadProperties((InputStream)resource.openStream());
                String impl = conf.getProperty(key);
                if (impl == null) continue;
                return (Slf4jConfiguration)Class.forName(impl).newInstance();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new BaseSlf4jConfiguration();
    }
}

