/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.codehaus.plexus.util.IOUtil;

public class Constants {
    private static Properties polyglotProperties = Constants.getPolyglotMavenProperties();

    public static String getGroupId() {
        return polyglotProperties.getProperty("groupId");
    }

    public static String getArtifactId(String postfix) {
        return polyglotProperties.getProperty("prefix") + postfix;
    }

    public static String getVersion() {
        return polyglotProperties.getProperty("version");
    }

    public static String getGAV(String postfix) {
        return Constants.getGroupId() + ":" + Constants.getArtifactId(postfix) + ":" + Constants.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPolyglotMavenProperties() {
        InputStream resourceAsStream;
        Properties properties;
        block4: {
            properties = new Properties();
            resourceAsStream = null;
            try {
                resourceAsStream = Constants.class.getClassLoader().getResourceAsStream("maven-polyglot.properties");
                if (resourceAsStream == null) break block4;
                properties.load(resourceAsStream);
            }
            catch (IOException e) {
                try {
                    System.err.println("Unable determine version from JAR file: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtil.close(resourceAsStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)resourceAsStream);
            }
        }
        IOUtil.close((InputStream)resourceAsStream);
        return properties;
    }
}

