/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.asn1;

import impl.krypt.asn1.ParseException;
import impl.krypt.asn1.ParsedHeader;
import impl.krypt.asn1.Parser;
import impl.krypt.asn1.ParserFactory;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.Streams;
import org.jruby.ext.krypt.asn1.RubyHeader;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyParser
extends RubyObject {
    private static ObjectAllocator PARSER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass type) {
            return new RubyParser(runtime, type);
        }
    };
    private static RubyClass cHeader;
    private final Parser parser = new ParserFactory().newHeaderParser();

    public static void createParser(Ruby runtime, RubyModule mASN1) {
        mASN1.defineClassUnder("Parser", runtime.getObject(), PARSER_ALLOCATOR).defineAnnotatedMethods(RubyParser.class);
        cHeader = ((RubyModule)runtime.getModule("Krypt").getConstant("ASN1")).getClass("Header");
    }

    public RubyParser(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext ctx) {
        return this;
    }

    @JRubyMethod
    public IRubyObject next(ThreadContext ctx, IRubyObject io) {
        Ruby runtime = ctx.getRuntime();
        InputStream in = RubyParser.asStream(runtime, io);
        return this.parseHeader(runtime, cHeader, in);
    }

    private IRubyObject parseHeader(Ruby runtime, RubyClass headerClass, InputStream in) {
        try {
            ParsedHeader h = this.parser.next(in);
            if (h == null) {
                return runtime.getNil();
            }
            return new RubyHeader(runtime, headerClass, h);
        }
        catch (ParseException ex) {
            throw Errors.newParseError(runtime, ex.getMessage());
        }
    }

    private static InputStream asStream(Ruby runtime, IRubyObject obj) {
        if (!obj.respondsTo("read")) {
            throw Errors.newError(runtime, "ArgumentError", "Object must respond to read");
        }
        return Streams.tryWrapAsInputStream(runtime, obj);
    }
}

