/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1;

public enum TagClass {
    UNIVERSAL(0),
    APPLICATION(64),
    CONTEXT_SPECIFIC(-128),
    PRIVATE(-64);

    private final byte mask;

    private TagClass(byte mask) {
        this.mask = mask;
    }

    public static TagClass forName(String name) {
        if ("IMPLICIT".equals(name)) {
            return CONTEXT_SPECIFIC;
        }
        if ("EXPLICIT".equals(name)) {
            return CONTEXT_SPECIFIC;
        }
        return TagClass.valueOf(name);
    }

    public byte getMask() {
        return this.mask;
    }

    public static TagClass of(byte b) {
        switch (b) {
            case 0: {
                return UNIVERSAL;
            }
            case 64: {
                return APPLICATION;
            }
            case -128: {
                return CONTEXT_SPECIFIC;
            }
            case -64: {
                return PRIVATE;
            }
        }
        throw new IllegalArgumentException("Unknown tag class: " + b);
    }

    private static class Masks {
        static final byte UNIVERSAL_MASK = 0;
        static final byte APPLICATION_MASK = 64;
        static final byte CONTEXT_SPECIFIC_MASK = -128;
        static final byte PRIVATE_MASK = -64;

        private Masks() {
        }
    }
}

