/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository.layout;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.repository.layout.RepositoryLayout;

public final class MavenDefaultLayout
implements RepositoryLayout {
    private URI toUri(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public URI getPath(Artifact artifact) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return this.toUri(path.toString());
    }

    public URI getPath(Metadata metadata) {
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path.append(metadata.getVersion()).append('/');
                }
            }
        }
        path.append(metadata.getType());
        return this.toUri(path.toString());
    }
}

