/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;

public abstract class ChangeCommand
extends AbstractCommand {
    protected ChangeDescription changeDescription;
    protected Notifier notifier;
    protected Collection notifiers;
    protected ChangeRecorder changeRecorder;

    protected ChangeCommand(ChangeRecorder changeRecorder) {
        if (changeRecorder.isRecording()) {
            new IllegalStateException("The changeRecorder cannot be currently recording.");
        }
        this.changeRecorder = changeRecorder;
    }

    public ChangeCommand(ChangeRecorder changeRecorder, Notifier notifier) {
        this(changeRecorder);
        this.notifier = notifier;
    }

    public ChangeCommand(Notifier notifier) {
        this.notifier = notifier;
    }

    public ChangeCommand(ChangeRecorder changeRecorder, Collection notifiers) {
        this(changeRecorder);
        this.notifiers = notifiers;
    }

    public ChangeCommand(Collection notifiers) {
        this.notifiers = notifiers;
    }

    public void dispose() {
        this.changeRecorder = null;
        this.notifier = null;
        this.notifiers = null;
        this.changeDescription = null;
        super.dispose();
    }

    public ChangeRecorder getChangeRecorder() {
        return this.changeRecorder;
    }

    protected ChangeRecorder createChangeRecorder() {
        return new ChangeRecorder();
    }

    protected ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    protected void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    protected boolean prepare() {
        return this.getChangeDescription() == null;
    }

    public boolean canUndo() {
        return this.getChangeDescription() != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        ChangeRecorder changeRecorder = this.getChangeRecorder();
        if (changeRecorder == null) {
            changeRecorder = this.createChangeRecorder();
        }
        changeRecorder.beginRecording(this.notifier != null ? Collections.singleton(this.notifier) : this.notifiers);
        try {
            this.doExecute();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setChangeDescription(changeRecorder.endRecording());
            this.disposeChangeRecorder(changeRecorder);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setChangeDescription(changeRecorder.endRecording());
            this.disposeChangeRecorder(changeRecorder);
            return;
        }
    }

    protected abstract void doExecute();

    protected void disposeChangeRecorder(ChangeRecorder changeRecorder) {
        if (changeRecorder != this.getChangeRecorder()) {
            changeRecorder.dispose();
        }
    }

    public void undo() {
        this.getChangeDescription().applyAndReverse();
    }

    public void redo() {
        this.getChangeDescription().applyAndReverse();
    }
}

