#
# Notification Originator
#
# Send SNMP notification using the following options:
#
# * SNMPv3
# * with local snmpEngineId = 0x8000000001020304
# * with user 'usr-sha-aes128', auth: SHA, priv: AES128
# * over IPv4/UDP
# * send TRAP notification
# * with TRAP ID 'authenticationFailure' specified as a MIB symbol
# * do not include any additional managed object information
#
# SNMPv3 TRAPs requires pre-sharing the Notification Originator's
# value of SnmpEngineId with Notification Receiver. To facilitate that
# we will use static (e.g. not autogenerated) version of snmpEngineId.
#
from pysnmp.entity import engine
from pysnmp.entity.rfc3413.oneliner import ntforg
from pysnmp.proto import rfc1902

# This SNMP Engine ID value should also be configured to TRAP receiver.
snmpEngineId = rfc1902.OctetString(hexValue='8000000001020304')

ntfOrg = ntforg.NotificationOriginator(engine.SnmpEngine(snmpEngineId))

errorIndication = ntfOrg.sendNotification(
    ntforg.UsmUserData('usr-sha-aes128', 'authkey1', 'privkey1',
                       authProtocol=ntforg.usmHMACSHAAuthProtocol,
                       privProtocol=ntforg.usmAesCfb128Protocol),
    ntforg.UdpTransportTarget(('127.0.0.1', 162)),
    'trap',
    ntforg.MibVariable('SNMPv2-MIB', 'authenticationFailure')
)

if errorIndication:
    print('Notification not sent: %s' % errorIndication)
