/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZOrderManager
extends WindowAdapter {
    private static ZOrderManager instance;
    private static Logger logger;
    private List<WeakReference<RootPaneContainer>> zOrder = new ArrayList<WeakReference<RootPaneContainer>>();
    private Set<WeakReference<RootPaneContainer>> excludeSet = new HashSet<WeakReference<RootPaneContainer>>();

    private ZOrderManager() {
    }

    public static ZOrderManager getInstance() {
        if (instance == null) {
            instance = new ZOrderManager();
        }
        return instance;
    }

    public void attachWindow(RootPaneContainer rootPaneContainer) {
        logger.entering(this.getClass().getName(), "attachWindow");
        if (!(rootPaneContainer instanceof Window)) {
            throw new IllegalArgumentException("Argument must be subclas of java.awt.Window: " + rootPaneContainer);
        }
        if (this.getWeak(rootPaneContainer) != null) {
            throw new IllegalArgumentException("Window already attached: " + rootPaneContainer);
        }
        this.zOrder.add(new WeakReference<RootPaneContainer>(rootPaneContainer));
        ((Window)((Object)rootPaneContainer)).addWindowListener(this);
    }

    public boolean detachWindow(RootPaneContainer rootPaneContainer) {
        logger.entering(this.getClass().getName(), "detachWindow");
        if (!(rootPaneContainer instanceof Window)) {
            throw new IllegalArgumentException("Argument must be subclas of java.awt.Window: " + rootPaneContainer);
        }
        WeakReference<RootPaneContainer> weakReference = this.getWeak(rootPaneContainer);
        if (weakReference == null) {
            return false;
        }
        ((Window)((Object)rootPaneContainer)).removeWindowListener(this);
        return this.zOrder.remove(weakReference);
    }

    public void setExcludeFromOrder(RootPaneContainer rootPaneContainer, boolean bl) {
        if (bl) {
            this.excludeSet.add(new WeakReference<RootPaneContainer>(rootPaneContainer));
        } else {
            WeakReference<RootPaneContainer> weakReference = this.getExcludedWeak(rootPaneContainer);
            if (weakReference != null) {
                this.excludeSet.remove(weakReference);
            }
        }
    }

    public void clear() {
        for (WeakReference<RootPaneContainer> weakReference : this.zOrder) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)weakReference.get();
            if (rootPaneContainer == null) continue;
            ((Window)((Object)rootPaneContainer)).removeWindowListener(this);
        }
        this.zOrder.clear();
    }

    public boolean isOnTop(RootPaneContainer rootPaneContainer, Point point) {
        logger.entering(this.getClass().getName(), "isOnTop");
        int n = this.zOrder.size();
        WeakReference<RootPaneContainer> weakReference = null;
        RootPaneContainer rootPaneContainer2 = null;
        for (int i = n - 1; i >= 0; --i) {
            weakReference = this.zOrder.get(i);
            if (weakReference == null || this.getExcludedWeak(rootPaneContainer2 = (RootPaneContainer)weakReference.get()) != null) continue;
            if (rootPaneContainer2 == rootPaneContainer) {
                return true;
            }
            Window window = (Window)((Object)rootPaneContainer2);
            Point point2 = new Point(point);
            SwingUtilities.convertPointFromScreen(point2, window);
            if (!window.contains(point2)) continue;
            return false;
        }
        return rootPaneContainer == WindowManager.getDefault().getMainWindow();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        logger.entering(this.getClass().getName(), "windowActivated");
        WeakReference<RootPaneContainer> weakReference = this.getWeak((RootPaneContainer)((Object)windowEvent.getWindow()));
        if (weakReference == null) {
            throw new IllegalArgumentException("Window not attached: " + windowEvent.getWindow());
        }
        this.zOrder.remove(weakReference);
        this.zOrder.add(weakReference);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private WeakReference<RootPaneContainer> getWeak(RootPaneContainer rootPaneContainer) {
        for (WeakReference<RootPaneContainer> weakReference : this.zOrder) {
            if (weakReference.get() != rootPaneContainer) continue;
            return weakReference;
        }
        return null;
    }

    private WeakReference<RootPaneContainer> getExcludedWeak(RootPaneContainer rootPaneContainer) {
        for (WeakReference<RootPaneContainer> weakReference : this.excludeSet) {
            if (weakReference.get() != rootPaneContainer) continue;
            return weakReference;
        }
        return null;
    }

    static {
        logger = Logger.getLogger("org.netbeans.core.windows.view.dnd");
    }
}

