/*
 * Decompiled with CFR 0.152.
 */
package tr.model.project;

import javax.swing.ImageIcon;
import tr.model.IDGenerator;
import tr.model.Item.AbstractItem;
import tr.model.Item.Item;
import tr.model.Item.ItemList;
import tr.model.topic.Topic;
import tr.util.Utils;

public class BrainstormItem
extends AbstractItem {
    protected Topic topic;
    protected String notes;

    public BrainstormItem(IDGenerator idGenerator) {
        super(idGenerator);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.notifyObservers(this);
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        if (this.topic != null) {
            this.topic.removeObserver(this);
        }
        this.topic = topic;
        if (this.topic != null) {
            this.topic.addObserver(this);
        }
        this.notifyObservers(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BrainstormItem)) {
            return false;
        }
        BrainstormItem bs = (BrainstormItem)object;
        if (!Utils.equal((Object)this.topic, (Object)bs.topic)) {
            return false;
        }
        if (!Utils.equal((Object)this.notes, (Object)bs.notes)) {
            return false;
        }
        return super.equals(object);
    }

    public ImageIcon getIcon(boolean expanded) {
        return null;
    }

    public void resetObservers() {
        if (this.topic != null) {
            this.topic.addObserver(this);
        }
        super.resetObservers();
    }

    public Item copy(IDGenerator idGenerator) {
        BrainstormItem copy = new BrainstormItem(idGenerator);
        copy.parent = this.parent;
        copy.description = this.description;
        copy.topic = this.topic;
        copy.notes = this.notes;
        return copy;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public boolean isWithin(ItemList list) {
        if (list == null || this.parent == null) {
            return false;
        }
        if (list == this.parent) {
            return true;
        }
        return this.parent.isWithin(list);
    }

    public int compareTo(Item item) {
        if (item instanceof BrainstormItem) {
            return this.getDescription().compareToIgnoreCase(((BrainstormItem)item).getDescription());
        }
        throw new ClassCastException(item.getClass().toString());
    }
}

