/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.calendar;

import java.util.Date;

public class DateSpan {
    private long _start;
    private long _end;

    public DateSpan(long l, long l2) {
        this._start = l;
        this._end = l2;
        if (this._start > this._end) {
            throw new IllegalArgumentException("Start date must be before end date");
        }
    }

    public DateSpan(Date date, Date date2) {
        this(date.getTime(), date2.getTime());
    }

    public long getStart() {
        return this._start;
    }

    public long getEnd() {
        return this._end;
    }

    public Date getStartAsDate() {
        return new Date(this.getStart());
    }

    public Date getEndAsDate() {
        return new Date(this.getEnd());
    }

    public boolean contains(DateSpan dateSpan) {
        return this.contains(dateSpan.getStart()) && this.contains(dateSpan.getEnd());
    }

    public boolean contains(long l) {
        return l >= this.getStart() && l <= this.getEnd();
    }

    public boolean contains(long l, long l2) {
        return l >= this.getStart() && l2 <= this.getEnd();
    }

    public boolean intersects(long l, long l2) {
        return l <= this.getEnd() && l2 >= this.getStart();
    }

    public boolean intersects(DateSpan dateSpan) {
        return this.intersects(dateSpan.getStart(), dateSpan.getEnd());
    }

    public DateSpan add(DateSpan dateSpan) {
        return this.add(dateSpan.getStart(), dateSpan.getEnd());
    }

    public DateSpan add(long l, long l2) {
        return new DateSpan(Math.min(l, this.getStart()), Math.max(l2, this.getEnd()));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DateSpan) {
            DateSpan dateSpan = (DateSpan)object;
            return this._start == dateSpan.getStart() && this._end == dateSpan.getEnd();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (int)(this._start ^ this._start >>> 32);
        n = 37 * n + (int)(this._end ^ this._end >>> 32);
        return n;
    }

    public String toString() {
        return "DateSpan [" + this.getStartAsDate() + "-" + this.getEndAsDate() + "]";
    }
}

