/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RTFUtility {
    private static final Pattern RTF_PATTERN = Pattern.compile("(\\\\\\\\)|(\\\\~)|(\\{\\\\stylesheet.*\\{.*\\}\\{.*\\}\\})|(\\{\\\\[A-Za-z]* .*\\})|(\\\\[A-Za-z]* .*;\\})|(\\\\[A-Za-z]*-?[0-9]* .*;\\})|(\\\\[A-Za-z]*-?[0-9]+ )|(\\\\[A-Za-z]*-?[0-9]+)|(\\\\\\*)|(\\\\[A-Za-z]* )|(\\\\[A-Za-z]*)|(\\\\\\{)|(\\\\\\})|(\\{)|(\\})|(\\r\\n)");
    private static final Map<String, String> RTF_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> LOCALEID_MAPPING;

    public String strip(String string) {
        string = this.processDoubleByteChars(string);
        string = this.regexpStrip(string);
        return string;
    }

    private String processDoubleByteChars(String string) {
        String[] stringArray = string.split("\\\\");
        int n = 0;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl2 = true;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string3.length() != 0) {
                String string4;
                if (string3.charAt(0) == '\'') {
                    if (!bl) {
                        bl = true;
                    }
                    linkedList.add(string3.substring(1, 3));
                    if (string3.length() > 3) {
                        string4 = this.processBytes(linkedList, string2);
                        if (bl2) {
                            bl2 = false;
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(string4);
                        bl = false;
                        linkedList.clear();
                        stringBuffer.append(string3.substring(3));
                    }
                    ++n;
                    continue;
                }
                if (bl) {
                    string4 = this.processBytes(linkedList, string2);
                    if (bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(string4);
                    bl = false;
                    linkedList.clear();
                }
                if (string3.startsWith("lang") || string3.startsWith("deflang")) {
                    string2 = this.processEncoding(string3);
                }
            }
            bl2 = true;
            if (n != 0) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string3);
            ++n;
        }
        return stringBuffer.toString();
    }

    private String processEncoding(String string) {
        CharSequence charSequence;
        int n;
        String string2 = null;
        for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n != string.length()) {
            charSequence = new StringBuffer(string.length());
            while (n < string.length() && Character.isDigit(string.charAt(n))) {
                ((StringBuffer)charSequence).append(string.charAt(n));
                ++n;
            }
            string2 = ((StringBuffer)charSequence).toString();
        }
        if ((charSequence = LOCALEID_MAPPING.get(string2)) == null) {
            charSequence = "Cp1252";
        }
        return charSequence;
    }

    private String processBytes(LinkedList<String> linkedList, String string) {
        byte[] byArray = new byte[linkedList.size()];
        int n = 0;
        for (String string2 : linkedList) {
            byArray[n++] = Integer.decode("0x" + string2).byteValue();
        }
        Object object = "";
        try {
            object = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return object;
    }

    private String regexpStrip(String string) {
        string = this.stripCommands("{\\object", string);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Matcher matcher = RTF_PATTERN.matcher(string);
            int n = 0;
            while (matcher.find()) {
                String string2;
                String string3;
                if (matcher.start() != n) {
                    string3 = string.substring(n, matcher.start());
                    stringBuffer.append(string3);
                }
                if ((string2 = RTF_MAPPING.get(string3 = matcher.group().trim())) != null) {
                    stringBuffer.append(string2);
                }
                n = matcher.end();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return stringBuffer.toString();
    }

    private String stripCommands(String string, String string2) {
        int n = string2.indexOf(string);
        if (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            do {
                int n2;
                int n3 = 1;
                block5: for (n2 = n + 1; n3 != 0 && n2 < stringBuffer.length(); ++n2) {
                    char c = stringBuffer.charAt(n2);
                    switch (c) {
                        case '{': {
                            ++n3;
                            continue block5;
                        }
                        case '}': {
                            --n3;
                        }
                    }
                }
                if (n3 != 0) break;
                stringBuffer.replace(n, --n2, "");
            } while ((n = stringBuffer.indexOf(string, n)) != -1);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    static {
        RTF_MAPPING.put("\\par", "\n");
        RTF_MAPPING.put("\\tab", "\t");
        RTF_MAPPING.put("\\\\", "\\");
        RTF_MAPPING.put("\\{", "{");
        RTF_MAPPING.put("\\}", "}");
        RTF_MAPPING.put("\\rquote", "\ufffd");
        RTF_MAPPING.put("\\endash", "\ufffd");
        RTF_MAPPING.put("\\ldblquote", "\ufffd");
        RTF_MAPPING.put("\\rdblquote", "\ufffd");
        RTF_MAPPING.put("\\~", "\ufffd");
        LOCALEID_MAPPING = new HashMap<String, String>();
        LOCALEID_MAPPING.put("1025", "Cp1256");
        LOCALEID_MAPPING.put("1026", "Cp1251");
        LOCALEID_MAPPING.put("1028", "Cp950");
        LOCALEID_MAPPING.put("1029", "Cp1250");
        LOCALEID_MAPPING.put("1032", "Cp1253");
        LOCALEID_MAPPING.put("1037", "Cp1255");
        LOCALEID_MAPPING.put("1038", "Cp1250");
        LOCALEID_MAPPING.put("1041", "SJIS");
        LOCALEID_MAPPING.put("1042", "Cp949");
        LOCALEID_MAPPING.put("1045", "Cp1250");
        LOCALEID_MAPPING.put("1048", "Cp1250");
        LOCALEID_MAPPING.put("1049", "Cp1251");
        LOCALEID_MAPPING.put("1050", "Cp1250");
        LOCALEID_MAPPING.put("1051", "Cp1250");
        LOCALEID_MAPPING.put("1052", "Cp1250");
        LOCALEID_MAPPING.put("1054", "Cp874");
        LOCALEID_MAPPING.put("1055", "Cp1254");
        LOCALEID_MAPPING.put("1056", "Cp1256");
        LOCALEID_MAPPING.put("1058", "Cp1251");
        LOCALEID_MAPPING.put("1059", "Cp1251");
        LOCALEID_MAPPING.put("1060", "Cp1250");
        LOCALEID_MAPPING.put("1061", "Cp1257");
        LOCALEID_MAPPING.put("1062", "Cp1257");
        LOCALEID_MAPPING.put("1063", "Cp1257");
        LOCALEID_MAPPING.put("1065", "Cp1256");
        LOCALEID_MAPPING.put("1066", "Cp1258");
        LOCALEID_MAPPING.put("1068", "Cp1254");
        LOCALEID_MAPPING.put("1071", "Cp1251");
        LOCALEID_MAPPING.put("1087", "Cp1251");
        LOCALEID_MAPPING.put("1088", "Cp1251");
        LOCALEID_MAPPING.put("1091", "Cp1254");
        LOCALEID_MAPPING.put("1092", "Cp1251");
        LOCALEID_MAPPING.put("1104", "Cp1251");
        LOCALEID_MAPPING.put("2049", "Cp1256");
        LOCALEID_MAPPING.put("2052", "MS936");
        LOCALEID_MAPPING.put("2074", "Cp1250");
        LOCALEID_MAPPING.put("2092", "Cp1251");
        LOCALEID_MAPPING.put("2115", "Cp1251");
        LOCALEID_MAPPING.put("3073", "Cp1256");
        LOCALEID_MAPPING.put("3076", "Cp950");
        LOCALEID_MAPPING.put("3098", "Cp1251");
        LOCALEID_MAPPING.put("4097", "Cp1256");
        LOCALEID_MAPPING.put("4100", "MS936");
        LOCALEID_MAPPING.put("5121", "Cp1256");
        LOCALEID_MAPPING.put("5124", "Cp950");
        LOCALEID_MAPPING.put("6145", "Cp1256");
        LOCALEID_MAPPING.put("7169", "Cp1256");
        LOCALEID_MAPPING.put("8193", "Cp1256");
        LOCALEID_MAPPING.put("9217", "Cp1256");
        LOCALEID_MAPPING.put("10241", "Cp1256");
        LOCALEID_MAPPING.put("11265", "Cp1256");
        LOCALEID_MAPPING.put("12289", "Cp1256");
        LOCALEID_MAPPING.put("13313", "Cp1256");
        LOCALEID_MAPPING.put("14337", "Cp1256");
        LOCALEID_MAPPING.put("15361", "Cp1256");
        LOCALEID_MAPPING.put("16385", "Cp1256");
    }
}

