/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimescaleAlignment implements MpxjEnum
{
    LEFT(0, "Left"),
    CENTER(1, "Center"),
    RIGHT(2, "Right");

    private static final TimescaleAlignment[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private TimescaleAlignment(int n2, String string2) {
        this.m_value = n2;
        this.m_name = string2;
    }

    public static TimescaleAlignment getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = CENTER.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static TimescaleAlignment getInstance(Number number) {
        int n = number == null ? -1 : NumberUtility.getInt(number);
        return TimescaleAlignment.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (TimescaleAlignment[])EnumUtility.createTypeArray(TimescaleAlignment.class);
    }
}

