/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.criticalpath;

import com.projity.association.AssociationList;
import com.projity.datatype.Duration;
import com.projity.grouping.core.Node;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class TaskSchedule
implements Cloneable {
    public static final int CURRENT = 0;
    public static final int EARLY = -1;
    public static final int LATE = 1;
    private double percentComplete = 0.0;
    private long rawDuration;
    private long start;
    private long finish;
    private Task task;
    private int type;
    private boolean forward = true;
    private long dependencyDate = -1L;
    private long remainingDependencyDate = 0L;

    public TaskSchedule() {
    }

    public TaskSchedule(Task task, int n) {
        this.init(task, n);
        this.start = 0L;
        this.finish = 0L;
    }

    public void init(Task task, int n) {
        this.task = task;
        this.type = n;
        if (n == -1) {
            this.forward = true;
        } else if (n == 1) {
            this.forward = false;
        }
        this.dependencyDate = -1L;
        this.invalidate();
    }

    public void initSerialized(Task task, int n) {
        this.task = task;
        this.type = n;
        if (n == -1) {
            this.forward = true;
        } else if (n == 1) {
            this.forward = false;
        }
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeDouble(this.percentComplete);
        objectOutputStream.writeLong(this.rawDuration);
        objectOutputStream.writeLong(this.start);
        objectOutputStream.writeLong(this.finish);
    }

    public static TaskSchedule deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        TaskSchedule taskSchedule = new TaskSchedule();
        taskSchedule.setPercentComplete(objectInputStream.readDouble());
        taskSchedule.setRawDuration(objectInputStream.readLong());
        taskSchedule.setStart(objectInputStream.readLong());
        taskSchedule.setFinish(objectInputStream.readLong());
        return taskSchedule;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object cloneWithTask(Task task) {
        TaskSchedule taskSchedule = (TaskSchedule)this.clone();
        taskSchedule.setTask(task);
        taskSchedule.invalidate();
        return taskSchedule;
    }

    public long getBegin() {
        return this.forward ? this.start : -this.finish;
    }

    public long getEnd() {
        return this.forward ? this.finish : -this.start;
    }

    public long getWindowBegin() {
        return this.forward ? this.task.getWindowEarlyStart() : -this.task.getWindowLateFinish();
    }

    public long getWindowEnd() {
        return this.forward ? this.task.getWindowEarlyFinish() : -this.task.getWindowLateStart();
    }

    public void setBegin(long l) {
        if (this.forward) {
            this.start = l;
        } else {
            this.finish = -l;
        }
    }

    public void setEnd(long l) {
        if (this.forward) {
            this.finish = l;
        } else {
            this.start = -l;
        }
    }

    public long getBeginDependency() {
        if (this.dependencyDate == -1L) {
            this.dependencyDate = this.calcDependencyDate();
        }
        return this.dependencyDate;
    }

    public final void invalidate() {
        if (this.task != null && this.task.isSubproject() && !((SubProj)((Object)this.task)).isValidAndOpen()) {
            return;
        }
        this.start = 0L;
        this.finish = 0L;
        this.dependencyDate = -1L;
    }

    public void copyDatesAfterClone(TaskSchedule taskSchedule) {
        this.start = taskSchedule.start;
        this.finish = taskSchedule.finish;
        this.dependencyDate = taskSchedule.dependencyDate;
    }

    final void invalidateDependencyDate() {
        this.dependencyDate = -1L;
    }

    public final double getPercentComplete() {
        return this.percentComplete;
    }

    public final void setPercentComplete(double d) {
        this.percentComplete = d;
    }

    public final long getRawDuration() {
        return this.rawDuration;
    }

    public final void setRawDuration(long l) {
        this.rawDuration = l;
    }

    private final boolean isLate() {
        return this.type == 1;
    }

    public final long getDependencyDate() {
        return this.dependencyDate;
    }

    public final void setDependencyDate(long l) {
        this.dependencyDate = l;
    }

    public final long getFinish() {
        return this.finish;
    }

    public final void setFinish(long l) {
        this.finish = l;
    }

    public final long getStart() {
        return this.start;
    }

    public final void setStart(long l) {
        this.start = l;
    }

    public TaskSchedule getOppositeSchedule() {
        return this.task.getSchedule(this.forward ? 1 : -1);
    }

    public final boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean bl) {
        if (this.forward != bl) {
            this.forward = bl;
            long l = this.start;
            this.start = -this.finish;
            this.finish = -l;
            this.dependencyDate = -this.dependencyDate;
            this.remainingDependencyDate = -this.remainingDependencyDate;
        }
    }

    public final void setRemainingDependencyDate(long l) {
        this.remainingDependencyDate = l;
    }

    public final long getRemainingDependencyDate() {
        return this.remainingDependencyDate;
    }

    final boolean affectsCriticalPath(CalculationContext calculationContext) {
        if (this.task.isOrWasCritical()) {
            return true;
        }
        this.calcStartAndFinish(calculationContext);
        long l = this.getEnd();
        long l2 = -this.getOppositeSchedule().getBegin();
        return l2 < l;
    }

    final void calcDates(CalculationContext calculationContext) {
        Cloneable cloneable;
        long l = this.getBegin();
        long l2 = this.getEnd();
        long l3 = 0L;
        long l4 = 0L;
        boolean bl = this.task.isSubproject() && !((SubProj)((Object)this.task)).isValidAndOpen();
        boolean bl2 = this.task.isExternal();
        if (!bl2 && !bl) {
            if (calculationContext.taskReferenceType == 1) {
                this.assignDatesFromChildren(calculationContext);
            } else {
                this.calcStartAndFinish(calculationContext);
            }
            l3 = this.getBegin();
            l4 = this.getEnd();
            boolean bl3 = this.task.isReverseScheduled();
            if (!calculationContext.earlyOnly && bl3) {
                cloneable = this.getOppositeSchedule();
                l3 = -((TaskSchedule)cloneable).getEnd();
                l4 = -((TaskSchedule)cloneable).getBegin();
            }
            if (calculationContext.assign && !bl) {
                cloneable = this.task.getCurrentSchedule();
                if (l3 < 0L) {
                    ((TaskSchedule)cloneable).setStart(-l4);
                    ((TaskSchedule)cloneable).setFinish(-l3);
                    ((TaskSchedule)cloneable).setRemainingDependencyDate(-this.remainingDependencyDate);
                } else {
                    ((TaskSchedule)cloneable).setStart(l3);
                    ((TaskSchedule)cloneable).setFinish(l4);
                    ((TaskSchedule)cloneable).setRemainingDependencyDate(this.remainingDependencyDate);
                }
                ((TaskSchedule)cloneable).setDependencyDate(this.dependencyDate);
                if (calculationContext.taskReferenceType == 1) {
                    super.updateDurationFromDates();
                    ((NormalTask)((TaskSchedule)cloneable).task).assignActualDatesFromChildren();
                }
            }
        } else if (bl2) {
            TaskSchedule taskSchedule = this.task.getCurrentSchedule();
            l3 = taskSchedule.getBegin();
            l4 = taskSchedule.getEnd();
            l = 0L;
        }
        if (l == l3 && l2 == l4 && !bl) {
            return;
        }
        if (bl) {
            l3 = l;
            l4 = l2;
        }
        AssociationList associationList = this.task.getDependencyList(!this.forward);
        cloneable = this.task.getWbsParentTask();
        TaskSchedule taskSchedule = null;
        long l5 = 0L;
        if (cloneable != null) {
            taskSchedule = ((Task)cloneable).getSchedule(this.type);
            l5 = taskSchedule.getEnd();
        }
        if (calculationContext.taskReferenceType == -1) {
            if (l != l3) {
                this.flagChildren();
                this.setDependencyDate(l3);
                if (l5 == l2) {
                    this.setEnd(-1L);
                } else {
                    this.setEnd(0L);
                }
            }
            return;
        }
        if (associationList.isEmpty()) {
            Dependency dependency;
            if (!this.task.isExternal() && this.task != calculationContext.sentinel && (dependency = (Dependency)calculationContext.sentinel.getDependencyList(this.forward).find(this.forward, this.task)) != null) {
                dependency.calcDependencyDate(this.forward, l3, l4, false);
                calculationContext.sentinel.setCalculationStateCount(calculationContext.stateCount);
                calculationContext.sentinel.getSchedule(this.type).setDependencyDate(-1L);
            }
        } else {
            for (Dependency dependency : associationList) {
                if (dependency.isDisabled()) continue;
                Task task = (Task)dependency.getTask(!this.forward);
                TaskSchedule taskSchedule2 = task.getSchedule(this.type);
                long l6 = task.getDependencyList(this.forward).size();
                long l7 = l3;
                if (l6 > 0L) {
                    boolean bl4 = !task.isWbsParent() && task.hasDuration();
                    l7 = dependency.calcDependencyDate(this.forward, l3, l4, bl4);
                    if (l6 > 1L) {
                        l7 = -1L;
                    }
                }
                taskSchedule2.setDependencyDate(l7);
                task.setCalculationStateCount(calculationContext.stateCount);
            }
        }
        if (cloneable != null && ((Task)cloneable).getCalculationStateCount() != calculationContext.stateCount) {
            long l8 = taskSchedule.getBegin();
            if (l2 == 0L || l2 == -1L) {
                ((Task)cloneable).setCalculationStateCount(calculationContext.stateCount);
            } else if (l2 != l4 && (l4 > l5 || l2 == l5) || l != l3 && (l3 < l8 || l == l8)) {
                ((Task)cloneable).setCalculationStateCount(calculationContext.stateCount);
            }
        }
        if (calculationContext.pass == 1) {
            this.task.setCalculationStateCount(calculationContext.stateCount + 1);
        }
    }

    private void flagChildren() {
        int n = this.task.getCalculationStateCount();
        Collection collection = this.task.getWbsChildrenNodes();
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof Task)) continue;
            ((Task)object).setCalculationStateCount(n);
        }
    }

    private void updateDurationFromDates() {
        this.setRawDuration(this.task.getEffectiveWorkCalendar().compare(this.getFinish(), this.getStart(), false));
    }

    public void assignDatesFromChildren(CalculationContext calculationContext) {
        long l;
        Collection collection = this.task.getWbsChildrenNodes();
        if (collection == null) {
            return;
        }
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        Iterator iterator = collection.iterator();
        boolean bl = false;
        int n = this.type;
        if (calculationContext != null && calculationContext.pass == 3) {
            n = 0;
        }
        while (iterator.hasNext()) {
            long l4;
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof NormalTask)) continue;
            NormalTask normalTask = (NormalTask)object;
            bl |= normalTask.isEstimated();
            TaskSchedule taskSchedule = normalTask.getSchedule(n);
            l = taskSchedule.getBegin();
            if (l != 0L) {
                l2 = Math.min(l2, l);
            }
            if ((l4 = taskSchedule.getEnd()) == 0L) continue;
            l3 = Math.max(l3, l4);
        }
        if (l2 == Long.MAX_VALUE || l2 == 0L) {
            return;
        }
        this.setBegin(l2);
        if (l3 == Long.MIN_VALUE || l3 == 0L) {
            return;
        }
        this.setEnd(l3);
        l = this.task.getEffectiveWorkCalendar().compare(l3, l2, false);
        l = Duration.setAsEstimated(l, bl);
        ((NormalTask)this.task).setEstimated(bl);
        this.setRawDuration(l);
    }

    long calcDependencyDate() {
        long l = 0L;
        AssociationList associationList = this.task.getDependencyList(this.forward);
        for (Dependency dependency : associationList) {
            if (dependency.isDisabled()) continue;
            long l2 = dependency.getDate(this.forward);
            if (l == 0L) {
                l = l2;
                continue;
            }
            l = Math.max(l, l2);
        }
        this.setDependencyDate(l);
        return l;
    }

    private void calcStartAndFinish(CalculationContext calculationContext) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        boolean bl;
        long l6 = this.getBeginDependency();
        Task task = this.task.getWbsParentTask();
        boolean bl2 = bl = !this.task.hasDuration();
        if (task != null) {
            TaskSchedule taskSchedule = task.getSchedule(this.type);
            long l7 = taskSchedule.getBeginDependency();
            long l8 = taskSchedule.getWindowBegin();
            if (l7 == 0L || l8 != 0L && l8 > l7) {
                l7 = l8;
            }
            if (l7 != 0L && (l6 == 0L || l7 > l6)) {
                l6 = this.task.getEffectiveWorkCalendar().add(l7, 0L, bl);
            }
        }
        if (this.task.isInSubproject()) {
            l6 = Math.max(l6, calculationContext.forward ? this.task.getOwningProject().getStartConstraint() : -this.task.getOwningProject().getEnd());
        }
        if ((l5 = this.getWindowBegin()) != 0L) {
            if (l6 == 0L) {
                l6 = l5;
            } else if (l5 < l6) {
                if (this.task.startsBeforeProject()) {
                    l6 = l5;
                }
            } else {
                l6 = l5;
            }
        }
        if ((l4 = this.getWindowEnd()) != 0L) {
            if (l6 == 0L) {
                l6 = Long.MIN_VALUE;
            }
            l6 = Math.max(l6, this.task.calcOffsetFrom(l4, l4, false, false, bl));
        }
        if (calculationContext.honorRequiredDates) {
            l3 = -this.getOppositeSchedule().getWindowBegin();
            if (l3 != 0L) {
                if (l6 == 0L) {
                    l6 = Long.MAX_VALUE;
                }
                l6 = Math.min(l6, this.task.calcOffsetFrom(l3, this.dependencyDate, false, false, bl));
            }
            if ((l2 = -this.getOppositeSchedule().getWindowEnd()) != 0L) {
                if (l6 == 0L) {
                    l6 = Long.MAX_VALUE;
                }
                l6 = Math.min(l6, l2);
            }
        }
        if (l6 == 0L && !this.task.isWbsParent()) {
            l6 = calculationContext.boundary;
        }
        if (this.task.isSubproject()) {
            SubProj subProj = (SubProj)((Object)this.task);
            if (!subProj.isValidAndOpen()) {
                return;
            }
            if (this.task.getPredecessorList().size() == 0 && this.task.getConstraintDate() == 0L) {
                return;
            }
            l6 = Math.max(l6, calculationContext.forward ? subProj.getSubproject().getStartConstraint() : -subProj.getSubproject().getEnd());
        }
        if (Duration.millis(l3 = this.task.getLevelingDelay()) != 0L) {
            l6 = this.task.getEffectiveWorkCalendar().add(l6, l3, bl);
        }
        l2 = l6;
        if (this.forward == calculationContext.forward) {
            this.setRemainingDependencyDate(l2);
        }
        if (calculationContext.forward && (l = this.task.getActualStart()) != 0L) {
            l6 = l;
        }
        this.setBegin(l6);
        l = this.task.calcOffsetFrom(l6, l2, true, true, true);
        this.setEnd(l);
    }

    public void dump() {
        System.out.println("Task " + this.task + " schedule " + this.type + " start " + new Date(this.start) + " finish " + new Date(this.finish));
    }

    public String toString() {
        return "Task " + this.task + " schedule " + this.type + " begin " + new Date(this.getBegin()) + " end " + new Date(this.getEnd()) + " start " + new Date(this.start) + " finish " + new Date(this.finish);
    }

    public static Date d(long l) {
        return new Date(Math.abs(l));
    }

    static class CalculationContext {
        int stateCount;
        boolean forward;
        boolean honorRequiredDates;
        Task sentinel;
        int taskReferenceType;
        long boundary;
        boolean earlyOnly;
        boolean assign;
        int scheduleType;
        int pass;

        CalculationContext() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }
}

