/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.time;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnit {
    NON_TEMPORAL(-2, ""),
    NONE(-1, ""),
    MINUTES(0, "m"),
    HOURS(1, "h"),
    DAYS(2, "d"),
    WEEKS(3, "w"),
    MONTHS(4, "mo"),
    PERCENT(5, "%"),
    YEARS(6, "y"),
    ELAPSED_MINUTES(7, "em"),
    ELAPSED_HOURS(8, "eh"),
    ELAPSED_DAYS(9, "ed"),
    ELAPSED_WEEKS(10, "ew"),
    ELAPSED_MONTHS(11, "emo"),
    ELAPSED_YEARS(12, "ey"),
    ELAPSED_PERCENT(13, "e%");

    protected int id;
    protected String symbol;
    protected static Map<Integer, TimeUnit> reverseMap;

    private TimeUnit(int n2, String string2) {
        this.id = n2;
        this.symbol = string2;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public static TimeUnit getInstance(int n) {
        if (reverseMap == null) {
            reverseMap = new HashMap<Integer, TimeUnit>();
            for (TimeUnit timeUnit : TimeUnit.values()) {
                reverseMap.put(timeUnit.getId(), timeUnit);
            }
        }
        return reverseMap.get(n);
    }
}

