/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.pm.exchange.converters.mpx;

import com.projectlibre.core.pm.exchange.converters.mpx.MpxExceptionConverter;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxImportState;
import com.projectlibre.core.pm.exchange.converters.mpx.MpxRangeConverter;
import com.projectlibre.pm.calendar.CalendarId;
import com.projectlibre.pm.calendar.WorkCalendar;
import com.projectlibre.pm.calendar.WorkCalendarException;
import com.projectlibre.pm.calendar.WorkDay;
import com.projectlibre.pm.calendar.WorkWeek;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;

public class MpxCalendarConverter {
    public void from(ProjectCalendar projectCalendar, WorkCalendar workCalendar, MpxImportState mpxImportState) {
        Object object;
        workCalendar.setName(projectCalendar.getName());
        mpxImportState.getCalendarManager().fixBaseCalendar(workCalendar, mpxImportState.getProjectTitle());
        workCalendar.setId(new CalendarId(projectCalendar.getUniqueID().intValue()));
        WorkCalendar workCalendar2 = mpxImportState.getCalendarManager().getStandardBaseCalendar();
        ProjectCalendar projectCalendar2 = null;
        WorkCalendar workCalendar3 = null;
        if (projectCalendar.isDerived()) {
            projectCalendar2 = projectCalendar.getParent();
            if (projectCalendar2 == null) {
                projectCalendar2 = mpxImportState.getMpxStandardBaseCalendar();
            }
            if ((workCalendar3 = mpxImportState.getCalendarManager().getCalendar(new CalendarId(projectCalendar2.getUniqueID().intValue()))) == null) {
                workCalendar3 = workCalendar2;
            }
            workCalendar.setBase(workCalendar3);
        }
        WorkWeek workWeek = new WorkWeek();
        workCalendar.setWeek(workWeek);
        MpxRangeConverter mpxRangeConverter = new MpxRangeConverter();
        for (int i = 0; i < 7; ++i) {
            Day day = Day.getInstance(i + 1);
            ProjectCalendarHours projectCalendarDateRanges = projectCalendar.getCalendarHours(day);
            object = projectCalendar.getWorkingDay(day);
            WorkDay workDay = null;
            if (projectCalendarDateRanges == null) {
                if (projectCalendar.isDerived() && projectCalendar2 != null && projectCalendar2.isWorkingDay(day)) {
                    workDay = WorkDay.getNonWorkingDay();
                }
            } else {
                workDay = new WorkDay(com.projectlibre.pm.calendar.DayType.getInstance(((DayType)object).getValue()));
                mpxRangeConverter.from(projectCalendarDateRanges, workDay);
            }
            workWeek.setDay(i, workDay);
        }
        MpxExceptionConverter mpxExceptionConverter = new MpxExceptionConverter();
        for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
            object = new WorkCalendarException();
            mpxExceptionConverter.from(projectCalendarException, (WorkCalendarException)object);
            workCalendar.addException((WorkCalendarException)object);
        }
    }
}

