/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.wizards.common.DebugHelper;
import com.sun.star.wizards.common.PropertyNames;

public class NumericalHelper {
    public static final int UNKNOWN_TYPE = Short.MIN_VALUE;
    public static final int BYTE_TYPE = 0;
    public static final int SHORT_TYPE = 1;
    public static final int INT_TYPE = 2;
    public static final int LONG_TYPE = 3;
    public static final int FLOAT_TYPE = 4;
    public static final int DOUBLE_TYPE = 5;
    public static final int CHAR_TYPE = 6;
    public static final int STRING_TYPE = -1;
    public static final int BOOLEAN_TYPE = -2;
    public static final int SEQUENCE_TYPE = -3;
    public static final int ASCII_VALUE_0 = 48;
    public static final int ASCII_VALUE_A = 65;
    public static final int COUNT_CHARS_IN_ALPHABET = 26;
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int ASCII_LETTER_A_OFFSET = 55;

    private NumericalHelper() {
    }

    public static int getType(Object object) {
        try {
            TypeObject typeObject = NumericalHelper.getTypeObject(object);
            return typeObject.iType;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Short.MIN_VALUE;
        }
    }

    public static byte toByte(Object object) throws IllegalArgumentException {
        int n = 0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                n = (byte)NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                n = (byte)NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = (byte)NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (byte)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (byte)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (byte)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Byte by = new Byte((String)typeObject.aValue);
                    n = by.byteValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to byte: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return (byte)n;
    }

    public static char toChar(Object object) throws IllegalArgumentException {
        int n = '\u0000';
        boolean bl = false;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 6: {
                n = NumericalHelper.getChar(typeObject);
                break;
            }
            case 0: {
                n = (char)NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                n = (char)NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = (char)NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (char)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (char)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (char)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    String string = (String)typeObject.aValue;
                    if (string.length() > 0) {
                        n = string.charAt(0);
                        break;
                    }
                    n = 0;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to char: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? 65535 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return (char)n;
    }

    public static short toShort(Object object) throws IllegalArgumentException {
        int n = 0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                n = (byte)NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                n = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = (short)NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (short)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (short)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (short)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Short s = new Short((String)typeObject.aValue);
                    n = s.shortValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return (short)n;
    }

    public static boolean isValidAndNumerical(Object object) throws IllegalArgumentException {
        if (object != null && !AnyConverter.isVoid((Object)object)) {
            return NumericalHelper.isNumerical(object);
        }
        return false;
    }

    public static boolean isValidAndBoolean(Object object) throws IllegalArgumentException {
        if (object != null && !AnyConverter.isVoid((Object)object)) {
            int n = AnyConverter.getType((Object)object).getTypeClass().getValue();
            return n == 2;
        }
        return false;
    }

    public static boolean isValid(Object object) {
        return object != null && !AnyConverter.isVoid((Object)object);
    }

    public static boolean isNumerical(Object object) {
        try {
            TypeObject typeObject = NumericalHelper.getTypeObject(object);
            switch (typeObject.iType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isRealNumber(Object object) {
        return NumericalHelper.isNumerical(object);
    }

    public static boolean isInteger(Object object) throws IllegalArgumentException {
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringArray(Object object) {
        try {
            NumericalHelper.toStringArray(object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isIntegerArray(Object object) {
        try {
            NumericalHelper.toIntArray(object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static int toInt(Object object) throws IllegalArgumentException {
        int n = 0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                n = NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                n = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (int)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (int)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (int)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Integer n2 = new Integer((String)typeObject.aValue);
                    n = n2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to int: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return n;
    }

    public static long toLong(Object object) throws IllegalArgumentException {
        long l = 0L;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                l = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                l = NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                l = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                l = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                l = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                l = (long)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                l = (long)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Long l2 = new Long((String)typeObject.aValue);
                    l = l2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                l = NumericalHelper.getBool(typeObject) ? -1L : 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return l;
    }

    public static float toFloat(Object object) throws IllegalArgumentException {
        float f = 0.0f;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                f = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                f = NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                f = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                f = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                f = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                f = NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                f = (float)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Float f2 = new Float((String)typeObject.aValue);
                    f = f2.floatValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                f = NumericalHelper.getBool(typeObject) ? -1.0f : 0.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return f;
    }

    public static double toDouble(Object object) throws IllegalArgumentException {
        double d = 0.0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                d = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                d = NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                d = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                d = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                d = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                d = NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                d = NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Float f = new Float((String)typeObject.aValue);
                    d = f.floatValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                d = NumericalHelper.getBool(typeObject) ? -1.0 : 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return d;
    }

    public static String toString(Object object) throws IllegalArgumentException {
        String string = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                string = typeObject.aValue.toString();
                break;
            }
            case 6: {
                string = typeObject.aValue.toString();
                break;
            }
            case 1: {
                string = typeObject.aValue.toString();
                break;
            }
            case 2: {
                string = typeObject.aValue.toString();
                break;
            }
            case 3: {
                string = typeObject.aValue.toString();
                break;
            }
            case 4: {
                string = typeObject.aValue.toString();
                break;
            }
            case 5: {
                string = typeObject.aValue.toString();
                break;
            }
            case -1: {
                string = (String)typeObject.aValue;
                break;
            }
            case -2: {
                string = typeObject.aValue.toString();
                break;
            }
            case -3: {
                string = new String(NumericalHelper.toByteArray(object));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return string;
    }

    public static boolean toBoolean(Object object) throws IllegalArgumentException {
        boolean bl = true;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                bl = (Byte)typeObject.aValue != 0;
                break;
            }
            case 6: {
                bl = ((Character)typeObject.aValue).charValue() != '\u0000';
                break;
            }
            case 1: {
                bl = (Short)typeObject.aValue != 0;
                break;
            }
            case 2: {
                bl = (Integer)typeObject.aValue != 0;
                break;
            }
            case 3: {
                bl = (Long)typeObject.aValue != 0L;
                break;
            }
            case 4: {
                bl = ((Float)typeObject.aValue).floatValue() != 0.0f;
                break;
            }
            case 5: {
                bl = (Double)typeObject.aValue != 0.0;
                break;
            }
            case -1: {
                try {
                    Boolean bl2 = Boolean.valueOf((String)typeObject.aValue);
                    bl = bl2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                bl = (Boolean)typeObject.aValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return bl;
    }

    public static int[] toIntArray(Object object) throws IllegalArgumentException {
        int[] nArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -3) {
            Object[] objectArray = NumericalHelper.convertSequenceToObjectArray(typeObject);
            nArray = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                nArray[i] = NumericalHelper.toInt(objectArray[i]);
            }
        } else {
            nArray = new int[]{NumericalHelper.toInt(object)};
        }
        return nArray;
    }

    public static byte[] toByteArray(Object object) throws IllegalArgumentException {
        byte[] byArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -3) {
            Object[] objectArray = NumericalHelper.convertSequenceToObjectArray(typeObject);
            byArray = new byte[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                byArray[i] = NumericalHelper.toByte(objectArray[i]);
            }
        } else {
            byArray = new byte[]{NumericalHelper.toByte(object)};
        }
        return byArray;
    }

    public static short[] toShortArray(Object object) throws IllegalArgumentException {
        short[] sArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -3) {
            Object[] objectArray = NumericalHelper.convertSequenceToObjectArray(typeObject);
            sArray = new short[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                sArray[i] = NumericalHelper.toShort(objectArray[i]);
            }
        } else {
            sArray = new short[]{NumericalHelper.toShort(object)};
        }
        return sArray;
    }

    public static String[] toStringArray(Object object) throws IllegalArgumentException {
        String[] stringArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -3) {
            Object[] objectArray = NumericalHelper.convertSequenceToObjectArray(typeObject);
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = NumericalHelper.toString(objectArray[i]);
            }
        } else {
            stringArray = new String[]{NumericalHelper.toString(object)};
        }
        return stringArray;
    }

    public static int toInt(Object object, int n) throws Exception {
        int n2 = n;
        try {
            if (object != null && !AnyConverter.isVoid((Object)object)) {
                if (NumericalHelper.isInteger(object)) {
                    n2 = NumericalHelper.toInt(object);
                } else {
                    DebugHelper.exception(1, PropertyNames.EMPTY_STRING);
                }
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1, PropertyNames.EMPTY_STRING);
        }
        return n2;
    }

    public static long toLong(Object object, long l) {
        try {
            return NumericalHelper.toLong(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return l;
        }
    }

    public static float toFloat(Object object, float f) {
        try {
            return NumericalHelper.toFloat(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return f;
        }
    }

    public static double toDouble(Object object, double d) {
        try {
            return NumericalHelper.toDouble(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return d;
        }
    }

    public static String toString(Object object, String string) {
        try {
            return NumericalHelper.toString(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
    }

    public static boolean toBoolean(Object object, boolean bl) {
        try {
            return NumericalHelper.toBoolean(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return bl;
        }
    }

    public static int[] toIntArray(Object object, int[] nArray) {
        try {
            return NumericalHelper.toIntArray(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return nArray;
        }
    }

    public static short[] toShortArray(Object object, short[] sArray) {
        try {
            return NumericalHelper.toShortArray(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return sArray;
        }
    }

    public static String[] toStringArray(Object object, String[] stringArray) {
        try {
            return NumericalHelper.toStringArray(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringArray;
        }
    }

    public static String getHexStringFromNumber(long l) {
        TransformNumToHex transformNumToHex = new TransformNumToHex(l);
        return transformNumToHex.getResult();
    }

    private static TypeObject getTypeObject(Object object) throws IllegalArgumentException {
        TypeObject typeObject = new TypeObject();
        if (object == null || AnyConverter.isVoid((Object)object)) {
            throw new IllegalArgumentException("Cannot convert a null object.");
        }
        int n = AnyConverter.getType((Object)object).getTypeClass().getValue();
        switch (n) {
            case 1: {
                typeObject.iType = 6;
                typeObject.aValue = new Character(AnyConverter.toChar((Object)object));
                break;
            }
            case 3: {
                typeObject.iType = 0;
                typeObject.aValue = new Byte(AnyConverter.toByte((Object)object));
                break;
            }
            case 4: {
                typeObject.iType = 1;
                typeObject.aValue = new Short(AnyConverter.toShort((Object)object));
                break;
            }
            case 6: {
                typeObject.iType = 2;
                typeObject.aValue = new Integer(AnyConverter.toInt((Object)object));
                break;
            }
            case 8: {
                typeObject.iType = 3;
                typeObject.aValue = new Long(AnyConverter.toLong((Object)object));
                break;
            }
            case 10: {
                typeObject.iType = 4;
                typeObject.aValue = new Float(AnyConverter.toFloat((Object)object));
                break;
            }
            case 11: {
                typeObject.iType = 5;
                typeObject.aValue = new Double(AnyConverter.toDouble((Object)object));
                break;
            }
            case 12: {
                typeObject.iType = -1;
                typeObject.aValue = AnyConverter.toString((Object)object);
                break;
            }
            case 2: {
                typeObject.iType = -2;
                typeObject.aValue = AnyConverter.toBoolean((Object)object);
                break;
            }
            case 20: {
                typeObject.iType = -3;
                typeObject.aValue = object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return typeObject;
    }

    private static byte getByte(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 0) {
            throw new IllegalArgumentException("Given argument is not a byte type.");
        }
        return (Byte)typeObject.aValue;
    }

    private static char getChar(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 6) {
            throw new IllegalArgumentException("Given argument is not a char type.");
        }
        return ((Character)typeObject.aValue).charValue();
    }

    private static short getShort(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 1) {
            throw new IllegalArgumentException("Given argument is not a short type.");
        }
        return (Short)typeObject.aValue;
    }

    static int getInt(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 2) {
            throw new IllegalArgumentException("Given argument is not an int type.");
        }
        return (Integer)typeObject.aValue;
    }

    static float getFloat(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 4) {
            throw new IllegalArgumentException("Given argument is not a float type.");
        }
        return ((Float)typeObject.aValue).floatValue();
    }

    private static double getDouble(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 5) {
            throw new IllegalArgumentException("Given argument is not a double type.");
        }
        return (Double)typeObject.aValue;
    }

    private static long getLong(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 3) {
            throw new IllegalArgumentException("Given argument is not a long type.");
        }
        return (Long)typeObject.aValue;
    }

    private static boolean getBool(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != -2) {
            throw new IllegalArgumentException("Given argument is not a boolean type.");
        }
        return (Boolean)typeObject.aValue;
    }

    private static Object[] convertSequenceToObjectArray(TypeObject typeObject) throws IllegalArgumentException {
        Object[] objectArray;
        Object object = typeObject.aValue;
        Class<?> clazz = object.getClass();
        Object[] objectArray2 = null;
        if (clazz.equals(byte[].class)) {
            objectArray = (byte[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Byte(objectArray[i]);
            }
        } else if (clazz.equals(short[].class)) {
            objectArray = (short[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Short(objectArray[i]);
            }
        } else if (clazz.equals(int[].class)) {
            objectArray = (int[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Integer(objectArray[i]);
            }
        } else if (clazz.equals(long[].class)) {
            objectArray = (long[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Long(objectArray[i]);
            }
        } else if (clazz.equals(float[].class)) {
            objectArray = (float[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Float(objectArray[i]);
            }
        } else if (clazz.equals(double[].class)) {
            objectArray = (double[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Double(objectArray[i]);
            }
        } else if (clazz.equals(boolean[].class)) {
            objectArray = (boolean[])object;
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
        }
        if (objectArray2 == null) {
            try {
                objectArray2 = (Object[])object;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Cannot convert unknown type: '" + classCastException.getMessage() + "'");
            }
        }
        return objectArray2;
    }

    public static boolean representsIntegerNumber(double d) {
        double d2 = (int)d;
        return Double.compare(d, d2) == 0;
    }

    public static double roundDouble(Double d, int n) {
        return NumericalHelper.roundDouble((double)d, n);
    }

    public static double roundDouble(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)((int)(d * d2)) / d2;
    }

    private static class RomanNumbering {
        private static final String[] ROMAN_EQUIV = new String[]{"I", "V", "X", "L", "C", "D", "M"};
        private static final int MAX_NUMBER = 3999;
        private static final int MIN_NUMBER = 1;
        private static final int ASCII_CODE_0 = 48;
        private static final int FOUR = 4;
        private static final int FIVE = 5;
        private static final int NINE = 9;

        private RomanNumbering() {
        }

        public static String getRomanEquivalent(int n) throws Exception {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (n > 3999 || n < 1) {
                    DebugHelper.exception(1, PropertyNames.EMPTY_STRING);
                }
                String string = NumericalHelper.toString(new Integer(n));
                int n2 = 0;
                for (int i = string.length() - 1; i >= 0; --i) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    int n3 = string.charAt(i) - 48;
                    if (n3 == 4) {
                        stringBuffer2.append(ROMAN_EQUIV[n2]);
                        stringBuffer2.append(ROMAN_EQUIV[n2 + 1]);
                    } else if (n3 == 9) {
                        stringBuffer2.append(ROMAN_EQUIV[n2]);
                        stringBuffer2.append(ROMAN_EQUIV[n2 + 2]);
                    } else {
                        if (n3 >= 5) {
                            stringBuffer2.append(ROMAN_EQUIV[n2 + 1]);
                            n3 -= 5;
                        }
                        for (int j = 0; j < n3; ++j) {
                            stringBuffer2.append(ROMAN_EQUIV[n2]);
                        }
                    }
                    n2 += 2;
                    stringBuffer.append(stringBuffer2.reverse());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return stringBuffer.reverse().toString();
        }
    }

    private static class TransformNumToHex {
        private StringBuffer val = new StringBuffer();

        public TransformNumToHex(long l) {
            this.transform(l);
        }

        private void transform(long l) {
            int n = (int)(l % 16L);
            l /= 16L;
            if (n < 10) {
                this.val.insert(0, n);
            } else {
                this.val.insert(0, (char)(55 + n));
            }
            if (l > 0L) {
                this.transform(l);
            }
        }

        public String getResult() {
            return this.val.toString();
        }
    }

    private static class TypeObject {
        public int iType;
        public Object aValue;

        private TypeObject() {
        }
    }
}

