/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.servicemanager;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XSet;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class ServiceManager
implements XMultiServiceFactory,
XMultiComponentFactory,
XSet,
XContentEnumerationAccess,
XComponent,
XServiceInfo {
    private static final boolean DEBUG = false;
    private static Type UNO_TYPE = null;
    static String[] supportedServiceNames = new String[]{"com.sun.star.lang.MultiServiceFactory", "com.sun.star.lang.ServiceManager"};
    ArrayList<XEventListener> eventListener = new ArrayList();
    HashMap<String, Object> factoriesByImplNames = new HashMap();
    HashMap<String, ArrayList<Object>> factoriesByServiceNames = new HashMap();
    private XComponentContext m_xDefaultContext = null;

    private static final void DEBUG(String string) {
    }

    public void setDefaultContext(XComponentContext xComponentContext) {
        this.m_xDefaultContext = xComponentContext;
    }

    public Object createInstance(String string) throws Exception, RuntimeException {
        return this.createInstanceWithContext(string, this.m_xDefaultContext);
    }

    public Object createInstanceWithArguments(String string, Object[] objectArray) throws Exception, RuntimeException {
        return this.createInstanceWithArgumentsAndContext(string, objectArray, this.m_xDefaultContext);
    }

    private Object queryServiceFactory(String string) throws Exception, RuntimeException {
        ServiceManager.DEBUG("queryServiceFactory for name " + string);
        Object object = null;
        if (this.factoriesByServiceNames.containsKey(string)) {
            ArrayList<Object> arrayList = this.factoriesByServiceNames.get(string);
            ServiceManager.DEBUG("");
            ServiceManager.DEBUG("aviable factories for " + string + " " + arrayList);
            ServiceManager.DEBUG("");
            if (!arrayList.isEmpty()) {
                object = arrayList.get(arrayList.size() - 1);
            }
        } else {
            object = this.factoriesByImplNames.get(string);
        }
        if (object == null) {
            throw new Exception("Query for service factory for " + string + " failed.");
        }
        return object;
    }

    public String[] getAvailableServiceNames() throws RuntimeException {
        int n = 0;
        String[] stringArray = new String[this.factoriesByServiceNames.size()];
        Iterator<String> iterator = this.factoriesByServiceNames.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        return stringArray;
    }

    public Object createInstanceWithContext(String string, XComponentContext xComponentContext) throws Exception {
        Object object = this.queryServiceFactory(string);
        if (object != null) {
            XSingleComponentFactory xSingleComponentFactory = UnoRuntime.queryInterface(XSingleComponentFactory.class, object);
            if (xSingleComponentFactory != null) {
                return xSingleComponentFactory.createInstanceWithContext(xComponentContext);
            }
            XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
            if (xSingleServiceFactory != null) {
                return xSingleServiceFactory.createInstance();
            }
            throw new Exception("retrieved service factory object for \"" + string + "\" does not export XSingleComponentFactory nor XSingleServiceFactory!");
        }
        return null;
    }

    public Object createInstanceWithArgumentsAndContext(String string, Object[] objectArray, XComponentContext xComponentContext) throws Exception {
        Object object = this.queryServiceFactory(string);
        if (object != null) {
            XSingleComponentFactory xSingleComponentFactory = UnoRuntime.queryInterface(XSingleComponentFactory.class, object);
            if (xSingleComponentFactory != null) {
                return xSingleComponentFactory.createInstanceWithArgumentsAndContext(objectArray, xComponentContext);
            }
            XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
            if (xSingleServiceFactory != null) {
                return xSingleServiceFactory.createInstanceWithArguments(objectArray);
            }
            throw new Exception("retrieved service factory object for \"" + string + "\" does not export XSingleComponentFactory nor XSingleServiceFactory!");
        }
        return null;
    }

    public void dispose() throws RuntimeException {
        if (this.eventListener != null) {
            for (XEventListener xEventListener : this.eventListener) {
                xEventListener.disposing(new EventObject(this));
            }
            this.eventListener.clear();
        }
        this.factoriesByServiceNames.clear();
        this.factoriesByImplNames.clear();
    }

    public void addEventListener(XEventListener xEventListener) throws RuntimeException {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener already registred.");
        }
        this.eventListener.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) throws RuntimeException {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.eventListener.remove(xEventListener);
    }

    public boolean has(Object object) throws RuntimeException {
        if (object == null) {
            throw new RuntimeException("The parameter must not been null");
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        return xServiceInfo != null && UnoRuntime.areSame(this.factoriesByImplNames.get(xServiceInfo.getImplementationName()), object);
    }

    public void insert(Object object) throws IllegalArgumentException, ElementExistException, RuntimeException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        if (xServiceInfo == null) {
            throw new IllegalArgumentException("The given object does not implement the XServiceInfo interface.");
        }
        if (this.factoriesByImplNames.containsKey(xServiceInfo.getImplementationName())) {
            throw new ElementExistException(xServiceInfo.getImplementationName() + " already registred");
        }
        ServiceManager.DEBUG("add factory " + object.toString() + " for " + xServiceInfo.getImplementationName());
        this.factoriesByImplNames.put(xServiceInfo.getImplementationName(), object);
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<Object> arrayList;
            if (!this.factoriesByServiceNames.containsKey(stringArray[i])) {
                ServiceManager.DEBUG("> no registered services found under " + stringArray[i] + ": adding...");
                this.factoriesByServiceNames.put(stringArray[i], new ArrayList());
            }
            if ((arrayList = this.factoriesByServiceNames.get(stringArray[i])).contains(object)) {
                System.err.println("The implementation " + xServiceInfo.getImplementationName() + " already registered for the service " + stringArray[i] + " - ignoring!");
                continue;
            }
            arrayList.add(object);
        }
    }

    public void remove(Object object) throws IllegalArgumentException, NoSuchElementException, RuntimeException {
        if (object == null) {
            throw new IllegalArgumentException("The given object must not be null.");
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        if (xServiceInfo == null) {
            throw new IllegalArgumentException("The given object does not implement the XServiceInfo interface.");
        }
        XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
        if (xSingleServiceFactory == null) {
            throw new IllegalArgumentException("The given object does not implement the XSingleServiceFactory interface.");
        }
        if (this.factoriesByImplNames.remove(xServiceInfo.getImplementationName()) == null) {
            throw new NoSuchElementException(xServiceInfo.getImplementationName() + " is not registered as an implementation.");
        }
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.factoriesByServiceNames.containsKey(stringArray[i])) continue;
            ArrayList<Object> arrayList = this.factoriesByServiceNames.get(stringArray[i]);
            if (!arrayList.remove(object)) {
                System.err.println("The implementation " + xServiceInfo.getImplementationName() + " is not registered for the service " + stringArray[i] + " - ignoring!");
            }
            if (!arrayList.isEmpty()) continue;
            this.factoriesByServiceNames.remove(stringArray[i]);
        }
    }

    public XEnumeration createEnumeration() throws RuntimeException {
        return new ServiceEnumerationImpl(this.factoriesByImplNames.values().iterator());
    }

    public Type getElementType() throws RuntimeException {
        if (UNO_TYPE == null) {
            UNO_TYPE = new Type(ServiceManager.class);
        }
        return UNO_TYPE;
    }

    public boolean hasElements() {
        return !this.factoriesByImplNames.isEmpty();
    }

    public XEnumeration createContentEnumeration(String string) throws RuntimeException {
        ArrayList<Object> arrayList = this.factoriesByServiceNames.get(string);
        ServiceEnumerationImpl serviceEnumerationImpl = arrayList != null ? new ServiceEnumerationImpl(arrayList.iterator()) : new ServiceEnumerationImpl();
        return serviceEnumerationImpl;
    }

    public String getImplementationName() throws RuntimeException {
        return this.getClass().getName();
    }

    public boolean supportsService(String string) throws RuntimeException {
        for (int i = 0; i < supportedServiceNames.length; ++i) {
            if (!supportedServiceNames[i].equals(string)) continue;
            return true;
        }
        return this.getImplementationName().equals(string);
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return supportedServiceNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceEnumerationImpl
    implements XEnumeration {
        Iterator<Object> enumeration = null;

        public ServiceEnumerationImpl() {
        }

        public ServiceEnumerationImpl(Enumeration<Object> enumeration) {
            this.enumeration = Collections.list(enumeration).iterator();
        }

        public ServiceEnumerationImpl(Iterator<Object> iterator) {
            this.enumeration = iterator;
        }

        @Override
        public boolean hasMoreElements() throws RuntimeException {
            return this.enumeration != null && this.enumeration.hasNext();
        }

        @Override
        public Object nextElement() throws NoSuchElementException, WrappedTargetException, RuntimeException {
            if (this.enumeration == null) {
                throw new NoSuchElementException();
            }
            try {
                return this.enumeration.next();
            }
            catch (java.util.NoSuchElementException noSuchElementException) {
                NoSuchElementException noSuchElementException2 = new NoSuchElementException(noSuchElementException.toString());
                noSuchElementException2.initCause(noSuchElementException);
                throw noSuchElementException2;
            }
        }
    }
}

