/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Attribute;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.impl.PKCS10Request;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Request
extends RubyObject {
    private static final long serialVersionUID = -2886532636278901502L;
    private static ObjectAllocator REQUEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Request(runtime, klass);
        }
    };
    private IRubyObject subject;
    private IRubyObject public_key;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private PKCS10Request request = new PKCS10Request((X500Name)null, (PublicKey)null, null);

    public static void createRequest(Ruby runtime, RubyModule _X509) {
        RubyClass _Request = _X509.defineClassUnder("Request", runtime.getObject(), REQUEST_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("RequestError", _OpenSSLError, _OpenSSLError.getAllocator());
        _Request.defineAnnotatedMethods(Request.class);
    }

    public Request(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args, Block block) {
        byte[] encoded;
        String algorithm;
        Ruby runtime = context.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            return this;
        }
        try {
            this.request = new PKCS10Request(OpenSSLImpl.readX509PEM(context, args[0]));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw Request.newRequestError(runtime, "invalid certificate request data");
        }
        try {
            PublicKey pkey = this.request.getPublicKey();
            algorithm = pkey.getAlgorithm();
            encoded = pkey.getEncoded();
        }
        catch (IOException e) {
            throw Request.newRequestError(runtime, e.getMessage());
        }
        RubyString enc = RubyString.newString((Ruby)runtime, (byte[])encoded);
        if ("RSA".equalsIgnoreCase(algorithm)) {
            this.public_key = Request.newPKeyImplInstance(context, "RSA", enc);
        } else if ("DSA".equalsIgnoreCase(algorithm)) {
            this.public_key = Request.newPKeyImplInstance(context, "DSA", enc);
        } else {
            throw runtime.newLoadError("not implemented algo for public key: " + algorithm);
        }
        this.subject = Request.newX509Name(context, this.request.getSubject());
        try {
            for (org.bouncycastle.asn1.pkcs.Attribute attr : this.request.getAttributes()) {
                this.attributes.add((Attribute)Request.newX509Attribute(context, attr.getAttrType(), attr.getAttrValues()));
            }
        }
        catch (IOException ex) {
            throw Request.newRequestError(runtime, ex.getMessage());
        }
        return this;
    }

    private static IRubyObject newPKeyImplInstance(ThreadContext context, String className, RubyString encoded) {
        return PKey._PKey(context.runtime).getClass(className).callMethod(context, "new", (IRubyObject)encoded);
    }

    private static IRubyObject newX509Attribute(ThreadContext context, ASN1ObjectIdentifier type, ASN1Set values) throws IOException {
        Ruby runtime = context.runtime;
        RubyString attrType = runtime.newString(ASN1.oid2Sym(runtime, type));
        IRubyObject attrValue = ASN1.decode(context, (IRubyObject)ASN1._ASN1(runtime), (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])values.getEncoded()));
        return Attribute._Attribute(runtime).callMethod(context, "new", new IRubyObject[]{attrType, attrValue});
    }

    private static IRubyObject newX509Name(ThreadContext context, X500Name name) {
        Ruby runtime = context.runtime;
        if (name == null) {
            return context.runtime.getNil();
        }
        X509Name newName = (X509Name)X509Name._Name(runtime).callMethod(context, "new");
        for (RDN rdn : name.getRDNs()) {
            for (AttributeTypeAndValue tv : rdn.getTypesAndValues()) {
                ASN1ObjectIdentifier oid = tv.getType();
                String val = null;
                if (tv.getValue() instanceof ASN1String) {
                    val = ((ASN1String)tv.getValue()).getString();
                }
                RubyFixnum type = runtime.newFixnum(ASN1.idForJava(tv.getValue()));
                newName.addEntry(oid, val, (RubyInteger)type);
            }
        }
        return newName;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        Ruby runtime = this.getRuntime();
        OpenSSLReal.warn(runtime.getCurrentContext(), "WARNING: unimplemented method called: request#initialize_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.subject = this.public_key = runtime.getNil();
        return this;
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        StringWriter writer = new StringWriter();
        try {
            PEMInputOutput.writeX509Request(writer, this.request);
            return this.getRuntime().newString(writer.toString());
        }
        catch (IOException e) {
            throw Utils.newIOError(this.getRuntime(), e);
        }
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])this.request.toASN1Structure().getEncoded());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_text(ThreadContext context) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: request#to_text");
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.getRuntime().newFixnum(this.request.getVersion());
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(ThreadContext context, IRubyObject val) {
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject;
    }

    private static X500Name x500Name(IRubyObject name) {
        return ((X509Name)name).getX500Name();
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject val) {
        if (val != this.subject) {
            this.request.setSubject(Request.x500Name(val));
            this.subject = val;
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm(ThreadContext context) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: request#signature_algorithm");
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject pkey) {
        if (pkey != this.subject) {
            this.request.setPublicKey(((PKey)pkey).getPublicKey());
            this.public_key = pkey;
        }
        return pkey;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context, IRubyObject key, IRubyObject digest) {
        String digName;
        String digAlg;
        PublicKey publicKey = ((PKey)this.public_key).getPublicKey();
        PrivateKey privateKey = ((PKey)key).getPrivateKey();
        String keyAlg = publicKey.getAlgorithm();
        if (PKCS10Request.algorithmMismatch(keyAlg, digAlg = ((Digest)digest).getShortAlgorithm(), digName = ((Digest)digest).name().toString())) {
            throw Request.newRequestError(context.runtime, null);
        }
        this.request = new PKCS10Request(Request.x500Name(this.subject), publicKey, Request.newAttributes(this.attributes));
        try {
            this.request.sign(privateKey, digAlg);
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
        return this;
    }

    private static List<org.bouncycastle.asn1.pkcs.Attribute> newAttributes(List<Attribute> attributes) {
        ArrayList<org.bouncycastle.asn1.pkcs.Attribute> attrs = new ArrayList<org.bouncycastle.asn1.pkcs.Attribute>(attributes.size());
        for (Attribute attribute : attributes) {
            attrs.add(Request.newAttribute((IRubyObject)attribute));
        }
        return attrs;
    }

    private static org.bouncycastle.asn1.pkcs.Attribute newAttribute(IRubyObject attribute) {
        return org.bouncycastle.asn1.pkcs.Attribute.getInstance((Object)((Attribute)attribute).toASN1());
    }

    @JRubyMethod
    public IRubyObject verify(ThreadContext context, IRubyObject key) {
        try {
            PublicKey publicKey = ((PKey)key.callMethod(context, "public_key")).getPublicKey();
            return this.request.verify(publicKey) ? context.runtime.getTrue() : context.runtime.getFalse();
        }
        catch (InvalidKeyException e) {
            throw Request.newRequestError(context.runtime, e.getMessage());
        }
        catch (Exception e) {
            return context.runtime.getFalse();
        }
    }

    @JRubyMethod
    public IRubyObject attributes() {
        List<Attribute> attributes = this.attributes;
        return this.getRuntime().newArray(attributes);
    }

    @JRubyMethod(name={"attributes="})
    public IRubyObject set_attributes(IRubyObject attributes) {
        this.attributes.clear();
        RubyArray attrs = (RubyArray)attributes;
        for (int i = 0; i < attrs.size(); ++i) {
            this.attributes.add((Attribute)attrs.entry(i));
        }
        this.request.setAttributes(Request.newAttributes(this.attributes));
        return attributes;
    }

    @JRubyMethod
    public IRubyObject add_attribute(IRubyObject attribute) {
        this.attributes.add((Attribute)attribute);
        this.request.addAttribute(Request.newAttribute(attribute));
        return attribute;
    }

    private static RaiseException newRequestError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("RequestError"), message);
    }
}

