/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.provider;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.digest.RubyNativeDigest;
import org.jruby.ext.krypt.provider.Digest;
import org.jruby.ext.krypt.provider.KryptProvider;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNativeProvider
extends RubyObject {
    private static RubyClass cNativeProvider;
    private static RubyModule mDigest;
    private final KryptProvider provider;

    public static void createProvider(Ruby runtime, RubyModule mKrypt) {
        RubyModule mProvider = (RubyModule)mKrypt.getConstant("Provider");
        cNativeProvider = mProvider.defineClassUnder("NativeProvider", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cNativeProvider.defineAnnotatedMethods(RubyNativeProvider.class);
        mDigest = (RubyModule)mKrypt.getConstant("Digest");
    }

    public static RubyClass getRubyClass() {
        return cNativeProvider;
    }

    protected RubyNativeProvider(Ruby runtime, RubyClass type, KryptProvider provider) {
        super(runtime, type);
        if (provider == null) {
            throw new NullPointerException();
        }
        this.provider = provider;
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext ctx) {
        return ctx.getRuntime().newString(this.provider.getName());
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject new_service(ThreadContext ctx, IRubyObject[] args) {
        IRubyObject serviceClass = args[0];
        if (serviceClass == mDigest) {
            return this.newDigest(ctx, RubyNativeProvider.stripFirst(args));
        }
        return ctx.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject finalize(ThreadContext ctx) {
        this.provider.cleanUp();
        return ctx.getRuntime().getNil();
    }

    private IRubyObject newDigest(ThreadContext ctx, IRubyObject[] args) {
        Ruby runtime = ctx.getRuntime();
        if (args == null) {
            return runtime.getNil();
        }
        String nameOrOid = args[0].convertToString().asJavaString();
        Digest digest = this.provider.newDigestByName(nameOrOid);
        if (digest == null) {
            digest = this.provider.newDigestByOid(nameOrOid);
        }
        if (digest == null) {
            return runtime.getNil();
        }
        return new RubyNativeDigest(runtime, digest);
    }

    private static IRubyObject[] stripFirst(IRubyObject[] args) {
        if (args.length == 1) {
            return null;
        }
        IRubyObject[] ret = new IRubyObject[args.length - 1];
        System.arraycopy(args, 1, ret, 0, args.length - 1);
        return ret;
    }
}

