/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=SetupClassRealm.class)
public class SetupClassRealm {
    @Requirement
    RepositorySystem system;
    @Requirement
    protected LegacySupport legacySupport;

    public void setupArtifact(String gav, ClassRealm realm) throws MalformedURLException {
        String[] parts = gav.split(":");
        Artifact root = this.system.createArtifact(parts[0], parts[1], parts[2], "pom");
        ArtifactResolutionResult result = this.system.resolve(new ArtifactResolutionRequest().setArtifact(root).setCollectionFilter(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !"tesla-polyglot-common".equals(artifact.getArtifactId()) && !"test".equals(artifact.getScope());
            }
        }).setResolveRoot(true).setForceUpdate(true).setOffline(this.legacySupport.getSession().getRequest().isOffline()).setMirrors(this.legacySupport.getSession().getRequest().getMirrors()).setProxies(this.legacySupport.getSession().getRequest().getProxies()).setServers(this.legacySupport.getSession().getRequest().getServers()).setLocalRepository(this.legacySupport.getSession().getRequest().getLocalRepository()).setRemoteRepositories(this.legacySupport.getSession().getRequest().getRemoteRepositories()).setResolveTransitively(true));
        TreeSet<String> urls = new TreeSet<String>();
        for (URL url : realm.getURLs()) {
            urls.add(url.toString());
        }
        for (Artifact a : result.getArtifacts()) {
            URL url;
            if (!"jar".equals(a.getType()) || a.getFile() == null || urls.contains((url = a.getFile().toURI().toURL()).toString())) continue;
            realm.addURL(a.getFile().toURI().toURL());
        }
    }
}

