/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class DateUtils {
    public static final BooleanProperty PROP_ISO_DATES = new BooleanProperty("iso.dates", false);
    private static GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private static final DatatypeFactory XML_DATE;

    private DateUtils() {
    }

    public static synchronized Date fromString(String string) {
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx-xx:00")) {
            calendar.set(DateUtils.parsePart(string, 0, 4), DateUtils.parsePart(string, 5, 2) - 1, DateUtils.parsePart(string, 8, 2), DateUtils.parsePart(string, 11, 2), DateUtils.parsePart(string, 14, 2), DateUtils.parsePart(string, 17, 2));
            if (string.length() == 25) {
                int n = DateUtils.parsePart(string, 20, 2);
                int n2 = string.charAt(19) == '+' ? -3600000 : 3600000;
                calendar.setTimeInMillis(calendar.getTimeInMillis() + (long)(n * n2));
            }
            return calendar.getTime();
        }
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx-xx:00")) {
            calendar.set(DateUtils.parsePart(string, 0, 4), DateUtils.parsePart(string, 5, 2) - 1, DateUtils.parsePart(string, 8, 2), DateUtils.parsePart(string, 11, 2), DateUtils.parsePart(string, 14, 2), DateUtils.parsePart(string, 17, 2));
            long l = DateUtils.parsePart(string, 20, 3);
            if (string.length() == 29) {
                l += (long)(DateUtils.parsePart(string, 24, 2) * (string.charAt(23) == '+' ? -3600000 : 3600000));
            }
            calendar.setTimeInMillis(calendar.getTimeInMillis() + l);
            return calendar.getTime();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
        Date date = simpleDateFormat.parse(string, new ParsePosition(0));
        if (date != null) {
            return date;
        }
        try {
            return XML_DATE.newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    public static synchronized String fromDate(Date date) {
        calendar.setTime(date);
        XMLGregorianCalendar xMLGregorianCalendar = XML_DATE.newXMLGregorianCalendar(calendar);
        if (calendar.get(14) == 0) {
            xMLGregorianCalendar.setFractionalSecond(null);
        }
        return xMLGregorianCalendar.toXMLFormat();
    }

    private static boolean checkLayout(String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            char c2 = string.charAt(i);
            if (c == 'x' && c2 >= '0' && c2 <= '9' || c != 'x' && c == c2) continue;
            return false;
        }
        return true;
    }

    private static int parsePart(String string, int n, int n2) {
        return Integer.valueOf(string.substring(n, n + n2));
    }

    public static final SimpleDateFormat newIsoDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static final SimpleDateFormat newIsoDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static final SimpleDateFormat newOsmApiDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
    }

    public static final DateFormat getDateFormat(int n) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return DateUtils.newIsoDateFormat();
        }
        return DateFormat.getDateInstance(n, Locale.getDefault());
    }

    public static final String formatDate(Date date, int n) {
        CheckParameterUtil.ensureParameterNotNull(date, "date");
        return DateUtils.getDateFormat(n).format(date);
    }

    public static final DateFormat getTimeFormat(int n) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        return DateFormat.getTimeInstance(n, Locale.getDefault());
    }

    public static final String formatTime(Date date, int n) {
        CheckParameterUtil.ensureParameterNotNull(date, "time");
        return DateUtils.getTimeFormat(n).format(date);
    }

    public static final DateFormat getDateTimeFormat(int n, int n2) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return DateFormat.getDateTimeInstance(n, n2, Locale.getDefault());
    }

    public static final String formatDateTime(Date date, int n, int n2) {
        CheckParameterUtil.ensureParameterNotNull(date, "datetime");
        return DateUtils.getDateTimeFormat(n, n2).format(date);
    }

    static {
        calendar.setTimeInMillis(0L);
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Main.error(datatypeConfigurationException);
        }
        XML_DATE = datatypeFactory;
    }
}

