/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;

public final class LanguageInfo {
    private LanguageInfo() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWikiLanguagePrefix(LocaleType localeType) {
        if (localeType == LocaleType.ENGLISH) {
            return "";
        }
        String string = LanguageInfo.getJOSMLocaleCode();
        if (localeType == LocaleType.BASELANGUAGE) {
            if (!string.matches("[^_]+_[^_]+")) return null;
            if (!"en".equals(string = string.substring(0, 2))) return string.substring(0, 1).toUpperCase() + string.substring(1) + ":";
            return null;
        }
        if (localeType != LocaleType.DEFAULTNOTENGLISH || !"en".equals(string)) return string.substring(0, 1).toUpperCase() + string.substring(1) + ":";
        return null;
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(LocaleType.DEFAULT);
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        String string = locale.toString();
        if ("iw_IL".equals(string)) {
            return "he";
        }
        if ("in".equals(string)) {
            return "id";
        }
        if (I18n.hasCode(string)) {
            return string;
        }
        return locale.getLanguage();
    }

    public static Locale getLocale(String string) {
        if ("he".equals(string)) {
            string = "iw_IL";
        } else if ("id".equals(string)) {
            string = "in";
        }
        int n = string.indexOf(95);
        Locale locale = n > 0 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string);
        return locale;
    }

    public static String getLanguageCodeXML() {
        return LanguageInfo.getJOSMLocaleCode() + ".";
    }

    public static String getLanguageCodeManifest() {
        return LanguageInfo.getJOSMLocaleCode() + "_";
    }

    public static enum LocaleType {
        DEFAULT,
        DEFAULTNOTENGLISH,
        BASELANGUAGE,
        ENGLISH;

    }
}

