/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.tools.I18n;

public class RemoteControlHttpServer
extends Thread {
    private ServerSocket server;
    private static RemoteControlHttpServer instance;

    public static void restartRemoteControlHttpServer() {
        int n = Main.pref.getInteger("remote.control.port", 8111);
        try {
            RemoteControlHttpServer.stopRemoteControlHttpServer();
            instance = new RemoteControlHttpServer(n);
            instance.start();
        }
        catch (BindException bindException) {
            Main.warn(I18n.marktr("Cannot start remotecontrol server on port {0}: {1}"), Integer.toString(n), bindException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    public static void stopRemoteControlHttpServer() {
        if (instance != null) {
            try {
                instance.stopServer();
                instance = null;
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
        }
    }

    public RemoteControlHttpServer(int n) throws IOException {
        super("RemoteControl HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(n, 1, InetAddress.getByName(Main.pref.get("remote.control.host", "localhost")));
    }

    @Override
    public void run() {
        Main.info(I18n.marktr("RemoteControl::Accepting connections on port {0}"), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    RequestProcessor.processRequest(socket);
                }
            }
            catch (SocketException socketException) {
                if (this.server.isClosed()) continue;
                Main.error(socketException);
                continue;
            }
            catch (IOException iOException) {
                Main.error(iOException);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        this.server.close();
        Main.info(I18n.marktr("RemoteControl::Server stopped."));
    }
}

