/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class NoteImporter
extends FileImporter {
    private static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("osn,osn.bz2", "osn", I18n.tr("Note Files", new Object[0]) + " (*.osn *.osn.bz2)");

    public NoteImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        Main.debug("importing notes file " + file.getAbsolutePath());
        final String string = file.getName();
        InputStream inputStream = string.endsWith(".bz2") ? Utils.getBZip2InputStream(new FileInputStream(file)) : new FileInputStream(file);
        NoteReader noteReader = new NoteReader(inputStream);
        try {
            final List<Note> list = noteReader.parse();
            List<NoteLayer> list2 = null;
            if (Main.map != null) {
                list2 = Main.map.mapView.getLayersOfType(NoteLayer.class);
            }
            if (list2 != null && list2.size() > 0) {
                NoteLayer noteLayer = list2.get(0);
                noteLayer.getNoteData().addNotes(list);
            } else {
                GuiHelper.runInEDT(new Runnable(){

                    @Override
                    public void run() {
                        NoteLayer noteLayer = new NoteLayer(list, string);
                        Main.main.addLayer(noteLayer);
                    }
                });
            }
        }
        catch (SAXException sAXException) {
            Main.error("error opening up notes file");
            Main.error(sAXException, true);
            throw new IOException(sAXException.getMessage(), sAXException);
        }
        finally {
            Utils.close(inputStream);
        }
    }
}

