/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.io.File;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.Utils;

public class SourceEntry {
    public String url;
    public boolean isZip;
    public String zipEntryPath;
    public String name;
    public String title;
    public boolean active;

    public SourceEntry(String string, boolean bl, String string2, String string3, String string4, boolean bl2) {
        this.url = string;
        this.isZip = bl;
        this.zipEntryPath = "".equals(string2) ? null : string2;
        this.name = "".equals(string3) ? null : string3;
        this.title = "".equals(string4) ? null : string4;
        this.active = bl2;
    }

    public SourceEntry(String string, String string2, String string3, Boolean bl) {
        this(string, false, null, string2, string3, bl);
    }

    public SourceEntry(SourceEntry sourceEntry) {
        this.url = sourceEntry.url;
        this.isZip = sourceEntry.isZip;
        this.zipEntryPath = sourceEntry.zipEntryPath;
        this.name = sourceEntry.name;
        this.title = sourceEntry.title;
        this.active = sourceEntry.active;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SourceEntry sourceEntry = (SourceEntry)object;
        return Objects.equals(sourceEntry.url, this.url) && sourceEntry.isZip == this.isZip && Objects.equals(sourceEntry.zipEntryPath, this.zipEntryPath) && Objects.equals(sourceEntry.name, this.name) && Objects.equals(sourceEntry.title, this.title) && sourceEntry.active == this.active;
    }

    public int hashCode() {
        int n = 5;
        n = 89 * n + (this.url != null ? this.url.hashCode() : 0);
        n = 89 * n + (this.isZip ? 1 : 0);
        n = 89 * n + (this.zipEntryPath != null ? this.zipEntryPath.hashCode() : 0);
        n = 89 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 89 * n + (this.title != null ? this.title.hashCode() : 0);
        n = 89 * n + (this.active ? 1 : 0);
        return n;
    }

    public String toString() {
        return this.title != null ? this.title : this.url;
    }

    public String getDisplayString() {
        if (this.title != null) {
            return this.title;
        }
        return this.getFileNamePart();
    }

    public String getFileNamePart() {
        Pattern pattern = Pattern.compile("([^/\\\\]*?)([?].*)?$");
        Matcher matcher = pattern.matcher(this.url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        Main.warn("Unexpected URL format: " + this.url);
        return this.url;
    }

    public String getPrefName() {
        return this.name == null ? "standard" : this.name;
    }

    public boolean isLocal() {
        return Utils.isLocalUrl(this.url);
    }

    public File getLocalSourceDir() {
        if (!this.isLocal()) {
            return null;
        }
        return new File(this.url).getParentFile();
    }

    public String getZipEntryDirName() {
        if (this.zipEntryPath == null) {
            return null;
        }
        File file = new File(this.zipEntryPath);
        File file2 = file.getParentFile();
        if (file2 == null) {
            return ".";
        }
        String string = file2.getPath();
        if (!"/".equals(File.separator)) {
            string = string.replace(File.separator, "/");
        }
        return string;
    }
}

