/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public abstract class Condition {
    public static final EnumSet<Op> COMPARISON_OPERATERS = EnumSet.of(Op.GREATER_OR_EQUAL, Op.GREATER, Op.LESS_OR_EQUAL, Op.LESS);

    public abstract boolean applies(Environment var1);

    public static Condition createKeyValueCondition(String string, String string2, Op op, Context context, boolean bl) {
        switch (context) {
            case PRIMITIVE: {
                if (KeyValueRegexpCondition.SUPPORTED_OPS.contains((Object)op) && !bl) {
                    return new KeyValueRegexpCondition(string, string2, op, false);
                }
                if (!bl && op.equals((Object)Op.EQ)) {
                    return new SimpleKeyValueCondition(string, string2);
                }
                return new KeyValueCondition(string, string2, op, bl);
            }
            case LINK: {
                if (bl) {
                    throw new MapCSSException("''considerValAsKey'' not supported in LINK context");
                }
                if ("role".equalsIgnoreCase(string)) {
                    return new RoleCondition(string2, op);
                }
                if ("index".equalsIgnoreCase(string)) {
                    return new IndexCondition(string2, op);
                }
                throw new MapCSSException(MessageFormat.format("Expected key ''role'' or ''index'' in link context. Got ''{0}''.", string));
            }
        }
        throw new AssertionError();
    }

    public static Condition createKeyCondition(String string, boolean bl, KeyMatchType keyMatchType, Context context) {
        switch (context) {
            case PRIMITIVE: {
                return new KeyCondition(string, bl, keyMatchType);
            }
            case LINK: {
                if (keyMatchType != null) {
                    throw new MapCSSException("Question mark operator ''?'' and regexp match not supported in LINK context");
                }
                if (bl) {
                    return new RoleCondition(string, Op.NEQ);
                }
                return new RoleCondition(string, Op.EQ);
            }
        }
        throw new AssertionError();
    }

    public static PseudoClassCondition createPseudoClassCondition(String string, boolean bl, Context context) {
        return new PseudoClassCondition(string, bl, context);
    }

    public static ClassCondition createClassCondition(String string, boolean bl, Context context) {
        return new ClassCondition(string, bl);
    }

    public static ExpressionCondition createExpressionCondition(Expression expression, Context context) {
        return new ExpressionCondition(expression);
    }

    public static class ExpressionCondition
    extends Condition {
        private final Expression e;

        public ExpressionCondition(Expression expression) {
            this.e = expression;
        }

        @Override
        public boolean applies(Environment environment) {
            Boolean bl = Cascade.convertTo(this.e.evaluate(environment), Boolean.class);
            return bl != null && bl != false;
        }

        public String toString() {
            return "[" + this.e + "]";
        }
    }

    public static class PseudoClassCondition
    extends Condition {
        public final String id;
        public final boolean not;

        public PseudoClassCondition(String string, boolean bl, Context context) {
            this.id = string;
            this.not = bl;
            CheckParameterUtil.ensureThat(!"sameTags".equals(string) || Context.LINK.equals((Object)context), "sameTags only supported in LINK context");
        }

        @Override
        public boolean applies(Environment environment) {
            return this.not ^ this.appliesImpl(environment);
        }

        public boolean appliesImpl(Environment environment) {
            switch (this.id) {
                case "closed": {
                    if (environment.osm instanceof Way && ((Way)environment.osm).isClosed()) {
                        return true;
                    }
                    if (!(environment.osm instanceof Relation) || !((Relation)environment.osm).isMultipolygon()) break;
                    return true;
                }
                case "modified": {
                    return environment.osm.isModified() || environment.osm.isNewOrUndeleted();
                }
                case "new": {
                    return environment.osm.isNew();
                }
                case "connection": {
                    return environment.osm instanceof Node && ((Node)environment.osm).isConnectionNode();
                }
                case "tagged": {
                    return environment.osm.isTagged();
                }
                case "sameTags": {
                    return environment.osm.hasSameInterestingTags(Utils.firstNonNull(environment.child, environment.parent));
                }
                case "areaStyle": {
                    return ElemStyles.hasAreaElemStyle(environment.osm, false);
                }
                case "unconnected": {
                    return environment.osm instanceof Node && OsmPrimitive.getFilteredList(environment.osm.getReferrers(), Way.class).isEmpty();
                }
                case "righthandtraffic": {
                    return ExpressionFactory.Functions.is_right_hand_traffic(environment);
                }
            }
            return false;
        }

        public String toString() {
            return ":" + (this.not ? "!" : "") + this.id;
        }
    }

    public static class ClassCondition
    extends Condition {
        public final String id;
        public final boolean not;

        public ClassCondition(String string, boolean bl) {
            this.id = string;
            this.not = bl;
        }

        @Override
        public boolean applies(Environment environment) {
            return environment != null && environment.getCascade(environment.layer) != null && this.not ^ environment.getCascade(environment.layer).containsKey(this.id);
        }

        public String toString() {
            return (this.not ? "!" : "") + "." + this.id;
        }
    }

    public static class KeyCondition
    extends Condition {
        public final String label;
        public final boolean negateResult;
        public final KeyMatchType matchType;
        public Predicate<String> containsPattern;

        public KeyCondition(String string, boolean bl, KeyMatchType keyMatchType) {
            this.label = string;
            this.negateResult = bl;
            this.matchType = keyMatchType;
            this.containsPattern = KeyMatchType.REGEX.equals((Object)keyMatchType) ? Predicates.stringContainsPattern(Pattern.compile(string)) : null;
        }

        @Override
        public boolean applies(Environment environment) {
            switch (environment.getContext()) {
                case PRIMITIVE: {
                    if (KeyMatchType.TRUE.equals((Object)this.matchType)) {
                        return environment.osm.isKeyTrue(this.label) ^ this.negateResult;
                    }
                    if (KeyMatchType.FALSE.equals((Object)this.matchType)) {
                        return environment.osm.isKeyFalse(this.label) ^ this.negateResult;
                    }
                    if (KeyMatchType.REGEX.equals((Object)this.matchType)) {
                        return Utils.exists(environment.osm.keySet(), this.containsPattern) ^ this.negateResult;
                    }
                    return environment.osm.hasKey(this.label) ^ this.negateResult;
                }
                case LINK: {
                    Utils.ensure(false, "Illegal state: KeyCondition not supported in LINK context", new Object[0]);
                    return false;
                }
            }
            throw new AssertionError();
        }

        public Tag asTag() {
            return new Tag(this.label);
        }

        public String toString() {
            return "[" + (this.negateResult ? "!" : "") + this.label + "]";
        }
    }

    public static enum KeyMatchType {
        EQ,
        TRUE,
        FALSE,
        REGEX;

    }

    public static class IndexCondition
    extends Condition {
        public final String index;
        public final Op op;

        public IndexCondition(String string, Op op) {
            this.index = string;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            if (environment.index == null) {
                return false;
            }
            return this.op.eval(Integer.toString(environment.index + 1), this.index);
        }
    }

    public static class RoleCondition
    extends Condition {
        public final String role;
        public final Op op;

        public RoleCondition(String string, Op op) {
            this.role = string;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            String string = environment.getRole();
            if (string == null) {
                return false;
            }
            return this.op.eval(string, this.role);
        }
    }

    public static class KeyValueRegexpCondition
    extends KeyValueCondition {
        public final Pattern pattern;
        public static final EnumSet<Op> SUPPORTED_OPS = EnumSet.of(Op.REGEX, Op.NREGEX);

        public KeyValueRegexpCondition(String string, String string2, Op op, boolean bl) {
            super(string, string2, op, bl);
            CheckParameterUtil.ensureThat(!bl, "considerValAsKey is not supported");
            CheckParameterUtil.ensureThat(SUPPORTED_OPS.contains((Object)op), "Op must be REGEX or NREGEX");
            this.pattern = Pattern.compile(string2);
        }

        @Override
        public boolean applies(Environment environment) {
            String string = environment.osm.get(this.k);
            if (Op.REGEX.equals((Object)this.op)) {
                return string != null && this.pattern.matcher(string).find();
            }
            if (Op.NREGEX.equals((Object)this.op)) {
                return string == null || !this.pattern.matcher(string).find();
            }
            throw new IllegalStateException();
        }
    }

    public static class KeyValueCondition
    extends Condition {
        public final String k;
        public final String v;
        public final Op op;
        public boolean considerValAsKey;

        public KeyValueCondition(String string, String string2, Op op, boolean bl) {
            this.k = string;
            this.v = string2;
            this.op = op;
            this.considerValAsKey = bl;
        }

        @Override
        public boolean applies(Environment environment) {
            return this.op.eval(environment.osm.get(this.k), this.considerValAsKey ? environment.osm.get(this.v) : this.v);
        }

        public Tag asTag() {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return "[" + this.k + "'" + (Object)((Object)this.op) + "'" + this.v + "]";
        }
    }

    public static class SimpleKeyValueCondition
    extends Condition {
        public final String k;
        public final String v;

        public SimpleKeyValueCondition(String string, String string2) {
            this.k = string;
            this.v = string2;
        }

        @Override
        public boolean applies(Environment environment) {
            return this.v.equals(environment.osm.get(this.k));
        }

        public Tag asTag() {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return '[' + this.k + '=' + this.v + ']';
        }
    }

    public static enum Context {
        PRIMITIVE,
        LINK;

    }

    public static enum Op {
        EQ,
        NEQ,
        GREATER_OR_EQUAL,
        GREATER,
        LESS_OR_EQUAL,
        LESS,
        REGEX,
        NREGEX,
        ONE_OF,
        BEGINS_WITH,
        ENDS_WITH,
        CONTAINS;

        private static final Set<Op> NEGATED_OPS;

        public boolean eval(String string, String string2) {
            float f;
            if (string == null && !NEGATED_OPS.contains((Object)this)) {
                return false;
            }
            switch (this) {
                case EQ: {
                    return Objects.equals(string, string2);
                }
                case NEQ: {
                    return !Objects.equals(string, string2);
                }
                case REGEX: 
                case NREGEX: {
                    boolean bl = Pattern.compile(string2).matcher(string).find();
                    return REGEX.equals((Object)this) ? bl : !bl;
                }
                case ONE_OF: {
                    return Arrays.asList(string.split("\\s*;\\s*")).contains(string2);
                }
                case BEGINS_WITH: {
                    return string.startsWith(string2);
                }
                case ENDS_WITH: {
                    return string.endsWith(string2);
                }
                case CONTAINS: {
                    return string.contains(string2);
                }
            }
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            float f2 = Float.parseFloat(string2);
            switch (this) {
                case GREATER_OR_EQUAL: {
                    return f >= f2;
                }
                case GREATER: {
                    return f > f2;
                }
                case LESS_OR_EQUAL: {
                    return f <= f2;
                }
                case LESS: {
                    return f < f2;
                }
            }
            throw new AssertionError();
        }

        static {
            NEGATED_OPS = EnumSet.of(NEQ, NREGEX);
        }
    }
}

