/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.tools.Pair;

public final class StyleCache {
    private final List<Double> bd;
    private final List<StyleList> data;
    private static final Storage<StyleCache> internPool = new Storage();
    public static final StyleCache EMPTY_STYLECACHE = new StyleCache().intern();

    private StyleCache() {
        this.bd = new ArrayList<Double>();
        this.bd.add(0.0);
        this.bd.add(Double.POSITIVE_INFINITY);
        this.data = new ArrayList<StyleList>();
        this.data.add(null);
    }

    private StyleCache(StyleCache styleCache) {
        this.bd = new ArrayList<Double>(styleCache.bd);
        this.data = new ArrayList<StyleList>(styleCache.data);
    }

    public StyleList get(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < d) || !(d <= this.bd.get(i + 1))) continue;
            return this.data.get(i);
        }
        throw new AssertionError();
    }

    public Pair<StyleList, Range> getWithRange(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < d) || !(d <= this.bd.get(i + 1))) continue;
            return new Pair<StyleList, Range>(this.data.get(i), new Range(this.bd.get(i), this.bd.get(i + 1)));
        }
        throw new AssertionError();
    }

    public StyleCache put(StyleList styleList, Range range) {
        return this.put(styleList, range.getLower(), range.getUpper());
    }

    public StyleCache put(StyleList styleList, double d, double d2) {
        StyleCache styleCache = new StyleCache(this);
        styleCache.putImpl(styleList, d, d2);
        styleCache.consistencyTest();
        return styleCache.intern();
    }

    private void putImpl(StyleList styleList, double d, double d2) {
        int n = 0;
        while (this.bd.get(n) < d) {
            ++n;
        }
        if (this.bd.get(n) == d) {
            if (d2 > this.bd.get(n + 1)) {
                throw new RangeViolatedError();
            }
            if (this.data.get(n) != null) {
                throw new AssertionError((Object)"the new range must be within a subrange that has no data");
            }
            if (this.bd.get(n + 1) == d2) {
                this.data.set(n, styleList);
            } else {
                this.bd.add(n + 1, d2);
                this.data.add(n, styleList);
            }
            return;
        }
        if (this.bd.get(n) < d2) {
            throw new AssertionError((Object)"the new range must be within a single subrange");
        }
        if (this.data.get(n - 1) != null) {
            throw new AssertionError();
        }
        this.bd.add(n, d);
        this.data.add(n, styleList);
        if (this.bd.get(n + 1) > d2) {
            this.bd.add(n + 1, d2);
            this.data.add(n + 1, null);
        }
    }

    public void consistencyTest() {
        if (this.bd.size() < 2) {
            throw new AssertionError();
        }
        if (this.data.size() < 1) {
            throw new AssertionError();
        }
        if (this.bd.size() != this.data.size() + 1) {
            throw new AssertionError();
        }
        if (this.bd.get(0) != 0.0) {
            throw new AssertionError();
        }
        if (this.bd.get(this.bd.size() - 1) != Double.POSITIVE_INFINITY) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (this.bd.get(i) >= this.bd.get(i + 1)) {
                throw new AssertionError();
            }
        }
    }

    public StyleCache intern() {
        return internPool.putUnique(this);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StyleCache styleCache = (StyleCache)object;
        return this.bd.equals(styleCache.bd) && this.data.equals(styleCache.data);
    }

    public int hashCode() {
        int n = 7;
        n = 23 * n + this.bd.hashCode();
        n = 23 * n + this.data.hashCode();
        return n;
    }

    public String toString() {
        return "SC{" + this.bd + ' ' + this.data + '}';
    }

    public static class RangeViolatedError
    extends Error {
    }

    public static class StyleList
    implements Iterable<ElemStyle> {
        private List<ElemStyle> lst;

        public StyleList() {
            this.lst = new ArrayList<ElemStyle>();
        }

        public StyleList(ElemStyle ... elemStyleArray) {
            this.lst = new ArrayList<ElemStyle>(Arrays.asList(elemStyleArray));
        }

        public StyleList(Collection<ElemStyle> collection) {
            this.lst = new ArrayList<ElemStyle>(collection);
        }

        public StyleList(StyleList styleList, ElemStyle elemStyle) {
            this.lst = new ArrayList<ElemStyle>(styleList.lst);
            this.lst.add(elemStyle);
        }

        @Override
        public Iterator<ElemStyle> iterator() {
            return this.lst.iterator();
        }

        public boolean isEmpty() {
            return this.lst.isEmpty();
        }

        public int size() {
            return this.lst.size();
        }

        public String toString() {
            return this.lst.toString();
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StyleList styleList = (StyleList)object;
            return Objects.equals(this.lst, styleList.lst);
        }

        public int hashCode() {
            return this.lst.hashCode();
        }
    }
}

