/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.JpegFileFilter;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class GeoImageLayer
extends Layer
implements PropertyChangeListener,
JumpToMarkerActions.JumpToMarkerLayer {
    List<ImageEntry> data;
    GpxLayer gpxLayer;
    private Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    private int currentPhoto = -1;
    boolean useThumbs = false;
    ThumbsLoader thumbsloader;
    boolean thumbsLoaded = false;
    private BufferedImage offscreenBuffer;
    boolean updateOffscreenBuffer = true;
    private static List<Action> menuAdditions = new LinkedList<Action>();
    private static List<MapMode> supportedMapModes = null;
    private MouseAdapter mouseAdapter = null;
    private MapFrame.MapModeChangeListener mapModeListener = null;

    public static void create(Collection<File> collection, GpxLayer gpxLayer) {
        Loader loader = new Loader(collection, gpxLayer);
        Main.worker.execute(loader);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer) {
        this(list, gpxLayer, null, false);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer, String string) {
        this(list, gpxLayer, string, false);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer, boolean bl) {
        this(list, gpxLayer, null, bl);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer, String string, boolean bl) {
        super(string != null ? string : I18n.tr("Geotagged Images", new Object[0]));
        Collections.sort(list);
        this.data = list;
        this.gpxLayer = gpxLayer;
        this.useThumbs = bl;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage");
    }

    public static void registerMenuAddition(Action action) {
        menuAdditions.add(action);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(LayerListDialog.getInstance().createShowHideLayerAction());
        arrayList.add(LayerListDialog.getInstance().createDeleteLayerAction());
        arrayList.add(new RenameLayerAction(null, this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new CorrelateGpxWithImages(this));
        if (!menuAdditions.isEmpty()) {
            arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
            arrayList.addAll(menuAdditions);
        }
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new JumpToMarkerActions.JumpToNextMarker(this));
        arrayList.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new LayerListPopup.InfoAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private String infoText() {
        int n = 0;
        for (ImageEntry imageEntry : this.data) {
            if (imageEntry.getPos() == null) continue;
            ++n;
        }
        return I18n.trn("{0} image loaded.", "{0} images loaded.", this.data.size(), this.data.size()) + " " + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", n, n);
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer layer) {
        GeoImageLayer geoImageLayer = (GeoImageLayer)layer;
        ImageEntry imageEntry = null;
        if (geoImageLayer.currentPhoto >= 0) {
            imageEntry = geoImageLayer.data.get(geoImageLayer.currentPhoto);
        }
        this.data.addAll(geoImageLayer.data);
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry imageEntry2 = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry imageEntry3 = this.data.get(i);
                if (imageEntry3.getFile().equals(imageEntry2.getFile())) {
                    this.data.remove(i);
                    continue;
                }
                imageEntry2 = imageEntry3;
            }
        }
        if (imageEntry != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) != imageEntry) continue;
                this.currentPhoto = i;
                ImageViewerDialog.showImage(this, this.data.get(i));
                break;
            }
        }
        this.setName(geoImageLayer.getName());
    }

    private Dimension scaledDimension(Image image) {
        double d = Main.map.mapView.getDist100Pixel();
        double d2 = 1000.0 / d;
        if (d2 < 22.0) {
            d2 = 22.0;
        }
        if (d2 > 120.0) {
            d2 = 120.0;
        }
        double d3 = d2 / 120.0;
        if (image == null) {
            return null;
        }
        return new Dimension((int)Math.round(d3 * (double)image.getWidth(null)), (int)Math.round(d3 * (double)image.getHeight(null)));
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        Object object2;
        Object object3;
        int n = mapView.getWidth();
        int n2 = mapView.getHeight();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.useThumbs) {
            if (!this.thumbsLoaded) {
                this.loadThumbs();
            }
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != n || this.offscreenBuffer.getHeight() != n2) {
                this.offscreenBuffer = new BufferedImage(n, n2, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                object3 = this.offscreenBuffer.createGraphics();
                ((Graphics)object3).setColor(new Color(0, 0, 0, 0));
                object2 = ((Graphics2D)object3).getComposite();
                ((Graphics2D)object3).setComposite(AlphaComposite.Clear);
                ((Graphics)object3).fillRect(0, 0, n, n2);
                ((Graphics2D)object3).setComposite((Composite)object2);
                for (ImageEntry imageEntry : this.data) {
                    if (imageEntry.getPos() == null) continue;
                    Point point = mapView.getPoint(imageEntry.getPos());
                    if (imageEntry.thumbnail != null) {
                        Dimension dimension = this.scaledDimension(imageEntry.thumbnail);
                        Rectangle rectangle2 = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                        if (!rectangle.intersects(rectangle2)) continue;
                        ((Graphics)object3).drawImage(imageEntry.thumbnail, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
                        continue;
                    }
                    this.icon.paintIcon(mapView, (Graphics)object3, point.x - this.icon.getIconWidth() / 2, point.y - this.icon.getIconHeight() / 2);
                }
                this.updateOffscreenBuffer = false;
            }
            graphics2D.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else {
            object3 = this.data.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (((ImageEntry)object2).getPos() == null) continue;
                object = mapView.getPoint(((ImageEntry)object2).getPos());
                this.icon.paintIcon(mapView, graphics2D, ((Point)object).x - this.icon.getIconWidth() / 2, ((Point)object).y - this.icon.getIconHeight() / 2);
            }
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size() && ((ImageEntry)(object3 = this.data.get(this.currentPhoto))).getPos() != null) {
            object2 = mapView.getPoint(((ImageEntry)object3).getPos());
            if (this.useThumbs && ((ImageEntry)object3).thumbnail != null) {
                object = this.scaledDimension(((ImageEntry)object3).thumbnail);
                graphics2D.setColor(new Color(128, 0, 0, 122));
                graphics2D.fillRect(((Point)object2).x - ((Dimension)object).width / 2, ((Point)object2).y - ((Dimension)object).height / 2, ((Dimension)object).width, ((Dimension)object).height);
            } else {
                if (((ImageEntry)object3).getExifImgDir() != null) {
                    double d = 25.0;
                    double d2 = 18.0;
                    double d3 = ((ImageEntry)object3).getExifImgDir();
                    double d4 = d3 < 90.0 ? d3 + 270.0 : d3 - 90.0;
                    double d5 = d4 < 90.0 ? d4 + 270.0 : d4 - 90.0;
                    double d6 = d4 > 270.0 ? d4 - 270.0 : d4 + 90.0;
                    double d7 = (double)((Point)object2).x + Math.cos(Math.toRadians(d4)) * d;
                    double d8 = (double)((Point)object2).y + Math.sin(Math.toRadians(d4)) * d;
                    double d9 = (double)((Point)object2).x + Math.cos(Math.toRadians(d5)) * d2 / 2.0;
                    double d10 = (double)((Point)object2).y + Math.sin(Math.toRadians(d5)) * d2 / 2.0;
                    double d11 = (double)((Point)object2).x + Math.cos(Math.toRadians(d6)) * d2 / 2.0;
                    double d12 = (double)((Point)object2).y + Math.sin(Math.toRadians(d6)) * d2 / 2.0;
                    graphics2D.setColor(Color.white);
                    int[] nArray = new int[]{(int)d9, (int)d7, (int)d11, (int)d9};
                    int[] nArray2 = new int[]{(int)d10, (int)d8, (int)d12, (int)d10};
                    graphics2D.fillPolygon(nArray, nArray2, 4);
                }
                this.selectedIcon.paintIcon(mapView, graphics2D, ((Point)object2).x - this.selectedIcon.getIconWidth() / 2, ((Point)object2).y - this.selectedIcon.getIconHeight() / 2);
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (ImageEntry imageEntry : this.data) {
            boundingXYVisitor.visit(imageEntry.getPos());
        }
    }

    private static void extractExif(ImageEntry imageEntry) {
        Object object;
        Object object2;
        GpsDirectory gpsDirectory;
        ExifIFD0Directory exifIFD0Directory;
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(imageEntry.getFile());
            exifIFD0Directory = metadata.getDirectory(ExifIFD0Directory.class);
            gpsDirectory = metadata.getDirectory(GpsDirectory.class);
        }
        catch (CompoundException | IOException exception) {
            imageEntry.setExifCoor(null);
            imageEntry.setPos(null);
            return;
        }
        try {
            if (exifIFD0Directory != null) {
                int n = exifIFD0Directory.getInt(274);
                imageEntry.setExifOrientation(n);
            }
        }
        catch (MetadataException metadataException) {
            Main.debug(metadataException.getMessage());
        }
        if (gpsDirectory == null) {
            imageEntry.setExifCoor(null);
            imageEntry.setPos(null);
            return;
        }
        try {
            double d = gpsDirectory.getDouble(6);
            object2 = gpsDirectory.getInt(5);
            if (object2 == 1) {
                d *= -1.0;
            }
            imageEntry.setElevation(d);
        }
        catch (MetadataException metadataException) {
            Main.debug(metadataException.getMessage());
        }
        try {
            object = ExifReader.readLatLon(gpsDirectory);
            imageEntry.setExifCoor((LatLon)object);
            imageEntry.setPos(imageEntry.getExifCoor());
        }
        catch (Exception exception) {
            Main.error("Error reading EXIF from file: " + exception);
            imageEntry.setExifCoor(null);
            imageEntry.setPos(null);
        }
        try {
            object = ExifReader.readDirection(gpsDirectory);
            if (object != null) {
                imageEntry.setExifImgDir((Double)object);
            }
        }
        catch (Exception exception) {
            Main.debug(exception.getMessage());
        }
        object = gpsDirectory.getIntArray(7);
        if (object != null) {
            Object object3 = object[0];
            object2 = object[1];
            Object object4 = object[2];
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            String string = gpsDirectory.getString(29);
            if (string != null && string.matches("^\\d+:\\d+:\\d+$")) {
                String[] stringArray = string.split(":");
                gregorianCalendar.set(1, Integer.parseInt(stringArray[0]));
                gregorianCalendar.set(2, Integer.parseInt(stringArray[1]) - 1);
                gregorianCalendar.set(5, Integer.parseInt(stringArray[2]));
            } else if (imageEntry.hasExifTime()) {
                gregorianCalendar.setTime(imageEntry.getExifTime());
            }
            gregorianCalendar.set(11, (int)object3);
            gregorianCalendar.set(12, (int)object2);
            gregorianCalendar.set(13, (int)object4);
            imageEntry.setExifGpsTime(gregorianCalendar.getTime());
        }
    }

    public void showNextPhoto() {
        if (this.data != null && this.data.size() > 0) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && !this.data.isEmpty()) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showFirstPhoto() {
        if (this.data != null && this.data.size() > 0) {
            this.currentPhoto = 0;
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showLastPhoto() {
        if (this.data != null && this.data.size() > 0) {
            this.currentPhoto = this.data.size() - 1;
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void checkPreviousNextButtons() {
        ImageViewerDialog.setNextEnabled(this.currentPhoto < this.data.size() - 1);
        ImageViewerDialog.setPreviousEnabled(this.currentPhoto > 0);
    }

    public void removeCurrentPhoto() {
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                ImageViewerDialog.showImage(this, null);
            }
            this.updateOffscreenBuffer = true;
            Main.map.repaint();
        }
    }

    public void removeCurrentPhotoFromDisk() {
        ImageEntry imageEntry = null;
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            imageEntry = this.data.get(this.currentPhoto);
            int n = new ExtendedDialog(Main.parent, I18n.tr("Delete image file from disk", new Object[0]), new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Delete", new Object[0])}).setButtonIcons(new String[]{"cancel.png", "dialogs/delete.png"}).setContent(new JLabel(I18n.tr("<html><h3>Delete the file {0} from disk?<p>The image file will be permanently lost!</h3></html>", imageEntry.getFile().getName()), ImageProvider.get("dialogs/geoimage/deletefromdisk"), 2)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
            if (n == 2) {
                this.data.remove(this.currentPhoto);
                if (this.currentPhoto >= this.data.size()) {
                    this.currentPhoto = this.data.size() - 1;
                }
                if (this.currentPhoto >= 0) {
                    ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
                } else {
                    ImageViewerDialog.showImage(this, null);
                }
                if (imageEntry.getFile().delete()) {
                    Main.info("File " + imageEntry.getFile().toString() + " deleted. ");
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Image file could not be deleted.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                }
                this.updateOffscreenBuffer = true;
                Main.map.repaint();
            }
        }
    }

    public void removePhotoByIdx(int n) {
        if (n >= 0 && this.data != null && n < this.data.size()) {
            this.data.remove(n);
        }
    }

    public ImageEntry getPhotoUnderMouse(MouseEvent mouseEvent) {
        if (this.data != null) {
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Rectangle rectangle;
                ImageEntry imageEntry = this.data.get(i);
                if (imageEntry.getPos() == null) continue;
                Point point = Main.map.mapView.getPoint(imageEntry.getPos());
                if (this.useThumbs && imageEntry.thumbnail != null) {
                    Dimension dimension = this.scaledDimension(imageEntry.thumbnail);
                    rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                } else {
                    rectangle = new Rectangle(point.x - this.icon.getIconWidth() / 2, point.y - this.icon.getIconHeight() / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
                }
                if (!rectangle.contains(mouseEvent.getPoint())) continue;
                return imageEntry;
            }
        }
        return null;
    }

    public void clearCurrentPhoto(boolean bl) {
        this.currentPhoto = -1;
        if (bl) {
            this.updateBufferAndRepaint();
        }
    }

    private void clearOtherCurrentPhotos() {
        for (GeoImageLayer geoImageLayer : Main.map.mapView.getLayersOfType(GeoImageLayer.class)) {
            if (geoImageLayer == this) continue;
            geoImageLayer.clearCurrentPhoto(false);
        }
    }

    public static void registerSupportedMapMode(MapMode mapMode) {
        if (supportedMapModes == null) {
            supportedMapModes = new ArrayList<MapMode>();
        }
        supportedMapModes.add(mapMode);
    }

    private static final boolean isSupportedMapMode(MapMode mapMode) {
        if (mapMode instanceof SelectAction) {
            return true;
        }
        if (supportedMapModes != null) {
            for (MapMode mapMode2 : supportedMapModes) {
                if (mapMode != mapMode2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void hookUpMapView() {
        this.mouseAdapter = new MouseAdapter(){

            private final boolean isMapModeOk() {
                return Main.map.mapMode == null || GeoImageLayer.isSupportedMapMode(Main.map.mapMode);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.isVisible() && this.isMapModeOk()) {
                    Main.map.mapView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.data == null || !GeoImageLayer.this.isVisible() || !this.isMapModeOk()) {
                    return;
                }
                for (int i = GeoImageLayer.this.data.size() - 1; i >= 0; --i) {
                    Rectangle rectangle;
                    ImageEntry imageEntry = GeoImageLayer.this.data.get(i);
                    if (imageEntry.getPos() == null) continue;
                    Point point = Main.map.mapView.getPoint(imageEntry.getPos());
                    if (GeoImageLayer.this.useThumbs && imageEntry.thumbnail != null) {
                        Dimension dimension = GeoImageLayer.this.scaledDimension(imageEntry.thumbnail);
                        rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                    } else {
                        rectangle = new Rectangle(point.x - GeoImageLayer.this.icon.getIconWidth() / 2, point.y - GeoImageLayer.this.icon.getIconHeight() / 2, GeoImageLayer.this.icon.getIconWidth(), GeoImageLayer.this.icon.getIconHeight());
                    }
                    if (!rectangle.contains(mouseEvent.getPoint())) continue;
                    GeoImageLayer.this.clearOtherCurrentPhotos();
                    GeoImageLayer.this.currentPhoto = i;
                    ImageViewerDialog.showImage(GeoImageLayer.this, imageEntry);
                    Main.map.repaint();
                    break;
                }
            }
        };
        this.mapModeListener = new MapFrame.MapModeChangeListener(){

            @Override
            public void mapModeChange(MapMode mapMode, MapMode mapMode2) {
                if (mapMode2 == null || GeoImageLayer.isSupportedMapMode(mapMode2)) {
                    Main.map.mapView.addMouseListener(GeoImageLayer.this.mouseAdapter);
                } else {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, Main.map.mapMode);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            @Override
            public void activeLayerChange(Layer layer, Layer layer2) {
                if (layer2 == GeoImageLayer.this) {
                    Main.map.selectSelectTool(false);
                }
            }

            @Override
            public void layerAdded(Layer layer) {
            }

            @Override
            public void layerRemoved(Layer layer) {
                if (layer == GeoImageLayer.this) {
                    if (GeoImageLayer.this.thumbsloader != null) {
                        GeoImageLayer.this.thumbsloader.stop = true;
                    }
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                    MapFrame.removeMapModeChangeListener(GeoImageLayer.this.mapModeListener);
                    GeoImageLayer.this.currentPhoto = -1;
                    GeoImageLayer.this.data.clear();
                    GeoImageLayer.this.data = null;
                    MapView.removeLayerChangeListener(this);
                }
            }
        });
        Main.map.mapView.addPropertyChangeListener(this);
        if (Main.map.getToggleDialog(ImageViewerDialog.class) == null) {
            ImageViewerDialog.newInstance();
            Main.map.addToggleDialog(ImageViewerDialog.getInstance());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("center".equals(propertyChangeEvent.getPropertyName()) || "scale".equals(propertyChangeEvent.getPropertyName())) {
            this.updateOffscreenBuffer = true;
        }
    }

    public void loadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded) {
            this.thumbsLoaded = true;
            this.thumbsloader = new ThumbsLoader(this);
            Thread thread = new Thread(this.thumbsloader);
            thread.setPriority(1);
            thread.start();
        }
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    public List<ImageEntry> getImages() {
        ArrayList<ImageEntry> arrayList = new ArrayList<ImageEntry>(this.data.size());
        for (ImageEntry imageEntry : this.data) {
            arrayList.add(imageEntry.clone());
        }
        return arrayList;
    }

    public GpxLayer getGpxLayer() {
        return this.gpxLayer;
    }

    @Override
    public void jumpToNextMarker() {
        this.showNextPhoto();
    }

    @Override
    public void jumpToPreviousMarker() {
        this.showPreviousPhoto();
    }

    public boolean isUseThumbs() {
        return this.useThumbs;
    }

    public void setUseThumbs(boolean bl) {
        this.useThumbs = bl;
        if (bl && !this.thumbsLoaded) {
            this.loadThumbs();
        }
    }

    private static final class Loader
    extends PleaseWaitRunnable {
        private boolean canceled = false;
        private GeoImageLayer layer;
        private Collection<File> selection;
        private Set<String> loadedDirectories = new HashSet<String>();
        private Set<String> errorMessages;
        private GpxLayer gpxLayer;

        protected void rememberError(String string) {
            this.errorMessages.add(string);
        }

        public Loader(Collection<File> collection, GpxLayer gpxLayer) {
            super(I18n.tr("Extracting GPS locations from EXIF", new Object[0]));
            this.selection = collection;
            this.gpxLayer = gpxLayer;
            this.errorMessages = new LinkedHashSet<String>();
        }

        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Starting directory scan", new Object[0]));
            ArrayList<File> arrayList = new ArrayList<File>();
            try {
                this.addRecursiveFiles(arrayList, this.selection);
            }
            catch (IllegalStateException illegalStateException) {
                this.rememberError(illegalStateException.getMessage());
            }
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(arrayList.size());
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(arrayList.size());
            ArrayList<ImageEntry> arrayList2 = new ArrayList<ImageEntry>(arrayList.size());
            for (File file : arrayList) {
                if (this.canceled) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", file.getName()));
                this.progressMonitor.worked(1);
                ImageEntry imageEntry = new ImageEntry();
                try {
                    imageEntry.setExifTime(ExifReader.readTime(file));
                }
                catch (ParseException parseException) {
                    imageEntry.setExifTime(null);
                }
                imageEntry.setFile(file);
                GeoImageLayer.extractExif(imageEntry);
                arrayList2.add(imageEntry);
            }
            this.layer = new GeoImageLayer(arrayList2, this.gpxLayer);
            arrayList.clear();
        }

        private void addRecursiveFiles(Collection<File> collection, Collection<File> collection2) {
            boolean bl = false;
            for (File file : collection2) {
                if (this.canceled) break;
                if (file == null) {
                    bl = true;
                    continue;
                }
                if (file.isDirectory()) {
                    String string = null;
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        Main.error(iOException);
                        this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", file.getAbsolutePath()));
                    }
                    if (string == null || this.loadedDirectories.contains(string)) continue;
                    this.loadedDirectories.add(string);
                    File[] fileArray = file.listFiles(JpegFileFilter.getInstance());
                    if (fileArray != null) {
                        this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", file.getPath()));
                        this.addRecursiveFiles(collection, Arrays.asList(fileArray));
                        continue;
                    }
                    this.rememberError(I18n.tr("Error while getting files from directory {0}\n", file.getPath()));
                    continue;
                }
                collection.add(file);
            }
            if (bl) {
                throw new IllegalStateException(I18n.tr("One of the selected files was null", new Object[0]));
            }
        }

        protected String formatErrorMessages() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            if (this.errorMessages.size() == 1) {
                stringBuilder.append(this.errorMessages.iterator().next());
            } else {
                stringBuilder.append(Utils.joinAsHtmlUnorderedList(this.errorMessages));
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        protected void finish() {
            if (!this.errorMessages.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, this.formatErrorMessages(), I18n.tr("Error", new Object[0]), 0);
            }
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
                if (!this.canceled && !this.layer.data.isEmpty()) {
                    boolean bl = true;
                    for (ImageEntry imageEntry : this.layer.data) {
                        if (imageEntry.getPos() == null) continue;
                        bl = false;
                    }
                    if (bl) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }
    }
}

