/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CustomizeColor
extends AbstractAction
implements Layer.LayerAction,
Layer.MultiLayerAction {
    List<Layer> layers;

    public CustomizeColor(List<Layer> list) {
        this();
        this.layers = list;
    }

    public CustomizeColor(Layer layer) {
        this();
        this.layers = new LinkedList<Layer>();
        this.layers.add(layer);
    }

    private CustomizeColor() {
        super(I18n.tr("Customize Color", new Object[0]), ImageProvider.get("colorchooser"));
        this.putValue("help", HelpUtil.ht("/Action/LayerCustomizeColor"));
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        for (Layer layer : list) {
            if (layer.getColor(false) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public Action getMultiLayerAction(List<Layer> list) {
        return new CustomizeColor(list);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = this.layers.get(0).getColor(false);
        if (color == null) {
            color = Color.gray;
        }
        JColorChooser jColorChooser = new JColorChooser(color);
        Object[] objectArray = new Object[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Default", new Object[0])};
        int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color", new Object[0]), 2, -1, null, objectArray, objectArray[0]);
        switch (n) {
            case 0: {
                for (Layer layer : this.layers) {
                    Main.pref.putColor("layer " + layer.getName(), jColorChooser.getColor());
                }
                break;
            }
            case 1: {
                return;
            }
            case 2: {
                for (Layer layer : this.layers) {
                    Main.pref.putColor("layer " + layer.getName(), null);
                }
                break;
            }
        }
        Main.map.repaint();
    }
}

