/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class SaveLayersModel
extends DefaultTableModel {
    public static final String MODE_PROP = SaveLayerInfo.class.getName() + ".mode";
    private List<SaveLayerInfo> layerInfo;
    private Mode mode = Mode.EDITING_DATA;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final int columnFilename = 0;
    private static final int columnActions = 2;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireModeChanged(Mode mode, Mode mode2) {
        this.support.firePropertyChange(MODE_PROP, (Object)mode, (Object)mode2);
    }

    public void setMode(Mode mode) {
        Mode mode2 = this.mode;
        this.mode = mode;
        this.fireModeChanged(mode2, mode);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void populate(List<? extends AbstractModifiableLayer> list) {
        this.layerInfo = new ArrayList<SaveLayerInfo>();
        if (list == null) {
            return;
        }
        for (AbstractModifiableLayer abstractModifiableLayer : list) {
            this.layerInfo.add(new SaveLayerInfo(abstractModifiableLayer));
        }
        Collections.sort(this.layerInfo, new Comparator<SaveLayerInfo>(){

            @Override
            public int compare(SaveLayerInfo saveLayerInfo, SaveLayerInfo saveLayerInfo2) {
                return saveLayerInfo.compareTo(saveLayerInfo2);
            }
        });
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.layerInfo == null) {
            return 0;
        }
        return this.layerInfo.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.layerInfo == null) {
            return null;
        }
        return this.layerInfo.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 || n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                this.layerInfo.get(n).setFile((File)object);
                this.layerInfo.get(n).setDoSaveToFile(true);
                break;
            }
            case 2: {
                boolean[] blArray = (boolean[])object;
                this.layerInfo.get(n).setDoUploadToServer(blArray[0]);
                this.layerInfo.get(n).setDoSaveToFile(blArray[1]);
            }
        }
        this.fireTableDataChanged();
    }

    public List<SaveLayerInfo> getSafeLayerInfo() {
        return this.layerInfo;
    }

    public List<SaveLayerInfo> getLayersWithoutFilesAndSaveRequest() {
        ArrayList<SaveLayerInfo> arrayList = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (!saveLayerInfo.isDoSaveToFile() || saveLayerInfo.getFile() != null) continue;
            arrayList.add(saveLayerInfo);
        }
        return arrayList;
    }

    public List<SaveLayerInfo> getLayersWithIllegalFilesAndSaveRequest() {
        ArrayList<SaveLayerInfo> arrayList = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (!saveLayerInfo.isDoSaveToFile() || saveLayerInfo.getFile() == null || !saveLayerInfo.getFile().exists() || saveLayerInfo.getFile().canWrite()) continue;
            arrayList.add(saveLayerInfo);
        }
        return arrayList;
    }

    public List<SaveLayerInfo> getLayersWithConflictsAndUploadRequest() {
        ArrayList<SaveLayerInfo> arrayList = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            AbstractModifiableLayer abstractModifiableLayer = saveLayerInfo.getLayer();
            if (!saveLayerInfo.isDoUploadToServer() || !(abstractModifiableLayer instanceof OsmDataLayer) || ((OsmDataLayer)abstractModifiableLayer).getConflicts().isEmpty()) continue;
            arrayList.add(saveLayerInfo);
        }
        return arrayList;
    }

    public List<SaveLayerInfo> getLayersToUpload() {
        ArrayList<SaveLayerInfo> arrayList = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (!saveLayerInfo.isDoUploadToServer()) continue;
            arrayList.add(saveLayerInfo);
        }
        return arrayList;
    }

    public List<SaveLayerInfo> getLayersToSave() {
        ArrayList<SaveLayerInfo> arrayList = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (!saveLayerInfo.isDoSaveToFile()) continue;
            arrayList.add(saveLayerInfo);
        }
        return arrayList;
    }

    public void setUploadState(AbstractModifiableLayer abstractModifiableLayer, UploadOrSaveState uploadOrSaveState) {
        SaveLayerInfo saveLayerInfo = this.getSaveLayerInfo(abstractModifiableLayer);
        if (saveLayerInfo != null) {
            saveLayerInfo.setUploadState(uploadOrSaveState);
        }
        this.fireTableDataChanged();
    }

    public void setSaveState(AbstractModifiableLayer abstractModifiableLayer, UploadOrSaveState uploadOrSaveState) {
        SaveLayerInfo saveLayerInfo = this.getSaveLayerInfo(abstractModifiableLayer);
        if (saveLayerInfo != null) {
            saveLayerInfo.setSaveState(uploadOrSaveState);
        }
        this.fireTableDataChanged();
    }

    public SaveLayerInfo getSaveLayerInfo(AbstractModifiableLayer abstractModifiableLayer) {
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (saveLayerInfo.getLayer() != abstractModifiableLayer) continue;
            return saveLayerInfo;
        }
        return null;
    }

    public void resetSaveAndUploadState() {
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            saveLayerInfo.setSaveState(null);
            saveLayerInfo.setUploadState(null);
        }
    }

    public boolean hasUnsavedData() {
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (saveLayerInfo.isDoUploadToServer() && !UploadOrSaveState.OK.equals((Object)saveLayerInfo.getUploadState())) {
                return true;
            }
            if (!saveLayerInfo.isDoSaveToFile() || UploadOrSaveState.OK.equals((Object)saveLayerInfo.getSaveState())) continue;
            return true;
        }
        return false;
    }

    public int getNumCancel() {
        int n = 0;
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (!UploadOrSaveState.CANCELED.equals((Object)saveLayerInfo.getSaveState()) && !UploadOrSaveState.CANCELED.equals((Object)saveLayerInfo.getUploadState())) continue;
            ++n;
        }
        return n;
    }

    public int getNumFailed() {
        int n = 0;
        for (SaveLayerInfo saveLayerInfo : this.layerInfo) {
            if (!UploadOrSaveState.FAILED.equals((Object)saveLayerInfo.getSaveState()) && !UploadOrSaveState.FAILED.equals((Object)saveLayerInfo.getUploadState())) continue;
            ++n;
        }
        return n;
    }

    public static enum Mode {
        EDITING_DATA,
        UPLOADING_AND_SAVING;

    }
}

