/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private JPanel pnlChangesetSource;
    private JLabel lblSource;
    private JTextArea lblChangesetComment;
    private JTextArea lblChangesetSource;

    protected static JTextArea buildTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setToolTipText(string);
        return jTextArea;
    }

    protected static JLabel buildLabel(String string, String string2, JTextArea jTextArea) {
        JLabel jLabel = new JLabel("<html><p style='margin-top:" + jTextArea.getMargin().top + "'>" + string + "</html>");
        jLabel.setFont(jTextArea.getFont());
        jLabel.setToolTipText(string2);
        return jLabel;
    }

    protected static JPanel buildTextPanel(JLabel jLabel, JTextArea jTextArea) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.std().anchor(18));
        jPanel.add((Component)jTextArea, GBC.eol().fill());
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        jPanel.add((Component)this.lblInfo, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2));
        this.lblUser = new UrlLabel("", 2);
        jPanel2.add(new JLabel(I18n.tr("User:", new Object[0])));
        jPanel2.add(this.lblUser);
        jPanel2.add(new JLabel(I18n.tr("Changeset:", new Object[0])));
        this.lblChangeset = new UrlLabel("", 2);
        jPanel2.add(this.lblChangeset);
        this.lblChangesetComment = VersionInfoPanel.buildTextArea(I18n.tr("Changeset comment", new Object[0]));
        this.lblChangesetSource = VersionInfoPanel.buildTextArea(I18n.tr("Changeset source", new Object[0]));
        this.lblSource = VersionInfoPanel.buildLabel(I18n.tr("<b>Source</b>:", new Object[0]), I18n.tr("Changeset source", new Object[0]), this.lblChangesetSource);
        this.pnlChangesetSource = VersionInfoPanel.buildTextPanel(this.lblSource, this.lblChangesetSource);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.lblChangesetComment, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.pnlChangesetSource, gridBagConstraints);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        String string;
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive == null) {
            return "";
        }
        if (this.model.isLatest(historyOsmPrimitive)) {
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            string = I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(historyOsmPrimitive.getVersion()), osmDataLayer == null ? I18n.tr("unknown", new Object[0]) : osmDataLayer.getName());
        } else {
            String string2 = "?";
            if (historyOsmPrimitive.getTimestamp() != null) {
                string2 = DateUtils.formatDateTime(historyOsmPrimitive.getTimestamp(), 3, 3);
            }
            string = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(historyOsmPrimitive.getVersion()), string2);
        }
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addObserver(this);
        this.build();
    }

    protected static String getUserUrl(String string) throws UnsupportedEncodingException {
        return AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
    }

    @Override
    public void update(Observable observable, Object object) {
        Object object2;
        Changeset changeset;
        block10: {
            this.lblInfo.setText(this.getInfoText());
            HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
            changeset = historyOsmPrimitive.getChangeset();
            if (!this.model.isLatest(historyOsmPrimitive)) {
                object2 = historyOsmPrimitive.getUser();
                String string = AbstractInfoAction.getBaseBrowseUrl() + "/changeset/" + historyOsmPrimitive.getChangesetId();
                this.lblChangeset.setUrl(string);
                this.lblChangeset.setDescription(Long.toString(historyOsmPrimitive.getChangesetId()));
                String string2 = "";
                if (object2 != null) {
                    string2 = ((User)object2).getName();
                }
                this.lblUser.setDescription(string2);
                try {
                    if (object2 != null && object2 != User.getAnonymous()) {
                        this.lblUser.setUrl(VersionInfoPanel.getUserUrl(string2));
                        break block10;
                    }
                    this.lblUser.setUrl(null);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Main.error(unsupportedEncodingException);
                    this.lblUser.setUrl(null);
                }
            } else {
                object2 = JosmUserIdentityManager.getInstance().getUserName();
                if (object2 == null) {
                    this.lblUser.setDescription(I18n.tr("anonymous", new Object[0]));
                    this.lblUser.setUrl(null);
                } else {
                    this.lblUser.setDescription((String)object2);
                    try {
                        this.lblUser.setUrl(VersionInfoPanel.getUserUrl((String)object2));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Main.error(unsupportedEncodingException);
                        this.lblUser.setUrl(null);
                    }
                }
                this.lblChangeset.setDescription(I18n.tr("none", new Object[0]));
                this.lblChangeset.setUrl(null);
            }
        }
        object2 = this.model.getPointInTime(this.pointInTimeType.opposite()).getChangeset();
        VersionInfoPanel.updateText(changeset, "comment", this.lblChangesetComment, null, (Changeset)object2, this.lblChangesetComment);
        VersionInfoPanel.updateText(changeset, "source", this.lblChangesetSource, this.lblSource, (Changeset)object2, this.pnlChangesetSource);
    }

    protected static void updateText(Changeset changeset, String string, JTextArea jTextArea, JLabel jLabel, Changeset changeset2, JComponent jComponent) {
        String string2;
        String string3 = string2 = changeset != null ? changeset.get(string) : null;
        if (jLabel != null) {
            jLabel.setVisible(string2 != null && !Utils.strip(string2).isEmpty());
        }
        jTextArea.setText(string2);
        jComponent.setVisible(string2 != null || changeset2 != null && changeset2.get(string) != null);
    }
}

